<?php
/**
 * Createing an Facility pannel for customizer
 *
 */

// START FACILITY SECTION 
    $wp_customize->add_section(
        'lz_fitness_premium_facility_section',
        array(
            'title' => __( 'Our Skills Section', 'lz-fitness-premium' ),
            'panel' => 'lz_fitness_premium_home_panel'
        )
    );
    // ENABLE/DISABLE facility SECTION
    $wp_customize->add_setting(
        'lz_fitness_premium_facility_section_disable',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text',
        )
    );

    $wp_customize->add_control(
        new lz_fitness_Switch_Control(
            $wp_customize,
            'lz_fitness_premium_facility_section_disable',
            array(
                'settings'      => 'lz_fitness_premium_facility_section_disable',
                'section'       => 'lz_fitness_premium_facility_section',
                'label'         => __( 'Disable Section', 'lz-fitness-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'lz-fitness-premium' ),
                    'off' => __( 'No', 'lz-fitness-premium' )
                ),
            )
        )
    );

   backgroundManager($wp_customize, 'facility', 'lz_fitness_premium_facility_section', $color='#ffffff');

$wp_customize->add_setting(
    'lz_fitness_facility_title_sub_title_heading',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text'
    )
);
$wp_customize->add_control(
    new lz_fitness_Customize_Heading(
        $wp_customize,
        'lz_fitness_facility_title_sub_title_heading',
        array(
            'settings'      => 'lz_fitness_facility_title_sub_title_heading',
            'section'       => 'lz_fitness_premium_facility_section',
            'label'         => __( 'Section Title & Sub Title', 'gurukul' ),
        )
    )
);    
$wp_customize->add_setting(
    'lz_fitness_facility_sub_title',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '<p>Lorem ipsum is simply text</p>', 'gurukul' )
    )
);
$wp_customize->add_control(
    'lz_fitness_facility_sub_title',
    array(
        'settings'      => 'lz_fitness_facility_sub_title',
        'section'       => 'lz_fitness_premium_facility_section',
        'type'          => 'textarea',
        'label'         => __( 'Title', 'gurukul' ),
    )
);

$wp_customize->add_setting(
    'lz_fitness_facility_title',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( 'OUR SKILLS', 'gurukul' )
    )
);
$wp_customize->add_control(
    'lz_fitness_facility_title',
    array(
        'settings'      => 'lz_fitness_facility_title',
        'section'       => 'lz_fitness_premium_facility_section',
        'type'          => 'text',
        'label'         => __( 'Sub Title', 'gurukul' )
    )
);

    // Heading color
    addColorPalatOption($wp_customize, 'lz_fitness_facility_HeadingColor', 'lz_fitness_premium_facility_section', 'Heading color '. $headingColor, '#2a2a2a');
    // Text color
    addColorPalatOption($wp_customize, 'lz_fitness_facility_TextColor', 'lz_fitness_premium_facility_section', 'Text color', '#4f4f4f');

$wp_customize->add_setting('lz_fitness_facility_npp_heading',array('sanitize_callback' => 'lz_fitness_sanitize_text'));
$wp_customize->add_control(
    new lz_fitness_Customize_Heading(
        $wp_customize,
        'lz_fitness_facility_npp_heading',
        array(
            'settings'      => 'lz_fitness_facility_npp_heading',
            'section'       => 'lz_fitness_premium_facility_section',
            'label'         => __( 'Number Of facility Plans', 'gurukul' ),
        )
    )
);    
$wp_customize->add_setting('lz_fitness_facility_npp_count',array('sanitize_callback' => 'lz_fitness_sanitize_text','default' => 3));
$wp_customize->add_control(
    'lz_fitness_facility_npp_count',
    array(
        'settings'      => 'lz_fitness_facility_npp_count',
        'section'       => 'lz_fitness_premium_facility_section',
        'type'          => 'select',
        'label'         => __( 'Number of plan to show', 'gurukul' ),
        'choices'=>array(1,2,3,4,5,6)
    )
);

//facility PAGES
for( $i = 1; $i <= 6; $i++ ){
    $wp_customize->add_setting(
        'lz_fitness_facility_header'.$i,
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Customize_Heading(
            $wp_customize,
            'lz_fitness_facility_header'.$i,
            array(
                'settings'      => 'lz_fitness_facility_header'.$i,
                'section'       => 'lz_fitness_premium_facility_section',
                'label'         => __( 'facility Page ', 'gurukul' ).$i
            )
        )
    );

lzAddElement($wp_customize, 'lz_fitness_facility_page_title_'.$i, 'lz_fitness_premium_facility_section', $type = 'text', $label="Title", $callback ='lz_fitness_sanitize_text', $default='Design');
lzAddElement($wp_customize, 'lz_fitness_facility_page_description_'.$i, 'lz_fitness_premium_facility_section', $type = 'textarea', $label="Description", $callback ='lz_fitness_sanitize_text', $default='Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. ');

    // $wp_customize->add_setting(
    //     'lz_fitness_facility_page'.$i,
    //     array(
    //         'sanitize_callback' => 'absint'
    //     )
    // );
    // $wp_customize->add_control(
    //     'lz_fitness_facility_page'.$i,
    //     array(
    //         'settings'      => 'lz_fitness_facility_page'.$i,
    //         'section'       => 'lz_fitness_premium_facility_section',
    //         'type'          => 'dropdown-pages',
    //         'label'         => __( 'Select a Page', 'gurukul' )
    //     )
    // );
    
    $wp_customize->add_setting(
        'lz_fitness_facility_page_icon'.$i,
        array(
            'default'           => 'fa fa-bell',
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new lz_fitness_Fontawesome_Icon_Chooser(
            $wp_customize,
            'lz_fitness_facility_page_icon'.$i,
            array(
                'settings'      => 'lz_fitness_facility_page_icon'.$i,
                'section'       => 'lz_fitness_premium_facility_section',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'gurukul' ),
            )
        )
    );
    
    //my edit code
    // $wp_customize->add_control( 
    // 'lz_fitness_facility_page', 
    // array(
    // 'settings'=> 'lz_fitness_facility_page', 
    // 'section' => 'lz_fitness_premium_facility_section', 
    // 'type'=>'select', 
    // 'label'=>__('Link to facility page', 'lz-facility-premium'), 
    // //'choices'=>$lz_facility_page_choice 
    //  ) 
    // );
    
    // $wp_customize->add_setting(
    // 'lz_fitness_facility_image_heading', 
    // array(
    // 'sanitize_callback' => 'lz_fitness_sanitize_text' 
    //     ) 
    // ); 
    
    // $wp_customize->add_control(
    // new lz_fitness_Customize_Heading(
    // $wp_customize, 
    // 'lz_fitness_facility_image_heading', 
    // array(
    // 'settings' => 'lz_fitness_facility_image_heading', 
    // 'section' => 'lz_fitness_premium_facility_section', 
    // 'label' => __( 'Right Image', 'lz-facility-premium' ), 
    //         ) 
    //     ) 
    // ); 
    
    // $wp_customize->add_setting(
    // 'lz_fitness_facility_image', 
    // array( 
    // 'sanitize_callback' => 'esc_url_raw' 
    //     ) 
    // );
    
    // $wp_customize->add_control(
    // new WP_Customize_Image_Control(
    // $wp_customize, 
    // 'lz_fitness_facility_image', 
    // array(
    // 'section' => 'lz_fitness_premium_facility_section',
    // 'settings' => 'lz_fitness_facility_image',
    // 'description' => __('Recommended Image Size: 500X600px', 'lz-facility-premium') 
    //         )
    //     ) 
    // );

}


    
    //end image2//
 // Heading color
    addColorPalatOption($wp_customize, 'lz_fitness_facility_HeadingColor', 'lz_fitness_premium_facility_section', 'Heading color', '#7854c0');
    // Heading color
    addColorPalatOption($wp_customize, 'lz_fitness_facility_SubHeadingColor', 'lz_fitness_premium_facility_section', 'Sub Heading color', '#000000');
    // Heading color
    addColorPalatOption($wp_customize, 'lz_fitness_facility_TitleColor', 'lz_fitness_premium_facility_section', 'Title color', '#373737');
    // Text color
    addColorPalatOption($wp_customize, 'lz_fitness_facility_TextColor', 'lz_fitness_premium_facility_section', 'Text color', '#373737');
     // Text color
    addColorPalatOption($wp_customize, 'lz_fitness_facility_IconColor', 'lz_fitness_premium_facility_section', 'Icon color', '#ffffff');
    addColorPalatOption($wp_customize, 'lz_fitness_facility_IconBackgroundColor', 'lz_fitness_premium_facility_section', 'Icon Background color', '#7854c0');
    // END FACILITY SECTION 