<?php 
/**
 * Createing an about us pannel for customizer
 *
 */
// PROJECT SECTION START HERE 
/*============PROJECT SECTION PANEL============*/
$wp_customize->add_section(
	'project_section',
	array(
		'title'         => __( 'Feature Projects Section', 'gurukul' ),
		'panel'   => 'lz_fitness_premium_home_panel',
	)
);
// ENABLE/DISABLE TEAM SECTION
$wp_customize->add_setting(
	'project_section_disable',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'project_section_disable',
		array(
			'settings'      => 'project_section_disable',
			'section'       => 'project_section',
			'label'         => __( 'Disable Section', 'gurukul' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'gurukul' ),
				'off' => __( 'No', 'gurukul' )
			)   
		)
	)
);
backgroundManager($wp_customize, 'project', 'project_section', $color='#fff');

$wp_customize->add_setting(
	'project_title_subtitle_heading',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
	)
);
$wp_customize->add_control(
	new lz_fitness_Customize_Heading(
		$wp_customize,
		'project_title_subtitle_heading',
		array(
			'settings'      => 'project_title_subtitle_heading',
			'section'       => 'project_section',
			'label'         => __( 'Section Title & Sub Title', 'gurukul' ),
		)
	)
);
$wp_customize->add_setting(
	'project_sub_title',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Lorem Ipsum is simply text', 'gurukul' )
	)
);
$wp_customize->add_control(
	'project_sub_title',
	array(
		'settings'      => 'project_sub_title',
		'section'       => 'project_section',
		'type'          => 'textarea',
		'label'         => __( 'Title', 'gurukul' )
	)
);
$wp_customize->add_setting(
	'project_title',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'FEATURE <b>PROJECTS</b>', 'gurukul' )
	)
);
$wp_customize->add_control(
	'project_title',
	array(
		'settings'      => 'project_title',
		'section'       => 'project_section', 
		'type'          => 'text',
		'label'         => __( 'Sub Title', 'gurukul' )
	)
);



$wp_customize->add_setting('project_npp_heading',array('sanitize_callback' => 'lz_fitness_sanitize_text'));
$wp_customize->add_control(
	new lz_fitness_Customize_Heading(
		$wp_customize,
		'project_npp_heading',
		array(
			'settings'      => 'project_npp_heading',
			'section'       => 'project_section',
			'label'         => __( 'Number Of project to show', 'gurukul' ),
		)
	)
);    
$wp_customize->add_setting('project_npp_count',array('sanitize_callback' => 'lz_fitness_sanitize_text','default' => 2));
$wp_customize->add_control(
	'project_npp_count',
	array(
		'settings'      => 'project_npp_count',
		'section'       => 'project_section',
		'type'          => 'select',
		'label'         => __( 'Number of projects to show', 'gurukul' ),
		'choices'=>array(1,2,3,4,5,6)
	)
);

// $wp_customize->add_setting(
//         'project_page',
//         array(
//             'sanitize_callback'=> 'absint',
//             'default' => __('Project Readmore Link', 'gurukul')
//         )
//     );
//     $wp_customize->add_control(
//         'project_page',
//         array(
//             'settings'=> 'project_page',
//             'section' => 'project_section',
//             'type'=>'select',
//             'label'=>__('Link to Project page', 'gurukul'),
//             'choices'=>$lz_fitness_page_choice
//         )
//     );

// PROJECT PAGES
for( $i = 1; $i <= 6; $i++ ){
	$wp_customize->add_setting(
		'project_heading'.$i,
		array(
			'sanitize_callback' => 'lz_fitness_sanitize_text'
		)
	);
	$wp_customize->add_control(
		new lz_fitness_Customize_Heading(
			$wp_customize,
			'project_heading'.$i,
			array(
				'settings'      => 'project_heading'.$i,
				'section'       => 'project_section',
				'label'         => __( 'project', 'gurukul' ).$i,
			)
		)
	);
	if(is_array($lzFitnessProjectSingleChoice)){
		$wp_customize->add_setting(
			'project_page'.$i,
			array(
				'sanitize_callback' => 'absint'
			)
		);
		$wp_customize->add_control(
			'project_page'.$i,
			array(
				'settings'      => 'project_page'.$i,
				'section'       => 'project_section',
				'type'=> 'select',
				'label'         => __( 'Select a Project', 'gurukul' ),
				'choices' => $lzFitnessProjectSingleChoice,
			)
		);
	}else{
		$wp_customize->add_setting('project_section_lbl'.$i, array('sanitize_callback'=>'lz_fitness_sanitize_text'));
		$wp_customize->add_control(
			new lz_fitness_Info_Text( 
				$wp_customize,
				'project_section_lbl'.$i,
				array(
					'settings'		=> 'project_section_lbl'.$i,
					'section'		=> 'project_section',
					'label'			=> __( 'Note:', 'gurukul' ),	
					'description'	=> __( '<strong>Changes will not reflect unless you select the project member.</strong> <br/>Please add the project from "Project menu" and then select project member to show information.', 'gurukul' ),
				)
			)
		);
	}
	// Title color
 addColorPalatOption($wp_customize, 'project_TitleColor', 'project_section', 'Text color', '#323030');

 // $wp_customize->add_setting(
 //        'project_page',
 //        array(
 //            'sanitize_callback'=> 'absint',
 //            'default' => __('Project Readmore Link', 'gurukul')
 //        )
 //    );
 //    $wp_customize->add_control(
 //        'project_page',
 //        array(
 //            'settings'=> 'project_page',
 //            'section' => 'project_section',
 //            'type'=>'select',
 //            'label'=>__('Link to Project page', 'gurukul'),
 //            'choices'=>$lz_fitness_page_choice
 //        )
 //    );
}

//FEATURED PAGES
for( $i = 1; $i <= 1; $i++ ){

    $wp_customize->add_setting(
        'project_page_header'.$i,
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Customize_Heading(
            $wp_customize,
            'project_page_header'.$i,
            array(
                'settings'      => 'project_page_header'.$i,
                'section'       => 'project_section',
                'label'         => __( 'Button Details '.$i, 'gurukul' )
            )
        )
    );

     lzAddElement($wp_customize, 'project_button_url_'.$i, 'project_section', $type = 'text', $label="Button Link".$i."&nbsp;", $callback ='esc_url', $default='Add link here');


	/*code for button text*/
	// $wp_customize->add_setting(
 //        'project_button'.$i,
 //        array(
 //            'sanitize_callback'=>'lz_fitness_sanitize_text',
 //            'default'=> __('View all Project', 'gurukul')
 //        )
 //    );
 //    $wp_customize->add_control(
 //        'project_button'.$i,
 //        array(
 //            'settings' =>'project_button'.$i,
 //            'section' => 'project_section',
 //            'type'=> 'text',
 //            'label'=> __('Button Text', 'gurukul')
 //        )
 //    );

}
// TEAM SECTION END HERE 
// Heading color
addColorPalatOption($wp_customize, 'project_HeadingColor', 'project_section', 'Heading color', '#7854c0');
// Sub Heading color
addColorPalatOption($wp_customize, 'project_SubHeadingColor', 'project_section', 'Sub Heading color', '#000000');
// Text color
addColorPalatOption($wp_customize, 'project_TitleColor', 'project_section', 'Title color', '#383737');

// Text color
addColorPalatOption($wp_customize, 'project_TextColor', 'project_section', 'Text color', '#373737');


addColorPalatOption($wp_customize, 'project_ButtonHmpgTextColor', 'project_section', 'Button Text color', '#7854c0');
addColorPalatOption($wp_customize, 'project_BUttonbrsshmpgColor', 'project_section', 'Button Border color', '#7854c0'); 
