<?php
/**
 * The template for displaying archive pages.
 *
 * Used for displaying archive-type pages. These views can be further customized by
 * creating a separate template for each one.
 *
 * - author.php (Author archive)
 * - category.php (Category archive)
 * - date.php (Date archive)
 * - tag.php (Tag archive)
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 */
?>
<?php get_header(); ?>
<header class="page-main-header">
	<div>
        <?php $image = wp_get_attachment_url( get_post_thumbnail_id($post->ID));?>
        <?php
        //print_r ($post);
            if (!empty($image)){
                echo '<img src="'.$image.'" class="ht-page-header-img" />';
            }
        ?>
        <!-- <img src="<?php //echo !empty($image)?$image : get_template_directory_uri().'/images/innerpage.jpg';?>" class="ht-page-header-img" alt="<?php //the_title();?>" /> -->
    </div>
	<div class="container">
		<?php the_title( '<h1 class="ht-main-title">', '</h1>' ); ?>
		<div class="clearfix"></div>
	</div>
</header><!-- .entry-header -->
<div class="breadcrumbbox">
	<div class="container">
	    <?php luzuk_lite_the_breadcrumb(); ?>
	</div>
</div>
  <?php 
            if( get_theme_mod('innerpagesbox_toppadding',true) ) {
                $innerpagesbox_toppadding = 'padding-top:'.esc_attr(get_theme_mod('innerpagesbox_toppadding')).';';
            }
            if( get_theme_mod('innerpagesbox_bottompadding',true) ) {
                $innerpagesbox_bottompadding = 'padding-bottom:'.esc_attr(get_theme_mod('innerpagesbox_bottompadding')).';';
            }
            if( get_theme_mod('innerpagesbox_leftpadding',true) ) {
                $innerpagesbox_leftpadding = 'padding-left:'.esc_attr(get_theme_mod('innerpagesbox_leftpadding')).';';
            }
            if( get_theme_mod('innerpagesbox_rightpadding',true) ) {
                $innerpagesbox_rightpadding = 'padding-right:'.esc_attr(get_theme_mod('innerpagesbox_rightpadding')).';';
            }
    ?>  

<main id="innerpage-box" style="<?php echo esc_attr($innerpagesbox_toppadding); ?>" "<?php echo esc_attr($innerpagesbox_bottompadding); ?>" "<?php echo esc_attr($innerpagesbox_leftpadding); ?>" "<?php echo esc_attr($innerpagesbox_rightpadding); ?>">
	<div class="container">
		<div id="blog-box" class="col-md-9 innerpage-whitebox">
			<?php if ( have_posts() ) :
			$luzuk_lite_full_posts = get_theme_mod('luzuk_lite_full_posts');
			while ( have_posts() ) : the_post();
				luzuk_lite_archive_post();
			endwhile;
			luzuk_lite_post_navigation();
		endif; ?>
		</div>
		<div class="col-md-3">
		<?php get_sidebar(); ?>
		</div>
	</div>
</main>
<?php get_footer(); ?>
<!--<div id="page" class="home-page">
	<div id="content" class="article">
		<h1 class="postsby">
			<span><?php //the_archive_title(); ?></span>
		</h1>	
		<?php ///if ( have_posts() ) :
			//$luzuk_lite_full_posts = get_theme_mod('luzuk_lite_full_posts');
			//while ( have_posts() ) : the_post();
				//luzuk_lite_archive_post();
			//endwhile;
			//luzuk_lite_post_navigation();
		//endif; ?>
	</div>
	<?php //get_sidebar(); ?>
</div>
<?php //get_footer(); ?>