<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luzuk Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">    
	
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/colorbox.css">

	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/headroom.css" />
	

	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/responsive-tabs.css" />

	<script src="<?php echo get_template_directory_uri(); ?>/js/jqueryjquery.colorbox.js" ></script>
	
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>

	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery.js" ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/responsiveTabs.js" type="text/javascript"></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/responsiveTabs.min.js" type="text/javascript"></script>
	
	
	
	
	
	<script>	
	$(document).ready(function(){
	  // Add smooth scrolling to all links
	  $("a").on('click', function(event) {

	    // Make sure this.hash has a value before overriding default behavior
	    if (this.hash !== "") {
	      // Prevent default anchor click behavior
	      event.preventDefault();

	      // Store hash
	      var hash = this.hash;

	      // Using jQuery's animate() method to add smooth page scroll
	      // The optional number (800) specifies the number of milliseconds it takes to scroll to the specified area
	      $('html, body').animate({
	        scrollTop: $(hash).offset().top
	      }, 800, function(){
	   
	        // Add hash (#) to URL when done scrolling (default click behavior)
	        window.location.hash = hash;
	      });
	    } // End if
	  });
	});
	</script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery.min.js" crossorigin="anonymous"></script>
	
   
	<?php wp_head(); ?>
	
</head>

<body <?php body_class(); ?>>

    <div class="main-container">
		<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'onepage' ); ?></a>
		
		<header id="ht-masthead" class="ht-site-header ">
		
			<div class="main-header mo-left header-seo">	
				<div class="header-box">
					
						<!-- <div class="head-side"></div> -->
						<div class="col-sm-12 upper-header padding0">
							<div class="container">
							<div class="col-md-3 col-sm-12 col-xs-12 padding0">
								<div class="logobox">
									<?php 				
										if( get_theme_mod('pages_logoTopsetmaxwidth',true) ) {
											$pages_logoTopsetmaxwidth = 'max-width:'.esc_attr(get_theme_mod('pages_logoTopsetmaxwidth')).';';
										}
										?>
									<?php 
									if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
										the_custom_logo();
									else : 
										if ( is_front_page() ) : ?>
										<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
									<?php else : ?>
										<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
									<?php endif; ?>
									<p class="ht-site-description"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'description' ); ?></a></p>
									<?php endif; ?>						
								</div>

				<!-- 				<div class="main-bar clearfix ">
					<div class="top-bar-head">
						<button class="navbar-toggler collapsed navicon justify-content-end" type="button" data-toggle="collapse" data-target="#navbarNavDropdown" aria-controls="navbarNavDropdown" aria-expanded="false" aria-label="Toggle navigation">
							<span></span>
							<span></span>
							<span></span>
						</button>
						<div class="header-nav navbar-collapse collapse justify-content-end" id="navbarNavDropdown">
	
							<ul class="nav navbar-nav wow slideInLeft ">	
								<?php 
								//wp_nav_menu( array( 
								//	'theme_location' => 'primary', 
								//	'container_class' => 'ht-menu clearfix' ,
								//	'menu_class' => 'ht-clearfix wow',
								//	'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
								//) ); 
								//?>
							</ul>
						
				</div>
						
					</div>
				</div> -->
							</div>	
					
							<div class="header-right-box col-md-offset-3 col-md-6 col-sm-12 col-xs-12 padding0">
								<?php
									$phone = get_theme_mod('luzuk_headermain_phone', '+123-345-6789');
									$phonetitle = get_theme_mod('luzuk_headermain_phonetitle', 'CALL US NOW');
									$email = get_theme_mod('luzuk_headermain_email', 'info@yourwebsite.com');
									$emailtitle = get_theme_mod('luzuk_headermain_emailtitle', 'MAIL US TODAY');
									
								?>
								<?php if($phone || $phonetitle){ ?>
								<div class="col-md-6 col-sm-6 col-xs-12 padding0">	
									<div class="contact-border">
										<div class="data">
											<div class="col-md-4 col-sm-4 col-xs-4">
												<i class="fa fa-mobile" aria-hidden="true"></i></div>
											<div class="col-md-8 col-sm-8 col-xs-8 padding0">	
												<span><?php echo $phonetitle;?></span> 
												<div class="clearfix"></div>
												<?php echo $phone;?> 
											</div>
										</div>
										<div class="clearfix"></div>
									</div>
									<div class="clearfix"></div>
								</div>
							<?php } ?>

				

							 <?php if($email || $emailtitle){ ?>
								<div class="col-md-6 col-sm-6 col-xs-12 padding0">	
									<div class="contact-border">
										<div class="mailto">
											
												<div class="col-md-4 col-sm-4 col-xs-4">
													<i class="fa fa-envelope-o" aria-hidden="true"></i>
												</div>
												<div class="col-md-8 col-sm-8 col-xs-8 padding0">
													<span><?php echo $emailtitle ;?></span>
													<div class="clearfix"></div>
														<a href="mailto:<?php echo $email;?>"><?php echo $email ;?></a>
												</div>
										</div>
										<div class="clearfix"></div>
									</div>
									<div class="clearfix"></div>
								</div>
							<?php } ?>


							</div>
							
							<div class="clearfix"></div>
							</div>
						</div>
						<div class="clearfix"></div>
						<div class="header-bottom">
						<div class="container">

					<div class="site-navigation">
	                    <div class="hamburger-menus">
	                        <span></span>
	                        <span></span>
	                        <span></span>
	                        <span></span>
	                        <span></span>
	                        <span></span>
	                        <span></span>
	                        <span></span>
	                        <span></span>
	                    </div>
	                    <nav class="navigation">
	                        <div class="overlaybg"></div><!--  /.overlaybg -->
	                        <!-- Main Menu -->
	                        <div class="menu-wrapper">
	                            <div class="menu-content">
	                                <?php
	                                    if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
	                                        wp_nav_menu ( array(
	                                            'menu_class' => 'mainmenu',
	                                            'container'=> 'ul',
	                                            'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
	                                            'theme_location' => 'primary',  
	                                        )); 
	                                    } else {
	                                        wp_nav_menu ( array(
	                                            'menu_class' => 'mainmenu',
	                                            'container'=> 'ul',
	                                            'theme_location' => 'primary',  
	                                        )); 
	                                    }
	                                ?>
	                            </div> <!-- /.hours-content-->
	                        </div><!-- /.menu-wrapper --> 
	                    </nav>
	                    <div class="clearfix"></div>
                	</div><!--  /.site-navigation -->



						<!-- <div class="col-md-12 col-sm-12 main-bar-wraper navbar-expand-lg padding0">
							<nav id="ht-site-navigation" class="ht-main-navigation">								
							<div class="toggle-bar"><span><i class="fa fa-bars" aria-hidden="true"></i></span></div>
							<?php 
							//wp_nav_menu( array( 
								//'theme_location' => 'primary', 
								//'container_class' => 'ht-menu clearfix' ,
								//'menu_class' => 'ht-clearfix',
								//'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
							//) ); 
							//?>
							</nav>

						</div> -->
						<div class="clearfix"></div>
						</div>
					</div>
			
			</div>
				
				<div class="clearfix"></div>
				
			</div>
				<div class="clearfix"></div>
	
		<div class="clearfix"></div>	
		</header><!-- #masthead -->
	
	</div>
	