<?php

$wp_customize->add_panel(
	'luzuk_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'lz-fitness-premium')
	)
);
//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'lz-fitness-premium' ),
	'panel' => 'luzuk_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'lz-fitness-premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title', 'lz-fitness-premium' ),
	'panel' => 'luzuk_general_panel',
) );

$wp_customize->add_setting(
    'pages_logoTopsetmaxwidth',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '100', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoTopsetmaxwidth',
    array(
        'settings'      => 'pages_logoTopsetmaxwidth',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Set Logo Max Width', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'headerluzuk_title_color', 'title_tagline', 'Logo Text Color', '#22bcd6');

addColorPalatOption($wp_customize, 'header_SiteTaglineColor', 'title_tagline', 'Tagline Text Color', '#000000');




//BACKGROUND IMAGE
//$wp_customize->add_section( 'background_image', array(
//	'title' => __( 'Background Image', 'lz-fitness-premium' ),
//	'panel' => 'luzuk_general_panel',
//) );

//Header IMAGE
//$wp_customize->add_section( 'header_image', array(
//	'title' => __( 'Header Image', 'lz-fitness-premium' ),
//	'panel' => 'luzuk_general_panel',
//) );

//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'lz-fitness-premium'),
	'panel' => 'luzuk_general_panel',
) );

//theme primary color
addColorPalatOption($wp_customize, 'luzuk_template_color', 'colors', 'Theme Primary Color', '#22bcd6');

//Inner page title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_titlecolor', 'colors', 'Inner page title color', '#ffffff');

//Inner page title Background  color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_Titlebgcolor', 'colors', 'Inner page title Background ', '#de733c');

//Inner breadcrumb Title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbtitlecolor', 'colors', 'Inner page breadcrumbbox title color', '#000');
//Inner page breadcrumbbox current title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlecolor', 'colors', 'Inner page breadcrumbbox current title color', '#de733c');

//Inner page breadcrumbbox background color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbbgcolor', 'colors', 'Inner page breadcrumbbox background color', '#fff');

//page colors
lzCustomLable($wp_customize, 'luzuk_template_color5', 'colors', 'Inner Page h1,h2,h3,h4,h5,h6 Tag Color Settings');

//Inner page Tag color
addColorPalatOption($wp_customize, 'innerpage_h1color', 'colors', 'Inner page h1 Tag color', '#000');
//Inner page Tag color
addColorPalatOption($wp_customize, 'innerpage_h2color', 'colors', 'Inner page h2 Tag color', '#000');
//Inner page Tag color
addColorPalatOption($wp_customize, 'innerpage_h3color', 'colors', 'Inner page h3 Tag color', '#000');

//Inner page Tag color
addColorPalatOption($wp_customize, 'innerpage_h4color', 'colors', 'Inner page h4 Tag color', '#000');

//Inner page Tag color
addColorPalatOption($wp_customize, 'innerpage_h5color', 'colors', 'Inner page h5 Tag color', '#000');
//Inner page Tag color
addColorPalatOption($wp_customize, 'innerpage_h6color', 'colors', 'Inner page h6 Tag color', '#000');


//page colors
lzCustomLable($wp_customize, 'luzuk_template_color6', 'colors', 'Inner Page ul ol li & Text Color Settings');

//Inner page Tag color
addColorPalatOption($wp_customize, 'innerpage_ullicolor', 'colors', 'Inner page ul li Tag color', '#000');

//Inner page Tag color
addColorPalatOption($wp_customize, 'innerpage_ollicolor', 'colors', 'Inner page ol li Tag color', '#000');

//Inner page Tag color
addColorPalatOption($wp_customize, 'innerpage_textcolor', 'colors', 'Inner page P Tag color', '#000');

lzCustomLable($wp_customize, 'luzuk_template_color3', 'colors', 'Inner Testimonial Page Color Settings');

// text color
addColorPalatOption($wp_customize, 'testimonilsinner_boxborderColor', 'colors', 'Testimonial Box Border Color', '#3fbcd6');

// text color
addColorPalatOption($wp_customize, 'testimonilsinner_boxbgColor', 'colors', 'Testimonial Box Background Color', '#ffffff');
// text color
addColorPalatOption($wp_customize, 'testimonilsinner_imageborColor', 'colors', 'Testimonial Author Image Border Color', '#ccc');
// text color
addColorPalatOption($wp_customize, 'testimonilsinner_textColor', 'colors', 'Testimonial Text Color', '#5d5d5d');

// text color
addColorPalatOption($wp_customize, 'testimonilsinner_authornaColor', 'colors', 'Testimonial Author Name Color', '#ed650f');

// text color
addColorPalatOption($wp_customize, 'testimonilsinner_authorDesigColor', 'colors', 'Testimonial Author Designation Color', '#4096df');


lzCustomLable($wp_customize, 'luzuk_template_color4', 'colors', 'Inner Team Page Color Settings');

//team text color
addColorPalatOption($wp_customize, 'teaminner_bgbacColor', 'colors', ' Team Box Background Color', '#ffffff');

//team text color
addColorPalatOption($wp_customize, 'teaminner_imgboderColor', 'colors', ' Team Image Border Color', '#3fbcd6');

//team text color
addColorPalatOption($wp_customize, 'teaminner_imghoverboderColor', 'colors', ' Team Image Hover Border Color', '#de733c');

//team text color
addColorPalatOption($wp_customize, 'teaminner_nametitlColor', 'colors', ' Team Name Title  Color', '#000');

//team text color
addColorPalatOption($wp_customize, 'teaminner_namePOSTColor', 'colors', ' Team Post Color', '#717171');

//team text color
addColorPalatOption($wp_customize, 'teaminner_DescriptiontexColor', 'colors', ' Team Description Text Color', '#333');

//team text color
addColorPalatOption($wp_customize, 'teaminner_SocialBgColor', 'colors', ' Team Social Background Color', '#3fbcd6');

//team text color
addColorPalatOption($wp_customize, 'teaminner_SocialiconColor', 'colors', ' Team Social Icon Color', '#ffffff');

//team text color
addColorPalatOption($wp_customize, 'teaminner_SocialiconborColor', 'colors', ' Team Social Icon Border Color', '#ffffff');

lzCustomLable($wp_customize, 'luzuk_template_color6', 'colors', 'Inner Projects Page Color Settings');

//Projects color
addColorPalatOption($wp_customize, 'projects_titleColor', 'colors', ' Projects Title Color', '#333');
addColorPalatOption($wp_customize, 'projects_titlehoverColor', 'colors', ' Projects Title Hover Color', '#10a9e2');


//Projects color
addColorPalatOption($wp_customize, 'projects_boxborderColor', 'colors', ' Projects Box Border Color', '#43bdd5');

//Projects color
addColorPalatOption($wp_customize, 'projects_boxbgbackColor', 'colors', ' Projects Box Background Color', '#ffffff');


//Projects color
addColorPalatOption($wp_customize, 'projectspage_textColor', 'colors', ' Projects Text Color', '#333');

//Projects color
addColorPalatOption($wp_customize, 'projectspage_numberColor', 'colors', ' Projects Number Color', '#43bdd5');

lzCustomLable($wp_customize, 'luzuk_servicetemplate_color7', 'colors', 'Inner Page Services Colors Settings');

//Colors
addColorPalatOption($wp_customize, 'ct_innerservicetextboxbgColor', 'colors', 'Select Service Text Box background color', '#ffffff');

//Colors
addColorPalatOption($wp_customize, 'ct_innerservicetextboxhovebgColor', 'colors', 'Select Service Text Box Hover background color', '#10a9e2');

//Colors
addColorPalatOption($wp_customize, 'ct_innerservicetitlecoColor', 'colors', 'Select Service Title color', '#252525');

//Colors
addColorPalatOption($wp_customize, 'ct_innerservicetitlehoveColor', 'colors', 'Select Service Title Hover color', '#ffffff');

//Colors
addColorPalatOption($wp_customize, 'ct_innerserviceTextColor', 'colors', 'Select Service Text color', '#737373');

//Colors
addColorPalatOption($wp_customize, 'ct_innerserviceTexthoverColor', 'colors', 'Select Service Text Hover color', '#ffffff');

//Colors
addColorPalatOption($wp_customize, 'ct_innerservicelikButtonbgColor', 'colors', 'Select Service Image Button background color', '#10a9e2');

//Colors
addColorPalatOption($wp_customize, 'ct_innerservicelikButtonhovebgColor', 'colors', 'Select Service Image Button Hover background color', '#ed620f');

//Colors
addColorPalatOption($wp_customize, 'ct_innerservicelikButtoniconColor', 'colors', 'Select Service Image Button icon color', '#ffffff');

//Colors
addColorPalatOption($wp_customize, 'ct_innerservicelikButtonhoviconColor', 'colors', 'Select Service Image Button Hover icon color', '#ffffff');

lzCustomLable($wp_customize, 'luzuk_template_color7', 'colors', 'Inner Page Faqs Colors Settings');

//faqs color
addColorPalatOption($wp_customize, 'faqpage_boxiconColor', 'colors', ' Icon Color', '#ffffff');

//faqs color
addColorPalatOption($wp_customize, 'faqpage_titleColor', 'colors', ' Faq Title Color', '#ffffff');

//faqs color
addColorPalatOption($wp_customize, 'faqpage_titlebgbaColor', 'colors', ' Faq Title Background Color', '#22bcd6');

//faqs color
addColorPalatOption($wp_customize, 'faqpage_boxtextColor', 'colors', ' Faq Text Color', '#000');

//faqs color
addColorPalatOption($wp_customize, 'faqpage_boxbordColor', 'colors', ' Faq Text Box Border Color', '#22bcd6');


lzCustomLable($wp_customize, 'luzuk_template_color8', 'colors', 'Inner Page Gallery Colors Settings');

addColorPalatOption($wp_customize, 'inner_galleryboxColor', 'colors', ' Gallery Box Border Color', '#46c2da');

addColorPalatOption($wp_customize, 'inner_galleryboximgColor', 'colors', ' Gallery Image Border Color', '#ffffff');

addColorPalatOption($wp_customize, 'inner_galleryOverlaybgColor', 'colors', ' Gallery Image Hover Overlay Background Color', '#ffffff');


addColorPalatOption($wp_customize, 'inner_galleryhoviconColor', 'colors', ' Gallery Image Hover Icon  Color', '#666666');

//HEADER LOGO MARGIN SETTINGS
$wp_customize->add_section(
	'luzuk_headerlogo_settings',
	array(
		'title' => __( 'Header Logo Margin Settings', 'lz-fitness-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'luzuk_headerlogo_margin', 'luzuk_headerlogo_settings', ' Site Header Logo Margin:');


$wp_customize->add_setting(
	'pages_logoTmargin',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '10px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoTmargin',
	array(
		'settings'      => 'pages_logoTmargin',
		'section'       => 'luzuk_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Top Margin', 'lz-fitness-premium' )
	)
);


$wp_customize->add_setting(
	'pages_logoBmargin',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '10px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoBmargin',
	array(
		'settings'      => 'pages_logoBmargin',
		'section'       => 'luzuk_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Bottom Margin', 'lz-fitness-premium' )
	)
);


$wp_customize->add_setting(
	'pages_logoLmargin',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '0px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoLmargin',
	array(
		'settings'      => 'pages_logoLmargin',
		'section'       => 'luzuk_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Left Margin', 'lz-fitness-premium' )
	)
);


$wp_customize->add_setting(
	'pages_logoRmargin',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '0px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoRmargin',
	array(
		'settings'      => 'pages_logoRmargin',
		'section'       => 'luzuk_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Right Margin', 'lz-fitness-premium' )
	)
);


//HEADER LOGO MARGIN SETTINGS
$wp_customize->add_section(
	'luzuk_pagepadding_settings',
	array(
		'title' => __( 'Inner Page Padding Settings', 'lz-fitness-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'luzuk_headerlogo_margin', 'luzuk_pagepadding_settings', ' Inner Page Padding Settings');


$wp_customize->add_setting(
    'innerpagesbox_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'innerpagesbox_toppadding',
    array(
        'settings'      => 'innerpagesbox_toppadding',
        'section'       => 'luzuk_pagepadding_settings',
        'type'          => 'text',
        'label'         => __( 'Page Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'innerpagesbox_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'innerpagesbox_bottompadding',
    array(
        'settings'      => 'innerpagesbox_bottompadding',
        'section'       => 'luzuk_pagepadding_settings',
        'type'          => 'text',
        'label'         => __( 'Page Bottom Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'innerpagesbox_leftpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'innerpagesbox_leftpadding',
    array(
        'settings'      => 'innerpagesbox_leftpadding',
        'section'       => 'luzuk_pagepadding_settings',
        'type'          => 'text',
        'label'         => __( 'Page Left Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'innerpagesbox_rightpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'innerpagesbox_rightpadding',
    array(
        'settings'      => 'innerpagesbox_rightpadding',
        'section'       => 'luzuk_pagepadding_settings',
        'type'          => 'text',
        'label'         => __( 'Page Right Padding', 'luzuk-premium' )
    )
);




/// page fonts
//INNER PAGE HEADING FONT SIZE SETTINGS
$wp_customize->add_section(
	'innerheadingfontsize_settings',
	array(
		'title' => __( 'Inner Page Heading Font Size Settings', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);


$wp_customize->add_setting(
	'pages_h1font',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '28px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h1font',
	array(
		'settings'      => 'pages_h1font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 1 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h2font',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '26px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h2font',
	array(
		'settings'      => 'pages_h2font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 2 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h3font',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '24px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h3font',
	array(
		'settings'      => 'pages_h3font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 3 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h4font',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '22px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h4font',
	array(
		'settings'      => 'pages_h4font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 4 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h5font',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '20px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h5font',
	array(
		'settings'      => 'pages_h5font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 5 Font Size', 'luzuk-premium' )
	)
);


$wp_customize->add_setting(
	'pages_h6font',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '18px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h6font',
	array(
		'settings'      => 'pages_h6font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 6 Font Size', 'luzuk-premium' )
	)
);


//HEADER SETTINGS
$wp_customize->add_section(
	'luzuk_header_settings',
	array(
		'title' => __( 'Header Settings', 'lz-fitness-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

$sectionHeader = 'luzuk_header_settings';

//top header



$wp_customize->add_setting(
	'luzuk_headermain_phonetitle',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'CALL US NOW', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'luzuk_headermain_phonetitle',
	array(
		'settings'      => 'luzuk_headermain_phonetitle',
		'section'       => 'luzuk_header_settings',
		'type'          => 'text',
		'label'         => __( 'Phone Label', 'lz-fitness-premium' )
	)
);


$wp_customize->add_setting(
	'luzuk_headermain_phone',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '+123-345-6789', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'luzuk_headermain_phone',
	array(
		'settings'      => 'luzuk_headermain_phone',
		'section'       => 'luzuk_header_settings',
		'type'          => 'text',
		'label'         => __( 'Phone Number', 'lz-fitness-premium' )
	)
);



$wp_customize->add_setting(
	'luzuk_headermain_emailtitle',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'MAIL US TODAY', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'luzuk_headermain_emailtitle',
	array(
		'settings'      => 'luzuk_headermain_emailtitle',
		'section'       => 'luzuk_header_settings',
		'type'          => 'text',
		'label'         => __( 'Email Label', 'lz-fitness-premium' )
	)
);

$wp_customize->add_setting(
	'luzuk_headermain_email',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'info@yourwebsite.com', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'luzuk_headermain_email',
	array(
		'settings'      => 'luzuk_headermain_email',
		'section'       => 'luzuk_header_settings',
		'type'          => 'text',
		'label'         => __( 'Email Address', 'lz-fitness-premium' )
	)
);


 //Set header contact icon color
addColorPalatOption($wp_customize, 'luzuk_headercontacticon_color', 'luzuk_header_settings', 'Header Top contact icon Color', '#de733c');

 //Set header contact icon border  color
addColorPalatOption($wp_customize, 'luzuk_headercontacticonborder_color', 'luzuk_header_settings', 'Header Top contact icon border Color', '#ececec');

 //Set header contact icon bg color
addColorPalatOption($wp_customize, 'luzuk_headercontacticonbg_color', 'luzuk_header_settings', 'Header Top contact icon background Color', '#f6f7f9');

 //Set header contact icon hover color
addColorPalatOption($wp_customize, 'luzuk_headercontacticonhover_color', 'luzuk_header_settings', 'Header Top contact icon hover Color', '#4096df');

 //Set header contact icon border hover color
addColorPalatOption($wp_customize, 'luzuk_headercontacticonborderhover_color', 'luzuk_header_settings', 'Header Top contact icon border hover Color', '#4096df');

   
//Set header contact title color
addColorPalatOption($wp_customize, 'luzuk_headercontacttitle_color', 'luzuk_header_settings', 'Header Top contact Label Color', '#000'); 

//Set header contact data color
addColorPalatOption($wp_customize, 'luzuk_headercontactdata_color', 'luzuk_header_settings', 'Header Top contact details Color', '#000'); 

//Set header contact email hover color
addColorPalatOption($wp_customize, 'luzuk_headercontactemailhover_color', 'luzuk_header_settings', 'Header Top contact email hover Color', '#4096df'); 

// -----------------------------------------------------

 // header background color
addColorPalatOption($wp_customize, 'luzuk_header_TbackgroundColor', 'luzuk_header_settings', 'Header Background color', '#fff');

 // headernavigation background color
  addColorPalatOption($wp_customize, 'luzuk_header_bgColor', 'luzuk_header_settings', 'Header navigation background color', '#fff');

 // header navigation border color
  addColorPalatOption($wp_customize, 'luzuk_header_borderColor', 'luzuk_header_settings', 'Header navigation border color', '#e3e3e3');


//Set header menu colour
addColorPalatOption($wp_customize, 'luzuk_headermenu_color', 'luzuk_header_settings', 'Header Menu Color', '#242424');



	//Set Menu Hover Text colour
	addColorPalatOption($wp_customize, 'luzuk_headerhovermenu_color', 'luzuk_header_settings', 'Hover Menu Text  Color', '#de733c');

	//Set Menu Hover border colour
	addColorPalatOption($wp_customize, 'luzuk_headerhovermenuborder_color', 'luzuk_header_settings', 'Hover Menu Border  Color', '#de733c');

//Set header sub menu colour
addColorPalatOption($wp_customize, 'luzuk_headersubmenu_color', 'luzuk_header_settings', 'Header sub menu Color', '#fff');


//Set header sub menu hover colour
addColorPalatOption($wp_customize, 'luzuk_headersubmenuhover_color', 'luzuk_header_settings', 'Header sub menu hover Color', '#000');

//Set header sub menu Background hover color
addColorPalatOption($wp_customize, 'luzuk_headersubmenubghover_color', 'luzuk_header_settings', 'Header Sub Menu Background hover Color', '#fff'); 


//Set header menu dropsown box bg color
addColorPalatOption($wp_customize, 'luzuk_headermenudropdownboxbg_color', 'luzuk_header_settings', 'Header menu dropdown box bg Color', '#de733c'); 


//Set header menu dropsown box border color
addColorPalatOption($wp_customize, 'luzuk_headermenudropdownboxborder_color', 'luzuk_header_settings', 'Header menu dropdown box border Color', '#4096df'); 





//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'luzuk_footer_copyright_settings',
	array(
		'title' => __( 'Footer Copyright Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

$wp_customize->add_setting(
	'luzuk_footer_copyrighttext',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'Copyright © 2019 LZ One Page. All Rights Reserved', 'Luzuk Premium' )
	)
);
$wp_customize->add_control(
	'luzuk_footer_copyrighttext',
	array(
		'settings'      => 'luzuk_footer_copyrighttext',
		'section'       => 'luzuk_footer_copyright_settings',
		'type'          => 'text',
		'label'         => __( 'Footer Copyright Text', 'Luzuk Premium' )
	)
);

backgroundManager($wp_customize, 'footer', 'luzuk_footer_copyright_settings', $color='#0f0f0f', get_template_directory_uri().'/images/default-gray.png', 'img');



//theme Footer title Color
addColorPalatOption($wp_customize, 'luzuk_footer_title_color', 'luzuk_footer_copyright_settings', 'Footer Title Color', '#ffffff');

//theme Footer icon Color
addColorPalatOption($wp_customize, 'luzuk_footer_icon_color', 'luzuk_footer_copyright_settings', 'Footer Icon Color', '#ffffff');

//theme Footer icon hover Color
addColorPalatOption($wp_customize, 'luzuk_footer_iconhover_color', 'luzuk_footer_copyright_settings', 'Footer Icon Hover Color', '#46c2da');

//theme Footer text Color
addColorPalatOption($wp_customize, 'luzuk_footer_text_color', 'luzuk_footer_copyright_settings', 'Footer Text Color', '#ffffff');

//theme Footer menu Color
addColorPalatOption($wp_customize, 'luzuk_footer_menu_color', 'luzuk_footer_copyright_settings', 'Footer Menu Color', '#ffffff');


//theme Footer menu hover Color
addColorPalatOption($wp_customize, 'luzuk_footer_menuhover_color', 'luzuk_footer_copyright_settings', 'Footer Menu Hover Color', '#ed630b');

//theme Footer menu hover Color
addColorPalatOption($wp_customize, 'luzuk_footer_menuiconcolor', 'luzuk_footer_copyright_settings', 'Footer Menu Icon Color', '#ed630b');


//theme Footer menu date Color
addColorPalatOption($wp_customize, 'luzuk_footer_menudate_color', 'luzuk_footer_copyright_settings', 'Footer Menu Date Color', '#10a9e2');

//theme Footer social Color
addColorPalatOption($wp_customize, 'luzuk_footer_social_color', 'luzuk_footer_copyright_settings', 'Footer Social Color', '#ffffff');

//theme Footer social Hover Color
addColorPalatOption($wp_customize, 'luzuk_footer_socialhover_color', 'luzuk_footer_copyright_settings', 'Footer Social Hover Color', '#45c2d9');



//theme Footer table text Color
addColorPalatOption($wp_customize, 'luzuk_footer_tabletext_color', 'luzuk_footer_copyright_settings', 'Footer Table Text Color', '#ffffff');


//theme Footer table border Color
addColorPalatOption($wp_customize, 'luzuk_footer_tableborder_color', 'luzuk_footer_copyright_settings', 'Footer Table Border Color', '#353535');

addColorPalatOption($wp_customize, 'luzuk_footer_formtext_color', 'luzuk_footer_copyright_settings', 'Footer Form Text Color', '#404040');
addColorPalatOption($wp_customize, 'luzuk_footer_formbg_color', 'luzuk_footer_copyright_settings', 'Footer Form Background  Color', '#ffffff');
addColorPalatOption($wp_customize, 'luzuk_footer_formborder_color', 'luzuk_footer_copyright_settings', 'Footer Form Border Color', '#EEE');



//theme Footer Text Color
addColorPalatOption($wp_customize, 'luzuk_footer_copyrighttext_color', 'luzuk_footer_copyright_settings', 'Copyright Footer Text Color', '#ffffff');


//theme Copyright Footer bg Color
addColorPalatOption($wp_customize, 'luzuk_footer_bg_color', 'luzuk_footer_copyright_settings', 'Footer Background Color', '#1c1c1c');


//theme Copyright Footer bg Color
addColorPalatOption($wp_customize, 'luzuk_footer_copyrightbg_color', 'luzuk_footer_copyright_settings', 'Copyright Footer Background Color', '#0f0f0f');



//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'luzuk_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

//for breadcrumb to show & hide button
$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'luzuk_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Breadcrumb', 'hide' => 'Hide Breadcrumb', ), ) ); 