<?php 
/**
 * Createing an about us pannel for customizer
 *
 */
// service SECTION START HERE 
/*============service SECTION PANEL============*/
$wp_customize->add_section(
    'ct_service_section',
    array(
        'title'         => __( 'Services Section', 'Luzuk Premium' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);
// ENABLE/DISABLE TEAM SECTION
$wp_customize->add_setting(
    'ct_service_section_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'ct_service_section_disable',
        array(
            'settings'      => 'ct_service_section_disable',
            'section'       => 'ct_service_section',
            'label'         => __( 'Disable Section', 'Luzuk Premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk Premium' ),
                'off' => __( 'No', 'Luzuk Premium' )
            )   
        )
    )
);
backgroundManager($wp_customize, 'ctservice', 'ct_service_section', $color='#fbfbfb', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'servicesection_padding', 'ct_service_section', ' Section Padding Setting:');

$wp_customize->add_setting(
    'servicesection_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'servicesection_toppadding',
    array(
        'settings'      => 'servicesection_toppadding',
        'section'       => 'ct_service_section',
        'type'          => 'text',
        'label'         => __( 'Section Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'servicesection_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'servicesection_bottompadding',
    array(
        'settings'      => 'servicesection_bottompadding',
        'section'       => 'ct_service_section',
        'type'          => 'text',
        'label'         => __( 'Section Bottom Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'servicesection_leftpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'servicesection_leftpadding',
    array(
        'settings'      => 'servicesection_leftpadding',
        'section'       => 'ct_service_section',
        'type'          => 'text',
        'label'         => __( 'Section Left Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'servicesection_rightpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'servicesection_rightpadding',
    array(
        'settings'      => 'servicesection_rightpadding',
        'section'       => 'ct_service_section',
        'type'          => 'text',
        'label'         => __( 'Section Right Padding', 'luzuk-premium' )
    )
);



$wp_customize->add_setting(
    'ct_service_title_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'ct_service_title_subtitle_heading',
        array(
            'settings'      => 'ct_service_title_subtitle_heading',
            'section'       => 'ct_service_section',
            'label'         => __( 'Section Title Sub Title', 'Luzuk Premium' ),
        )
    )
);

   //sub title
 lzAddElement($wp_customize, 'featured_sub_title', 'ct_service_section', 'text', $label="Sub Title", 'luzuk_sanitize_text', 'HEADING HERE');

 addColorPalatOption($wp_customize, 'services_subHeadingColor', 'ct_service_section', 'Select Section Sub Title color', '#10a9e2');

  addColorPalatOption($wp_customize, 'services_smallsubHeadingColor', 'ct_service_section', 'Select Section Sub Title Small Tag color', '#10a9e2');

$wp_customize->add_setting(
    'ct_service_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'OUR SERVICES', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'ct_service_title',
    array(
        'settings'      => 'ct_service_title',
        'section'       => 'ct_service_section', 
        'type'          => 'text',
        'label'         => __( 'Heading', 'Luzuk Premium' )
    )
);


addColorPalatOption($wp_customize, 'lz_services_HeadingColor', 'ct_service_section', 'Select Section Title color', '#242424');

addColorPalatOption($wp_customize, 'lz_services_smallHeadingColor', 'ct_service_section', 'Select Section Title Small Tag color', '#242424');

addColorPalatOption($wp_customize, 'services_HeadingrborderColor', 'ct_service_section', 'Select Section Title Border color', '#10a9e2');

$wp_customize->add_setting(
    'featured_subtexttitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'we denounce with righteous indignation and dislike men who are so beguiled and demoralized by the charms of pleasure of the moment.', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'featured_subtexttitle',
    array(
        'settings'      => 'featured_subtexttitle',
        'section'       => 'ct_service_section', 
        'type'          => 'textarea',
        'label'         => __( 'Text', 'Luzuk Premium' )
    )
);


addColorPalatOption($wp_customize, 'lz_services_maintextColor', 'ct_service_section', 'Select Section Text color', '#5d5d5d');



/*for note text*/
$wp_customize->add_setting('lz_CT_service_sectionnoteser_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'lz_CT_service_sectionnoteser_lbl',
        array(
            'settings'      => 'lz_CT_service_sectionnoteser_lbl',
            'section'       => 'ct_service_section',
            'label'         => __( 'Note:', 'Luzuk Premium' ),    
            'description'   => __( 'Just place the shortcode "[SERVICES]" in your page to Show all services in a page', 'Luzuk Premium' ),
        )
    )
);
/*for note text*/

/*for note text*/
$wp_customize->add_setting('lz_service_secnimgnote_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'lz_service_secnimgnote_lbl',
        array(
            'settings'      => 'lz_service_secnimgnote_lbl',
            'section'       => 'ct_service_section',
            'label'         => __( 'Note:', 'Luzuk Premium' ),    
            'description'   => __( 'Kindly add same size of services images. Recommended image size is 355 x 440', 'Luzuk Premium' ),
        )
    )
);
/*for note text*/


$wp_customize->add_setting('ct_service_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'ct_service_npp_heading',
        array(
            'settings'      => 'ct_service_npp_heading',
            'section'       => 'ct_service_section',
            'label'         => __( 'Set Number Of service to show', 'Luzuk Premium' ),
        )
    )
);    
$wp_customize->add_setting('ct_service_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 5));
$wp_customize->add_control(
    'ct_service_npp_count',
    array(
        'settings'      => 'ct_service_npp_count',
        'section'       => 'ct_service_section',
        'type'          => 'select',
        'label'         => __( 'Number of services to show', 'Luzuk Premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    )
);

// service PAGES
for( $i = 1; $i <= 12; $i++ ){
    $wp_customize->add_setting(
        'ct_service_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'ct_service_heading'.$i,
            array(
                'settings'      => 'ct_service_heading'.$i,
                'section'       => 'ct_service_section',
                'label'         => __( 'Our Service', 'Luzuk Premium' ).$i,
            )
        )
    );
    if(is_array($serviceSingleChoice)){
        $wp_customize->add_setting(
            'ct_service_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'ct_service_page'.$i,
            array(
                'settings'      => 'ct_service_page'.$i,
                'section'       => 'ct_service_section',
                'type'=> 'select',
                'label'         => __( 'Select a service', 'Luzuk Premium' ),
                'choices' => $serviceSingleChoice,
            )
        );

    }else{
        $wp_customize->add_setting('ct_service_section_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
        $wp_customize->add_control(
            new luzuk_Info_Text( 
                $wp_customize,
                'ct_service_section_lbl'.$i,
                array(
                    'settings'      => 'ct_service_section_lbl'.$i,
                    'section'       => 'ct_service_section',
                    'label'         => __( 'Note:', 'Luzuk Premium' ),  
                    'description'   => __( '<strong>Changes will not reflect unless you select the service.</strong> <br/>Please add the service from "services menu" and then select service to show.', 'Luzuk Premium' ),
                )
            )
        );
    }

}

//Colors
addColorPalatOption($wp_customize, 'ct_servicetextboxbgColor', 'ct_service_section', 'Select Service Text Box background color', '#ffffff');

//Colors
addColorPalatOption($wp_customize, 'ct_servicetextboxhovebgColor', 'ct_service_section', 'Select Service Text Box Hover background color', '#10a9e2');

//Colors
addColorPalatOption($wp_customize, 'ct_servicetitlecoColor', 'ct_service_section', 'Select Service Title color', '#252525');

//Colors
addColorPalatOption($wp_customize, 'ct_servicetitlehoveColor', 'ct_service_section', 'Select Service Title Hover color', '#ffffff');

//Colors
addColorPalatOption($wp_customize, 'ct_serviceTextColor', 'ct_service_section', 'Select Service Text color', '#737373');

//Colors
addColorPalatOption($wp_customize, 'ct_serviceTexthoverColor', 'ct_service_section', 'Select Service Text Hover color', '#ffffff');

//Colors
addColorPalatOption($wp_customize, 'ct_servicelikButtonbgColor', 'ct_service_section', 'Select Service Image Button background color', '#10a9e2');

//Colors
addColorPalatOption($wp_customize, 'ct_servicelikButtonhovebgColor', 'ct_service_section', 'Select Service Image Button Hover background color', '#ed620f');


//Colors
addColorPalatOption($wp_customize, 'ct_servicelikButtoniconColor', 'ct_service_section', 'Select Service Image Button icon color', '#ffffff');

//Colors
addColorPalatOption($wp_customize, 'ct_servicelikButtonhoviconColor', 'ct_service_section', 'Select Service Image Button Hover icon color', '#ffffff');


