<?php 
    $wp_customize->add_section(
        'about_area',
        array(
            'title' => __( 'About Us Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'about_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'about_area_disable',
            array(
                'settings'      => 'about_area_disable',
                'section'       => 'about_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 
lzCustomLable($wp_customize, 'aboutarea_wavelb', 'about_area', 'Set Section Wave:');

$wp_customize->add_setting( 'aboutwave_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'aboutwave_display', array( 'label' => 'Section Wave Display', 'section' => 'about_area', 'settings' => 'aboutwave_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Wave', 'hide' => 'Hide Wave', ), ) );

addColorPalatOption($wp_customize, 'about_area_bg_color', 'about_area', 'Section Background & Wave Color ', '#fff');

lzCustomLable($wp_customize, 'aboutarea_padding', 'about_area', 'Set Section Padding:');

$wp_customize->add_setting(
    'about_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaTpadding',
    array(
        'settings'      => 'about_areaTpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'about_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaBpadding',
    array(
        'settings'      => 'about_areaBpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);


  $wp_customize->add_setting(
        'about_image_heading',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'about_image_heading',
            array(
                'settings'      => 'about_image_heading',
                'section'       => 'about_area',
                'label'         => __( 'Left Image', 'luzuk-premium' ),
            )
        )
    );

      $wp_customize->add_setting(
        'about_image',
        array(
            'sanitize_callback' => 'esc_url_raw'
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'about_image',
            array(
                'section' => 'about_area',
                'settings' => 'about_image',
                'description' => __('Recommended Image Size: 500X600px', 'luzuk-premium')
            )
        )
    );


    $wp_customize->add_setting(
        'about_title_heading',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'about_title_heading',
            array(
                'settings'      => 'about_title_heading',
                'section'       => 'about_area',
                'label'         => __( 'Section Heading, Section Text', 'luzuk-premium' ),
            )
        )
    );    


    $wp_customize->add_setting(
        'about_title',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'About Us', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'about_title',
        array(
            'settings'      => 'about_title',
            'section'       => 'about_area',
            'type'          => 'text',
            'label'         => __( 'Section Heading', 'luzuk-premium' )
        )
    );

addColorPalatOption($wp_customize, 'about_area_sectitle_color', 'about_area', 'Heading color ', '#202020');

addColorPalatOption($wp_customize, 'about_area_sectitleborder_color_one', 'about_area', 'Heading Border Color One ', '#f499c3');
addColorPalatOption($wp_customize, 'about_area_sectitleborder_color_two', 'about_area', 'Heading Border Color Two ', '#f62b85');


    $wp_customize->add_setting(
        'about_text',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which do not look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there is not anything embarrassing hidden in the middle. There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which do not look even slightly believable. If you are going to use a passage of Lorem Ipsum.', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'about_text',
        array(
            'settings'      => 'about_text',
            'section'       => 'about_area',
            'type'          => 'textarea',
            'label'         => __( 'Section Text', 'luzuk-premium' )
        )
    );
addColorPalatOption($wp_customize, 'about_area_text', 'about_area', 'Section Text color', '#4f4f4f');


$wp_customize->add_setting('aboutus_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'aboutus_npp_heading',
        array(
            'settings'      => 'aboutus_npp_heading',
            'section'       => 'about_area',
            'label'         => __( 'Number Of About Plans', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('aboutus_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
    'aboutus_npp_count',
    array(
        'settings'      => 'aboutus_npp_count',
        'section'       => 'about_area',
        'type'          => 'select',
        'label'         => __( 'Number of About plan to show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    )
);

//ABOUT PAGES
for( $i = 1; $i <= 12; $i++ ){
    $wp_customize->add_setting(
        'aboutus_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'aboutus_header'.$i,
            array(
                'settings'      => 'aboutus_header'.$i,
                'section'       => 'about_area',
                'label'         => __( 'About Page ', 'luzuk-premium' ).$i
            )
        )
    );

     $wp_customize->add_setting(
        'aboutus_page_icon'.$i,
        array(
            'default'           => 'fa fa-check',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'aboutus_page_icon'.$i,
            array(
                'settings'      => 'aboutus_page_icon'.$i,
                'section'       => 'about_area',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'luzuk-premium' ),
            )
        )
    );

lzAddElement($wp_customize, 'aboutus_page_title'.$i, 'about_area', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='Starting New Project');

lzAddElement($wp_customize, 'aboutus_page_description'.$i, 'about_area', $type = 'textarea', $label="Description", $callback ='luzuk_sanitize_text', $default='Create a new idea for client project');
    
}
addColorPalatOption($wp_customize, 'about_area_pageicon', 'about_area', 'About page icon color', '#f72985');
addColorPalatOption($wp_customize, 'about_area_pageiconborder', 'about_area', 'About page icon border color', '#f72985');
addColorPalatOption($wp_customize, 'about_area_pageiconborderhover', 'about_area', 'About page icon border hover color', '#f72985');

addColorPalatOption($wp_customize, 'about_area_pagetitle', 'about_area', 'About page title color', '#3c3c3c');

addColorPalatOption($wp_customize, 'about_area_pagetext', 'about_area', 'About page text color', '#4f4f4f');



