<?php 
$wp_customize->add_section(
    'service_area',
    array(
        'title'         => __( 'Our Services Section', 'Luzuk' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);
$wp_customize->add_setting(
    'service_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'service_area_disable',
        array(
            'settings'      => 'service_area_disable',
            'section'       => 'service_area',
            'label'         => __( 'Disable Section', 'Luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk' ),
                'off' => __( 'No', 'Luzuk' )
            )   
        )
    )
);

lzCustomLable($wp_customize, 'luzuk_sec_servicessectionpadding', 'service_area', 'Set Section Padding:');

$wp_customize->add_setting(
    'service_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaTpadding',
    array(
        'settings'      => 'service_areaTpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'service_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaBpadding',
    array(
        'settings'      => 'service_areaBpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'service_areaLpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaLpadding',
    array(
        'settings'      => 'service_areaLpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Left Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'service_areaRpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaRpadding',
    array(
        'settings'      => 'service_areaRpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Right Padding', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'service_area_overlayop', 'service_area', 'Set Section Background Color:');

addColorPalatOption($wp_customize, 'servicearea_secbg_color_one', 'service_area', 'Background Color One ', '#f3f3f3');
addColorPalatOption($wp_customize, 'servicearea_secbg_color_two', 'service_area', 'Background Color Two ', '#ffffff');


$wp_customize->add_setting(
    'services_maintitle_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'services_maintitle_subtitle_heading',
        array(
            'settings'      => 'services_maintitle_subtitle_heading',
            'section'       => 'service_area',
            'label'         => __( 'Section Heading', 'Luzuk' ),
        )
    )
);
$wp_customize->add_setting(
    'services_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Our Services', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'services_maintitle',
    array(
        'settings'      => 'services_maintitle',
        'section'       => 'service_area', 
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'servicearea_sectitle_color', 'service_area', 'Heading color ', '#202020');

addColorPalatOption($wp_customize, 'servicearea_sectitleborder_color_one', 'service_area', 'Heading Border Color One ', '#f499c3');
addColorPalatOption($wp_customize, 'servicearea_sectitleborder_color_two', 'service_area', 'Heading Border Color Two ', '#f62b85');

$wp_customize->add_setting('service_area_lbl2', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'service_area_lbl2',
        array(
            'settings'      => 'service_area_lbl2',
            'section'       => 'service_area',
            'label'         => __( 'Note2:', 'Luzuk' ),  
            'description'   => __( 'Use Shortcode [SERVICES] to show all services in a page', 'Luzuk' ),
        )
    )
);


$wp_customize->add_setting('service_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'service_npp_heading',
        array(
            'settings'      => 'service_npp_heading',
            'section'       => 'service_area',
            'label'         => __( 'Number of Services to show', 'Luzuk' ),
        )
    )
);    
$wp_customize->add_setting('service_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
    'service_npp_count',
    array(
        'settings'      => 'service_npp_count',
        'section'       => 'service_area',
        'type'          => 'select',
        'label'         => __( 'Number of services to show', 'Luzuk' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16)
    )
);

$ServicesSingleChoice[] = 'Select';

for( $i = 1; $i <= 16; $i++ ){
    $wp_customize->add_setting(
        'services_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'services_heading'.$i,
            array(
                'settings'      => 'services_heading'.$i,
                'section'       => 'service_area',
                'label'         => __( 'Service Page', 'Luzuk' ).$i,
            )
        )
    );
    if(is_array($ServicesSingleChoice)){
        $wp_customize->add_setting(
            'services_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'services_page'.$i,
            array(
                'settings'      => 'services_page'.$i,
                'section'       => 'service_area',
                'type'=> 'select',
                'label'         => __( 'Select a Service Page', 'Luzuk' ),
                'choices' => $ServicesSingleChoice,
            )
        );

$wp_customize->add_setting(
        'services_page_icon1'.$i,
        array(
            'default'           => 'fa fa-bug',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'services_page_icon1'.$i,
            array(
                'settings'      => 'services_page_icon1'.$i,
                'section'       => 'service_area',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'Luzuk' ),
            )
        )
    );



    }else{
        $wp_customize->add_setting('service_area_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
        $wp_customize->add_control(
            new luzuk_Info_Text( 
                $wp_customize,
                'service_area_lbl'.$i,
                array(
                    'settings'      => 'service_area_lbl'.$i,
                    'section'       => 'service_area',
                    'label'         => __( 'Note:', 'Luzuk' ),    
                    'description'   => __( '<strong>Changes will not reflect unless you select the Service Page.</strong> <br/>Please add the Services from "Services menu" and then select Services to show information.', 'Luzuk' ),
                )
            )
        );
    }
 
}
addColorPalatOption($wp_customize, 'services_icon1Color', 'service_area', 'Services Icon color ', '#fca902');

addColorPalatOption($wp_customize, 'services_iconhoverColor', 'service_area', 'Services Icon Hover color ', '#fff');
//addColorPalatOption($wp_customize, 'services_icon2Color', 'service_area', 'Services Icon Two color ', '#089ad6');
//addColorPalatOption($wp_customize, 'services_icon3Color', 'service_area', 'Services Icon Three color ', '#fca902');
//addColorPalatOption($wp_customize, 'services_icon4Color', 'service_area', 'Services Icon Four color ', '#20d092');

addColorPalatOption($wp_customize, 'services_ServicePageTitleColor', 'service_area', 'Services Title color ', '#3d3d3d');

addColorPalatOption($wp_customize, 'services_SubttlColor', 'service_area', 'Services Text color ', '#505050');



addColorPalatOption($wp_customize, 'services_ServicePageTitlehoverColor', 'service_area', 'Services Title Hover color ', '#fff');

addColorPalatOption($wp_customize, 'services_SubttlhoverColor', 'service_area', 'Services Text Hover color ', '#fff');

addColorPalatOption($wp_customize, 'servicearea_boxbg_color', 'service_area', 'Services Box Color ', '#fff');

addColorPalatOption($wp_customize, 'servicearea_boxbg_color_one', 'service_area', 'Services Box Hover Color One ', '#8972ea');
addColorPalatOption($wp_customize, 'servicearea_boxbg_color_two', 'service_area', 'Services Box Hover Color Two ', '#516ced');

// end to show & hide button


