<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package LZ Fitness Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>

	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>
	   <!--- Tool Tip-->
	
		
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/jquery.tooltip.css" type="text/css" />
    <script type="text/javascript" src="https://code.jquery.com/jquery.min.js"></script>
    <script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/jquery.tooltip.js"></script>
    <script type="text/javascript">
      $j = jQuery.noConflict();
      $j(document).ready(function(){
        $j("div.item").tooltip();
      });
    </script>

   
   <!--- Tool Tip end-->
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<div class="main-container">
		<!-- <a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'Luzuk' ); ?></a> -->
		<div id="loading-area"><div class="la-anim-10"></div></div>
		<!-- header -->
		<header class="site-header header-transparent header mo-left header-seo" id="myHeader">


			<div class="top-header">
				<div class="container">
					<div class="col-md-5 col-sm-6 col-xs-12 padding0">
						<p class="ht-site-description"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'description' ); ?></a></p>
						
					</div>
					<div class="col-md-5 col-sm-6 col-xs-12 padding0">
						
						<?php

								$facebook = get_theme_mod('header_fb', '//facebook.com/');
								$twitter = get_theme_mod('header_tw', '//twitter.com/');
								$linkedIn = get_theme_mod('header_in', '//linkedin.com/');
								$youtube = get_theme_mod('header_yt', '//www.youtube.com/');
						?>
							<?php if($facebook || $twitter || $linkedIn || $youtube ){ ?>

							<div class="social-icons">
									<?php if(!empty($facebook)){ ?>
										<a href="<?php echo $facebook ?>" target="_blank" title="Facebook"><span class="fa fa-facebook"></span></a>
									<?php }?>
									<?php if(!empty($twitter)){ ?>
										<a href="<?php echo $twitter ?>" target="_blank" title="Twitter"><span class="fa fa-twitter"></span></a>
									<?php }?>
									<?php if(!empty($linkedIn)){ ?>
										<a href="<?php echo $linkedIn ?>" target="_blank" title="Linked In"><span class="fa fa-linkedin"></span></a>
									<?php }?>
									
								<?php if(!empty($youtube)){ ?>
									<a href="<?php echo $youtube ?>" target="_blank" title="youtube"><span class="fa fa-youtube"></span></a>
								<?php }?>
									
								</div>
						<?php }?>

					</div>
					<div class="col-md-2 total-count">
						<?php if(function_exists ('wc_get_cart_url')){?>				
    			<a href="<?php echo wc_get_cart_url();?>" class="Cart">
    				<i class="fa fa-shopping-cart"></i>
    			</a>
    			<div class="count heading-font"><?php global $woocommerce; ?><?php echo WC()->cart->get_cart_contents_count(); ?></div>
    		<?php }?>
					</div>
				</div>
					<div class="clearfix"></div>
			</div>
			<div class="clearfix"></div>

			<div class="maintop-header">
				<div class="container">
		
				<?php 
					if( get_theme_mod('pages_logoTmargin',true) ) {
		                $pages_logoTmargin = 'margin-top:'.esc_attr(get_theme_mod('pages_logoTmargin')).';';
		            }
		            if( get_theme_mod('pages_logoBmargin',true) ) {
		                $pages_logoBmargin = 'margin-bottom:'.esc_attr(get_theme_mod('pages_logoBmargin')).';';
		            }
		            if( get_theme_mod('pages_logoLmargin',true) ) {
		                $pages_logoLmargin = 'margin-left:'.esc_attr(get_theme_mod('pages_logoLmargin')).';';
		            }
		            if( get_theme_mod('pages_logoRmargin',true) ) {
		                $pages_logoRmargin = 'margin-right:'.esc_attr(get_theme_mod('pages_logoRmargin')).';';
		            }
				?>
			<div class="col-md-4 col-sm-6 col-xs-8 logomainboxx logo"> 
			
				<div class="logobox" style="<?php echo esc_attr($pages_logoTmargin); ?>" "<?php echo esc_attr($pages_logoBmargin); ?>" "<?php echo esc_attr($pages_logoLmargin); ?>" "<?php echo esc_attr($pages_logoRmargin); ?>">
					<?php 
					if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
						the_custom_logo();
				else : 
					if ( is_front_page() ) : ?>
						<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
						<?php else : ?>
							<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
						<?php endif; ?>
					<?php endif; ?>
				</div>
			</div>
			<!-- main header -->
			<div class="col-md-8 col-sm-6 col-xs-4  padding0 sticky-header main-bar-wraper navbar-expand-lg">
				<div class="main-bar clearfix ">
					<div class="top-bar-head">

						<!-- nav toggle button -->
						<button class="navbar-toggler collapsed navicon justify-content-end" type="button" data-toggle="collapse" data-target="#navbarNavDropdown" aria-controls="navbarNavDropdown" aria-expanded="false" aria-label="Toggle navigation">
							<span></span>
							<span></span>
							<span></span>
						</button>
						<!-- main nav -->


						<div class="header-nav navbar-collapse collapse justify-content-end" id="navbarNavDropdown" >
							<div class="reslogobox">
								<?php 
								if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
									the_custom_logo();
							else : 
								if ( is_front_page() ) : ?>
									<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
									<?php else : ?>
										<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
									<?php endif; ?>
									<!-- <p class="ht-site-description"><a href="<?php //echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php //bloginfo( 'description' ); ?></a></p> -->
								<?php endif; ?>
								<!-- .site-branding -->
								<div class="clearfix"></div>
					<p class="ht-site-description"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'description' ); ?></a></p>
							</div>

							<ul class="nav navbar-nav">	
								<?php 
								wp_nav_menu( array( 
									'theme_location' => 'primary', 
									'container_class' => 'ht-menu clearfix' ,
									'menu_class' => 'ht-clearfix wow',
									'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
								) ); 
								?>
							</ul>

							<div class="socialresponsive">
									<?php

								$facebook = get_theme_mod('header_fb', '//facebook.com/');
								$twitter = get_theme_mod('header_tw', '//twitter.com/');
								$linkedIn = get_theme_mod('header_in', '//linkedin.com/');
								$youtube = get_theme_mod('header_yt', '//www.youtube.com/');
						?>
							<?php if($facebook || $twitter || $linkedIn || $youtube ){ ?>

							<div class="social-icons">
									<?php if(!empty($facebook)){ ?>
										<a href="<?php echo $facebook ?>" target="_blank" title="Facebook"><span class="fa fa-facebook"></span></a>
									<?php }?>
									<?php if(!empty($twitter)){ ?>
										<a href="<?php echo $twitter ?>" target="_blank" title="Twitter"><span class="fa fa-twitter"></span></a>
									<?php }?>
									<?php if(!empty($linkedIn)){ ?>
										<a href="<?php echo $linkedIn ?>" target="_blank" title="Linked In"><span class="fa fa-linkedin"></span></a>
									<?php }?>
									
								<?php if(!empty($youtube)){ ?>
									<a href="<?php echo $youtube ?>" target="_blank" title="youtube"><span class="fa fa-youtube"></span></a>
								<?php }?>
									
								</div>
						<?php }?>


							</div>

						</div>

					</div>
				</div>
			</div>
				<div class="clearfix"></div>
			</div>
		</div>
			<!-- main header END -->
			<div class="clearfix"></div>

		</header><!-- #masthead -->

	</div>
