<?php


    /**
     * Use for the show the testimonials at home page and in testimonial page with shortcode
     * @param int $pageId default is null the id of a post
     * @param boolean $isCustomizer default is false if set to true it mean the output is set for the home page
     * @param int $i default null
     * @param boolean $showStaticVals default is false
     * @return void
     * @author Parag Chaure <parag.radical@outlook.com>
     * */
    function testimonialShortCode($pageId = null, $isCustomizer = false, $i = null, $showStaticVals = false) {
        global $query;
        $args = array('post_type' => 'lz_fitness_testimoni');
        if (!empty($pageId)) {
            $args['page_id'] = absint($pageId);
        } else {
            $args['paged'] = max(1, get_query_var('paged'));
        }
        $i = !empty($i) ? $i : 0;
        $text = '';
        $query = new WP_Query($args);
        // print_r($query);
        if ($query->have_posts()):
            $cssCls = ($isCustomizer == false) ? 'col-sm-12' : 'col-sm-10 col-sm-offset-1';

            ob_start();
            while ($query->have_posts()) : $query->the_post();
                $post = get_post();
                $lz_fitness_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'total-team-thumb');
                ?>
                <?php if ($isCustomizer == false) { ?>
                <div class="item <?php if ($i == 0) { ?>active<?php } ?>">
                    <blockquote>
                        <div class="row">
                            <div class="<?php echo $cssCls; ?>">
                                <div class="page-testimonial-box">
                                    <div class="col-sm-3">
                                        <img src="<?php echo (!empty($lz_fitness_image[0])) ? $lz_fitness_image[0] : get_template_directory_uri() . '/images/team-thumb.png' ?>" class="img-responsive" alt="<?php the_title(); ?>" />
                                    </div>
                                    <div class="col-sm-9">
                                        <p><?php
                                        if (has_excerpt()) {
                                            echo get_the_excerpt();
                                        } else {
                                            echo lz_fitness_excerpt(get_the_content(), 250);
                                        }
                                        ?></p>
                                        <h6><?php the_title(); ?></h6>
                                        <div class="text-designation">
                                            <?php
                                            $name2 = get_post_meta($post->ID, 'testimonial_Sub_Title', false);
                                            echo (!empty($name2[0])) ? $name2[0] : '';
                                            ?>
                                        </div>
                                    </div>
                                    <div class="clearfix"></div>
                                </div>
                            </div>
                        </div>
                    </blockquote>
                </div>
                <?php }else{ ?>
						<div class="col-md-2 paddind5">
							<div id="item<?php echo ++$i;?>" class="item">
								<a class="thumb">
									<img src="<?php echo $lz_fitness_image[0]; ?>">
								</a>
								<div class="tooltip_description" style="display:none" title="">
								 <h3><?php the_title(); ?></h3>
                                    <?php
										if (has_excerpt()) {
											echo get_the_excerpt();
										} else {
											echo lz_fitness_excerpt(get_the_content(), 250);
										}
										?>
								</div>
							</div>
						</div>

                <?php } ?>
                <?php
            endwhile;
            $text = ob_get_contents();
            ob_clean();
            ob_end_flush();
        endif;
        wp_reset_postdata();
        // echo $text;
        return $text;
    }

    add_shortcode('TESTIMONIALS', 'testimonialShortCode');
//CREATING A SHORTCODE FOR THE GALLERY SECTION 
    add_shortcode('GALLERY', 'galleryShortcode');
//adding a shortcode for the team / trainer list 
    add_shortcode('PLAN_PRICING', 'pricingShortcode');


    