<?php

$wp_customize->add_panel(
        'lz_fitness_general_panel', array(
    'priority' => 19,
    'title' => __('General Configuration', 'luzuk-premium')
        )
);
//STATIC FRONT PAGE
$wp_customize->add_section('static_front_page', array(
    'title' => __('Static Front Page', 'luzuk-premium'),
    'panel' => 'lz_fitness_general_panel',
    'description' => __('Your theme supports a static front page.', 'luzuk-premium'),
));

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section('title_tagline', array(
    'title' => __('Site Logo/Title/Tagline', 'luzuk-premium'),
    'panel' => 'lz_fitness_general_panel',
));

//HEADER LOGO MARGIN SETTINGS
$wp_customize->add_section(
    'lz_fitness_headerlogo_settings',
    array(
        'title' => __( 'Header Logo Margin Settings', 'luzuk-premium' ),
        'panel' => 'lz_fitness_general_panel',
    )
);

lzCustomLable($wp_customize, 'lz_fitness_headerlogo_margin', 'lz_fitness_headerlogo_settings', ' Site Header Logo Margin:');

$wp_customize->add_setting(
    'pages_logoTmargin',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoTmargin',
    array(
        'settings'      => 'pages_logoTmargin',
        'section'       => 'lz_fitness_headerlogo_settings',
        'type'          => 'text',
        'label'         => __( 'Logo Top Margin', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'pages_logoBmargin',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoBmargin',
    array(
        'settings'      => 'pages_logoBmargin',
        'section'       => 'lz_fitness_headerlogo_settings',
        'type'          => 'text',
        'label'         => __( 'Logo Bottom Margin', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'pages_logoLmargin',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoLmargin',
    array(
        'settings'      => 'pages_logoLmargin',
        'section'       => 'lz_fitness_headerlogo_settings',
        'type'          => 'text',
        'label'         => __( 'Logo Left Margin', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'pages_logoRmargin',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoRmargin',
    array(
        'settings'      => 'pages_logoRmargin',
        'section'       => 'lz_fitness_headerlogo_settings',
        'type'          => 'text',
        'label'         => __( 'Logo Right Margin', 'luzuk-premium' )
    )
);


//BACKGROUND IMAGE
$wp_customize->add_section('background_image', array(
    'title' => __('Background Image', 'luzuk-premium'),
    'panel' => 'lz_fitness_general_panel',
));

//Header IMAGE
$wp_customize->add_section('header_image', array(
    'title' => __('Header Image', 'luzuk-premium'),
    'panel' => 'lz_fitness_general_panel',
));




//HEADER SETTINGS
$wp_customize->add_section(
    'header_settings',
    array(
        'title' => __( 'Header Settings', 'Luzuk Premium' ),
        'panel' => 'lz_fitness_general_panel',
    )
);
//Sticky header colors

lzCustomLable($wp_customize, 'header_stickydisplay', 'header_settings', 'Sticky Header Setting:');


    //ENABLE/DISABLE STICKY HEADER
$wp_customize->add_setting(
    'lz_fitness_sticky_header_enable',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new lz_fitness_Switch_Control(
        $wp_customize,
        'lz_fitness_sticky_header_enable',
        array(
            'settings'      => 'lz_fitness_sticky_header_enable',
            'section'       => 'header_settings',
            'label'         => __( 'Sticky Header', 'Luzuk Premium' ),
            'on_off_label'  => array(
                'on' => __( 'Enable', 'Luzuk Premium' ),
                'off' => __( 'Disable', 'Luzuk Premium' )
            )   
        )
    )
);


// addColorPalatOption($wp_customize, 'header_stickyheaderbg', 'header_settings', 'Sticky Header Background', '#000');


 //header tagline color
addColorPalatOption($wp_customize, 'header_taglineColor', 'header_settings', 'Header Tagline color', '#fff');

// Adding the Label
lzCustomLable($wp_customize, 'lz_fitness_reservation_lblImgTxt', 'header_settings' , 'Social media icons');

// FACEBOOK 
$wp_customize->add_setting('header_fb', array('default'=> 'https://facebook.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_fb',
    array(
        'settings'      => 'header_fb',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'Facebook Url', 'luzuk-premium' )
    )
);
// TWITTER
$wp_customize->add_setting('header_tw', array('default'=> 'https://twitter.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_tw',
    array(
        'settings'      => 'header_tw',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'Twitter Url', 'luzuk-premium' )
    )
);

// LINKED IN
$wp_customize->add_setting('header_in',array('default'=> 'https://linkedin.com','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_in',
    array(
        'settings'      => 'header_in',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'Linkedin Url', 'luzuk-premium' )
    )
);



// youtube 
$wp_customize->add_setting('header_yt',array('default'=> 'https://www.youtube.com/','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_yt',
    array(
        'settings'      => 'header_yt',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'Youtube Url', 'luzuk-premium' )
    )
);

//Set header social colour
addColorPalatOption($wp_customize, 'header_socialiconColor', 'header_settings', 'Header Social Color', '#acacaa');

//Set header social border colour
addColorPalatOption($wp_customize, 'header_socialiconborderColor', 'header_settings', 'Header Social Border Color', '#46423f');

//Set header social hover colour
addColorPalatOption($wp_customize, 'header_socialiconhoverColor', 'header_settings', 'Header Social Hover Color', '#eb4444');

lzCustomLable($wp_customize, 'header_clrlblImgTxt', 'header_settings', 'Set Header Menu Colors:');

   //Set header menu colour
addColorPalatOption($wp_customize, 'headermenu_color', 'header_settings', 'Header Menu Color', '#faf8f9');

addColorPalatOption($wp_customize, 'headerhovermenu_color', 'header_settings', 'Header Menu Hover Color', '#eb4444');

addColorPalatOption($wp_customize, 'headerhovermenuborder_color', 'header_settings', 'Header Menu border Hover Color', '#eb4444');

    //Set header sub menu colour
addColorPalatOption($wp_customize, 'headersubmenu_color', 'header_settings', 'Header Dropdown Menu Color', '#000');

addColorPalatOption($wp_customize, 'headersubmenuhover_color', 'header_settings', 'Header Dropdown Menu hover Color', '#fff');

addColorPalatOption($wp_customize, 'headersubmenubghover_color', 'header_settings', 'Header Dropdown Menu hover Background Color', '#eb4444');

addColorPalatOption($wp_customize, 'headerdropdowncurrentsubmenu_color', 'header_settings', 'Header Dropdown Current Menu Color', '#eb4444');

    //Set header sub menu Background colour
addColorPalatOption($wp_customize, 'headersubmenubg_color', 'header_settings', 'Header Dropdown Background Color', '#fff');

    //Set header sub menu border colour
addColorPalatOption($wp_customize, 'headersubmenuborder_color', 'header_settings', 'Header Dropdown Border Color', '#eb4444');


lzCustomLable($wp_customize, 'innerpageheader_lblbutton1display', 'header_settings', 'Inner Page Header Setting:');


//Set header social colour
addColorPalatOption($wp_customize, 'header_innerpageheaderbgColor', 'header_settings', 'Inner page Header Background Color', '#000');



//responsive header colors

lzCustomLable($wp_customize, 'header_lblbutton1display', 'header_settings', 'Responsive Header Setting:');


addColorPalatOption($wp_customize, 'headerboxbgresponsive_color', 'header_settings', 'Header background color for mobile view', '#000');

addColorPalatOption($wp_customize, 'header_responsivetaglineColor', 'header_settings', 'Header site title and tagline color', '#fff');

addColorPalatOption($wp_customize, 'header_navresponsivebgColor', 'header_settings', 'Header nav bar background color', '#eb4444');
addColorPalatOption($wp_customize, 'header_navresponsiveborderrightColor', 'header_settings', 'Header nav bar border color', '#fff');
addColorPalatOption($wp_customize, 'header_navresponsiveoffbtnColor', 'header_settings', 'Header nav bar button color', '#fff');
addColorPalatOption($wp_customize, 'header_navresponsiveonbtnColor', 'header_settings', 'Header nav bar button hover color', '#fff');
addColorPalatOption($wp_customize, 'header_navresponsiveonbtnbgColor', 'header_settings', 'Header nav bar button hover background color', '#eb4444');


addColorPalatOption($wp_customize, 'header_responsivemenuColor', 'header_settings', 'Header menu color', '#fff');
addColorPalatOption($wp_customize, 'header_responsivemenuhoverColor', 'header_settings', 'Header menu hover color', '#000');
addColorPalatOption($wp_customize, 'header_responsivecurrentmenuColor', 'header_settings', 'Header current menu color', '#eb4444');
addColorPalatOption($wp_customize, 'header_responsivecurrentmenubgColor', 'header_settings', 'Header current menu background color', '#fff');

addColorPalatOption($wp_customize, 'header_responsivesubmenuboxbgColor', 'header_settings', 'Header Dropdown box color', '#fff');
addColorPalatOption($wp_customize, 'header_responsivesubmenuColor', 'header_settings', 'Header sub menu color', '#000');
addColorPalatOption($wp_customize, 'header_responsivesubmenuhoverColor', 'header_settings', 'Header sub menu hover color', '#fff');

addColorPalatOption($wp_customize, 'header_responsivesubmenucurrentmenuColor', 'header_settings', 'Header sub current menu color', '#eb4444');

addColorPalatOption($wp_customize, 'header_responsivesocialboxColor', 'header_settings', 'Header social box color', '#fff');


//COLOR SETTINGS
$wp_customize->add_section('colors', array(
    'title' => __('Colors', 'luzuk-premium'),
    'panel' => 'lz_fitness_general_panel',
));
//theme primary color
addColorPalatOption($wp_customize, 'lz_fitness_template_color', 'colors', 'Theme Primary Color', '#eb4444');

//theme Secondary color
addColorPalatOption($wp_customize, 'theme_secondary_color', 'colors', 'Theme Secondary Color', '#000');

lzCustomLable($wp_customize, 'innerpage_colorsetting', 'colors', ' Inner Page Color Setting:');

//Inner page title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_titlecolor', 'colors', 'Inner page title color', '#fff');
//Inner page background color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_bgcolor', 'colors', 'Inner page title background color', '#eb4444');

//Inner page content box heading 1 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh1color', 'colors', 'Heading 1 color', '#333333');

//Inner page content box heading 2 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh2color', 'colors', 'Heading 2 color', '#333333');

//Inner page content box heading 3 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh3color', 'colors', 'Heading 3 color', '#333333');

//Inner page content box heading 4 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh4color', 'colors', 'Heading 4 color', '#333333');

//Inner page content box heading 5 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh5color', 'colors', 'Heading 5 color', '#333333');

//Inner page content box heading 6 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh6color', 'colors', 'Heading 6 color', '#333333');

//Inner page content box text color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtextcolor', 'colors', 'Inner page content box text color', '#303030');

//Inner page content box list color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlistcolor', 'colors', 'Inner page content box list color', '#303030');

//Inner page content box list icon color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlisticoncolor', 'colors', 'Inner page content box list icon color', '#eb4444');

//Inner page content box list number color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlistnumbercolor', 'colors', 'Inner page content box list number color', '#fff');

//Inner page content box list number bg color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlistnumberbgcolor', 'colors', 'Inner page content box list number background color', '#eb4444');

//Inner page content box links color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlinkcolor', 'colors', 'Inner page content box links color', '#000');


//Inner page border color
addColorPalatOption($wp_customize, 'template_innerpage_bordercolor', 'colors', 'Inner page border color', '#EEE');


//Inner page table days Color
addColorPalatOption($wp_customize, 'template_innerpage_tabledays_color', 'colors', 'Inner Page Sidebar Table Days Color', '#fff');

//Inner page table days bg Color
addColorPalatOption($wp_customize, 'template_innerpage_tabledaysbg_color', 'colors', 'Inner Page Sidebar Table Days Background Color', '#eb4444');

//Inner page table text Color
addColorPalatOption($wp_customize, 'template_innerpage_tabletext_color', 'colors', 'Inner Page Sidebar Table Text Color', '#6b7385');

//Inner page table box bg Color
addColorPalatOption($wp_customize, 'template_innerpage_tableboxbg_color', 'colors', 'Inner Page Sidebar Table Box Background Color', '#fff');

//Inner page table btn Color
addColorPalatOption($wp_customize, 'template_innerpage_tablebtn_color', 'colors', 'Inner Page Sidebar Table, Form Button Text and category product dropdown hover Color', '#fff');

//Inner page table btn bg Color
addColorPalatOption($wp_customize, 'template_innerpage_tablebtnbg_color', 'colors', 'Inner Page Sidebar Table Button Background Color', '#eb4444');

//Inner Page Social color
addColorPalatOption($wp_customize, 'template_innerpage_socials_color', 'colors', 'Inner Page Social color', '#fff');

//Inner page box bg Color
addColorPalatOption($wp_customize, 'template_innerpage_boxbg_color', 'colors', 'Inner Page Box Background Color', '#fff');
//Inner page blog box bg Color
addColorPalatOption($wp_customize, 'template_innerpage_blogboxbg_color', 'colors', 'Inner Page Info Box Background Color', '#eee');

//INNER PAGE HEADING FONT SIZE SETTINGS
$wp_customize->add_section(
    'innerheadingfontsize_settings',
    array(
        'title' => __( 'Inner Page Heading Font Size Settings', 'luzuk-premium' ),
        'panel' => 'lz_fitness_general_panel',
    )
);

lzCustomLable($wp_customize, 'lz_fitness_headerlogo_margin', 'innerheadingfontsize_settings', ' Inner Page Heading Font Size:');


$wp_customize->add_setting(
    'pages_h1font',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '28px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_h1font',
    array(
        'settings'      => 'pages_h1font',
        'section'       => 'innerheadingfontsize_settings',
        'type'          => 'text',
        'label'         => __( 'Heading 1 Font Size', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'pages_h2font',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '26px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_h2font',
    array(
        'settings'      => 'pages_h2font',
        'section'       => 'innerheadingfontsize_settings',
        'type'          => 'text',
        'label'         => __( 'Heading 2 Font Size', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'pages_h3font',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '24px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_h3font',
    array(
        'settings'      => 'pages_h3font',
        'section'       => 'innerheadingfontsize_settings',
        'type'          => 'text',
        'label'         => __( 'Heading 3 Font Size', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'pages_h4font',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '22px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_h4font',
    array(
        'settings'      => 'pages_h4font',
        'section'       => 'innerheadingfontsize_settings',
        'type'          => 'text',
        'label'         => __( 'Heading 4 Font Size', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'pages_h5font',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '20px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_h5font',
    array(
        'settings'      => 'pages_h5font',
        'section'       => 'innerheadingfontsize_settings',
        'type'          => 'text',
        'label'         => __( 'Heading 5 Font Size', 'luzuk-premium' )
    )
);


$wp_customize->add_setting(
    'pages_h6font',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '18px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_h6font',
    array(
        'settings'      => 'pages_h6font',
        'section'       => 'innerheadingfontsize_settings',
        'type'          => 'text',
        'label'         => __( 'Heading 6 Font Size', 'luzuk-premium' )
    )
);


//Inner Page Box Padding Setting
$wp_customize->add_section(
    'innerboxpaddiing_settings',
    array(
        'title' => __( 'Inner Page Box Padding Setting', 'luzuk-premium' ),
        'panel' => 'lz_fitness_general_panel',
    )
);

lzCustomLable($wp_customize, 'innerpagebox_padding', 'innerboxpaddiing_settings', ' Inner Page Box Padding Setting:');

$wp_customize->add_setting(
    'innerpagesbox_toppadding',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'innerpagesbox_toppadding',
    array(
        'settings'      => 'innerpagesbox_toppadding',
        'section'       => 'innerboxpaddiing_settings',
        'type'          => 'text',
        'label'         => __( 'Section Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'innerpagesbox_bottompadding',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'innerpagesbox_bottompadding',
    array(
        'settings'      => 'innerpagesbox_bottompadding',
        'section'       => 'innerboxpaddiing_settings',
        'type'          => 'text',
        'label'         => __( 'Section Bottom Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'innerpagesbox_leftpadding',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'innerpagesbox_leftpadding',
    array(
        'settings'      => 'innerpagesbox_leftpadding',
        'section'       => 'innerboxpaddiing_settings',
        'type'          => 'text',
        'label'         => __( 'Section Left Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'innerpagesbox_rightpadding',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'innerpagesbox_rightpadding',
    array(
        'settings'      => 'innerpagesbox_rightpadding',
        'section'       => 'innerboxpaddiing_settings',
        'type'          => 'text',
        'label'         => __( 'Section Right Padding', 'luzuk-premium' )
    )
);

//BREADCRUMB SETTINGS
$wp_customize->add_section(
    'lz_fitness_breadcrumb_settings',
    array(
        'title' => __( 'Breadcrumb Settings', 'Luzuk Premium' ),
        'panel' => 'lz_fitness_general_panel',
    )
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'lz_fitness_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Breadcrumb', 'hide' => 'Hide Breadcrumb', ), ) ); 

$wp_customize->add_setting(
        'lz_fitness_breadcrumbhometxt',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text',
            'default'           => __( 'Home', 'luzuk' )
        )
    );
    $wp_customize->add_control(
        'lz_fitness_breadcrumbhometxt',
        array(
            'settings'      => 'lz_fitness_breadcrumbhometxt',
            'section'       => 'lz_fitness_breadcrumb_settings',
            'type'          => 'text',
            'label'         => __( 'Add Breadcrumb Text Here:', 'luzuk' )
        )
    );

//Inner page breadcrumbbox title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbtitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox title color', '#000');
//Inner page breadcrumbbox current title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbcurrenttitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox current title color', '#eb4444');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbcurrenttitlehovercolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox current title hover color', '#000');

//Inner page breadcrumbbox background color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbbgcolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox background color', '#fff');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbbgbordercolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox border color', '#eb4444');

// end to show & hide button



//POSTPAGEDATE SETTINGS
$wp_customize->add_section(
    'lz_fitness_postpagedate_settings',
    array(
        'title' => __( 'Post Page Settings', 'Luzuk Premium' ),
        'panel' => 'lz_fitness_general_panel',
    )
);

//for POSTPAGEDATE to show & hide button

$wp_customize->add_setting( 'postdate_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'postdate_button_display', array( 'label' => 'Post Date Display', 'section' => 'lz_fitness_postpagedate_settings', 'settings' => 'postdate_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Post Date', 'hide' => 'Hide Post Date', ), ) ); 

// end to show & hide button

//for POSTPAGEDATE to show & hide button

$wp_customize->add_setting( 'socialpost_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'socialpost_button_display', array( 'label' => 'Post Social Media Display', 'section' => 'lz_fitness_postpagedate_settings', 'settings' => 'socialpost_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Post Social Media', 'hide' => 'Hide Post Social Media', ), ) ); 

// end to show & hide button

//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
    'lz_fitness_shopsidebar_settings',
    array(
        'title' => __( 'Shop Page Sidebar Settings', 'Luzuk Premium' ),
        'panel' => 'lz_fitness_general_panel',
    )
);


// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'lz_fitness_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Sidebar', 'hide' => 'Hide Sidebar', ), ) ); 
// end to show & hide button




//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
    'footer_copyright_settings',
    array(
        'title' => __( 'Footer Settings', 'Luzuk Premium' ),
        'panel' => 'lz_fitness_general_panel',
    )
);



//backgroundManager($wp_customize, 'footer', 'footer_copyright_settings', $color='#2d2d2d');

backgroundManager($wp_customize, 'footer', 'footer_copyright_settings', $color='#ffffff', get_template_directory_uri().'/images/footerbg.jpg', 'color');


lzCustomLable($wp_customize, 'footer_padding', 'footer_copyright_settings', ' Section Padding Setting:');

$wp_customize->add_setting(
    'footer_toppadding',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '6em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'footer_toppadding',
    array(
        'settings'      => 'footer_toppadding',
        'section'       => 'footer_copyright_settings',
        'type'          => 'text',
        'label'         => __( 'Section Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'footer_bottompadding',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'footer_bottompadding',
    array(
        'settings'      => 'footer_bottompadding',
        'section'       => 'footer_copyright_settings',
        'type'          => 'text',
        'label'         => __( 'Section Bottom Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'footer_leftpadding',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'footer_leftpadding',
    array(
        'settings'      => 'footer_leftpadding',
        'section'       => 'footer_copyright_settings',
        'type'          => 'text',
        'label'         => __( 'Section Left Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'footer_rightpadding',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'footer_rightpadding',
    array(
        'settings'      => 'footer_rightpadding',
        'section'       => 'footer_copyright_settings',
        'type'          => 'text',
        'label'         => __( 'Section Right Padding', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'footer_colors', 'footer_copyright_settings', ' Footer Colors:');


//theme Footer title Color
addColorPalatOption($wp_customize, 'footer_title_color', 'footer_copyright_settings', 'Footer Title Color', '#fff');

//theme Footer border Color
addColorPalatOption($wp_customize, 'footer_border_color', 'footer_copyright_settings', 'Footer Border Color', '#382b28');

//theme Footer icon Color
addColorPalatOption($wp_customize, 'footer_icon_color', 'footer_copyright_settings', 'Footer Icon Color', '#ee5142');

//theme Footer text Color
addColorPalatOption($wp_customize, 'footer_text_color', 'footer_copyright_settings', 'Footer Text Color', '#979797');

addColorPalatOption($wp_customize, 'footer_menu_color', 'footer_copyright_settings', 'Footer Menu Color', '#989795');

//theme Footer menu hover Color
addColorPalatOption($wp_customize, 'footer_menuhover_color', 'footer_copyright_settings', 'Footer Menu Hover Color', '#ee5142');

addColorPalatOption($wp_customize, 'footer_menuicon_color', 'footer_copyright_settings', 'Footer Menu Icon Color', '#777576');

//theme Footer menu date Color
addColorPalatOption($wp_customize, 'footer_menudate_color', 'footer_copyright_settings', 'Footer Menu Date Color', '#989795');

//theme Footer social Color
addColorPalatOption($wp_customize, 'footer_social_color', 'footer_copyright_settings', 'Footer Social Color', '#8e8d89');

//theme Footer social Hover Color
addColorPalatOption($wp_customize, 'footer_socialhover_color', 'footer_copyright_settings', 'Footer Social Hover Color', '#ee5142');

//theme Footer table days Color
addColorPalatOption($wp_customize, 'footer_tabledays_color', 'footer_copyright_settings', 'Footer Table Days Color', '#fff');

//theme Footer table days bg Color
addColorPalatOption($wp_customize, 'footer_tabledaysbg_color', 'footer_copyright_settings', 'Footer Table Days Background Color', '#ea4444');

//theme Footer table text Color
addColorPalatOption($wp_customize, 'footer_tabletext_color', 'footer_copyright_settings', 'Footer Table Text Color', '#979797');

//theme Footer table btn Color
addColorPalatOption($wp_customize, 'footer_tablebtn_color', 'footer_copyright_settings', 'Footer Table Button and Table Active Text Color', '#ea4444');

addColorPalatOption($wp_customize, 'footer_formlabeltxt_color', 'footer_copyright_settings', 'Footer Form label Text Color', '#979797');

//theme Footer form Color
addColorPalatOption($wp_customize, 'footer_form_color', 'footer_copyright_settings', 'Footer Form Text & Placeholder Text Color', '#979797');

//theme Footer form border Color
addColorPalatOption($wp_customize, 'footer_formborder_color', 'footer_copyright_settings', 'Footer Form Border Color', '#979797');

//theme Footer form background Color
addColorPalatOption($wp_customize, 'footer_formbg_color', 'footer_copyright_settings', 'Footer Form Background Color', '#000');

//theme Footer form button Color
addColorPalatOption($wp_customize, 'footer_formbtn_color', 'footer_copyright_settings', 'Footer Form Button Color', '#ea4444');

//theme Footer Form Button Background Color
addColorPalatOption($wp_customize, 'footer_formbtnborder_color', 'footer_copyright_settings', 'Footer Form Button Border Color', '#ea4444');

lzCustomLable($wp_customize, 'footercopyright_padding', 'footer_copyright_settings', ' Footer Copyright Setting:');

$wp_customize->add_setting(
    'footer_copyrighttext',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( 'Copyright © 2018 LZ Restaurant. All Rights Reserved', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'footer_copyrighttext',
    array(
        'settings'      => 'footer_copyrighttext',
        'section'       => 'footer_copyright_settings',
        'type'          => 'text',
        'label'         => __( 'Footer Copyright Text', 'Luzuk Premium' )
    )
);


$wp_customize->add_setting(
    'footer_copyrighttextprivacy',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( 'Terms & Condition | Privacy Policy', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'footer_copyrighttextprivacy',
    array(
        'settings'      => 'footer_copyrighttextprivacy',
        'section'       => 'footer_copyright_settings',
        'type'          => 'text',
        'label'         => __( 'Privacy Policy Text', 'Luzuk Premium' )
    )
);




//theme Footer Copyright text Color
addColorPalatOption($wp_customize, 'footer_copyrighttext_color', 'footer_copyright_settings', 'Copyright Footer Text Color', '#979797');
