<?php
/**
 * Createing an about us pannel for customizer
 */

// START ABOUT SECTION 
    $wp_customize->add_section(
        'aboutus_section',
        array(
            'title' => __( 'About Us Section', 'luzuk-premium' ),
            'panel' => 'lz_fitness_premium_home_panel'
        )
    );
    // ENABLE/DISABLE FEATURED SECTION
    $wp_customize->add_setting(
        'aboutus_section_disable',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Switch_Control(
            $wp_customize,
            'aboutus_section_disable',
            array(
                'settings'      => 'aboutus_section_disable',
                'section'       => 'aboutus_section',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    );

    // Manage the background SECTION
    backgroundManager($wp_customize, 'aboutus', 'aboutus_section', $color='#ffffff', get_template_directory_uri().'/images/aboutsectionbg.jpg', 'color');

    $wp_customize->add_setting(
        'lz_fitness_aboutus_title_heading',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Customize_Heading(
            $wp_customize,
            'lz_fitness_aboutus_title_heading',
            array(
                'settings'      => 'lz_fitness_aboutus_title_heading',
                'section'       => 'aboutus_section',
                'label'         => __( 'ABOUT Title & Text', 'luzuk-premium' ),
            )
        )
    );    
    $wp_customize->add_setting(
        'lz_fitness_aboutus_title',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text',
            'default'           => __( 'About Us', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'lz_fitness_aboutus_title',
        array(
            'settings'      => 'lz_fitness_aboutus_title',
            'section'       => 'aboutus_section',
            'type'          => 'text',
            'label'         => __( 'Title for section', 'luzuk-premium' )
        )
    );
    lzAddElement($wp_customize, 'lz_fitness_aboutus_subTitle', 'aboutus_section', 'text', $label="Sub Title", 'lz_fitness_sanitize_text', 'Two or three words');

    $wp_customize->add_setting(
        'lz_fitness_aboutus_text',
        array(
            'sanitize_callback'=>'lz_fitness_sanitize_text',
            'default'=> __('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi maximus sit amet purus sed feugiat. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nunc vel ligula in augue tristique pellentesque a in nibh.<br><br> Fusce Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi maximus sit amet purus sed feugiat. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. <br><br><br> Nunc vel ligula in augue tristique pellentesque a in nibh.', 'luzuk-premium')
        )
    );
    $wp_customize->add_control(
        'lz_fitness_aboutus_text',
        array(
            'settings' =>'lz_fitness_aboutus_text',
            'section' => 'aboutus_section',
            'type'=> 'textarea',
            'label'=> __('Content for the section', 'luzuk-premium')
        )
    );

    // Heading color
    addColorPalatOption($wp_customize, 'lz_fitness_aboutus_page_HeadingColor', 'aboutus_section', 'Heading color', '#ffffff');
    // Text color
    addColorPalatOption($wp_customize, 'lz_fitness_aboutus_page_TextColor', 'aboutus_section', 'Text color', '#ffffff');

lzCustomLable($wp_customize, 'aboutus_lblbuttonabtdisplay', 'aboutus_section', 'About Us Button Display & Text Setting:');

// to show & hide another button
$wp_customize->add_setting( 'about_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'about_button_display', array( 'label' => 'Button Display', 'section' => 'aboutus_section', 'settings' => 'about_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button
// appointment 
$wp_customize->add_setting(
    'aboutus_abtbtntitle',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( 'Read More' )
    )
);
$wp_customize->add_control(
    'aboutus_abtbtntitle',
    array(
        'settings'      => 'aboutus_abtbtntitle',
        'section'       => 'aboutus_section',
        'type'          => 'text',
        'label'         => __( 'About Us Button Text', 'luzuk-premium' )
    )
);
$wp_customize->add_setting('aboutus_abtbtnlink',   array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('aboutus_abtbtnlink',
    array(
        'settings'      => 'aboutus_abtbtnlink',
        'section'       => 'aboutus_section',
        'type'          => 'url',
        'label'         => __( 'Add "About Us Button" link here', 'luzuk-premium' )
    )
);



 // Button text color
    addColorPalatOption($wp_customize, 'aboutus_buttontextColor', 'aboutus_section', 'Button Text color', '#ffffff');

 // Button bg color
    addColorPalatOption($wp_customize, 'aboutus_buttonbgColor', 'aboutus_section', 'Button Background color', '#ea4444');

    // Button text hover color
    addColorPalatOption($wp_customize, 'aboutus_buttontexthoverColor', 'aboutus_section', 'Button Text hover color', '#ea4444');

 // Button bg hover color
    addColorPalatOption($wp_customize, 'aboutus_buttonbghoverColor', 'aboutus_section', 'Button Background hover color', '#000');

    // END ABOUT SECTION 