<?php
/**
 * Customiser section for featured
 **/
// Start Feature section 
$wp_customize->add_section(
    'lz_fitness_featured_section',
    array(
        'title' => __( 'Featured Products', 'luzuk-premium' ),
        'panel' => 'lz_fitness_premium_home_panel'
    )
);
// ENABLE/DISABLE FEATURED SECTION
$wp_customize->add_setting(
    'lz_fitness_featured_section_disable',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
    )
);
$wp_customize->add_control(
    new lz_fitness_Switch_Control(
        $wp_customize,
        'lz_fitness_featured_section_disable',
        array(
            'settings'      => 'lz_fitness_featured_section_disable',
            'section'       => 'lz_fitness_featured_section',
            'label'         => __( 'Disable Section', 'luzuk-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk-premium' ),
                'off' => __( 'No', 'luzuk-premium' )
            ),
        )
    )
);

backgroundManager($wp_customize, 'featured', 'lz_fitness_featured_section', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'productsection_padding', 'lz_fitness_featured_section', ' Section Padding Setting:');

$wp_customize->add_setting(
    'sectionproduct_toppadding',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '3em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sectionproduct_toppadding',
    array(
        'settings'      => 'sectionproduct_toppadding',
        'section'       => 'lz_fitness_featured_section',
        'type'          => 'text',
        'label'         => __( 'Section Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'sectionproduct_bottompadding',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '3em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sectionproduct_bottompadding',
    array(
        'settings'      => 'sectionproduct_bottompadding',
        'section'       => 'lz_fitness_featured_section',
        'type'          => 'text',
        'label'         => __( 'Section Bottom Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'sectionproduct_leftpadding',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sectionproduct_leftpadding',
    array(
        'settings'      => 'sectionproduct_leftpadding',
        'section'       => 'lz_fitness_featured_section',
        'type'          => 'text',
        'label'         => __( 'Section Left Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'sectionproduct_rightpadding',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sectionproduct_rightpadding',
    array(
        'settings'      => 'sectionproduct_rightpadding',
        'section'       => 'lz_fitness_featured_section',
        'type'          => 'text',
        'label'         => __( 'Section Right Padding', 'luzuk-premium' )
    )
);


$wp_customize->add_setting(
    'lz_fitness_featured_title_sub_title_heading',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text'
    )
);
$wp_customize->add_control(
    new lz_fitness_Customize_Heading(
        $wp_customize,
        'lz_fitness_featured_title_sub_title_heading',
        array(
            'settings'      => 'lz_fitness_featured_title_sub_title_heading',
            'section'       => 'lz_fitness_featured_section',
            'label'         => __( 'Section Title & Sub Title', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting(
    'lz_fitness_featured_title',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( 'Featured Section', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'lz_fitness_featured_title',
    array(
        'settings'      => 'lz_fitness_featured_title',
        'section'       => 'lz_fitness_featured_section',
        'type'          => 'text',
        'label'         => __( 'Title', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'lz_fitness_featured_sub_title',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( 'Best of Photos', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'lz_fitness_featured_sub_title',
    array(
        'settings'      => 'lz_fitness_featured_sub_title',
        'section'       => 'lz_fitness_featured_section',
        'type'          => 'textarea',
        'label'         => __( 'Sub Title', 'luzuk-premium' ),
    )
);

// Heading color
addColorPalatOption($wp_customize, 'lz_fitness_featured_HeadingColor', 'lz_fitness_featured_section', 'Heading color ', $headingColor);
// Text color
addColorPalatOption($wp_customize, 'lz_fitness_featured_TextColor', 'lz_fitness_featured_section', 'Text color', '#333333');

