<?php

$lzFitnessSliderSingleChoice = getFitnessPostsType('slider');

// CREATING A SECTION IN CUSTOMIZER
$wp_customize->add_section(
	'premium_slider_section',
	array(
		'title' => __( 'Slider Section', 'Luzuk Premium' ),
        'panel' => 'lz_fitness_premium_home_panel',
		'priority' =>18
	)
);

// show content in slider
$wp_customize->add_setting(
	'premium_slider_show_content',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
	)
);
$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'premium_slider_show_content',
		array(
			'settings'      => 'premium_slider_show_content',
			'section'       => 'premium_slider_section',
			'label'         => __( 'Hide Title and description on slider', 'Luzuk Premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'Luzuk Premium' ),
				'off' => __( 'No', 'Luzuk Premium' )
			),
		)
	)
);
$wp_customize->add_setting('premium_slider_section_lbl', array('sanitize_callback'=>'lz_fitness_sanitize_text'));
$wp_customize->add_control(
	new lz_fitness_Info_Text( 
		$wp_customize,
		'premium_slider_section_lbl',
		array(
			'settings'		=> 'premium_slider_section_lbl',
			'section'		=> 'premium_slider_section',
			'label'			=> __( 'Note:', 'Luzuk Premium' ),	
			'description'	=> __( 'The Page featured image works as a slider banner and the title & content work as a slider caption. And you can add this from the Slider menu. <br/> Recommended Image Size: 1900X675', 'Luzuk Premium' ),
		)
	)
);


lzCustomLable($wp_customize, 'slider_slideropacity', 'premium_slider_section', ' Slider Opacity:');

$wp_customize->add_setting(
	'slider_opacity',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0.60', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'slider_opacity',
	array(
		'settings'      => 'slider_opacity',
		'section'       => 'premium_slider_section',
		'type'          => 'text',
		'label'         => __( 'Opacity', 'luzuk-premium' )
	)
);

// Slider opacity color
addColorPalatOption($wp_customize, 'slider_overlayColor', 'premium_slider_section', 'Slider Opacity Color', '#000');


// Slider Title color
addColorPalatOption($wp_customize, 'slider_TitleColor', 'premium_slider_section', 'Slider Title Color', '#f8faf7');


// Slider Sub Title color
addColorPalatOption($wp_customize, 'slider_subTitleColor', 'premium_slider_section', 'Slider Sub Title Color', '#ececec');


// button text color
addColorPalatOption($wp_customize, 'slider_buttontextColor', 'premium_slider_section', ' Button text color', '#fff');

// button background color
addColorPalatOption($wp_customize, 'slider_buttonbgColor', 'premium_slider_section', ' Button background color', '#ea4444');

// button text hover color
addColorPalatOption($wp_customize, 'slider_buttontexthoverColor', 'premium_slider_section', ' Button text hover color', '#fff');

// button background hover color
addColorPalatOption($wp_customize, 'slider_buttonbghoverColor', 'premium_slider_section', ' Button background hover color', '#000');

//border color
addColorPalatOption($wp_customize, 'slider_boxborderColor', 'premium_slider_section', ' Border color', '#ea4444');
