<?php
/**
 * @package LZ Restaurant Premium
 */
if(get_theme_mod('product_categories_catlogue_disable') != 'on' ){
	// wp_enqueue_script('product-category-slider', get_template_directory_uri().'/js/product-category-slider.js', array(), '1.1', true);
	wp_enqueue_script('product-category-slider', get_template_directory_uri().'/js/slider.js', array(), '1.1', true);
	?>
	 <?php 
            if( get_theme_mod('sectionprocat_toppadding',true) ) {
                $sectionprocat_toppadding = 'padding-top:'.esc_attr(get_theme_mod('sectionprocat_toppadding')).';';
            }
            if( get_theme_mod('sectionprocat_bottompadding',true) ) {
                $sectionprocat_bottompadding = 'padding-bottom:'.esc_attr(get_theme_mod('sectionprocat_bottompadding')).';';
            }
            if( get_theme_mod('sectionprocat_leftpadding',true) ) {
                $sectionprocat_leftpadding = 'padding-left:'.esc_attr(get_theme_mod('sectionprocat_leftpadding')).';';
            }
            if( get_theme_mod('sectionprocat_rightpadding',true) ) {
                $sectionprocat_rightpadding = 'padding-right:'.esc_attr(get_theme_mod('sectionprocat_rightpadding')).';';
            }
    ?>   
	<section id="product-category-section" class="ht-section product-category-section" style="<?php echo esc_attr($sectionprocat_toppadding); ?>" "<?php echo esc_attr($sectionprocat_bottompadding); ?>" "<?php echo esc_attr($sectionprocat_leftpadding); ?>" "<?php echo esc_attr($sectionprocat_rightpadding); ?>">
			<div class="container">
				<?php
				$product_category_title = get_theme_mod('product_category_title', 'Restaurent Menu');
				$product_category_sub_title = get_theme_mod('product_category_sub_title', 'Two or three words');
				?>
				<?php if( $product_category_title || $product_category_sub_title ){ ?>
				<div class="ht-section-title-tagline">
					<?php if($product_category_sub_title){ ?>
					<div class="ht-section-tagline product-category-text"><?php echo esc_html($product_category_sub_title); ?></div>
					<?php } ?>
					<?php if($product_category_title){ ?>
					<h2 class="ht-section-title product-category-heading"><?php echo esc_html($product_category_title); ?></h2>
					<?php } ?>
				</div>
				<?php } ?>

				<div class="row">
					<div class="col-md-12">
						<div class="product-grid">
							<?php
							$taxonomyName = "product_cat";
							global $thumbnail_id;
							// This gets top layer terms only.  This is done by setting parent to 0.  
							$parent_terms = get_terms($taxonomyName, array('parent' => 0,  'orderby' => 'slug', 'hide_empty' => false));
							if(!empty($parent_terms) && function_exists('get_term_meta')){
								?>
								<div class="slider" id="slider">
									<div class="slides" id="slides">
										<?php
										foreach ($parent_terms as $pterm) {
											if(function_exists('get_term_meta')){
												    if( isset( $pterm->term_id ) ){
											//show parent categories
												$thumbnail_id = get_term_meta($pterm->term_id, 'thumbnail_id', true);
											}

											// get the image URL for parent category
												$image = wp_get_attachment_url($thumbnail_id);
											}else{
												$image = esc_html(get_template_directory_uri()).'/images/default.png';
											}
											    if( isset( $pterm->name ) ){
											echo '<div class="slide-item cat-product">
											<a href="' . get_term_link($pterm->name, $taxonomyName) . '"><img src="'.$image.'" alt="" width="270" height="377" />
											<figure class="tint">											
											
											</figure>
											</a>
											<div class="clearfix"></div>
											  <h4><a href="' . get_term_link($pterm->name, $taxonomyName) . '">' . $pterm->name . '</a></h4></div>';
												//Get the Child terms
											$terms = get_terms($taxonomyName, array('parent' => $pterm->term_id, 'orderby' => 'slug', 'hide_empty' => false));
											foreach ($terms as $term) {
												$thumbnail_id = get_term_meta($pterm->term_id, 'thumbnail_id', true);
												// get the image URL for child category
												$image = wp_get_attachment_url($thumbnail_id);
												// print the IMG HTML for child category
												echo '<div class="slide-item cat-product">	
												<a href="' . get_term_link($pterm->name, $taxonomyName) . '"><img src="'.$image.'" alt="" width="270" height="377" /></a>
												<div class="clearfix"></div>
											  	<h4><a href="' . get_term_link($pterm->name, $taxonomyName) . '">' . $pterm->name . '</a></h4></div>'; }
											}
										}?>
										<div class="clearfix"></div>
									</div>
									<button class="ctrl-btn pro-prev slide-prev"><i class="fa fa-chevron-left"></i></button>
									<button class="ctrl-btn pro-next slide-next"><i class="fa fa-chevron-right"></i></button>
								</div>
								<?php
							}else{ ?>
								<div class="alert alert-warning">
									Kindly Install or Activate the WooCommerce plugin.
								</div>
							<?php }
							wp_reset_query();
							?>
							<div class="clearfix"></div>
						</div>
					</div>
				</div>


			</div>
	</div>
</section>
<?php }

