<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luzuk Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link href="https://fonts.googleapis.com/css?family=Roboto:700" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Dancing+Script" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Poppins:500" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Poppins:300" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Open+Sans" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Poppins" rel="stylesheet">
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>
	<script>
		function buttonUp(){
			var valux = $('.sb-search-input').val(); 
			valux = $.trim(valux).length;
			if(valux !== 0){
				$('.sb-search-submit').css('z-index','99');
			} else{
				$('.sb-search-input').val(''); 
				$('.sb-search-submit').css('z-index','-999');
			}
		}

		$(document).ready(function(){
			var submitIcon = $('.sb-icon-search');
			var submitInput = $('.sb-search-input');
			var searchBox = $('.sb-search');
			var isOpen = false;

			$(document).mouseup(function(){
				if(isOpen == true){
					submitInput.val('');
					$('.sb-search-submit').css('z-index','-999');
					submitIcon.click();
				}
			});

			submitIcon.mouseup(function(){
				return false;
			});

			searchBox.mouseup(function(){
				return false;
			});

			submitIcon.click(function(){
				if(isOpen == false){
					searchBox.addClass('sb-search-open');
					isOpen = true;
				} else {
					searchBox.removeClass('sb-search-open');
					isOpen = false;
				}
			});

		});
	</script><!--end script for search bar-->
	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<div class="main-container">
		<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'gurukul' ); ?></a>
		<header id="ht-masthead" class="ht-site-header">
			<div class="main-header">
				<div class="container">
					<div class="overlap-header">
						<div class="row upper-header">	
							<div class="mobile--logobox">
						<?php 
						if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
							the_custom_logo();
					else : 
						if ( is_front_page() ) : ?>
							<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
							<?php else : ?>
								<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
							<?php endif; ?>
							<!-- <p class="ht-site-description"><a href="<?php //echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php //bloginfo( 'description' ); ?></a></p> -->
						<?php endif; ?>
						<!-- .site-branding -->
					</div>
							<div class="col-md-6 col-sm-6 col-xs-12 padding0 header-data">	
								<?php
								$phone = get_theme_mod('lz_fitness_headermain_phone', '012 345 6789');
								$email = get_theme_mod('lz_fitness_headermain_email', 'info@yourmail.com');
								?>

								<ul class="header-menu-links">
									<?php if(!empty($email)){ ?>
										<li class="mailto"><a href="mailto:<?php echo $email;?>"><i class="fa fa-envelope-o" aria-hidden="true"></i><?php echo ($email);?></a></li>
									<?php }?> 
									<?php if(!empty($phone)){ ?>
										<li class="themetext"><i class="fa fa-phone" aria-hidden="true"></i><?php echo ($phone);?></li>
									<?php }?> 
								</ul>
							</div>	

							<div class="col-md-2 col-md-offset-4 col-sm-6 col-xs-12 padding0">
								<div id="sb-search" class="sb-search">
									<form>
										<input class="sb-search-input " onkeyup="buttonUp();" placeholder="Search Here.." onblur="monkey();" type="search" value="" name="s" id="search" />
										<input class="sb-search-submit" type="submit"  value="" />
										<span class="sb-icon-search"><i class="fa fa-search"></i></span>
									</form>
								</div>
							</div>
						</div>

						<div class="clearfix"></div>

					</div>
				</div>
				<div class="clearfix"></div>
			</div>
			<div class="col-md-12 col-sm-12 col-xs-12 header-main-box">
				<div class="container header-about-theme">

					<div class="logobox">
						<?php 
						if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
							the_custom_logo();
					else : 
						if ( is_front_page() ) : ?>
							<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
							<?php else : ?>
								<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
							<?php endif; ?>
							<!-- <p class="ht-site-description"><a href="<?php //echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php //bloginfo( 'description' ); ?></a></p> -->
						<?php endif; ?>
						<!-- .site-branding -->
					</div>
					<nav id="ht-site-navigation" class="ht-main-navigation">
						<div class="toggle-bar"><span><i class="fa fa-bars" aria-hidden="true"></i></span></div>
						<?php 
						wp_nav_menu( array( 
							'theme_location' => 'primary', 
							'container_class' => 'ht-menu clearfix' ,
							'menu_class' => 'ht-clearfix',
							'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
						) ); 
						?>
					</nav><!-- #ht-site-navigation -->
					<div class="clearfix"></div>
				</div>
				<div class="clearfix"></div>
			</div>	
		</header><!-- #masthead -->
	</div>
