<?php

$wp_customize->add_panel(
	'lz_fitness_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'Luzuk Premium')
	)
);

//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'Luzuk Premium' ),
	'panel' => 'lz_fitness_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'Luzuk Premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'Luzuk Premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image Setting', 'Luzuk Premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'Luzuk Premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'Luzuk Premium'),
	'panel' => 'lz_fitness_general_panel',
) );
//theme primary color
addColorPalatOption($wp_customize, 'lz_fitness_template_color', 'colors', 'Theme Primary Color', '#fe9955');

// // Set heading/title colour
// addColorPalatOption($wp_customize, 'lz_fitness_title_color', 'colors', 'Heading Text Color', '#fe5722');

// //theme Secondary color
// addColorPalatOption($wp_customize, 'theme_secondary_color', 'colors', 'Theme Secondary Color', '#f15a24');

//Inner page title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_titlecolor', 'colors', 'Inner page title color', '#fff');
//Inner page background color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_bgcolor', 'colors', 'Inner page backgroundcolor', '#fd9d58');

//a Services
lzCustomLable($wp_customize, 'lz_fitness_Servicesclrs', 'colors', 'Inner Services Color Setting');

//Inner page background color
addColorPalatOption($wp_customize, 'lz_inner_Serboxborcolor', 'colors', 'Inner Services Box border color', '#f79d58');

//Inner page background color
addColorPalatOption($wp_customize, 'lz_inner_Serboxbgcolor', 'colors', 'Inner Services Box Background color', '#ffffff');

//Inner page background color
addColorPalatOption($wp_customize, 'lz_inner_Sertitlecolor', 'colors', 'Inner Services Title color', '#000000');

//Inner page background color
addColorPalatOption($wp_customize, 'lz_inner_Sertitlehovcolor', 'colors', 'Inner Services Title Hover color', '#f79d58');

//Inner page background color
addColorPalatOption($wp_customize, 'lz_inner_Sertextcolor', 'colors', 'Inner Services Text color', '#333333');

//Inner page background color
addColorPalatOption($wp_customize, 'lz_inner_Sercontbgcolor', 'colors', 'Inner Services content Background color', '#ffffff');



//HEADER SETTINGS
$wp_customize->add_section(
	'lz_fitness_header_settings',
	array(
		'title' => __( 'Header Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

	//ENABLE/DISABLE STICKY HEADER
$wp_customize->add_setting(
	'lz_fitness_sticky_header_enable',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default' => 'off'
	)
);

$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'lz_fitness_sticky_header_enable',
		array(
			'settings'		=> 'lz_fitness_sticky_header_enable',
			'section'		=> 'lz_fitness_header_settings',
			'label'			=> __( 'Sticky Header', 'Luzuk Premium' ),
			'on_off_label' 	=> array(
				'on' => __( 'Enable', 'Luzuk Premium' ),
				'off' => __( 'Disable', 'Luzuk Premium' )
			)	
		)
	)
);
//top header
$wp_customize->add_setting(
	'lz_fitness_headermain_email',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'info@yourmail.com', 'Luzuk Premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_email',
	array(
		'settings'      => 'lz_fitness_headermain_email',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Email', 'Luzuk Premium' )
	)
);

$wp_customize->add_setting(
	'lz_fitness_headermain_phone',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '012 345 6789' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_phone',
	array(
		'settings'      => 'lz_fitness_headermain_phone',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Phone', 'Luzuk Premium' )
	)
);

$sectionHeader = 'lz_fitness_header_settings';


// header Email color
addColorPalatOption($wp_customize, 'lz_fitness_header_headerbgssclrColor', 'lz_fitness_header_settings', 'header Background color', '#fd9854'); 

   addColorPalatOption($wp_customize, 'lz_fitness_header_emailiconColor', 'lz_fitness_header_settings', 'header email icon color', '#fff'); 
   addColorPalatOption($wp_customize, 'lz_fitness_header_emailColor', 'lz_fitness_header_settings', 'Header email Text color', '#fff'); 
   addColorPalatOption($wp_customize, 'lz_fitness_header_emailhoverColor', 'lz_fitness_header_settings', 'Header email Text Hover color', '#4f4f4f'); 

   addColorPalatOption($wp_customize, 'lz_fitness_header_barclrColor', 'lz_fitness_header_settings', 'Right Border color', '#fff'); 

   addColorPalatOption($wp_customize, 'lz_fitness_header_timeiconColor', 'lz_fitness_header_settings', 'header Phone icon color', '#fff'); 
   addColorPalatOption($wp_customize, 'lz_fitness_header_timeColor', 'lz_fitness_header_settings', 'Header Phone Text color', '#fff'); 

   addColorPalatOption($wp_customize, 'lz_fitness_header_logoboxbgssColor', 'lz_fitness_header_settings', 'Header logo box background color', '#fff'); 
   addColorPalatOption($wp_customize, 'lz_fitness_header_logoboxbgssborderColor', 'lz_fitness_header_settings', 'Header logo box border color', '#fdb46d'); 

//header Serach border color
   addColorPalatOption($wp_customize, 'lz_fitness_header_searchborderColor', 'lz_fitness_header_settings', 'header Serach Form border color', '#fff'); 

//header search color
   addColorPalatOption($wp_customize, 'lz_fitness_header_searchtextColor', 'lz_fitness_header_settings', 'header search Form Text color', '#fff');
   addColorPalatOption($wp_customize, 'lz_fitness_header_headerformplacetextColor', 'lz_fitness_header_settings', 'header search Form Placeholder Text color', '#fff'); 

//header search icon color
   addColorPalatOption($wp_customize, 'lz_fitness_header_searchiconColor', 'lz_fitness_header_settings', 'header search Form icon color', '#fff'); 

   //Set header menu colour
	addColorPalatOption($wp_customize, 'lz_fitness_headermenu_color', 'lz_fitness_header_settings', 'Header Menu Color', '#2b2b2b');
	//Set Current Menu Text colour
	addColorPalatOption($wp_customize, 'lz_fitness_headercurrentmenu_color', 'lz_fitness_header_settings', 'Current Menu Text Color', '#fe9955');
	//Set Menu Hover Text colour
	addColorPalatOption($wp_customize, 'lz_fitness_headerhovermenu_color', 'lz_fitness_header_settings', 'Hover Menu Text  Color', '#fe9955');

	//Set header sub menu colour
	addColorPalatOption($wp_customize, 'lz_fitness_headersubmenu_color', 'lz_fitness_header_settings', 'Header Dropdown Menu Color', '#fff');
	//Set header sub menu Background colour
	addColorPalatOption($wp_customize, 'lz_fitness_headersubmenubg_color', 'lz_fitness_header_settings', 'Header Dropdown Background Color', '#fe9955');

	//Set header sub menu hover colour
	addColorPalatOption($wp_customize, 'lz_fitness_headersubmenuhover_color', 'lz_fitness_header_settings', 'Header Dropdown Menu hover Color', '#000');

	//Set header sub menu Background hover colour
	addColorPalatOption($wp_customize, 'lz_fitness_headersubmenubghover_color', 'lz_fitness_header_settings', 'Header Dropdown Background hover Color', '#fff');


	//Set header sub menu border colour
	addColorPalatOption($wp_customize, 'lz_fitness_headersubmenuborder_color', 'lz_fitness_header_settings', 'Header Dropdown Border Color', '#fdb46d');

	//Set Navigation Background colour
	addColorPalatOption($wp_customize, 'lz_fitness_headernavigationubg_color', 'lz_fitness_header_settings', 'Navigation Box Background Color', '#ffffff');
  	addColorPalatOption($wp_customize, 'lz_fitness_headernavigationuborderclr_color', 'lz_fitness_header_settings', 'Navigation Box Border Color', '#fdb46d');

//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'lz_fitness_footer_copyright_settings',
	array(
		'title' => __( 'Footer Copyright Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

$wp_customize->add_setting(
	'lz_fitness_footer_copyrighttext',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Copyright © 2018 Meditation Yoga. All Rights Reserved', 'Luzuk Premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_footer_copyrighttext',
	array(
		'settings'      => 'lz_fitness_footer_copyrighttext',
		'section'       => 'lz_fitness_footer_copyright_settings',
		'type'          => 'text',
		'label'         => __( 'Footer Copyright Text', 'Luzuk Premium' )
	)
);

backgroundManager($wp_customize, 'footer', 'lz_fitness_footer_copyright_settings', $color='#2e2e2e', get_template_directory_uri().'/images/footer-bg.jpg', 'color');



//theme Footer title Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_title_color', 'lz_fitness_footer_copyright_settings', 'Footer Title Color', '#fff');

//theme Footer icon Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_icon_color', 'lz_fitness_footer_copyright_settings', 'Footer Icon Color', '#ffffff');

//theme Footer icon hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_iconhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Icon Hover Color', '#fd9b56');

//theme Footer text Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_text_color', 'lz_fitness_footer_copyright_settings', 'Footer Text Color', '#757575');

//theme Footer menu Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_menu_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Color', '#757575');
addColorPalatOption($wp_customize, 'lz_fitness_footer_menuhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Hover Color', '#fd9b56');

addColorPalatOption($wp_customize, 'lz_fitness_footer_menuiconclr_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Icon Color', '#989898');
addColorPalatOption($wp_customize, 'lz_fitness_footer_menuiconclrhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Icon Hover Color', '#fd9b56');

addColorPalatOption($wp_customize, 'lz_fitness_footer_bottombrssmenumenu_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Bottom Border Color', '#989898');
addColorPalatOption($wp_customize, 'lz_fitness_footer_bottombrsshovermenumenu_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Bottom Border Hover Color', '#989898');


//theme Footer social Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_social_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Color', '#ffffff');

//theme Footer social Hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_socialhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Hover Color', '#fd9b56');

//theme Footer Social Background Color
//addColorPalatOption($wp_customize, 'lz_fitness_footer_socialbg_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Background Color', '#37333e');

//theme Footer Social border Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_socialborder_color', 'lz_fitness_footer_copyright_settings', 'Footer  Social Border Color', '#989898');

//theme Footer Social border hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_socialborderhover_color', 'lz_fitness_footer_copyright_settings', 'Footer  Social Border Hover Color', '#fd9b56');
addColorPalatOption($wp_customize, 'lz_fitness_footer_tabelborder_color', 'lz_fitness_footer_copyright_settings', 'Footer Tabel Border Color', '#989898');

//theme Footer menu hover Color

//theme Footer menu date Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_menudate_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Date Color', '#757575');

//theme Footer form Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_form_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Text Color', '#757575');

//theme Footer form border Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_formborder_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Border Color', '#fff');

//theme Footer form Background Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_formbg_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Background Color', '#fff');

//theme Footer form button Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_formbtn_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Button Text Color', '#fff');

//theme Footer Form Button Background Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_formbtnbg_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Button Background Color', '#fd9a56');




//theme Copyright Footer Border Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_copyrightborder_color', 'lz_fitness_footer_copyright_settings', 'Bottom Footer Background Color', '#282828');

//theme Footer Text Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_copyrighttext_color', 'lz_fitness_footer_copyright_settings', 'Copyright Footer Text Color', '#ffffff');


//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'lz_fitness_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'lz_fitness_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Breadcrumb', 'hide' => 'Hide Breadcrumb', ), ) ); 
//Inner page breadcrumbbox title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbtitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox title color', '#000');
//Inner page breadcrumbbox current title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbcurrenttitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox current title color', '#fd9d58');

//Inner page breadcrumbbox background color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbbgcolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox background color', '#fff');
// end to show & hide button


//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
	'lz_fitness_shopsidebar_settings',
	array(
		'title' => __( 'Shop Page Sidebar Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);






// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'lz_fitness_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Sidebar', 'hide' => 'Hide Sidebar', ), ) ); 
// end to show & hide button