<?php
/**
 * Customiser section for services
 **/
// Start Feature section 
$wp_customize->add_section(
    'lz_fitness_services_section',
    array(
        'title' => __( 'Meditation Benefits Section', 'lz-fitness-premium' ),
        'panel' => 'lz_fitness_premium_home_panel'
    ) 
);
// ENABLE/DISABLE FEATURED SECTION
$wp_customize->add_setting(
    'lz_fitness_services_section_disable',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
    )
);
$wp_customize->add_control(
    new lz_fitness_Switch_Control(
        $wp_customize,
        'lz_fitness_services_section_disable',
        array(
            'settings'      => 'lz_fitness_services_section_disable',
            'section'       => 'lz_fitness_services_section',
            'label'         => __( 'Disable Section', 'lz-fitness-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'lz-fitness-premium' ),
                'off' => __( 'No', 'lz-fitness-premium' )
            ),
        )
    )
);

backgroundManager($wp_customize, 'services', 'lz_fitness_services_section', $color='#ffffff');

$wp_customize->add_setting(
    'lz_fitness_services_title_sub_title_heading',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text'
    )
);
$wp_customize->add_control(
    new lz_fitness_Customize_Heading(
        $wp_customize,
        'lz_fitness_services_title_sub_title_heading',
        array(
            'settings'      => 'lz_fitness_services_title_sub_title_heading',
            'section'       => 'lz_fitness_services_section',
            'label'         => __( 'Section Title', 'lz-fitness-premium' ),
        )
    )
);    
$wp_customize->add_setting(
    'lz_fitness_services_title',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( 'Benefits of Meditation', 'lz-fitness-premium' )
    )
);
$wp_customize->add_control(
    'lz_fitness_services_title',
    array(
        'settings'      => 'lz_fitness_services_title',
        'section'       => 'lz_fitness_services_section',
        'type'          => 'text',
        'label'         => __( 'Section Title', 'lz-fitness-premium' )
    )
);
// Heading color
addColorPalatOption($wp_customize, 'lz_services_HeadingColor', 'lz_fitness_services_section', 'Heading Color ', '#4d4f4f');

$wp_customize->add_setting('lz_fitness_services_npp_heading',array('sanitize_callback' => 'lz_fitness_sanitize_text'));
$wp_customize->add_control(
    new lz_fitness_Customize_Heading(
        $wp_customize,
        'lz_fitness_services_npp_heading',
        array(
            'settings'      => 'lz_fitness_services_npp_heading',
            'section'       => 'lz_fitness_services_section',
            'label'         => __( 'Number Of Meditation Benefit Plans', 'lz-fitness-premium' ),
        )
    )
);    
$wp_customize->add_setting('lz_fitness_services_npp_count',array('sanitize_callback' => 'lz_fitness_sanitize_text','default' => 7));
$wp_customize->add_control(
    'lz_fitness_services_npp_count',
    array(
        'settings'      => 'lz_fitness_services_npp_count',
        'section'       => 'lz_fitness_services_section',
        'type'          => 'select',
        'label'         => __( 'Number of plan to show', 'lz-fitness-premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16)
    )
);

//FEATURED PAGES
for( $i = 1; $i <= 16; $i++ ){
    $wp_customize->add_setting(
        'lz_fitness_services_header'.$i,
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Customize_Heading(
            $wp_customize,
            'lz_fitness_services_header'.$i,
            array(
                'settings'      => 'lz_fitness_services_header'.$i,
                'section'       => 'lz_fitness_services_section',
                'label'         => __( 'Meditation Benefit plan', 'lz-fitness-premium' ).$i
            )
        )
    );

    lzAddImageElement($wp_customize, 'lz_fitness_services_page_icon'.$i, 'lz_fitness_services_section', $label="Recommended Image Size: 150X150px");

    lzAddElement($wp_customize, 'lz_fitness_services_page_title'.$i, 'lz_fitness_services_section', $type = 'text', $label="Title", $callback ='lz_fitness_sanitize_text', $default='Promotes Emotional Health');
     lzAddElement($wp_customize, 'lz_fitness_services_page_url_'.$i, 'lz_fitness_services_section', $type = 'text', $label="Add Link", $callback ='esc_url', $default='Add link here');

}
// End Feature section 
  
addColorPalatOption($wp_customize, 'lz_services_TitleboxbackgroundColor', 'lz_fitness_services_section', 'Image Border Color ', '#eaeaea');

    // Title color
addColorPalatOption($wp_customize, 'lz_services_TitleColor', 'lz_fitness_services_section', 'Title Color ', '#575757');
addColorPalatOption($wp_customize, 'lz_services_TitleservicebgssColor', 'lz_fitness_services_section', 'Title Background Color ', '#ffffff');
addColorPalatOption($wp_customize, 'lz_services_TitlehoverColor', 'lz_fitness_services_section', 'Title Hover Color ', '#fd9854');
addColorPalatOption($wp_customize, 'lz_services_TitleservicebgsshoverColor', 'lz_fitness_services_section', 'Title Background Hover Color ', '#ffffff');
addColorPalatOption($wp_customize, 'lz_services_boxbackgroundhoverColor', 'lz_fitness_services_section', 'Overlay Color ', '#000000');
 