<?php
/**
 * Customiser section for featured
 **/
// Start Feature section 
$wp_customize->add_section(
    'lz_fitness_sticky_section',
    array(
        'title' => __( 'Sticky Section', 'Luzuk Premium' ),
        'panel' => 'lz_fitness_premium_home_panel'
    )
);
// ENABLE/DISABLE FEATURED SECTION
$wp_customize->add_setting(
    'lz_fitness_sticky_section_disable',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
    )
);
$wp_customize->add_control(
    new lz_fitness_Switch_Control(
        $wp_customize,
        'lz_fitness_sticky_section_disable',
        array(
            'settings'      => 'lz_fitness_sticky_section_disable',
            'section'       => 'lz_fitness_sticky_section',
            'label'         => __( 'Disable Section', 'Luzuk Premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'lz-fitness-premium' ),
                'off' => __( 'No', 'lz-fitness-premium' )
            ),
        )
    )
);

// backgroundManager($wp_customize, 'sticky', 'lz_fitness_sticky_section', $color='#ffffff', get_template_directory_uri().'/images/default-gray.png', 'img');

$wp_customize->add_setting('lz_fitness_sticky_npp_heading',array('sanitize_callback' => 'lz_fitness_sanitize_text'));
$wp_customize->add_control(
    new lz_fitness_Customize_Heading(
        $wp_customize,
        'lz_fitness_sticky_npp_heading',
        array(
            'settings'      => 'lz_fitness_sticky_npp_heading',
            'section'       => 'lz_fitness_sticky_section',
            'label'         => __( 'Number of sticky menus', 'Luzuk Premium' ),
        )
    )
);    
$wp_customize->add_setting('lz_fitness_sticky_npp_count',array('sanitize_callback' => 'lz_fitness_sanitize_text','default' => 2));
$wp_customize->add_control(
    'lz_fitness_sticky_npp_count',
    array(
        'settings'      => 'lz_fitness_sticky_npp_count',
        'section'       => 'lz_fitness_sticky_section',
        'type'          => 'select',
        'label'         => __( 'Number of sticky to show', 'Luzuk Premium' ),
        'choices'=>array(1,2,3)
    )
);

//FEATURED PAGES
for( $i = 1; $i <= 3; $i++ ){
    $wp_customize->add_setting(
        'lz_fitness_sticky_header'.$i,
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Customize_Heading(
            $wp_customize,
            'lz_fitness_sticky_header'.$i,
            array(
                'settings'      => 'lz_fitness_sticky_header'.$i,
                'section'       => 'lz_fitness_sticky_section',
                'label'         => __( 'Sticky Page ', 'Luzuk Premium' ).$i
            )
        )
    );

     $wp_customize->add_setting(
        'lz_fitness_sticky_page_icon'.$i,
        array(
            'default'           => 'fa fa-commenting',
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new lz_fitness_Fontawesome_Icon_Chooser(
            $wp_customize,
            'lz_fitness_sticky_page_icon'.$i,
            array(
                'settings'      => 'lz_fitness_sticky_page_icon'.$i,
                'section'       => 'lz_fitness_sticky_section',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'Luzuk Premium' ),
            )
        )
    );


    lzAddElement($wp_customize, 'lz_fitness_sticky_page_title_'.$i, 'lz_fitness_sticky_section', $type = 'text', $label="Title", $callback ='lz_fitness_sanitize_text', $default='Contact');
   
    // $wp_customize->add_setting(
    //     'lz_fitness_featured_page'.$i,
    //     array(
    //         'sanitize_callback' => 'absint'
    //     )
    // );
    // $wp_customize->add_control(
    //     'lz_fitness_featured_page'.$i,
    //     array(
    //         'settings'      => 'lz_fitness_featured_page'.$i,
    //         'section'       => 'lz_fitness_featured_section',
    //         'type'          => 'dropdown-pages',
    //         'label'         => __( 'Select a Page', 'lz-fitness-premium' )
    //     )
    // );

}
// End sticky section 
  //Sticky section background color
    addColorPalatOption($wp_customize, 'lz_fitness_stickysectionbgColor', 'lz_fitness_sticky_section', 'Sticky section background color ', '#82B440');
    // Icon color
    addColorPalatOption($wp_customize, 'lz_fitness_sticky_iconColor', 'lz_fitness_sticky_section', 'Icon color', '#fff');
    // Heading color
    addColorPalatOption($wp_customize, 'lz_fitness_sticky_titleColor', 'lz_fitness_sticky_section', 'Title color ', '#363636');

    
