<?php
/**
 * Template Name: Contact Page
 *
 * @package Luzuk Premium
 */
get_header(); 
?>
<header class="page-main-header">
	<div>
		<?php $image = wp_get_attachment_url( get_post_thumbnail_id($post->ID));?>
		<img src="<?php echo !empty($image)?$image : get_template_directory_uri().'/images/default-gray.png';?>" class="ht-page-header-img" alt="<?php the_title();?>" />
	</div>
	<div class="container">
		<?php the_title( '<h1 class="ht-main-title">', '</h1>' ); ?>
		<?php do_action( 'total_breadcrumbs' ); ?>
		<div class="clearfix"></div>
	</div>
</header><!-- .entry-header -->

<?php if( get_theme_mod('breadcrumb_button_display','show' ) == 'show') :
        ?>
        <div class="breadcrumbbox">
            <div class="container">
                <div class='button'><?php lz_fitness_lite_the_breadcrumb(); ?></div>
                <!--  <?php //lz_fitness_lite_the_breadcrumb(); ?> -->
            </div>
        </div>

    <?php endif ?> 

<main id="innerpage-box">


	<div class="container">
		<?php
		
		// $lz_fitness_contactus_title = get_theme_mod('lz_fitness_contactus_title');
		$lz_fitness_contactus_sub_title = get_theme_mod('lz_fitness_contactus_sub_title');
		?>
		<?php /*if($lz_fitness_contactus_title){ ?>
		<div class="ht-section-title-tagline">
			<?php if($lz_fitness_contactus_title){ ?>
			<h2 class="ht-section-title"><?php echo esc_html($lz_fitness_contactus_title); ?></h2>
			<?php } ?>
		</div>
	<?php }*/ ?>
	<div class="ht-contactus-wrap innerpage-whitebox">
		<?php 
		$lz_fitness_contactus_addrress = get_theme_mod('lz_fitness_contactus_addrress', 'Address');
		$lz_fitness_contactus_emailid = get_theme_mod('lz_fitness_contactus_emailid', 'Email');
		$lz_fitness_contactus_phhone = get_theme_mod('lz_fitness_contactus_phhone', 'Phone');
		$lz_fitness_contactus_socialtitle = get_theme_mod('lz_fitness_contactus_socialtitle', 'Follow us on');
		$address = get_theme_mod('lz_fitness_contactus_address', 'Add Contact Address here..');
		$email = get_theme_mod('lz_fitness_contactus_email', 'contact@example.com');
		$phone = get_theme_mod('lz_fitness_contactus_phone', '+1 999 999 9999');
		$shortcodeLbl = get_theme_mod('lz_fitness_contactus_shortcode_lbl', 'Contact Now');
		$shortcode = get_theme_mod('lz_fitness_contactus_shortcode', 'Add your shortcode through customizer');
		
		$iframe = get_theme_mod('lz_fitness_contactus_embade', 'Add your Embed code in customizer');

		$facebook = get_theme_mod('lz_fitness_contactus_facebook', '//facebook.com/');
		$twitter = get_theme_mod('lz_fitness_contactus_twitter', '//twitter.com/');
		$instagram = get_theme_mod('lz_fitness_contactus_instagram', '//https://www.instagram.com/');
		$linkedIn = get_theme_mod('lz_fitness_contactus_linkedin', '//linkedin.com/');
		?>
		<div id="ht-contactus-wrap">
			<div class="row">
				<div class="col-md-6">
					<div class="contact-page-address">
						<div class="row address-box">
							<div class="col-md-5"> 
								<?php if($lz_fitness_contactus_addrress){ ?>
									<div class="padding0 ht-section-tagline lz-appointment-addresss"><span class="fa fa-map-marker"></span> <?php echo esc_html($lz_fitness_contactus_addrress);  ?> :</div>
								<?php } ?>
							</div>
							<div class="col-md-7 contact-info">  <?php echo nl2br($address); ?></div>
							<div class="clearfix"></div>	
						</div>

						<div class="row address-box">
							<div class="col-md-5">
								<?php if($lz_fitness_contactus_emailid){ ?>
									<div class="padding0 ht-section-tagline lz-appointment-email"><span class="fa fa-envelope"></span> <?php echo esc_html($lz_fitness_contactus_emailid);  ?> :</div>
								<?php } ?>
							</div>
							<div class="col-md-7 contact-info">  <a href="mailto:<?php echo $email;?>"><?php echo $email;?></a> </div>
							<div class="clearfix"></div>	
						</div>

						<div class="row address-box">
							<div class="col-md-5"> 
								<?php if($lz_fitness_contactus_phhone){ ?>
									<div class="padding0 ht-section-tagline lz-appointment-phhone"><span class="fa fa-phone"></span> <?php echo esc_html($lz_fitness_contactus_phhone);  ?> :</div>
								<?php } ?>
							</div>
							<div class="col-md-7 contact-info">  <?php echo $phone;?> </div>
							<div class="clearfix"></div>	
						</div>

						<div class="col-md-12">
							<!-- <h3>Follow us on: </h3> -->
							<h3><?php if($lz_fitness_contactus_socialtitle){ ?>
								<?php echo esc_html($lz_fitness_contactus_socialtitle);  ?> :
							</h3>
							<?php } ?>
							<ul class="contact-sm-links">
								<?php if(!empty($facebook)){ ?>
									<li><a href="<?php echo $facebook ?>" title="Facebook"><span class="fa fa-facebook"></span></a></li>
								<?php }?>
								<?php if(!empty($twitter)){ ?>
									<li><a href="<?php echo $twitter ?>" title="Twitter"><span class="fa fa-twitter"></span></a></li>
								<?php }?>
								<?php if(!empty($instagram)){ ?>
									<li><a href="<?php echo $instagram ?>" title="Instagram"><span class="fa fa-instagram"></span></a></li>
								<?php }?>
								<?php if(!empty($linkedIn)){ ?>
									<li><a href="<?php echo $linkedIn ?>" title="Linked In"><span class="fa fa-linkedin"></span></a></li>
								<?php }?>
							</ul>
						</div>
						<div class="clearfix"></div>
					</div>
				</div>

				<div class="col-md-6">
					<div class="contact-page-form">
						<h4 class="ht-section-title text-center"><?php echo $shortcodeLbl;?></h4> 
						<p><?php echo do_shortcode($shortcode);?></p>
						<div class="clearfix"></div>
					</div>
				</div>
				<div class="clearfix"></div>
			</div>
		</div>

		<div class="contact-mapbox">
			<!-- <iframe width="100%" height="350" frameborder="0" style="border:0" src="" allowfullscreen></iframe> -->
			<?php echo $iframe; ?>
		</div>

	</div>	
</div>
</main>
<?php get_footer(); ?>