<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luzuk Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link href="https://fonts.googleapis.com/css?family=Roboto:700" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Poppins:400,500,600" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Dancing+Script" rel="stylesheet">
	<!-- <link rel="stylesheet" href="<?php //echo get_template_directory_uri(); ?>/css/owl.carousel.min.css" />
	<link rel="stylesheet" href="<?php //echo get_template_directory_uri(); ?>/css/owl.theme.default.min.css" />
	<link rel="stylesheet" href="<?php //echo get_template_directory_uri(); ?>/css/style-ltr.css" /> -->

	<!-- new ico -->
	<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css
	" rel="stylesheet">
	
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>

	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<div class="main-container">
		<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'gurukul' ); ?></a>
		<header class="site-header header-transparent header mo-left header-seo">

			<div class="row upper-header">	
				<div class="container">
					<div class="col-md-5 col-sm-6 col-xs-6 padding0 mobile-width">
						
						<?php
						$phonelabel = get_theme_mod('lz_fitness_headermain_phonelabel', 'Call Us Free:');
						$phone = get_theme_mod('lz_fitness_headermain_phone', '(012) 345 6789');
						
						?>
						<?php if($phone){ ?>
							<li class="themetext"><i class="fa fa-phone blink" aria-hidden="true"></i><?php echo ($phonelabel);?> <span><a href="tel:<?php echo $phone;?>"><?php echo ($phone);?></a></span></li>
						<?php } ?> 
						
					</div>	
					<div class="col-md-7 col-sm-6 col-xs-6 padding0 mobile-widths">
						<?php
						$facebook = get_theme_mod('lz_fitness_header_fb', '//facebook.com/');
						$twitter = get_theme_mod('lz_fitness_header_tw', '//twitter.com/');
						$linkedIn = get_theme_mod('lz_fitness_header_in', '//linkedin.com/');
						$instagram = get_theme_mod('lz_fitness_header_insta', '//www.instagram.com/');
						$pintrest = get_theme_mod('lz_fitness_header_pintrest', 'https://in.pinterest.com/');
						//$youtube = get_theme_mod('lz_fitness_header_yt', '//www.youtube.com/');
						?>

						<div class="header-share show-in-mobile"> 

							<div class="share-btn">
								<ul class="clearfix">
									<?php if(!empty($facebook)){ ?>
										<li><a href="<?php echo $facebook ?>" title="Facebook" class="site-button sharp" target="_blank"><i class="fa fa-facebook"></i></a></li>
									<?php }?>
									<?php if(!empty($twitter)){ ?>
										<li><a href="<?php echo $twitter ?>" title="Twitter" class="site-button sharp" target="_blank"><i class="fa-brands fa-x-twitter"></i></a></li>
									<?php }?>
									<?php if(!empty($linkedIn)){ ?>
										<li><a href="<?php echo $linkedIn ?>" title="LinkedIn" class="site-button sharp" target="_blank"><i class="fa fa-linkedin"></i></a></li>
									<?php }?>
									<?php if(!empty($instagram)){ ?>
										<li><a href="<?php echo $instagram ?>" title="Instagram" class="site-button sharp" target="_blank"><i class="fa fa-instagram"></i></a></li>
									<?php }?>
									<?php if(!empty($pintrest)){ ?>
										<li><a href="<?php echo $pintrest ?>" title="pinterest" class="site-button sharp" target="_blank"><i class="fa fa-pinterest"></i></a></li>
									<?php }?>
									<li class="share-button"><a href="#" class="site-button sharp"><i class="fa fa-share-alt"></i></a></li>
								</ul>
							</div>
						</div>
						<div class="header-social-links hide-in-mobile">
							<!-- for button-->
							<?php if( get_theme_mod('headerrightbtn_button_display','show' ) == 'show') :
								?>
								<li>
									<?php
									$headerrightExt = get_theme_mod('lz_fitness_headermain_headerrightExt', 'GET A QUOTE'); 
									$headerrightExtlink = get_theme_mod('lz_fitness_header_headerrightExtlink', '#');
									?>

									<?php if(!empty($headerrightExtlink)){ ?>
										<a href="<?php echo $headerrightExtlink ?>" title=""><?php echo esc_html($headerrightExt);  ?></a>
									<?php }?>
								</li>
							<?php endif ?>
							<!-- for button-->
							<?php if(!empty($facebook)){ ?>
								<a href="<?php echo $facebook ?>" target="_blank" title="Facebook"><span class="fa fa-facebook"></span></a>
							<?php }?>
							<?php if(!empty($twitter)){ ?>
								<a href="<?php echo $twitter ?>" target="_blank" title="Twitter"><span class="fa-brands fa-x-twitter"></span></a>
							<?php }?>
							<?php if(!empty($linkedIn)){ ?>
								<a href="<?php echo $linkedIn ?>" target="_blank" title="Linked In"><span class="fa fa-linkedin"></span></a>
							<?php }?>
							<?php if(!empty($instagram)){ ?>
								<a href="<?php echo $instagram ?>" target="_blank" title="Instagram"><span class="fa fa-instagram"></span></a>
							<?php }?>
							<?php if(!empty($pintrest)){ ?>
								<a href="<?php echo $pintrest ?>" target="_blank" title="pintrest"><span class="fa fa-pinterest"></span></a>
							<?php }?>	

							<!-- <?php if(!empty($youtube)){ ?>
								<a href="<//?php echo $youtube ?>" target="_blank" title="youtube"><span class="fa fa-youtube-play"></span></a>
								<?php }?> -->						

							</div>	
						</div>
					</div>
				</div>		
				<div class="heade-border">
					<div class="row row-eq-height"> 
						<div class="header-left col-md-3 col-sm-4 col-xs-6">
							<div class="inside-full-height">

								<?php 
								if( get_theme_mod('pages_logoTmargin',true) ) {
									$pages_logoTmargin = 'margin-top:'.esc_attr(get_theme_mod('pages_logoTmargin')).';';
								}
								if( get_theme_mod('pages_logoBmargin',true) ) {
									$pages_logoBmargin = 'margin-bottom:'.esc_attr(get_theme_mod('pages_logoBmargin')).';';
								}
								if( get_theme_mod('pages_logoLmargin',true) ) {
									$pages_logoLmargin = 'margin-left:'.esc_attr(get_theme_mod('pages_logoLmargin')).';';
								}
								if( get_theme_mod('pages_logoRmargin',true) ) {
									$pages_logoRmargin = 'margin-right:'.esc_attr(get_theme_mod('pages_logoRmargin')).';';
								}
								?>
								<div class="col-md-offset-3 logobox"  style="<?php echo esc_attr($pages_logoTmargin); ?>" "<?php echo esc_attr($pages_logoBmargin); ?>" "<?php echo esc_attr($pages_logoLmargin); ?>" "<?php echo esc_attr($pages_logoRmargin); ?>">
									<?php 
									if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
										the_custom_logo();
								else : 
									if ( is_front_page() ) : ?>
										<h1 class="ht-site-title">
											<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a>
										</h1>
									<?php else : ?>
										<p class="ht-site-title">
											<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a>
										</p>
									<?php endif; ?>

								<?php endif; ?>	
								<div class="clearfix"></div>
							<!-- <li>
								<p class="ht-site-description"><//?php bloginfo( 'description' ); ?></p>  
							</li> -->	
						</div>
					</div>
				</div>

				<div class="col-md-9 col-sm-8 col-xs-6 top-bar-head">
					<div class="inside-full-height">
						<div class="site-navigation ">
							<div class="nav-menus">                 
								<a href="#" class="js-nav-toggle">
									<span></span>
								</a>
								<div class="nav-wrapper">
									<nav role="navigation">
										<div class="nav-toggle">
											<span class="nav-back"></span>
											<span class="nav-title">Menu</span>
											<span class="nav-close"></span>
										</div>
										<?php
										if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
											wp_nav_menu ( array(
												'menu_class' => 'mainm ht-clearfix',
												'container'=> 'ul',
												'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
												'theme_location' => 'primary',  
											)); 
										} else {
											wp_nav_menu ( array(
												'menu_class' => 'mainm ht-clearfix',
												'container'=> 'ul',
												'theme_location' => 'primary',  
											)); 
										}
										?>
									</nav>
								</div>
							</div>
							<nav class="navigation">
								<div class="overlaybg"></div>
								<div class="menu-wrapper">
									<div class="menu-content">
										<?php
										if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
											wp_nav_menu ( array(
												'menu_class' => 'mainmenu ht-clearfix',
												'container'=> 'ul',
												'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
												'theme_location' => 'primary',  
											)); 
										} else {
											wp_nav_menu ( array(
												'menu_class' => 'mainmenu ht-clearfix',
												'container'=> 'ul',
												'theme_location' => 'primary',  
											)); 
										}
										?>
									</div> 
									<?php if( get_theme_mod('headerrightbtn_button_display','show' ) == 'show') :
										?>
										<div class="col-md-3 header-right-box">
											<?php
											$headerrightExt = get_theme_mod('lz_fitness_headermain_headerrightExt', 'GET A QUOTE'); 
											$headerrightExtlink = get_theme_mod('lz_fitness_header_headerrightExtlink', '#');
											?>

											<?php if(!empty($headerrightExtlink)){ ?>
												<a href="<?php echo $headerrightExtlink ?>" title=""><?php echo esc_html($headerrightExt);  ?></a>
											<?php }?>
										</div>
									<?php endif ?>
									<div class="clearfix"></div>
								</div>
							</nav>
							<div class="clearfix"></div>
						</div>
					</div>
				</div>
			</div>			
			<div class="clearfix"></div>
		</div>
	</header>
	<script>
		jQuery(document).ready(function($){
			$('.fa-search').on('click', function() {
				$('.search-bar').slideToggle();
			});
		});
	</script>
</div>
