<?php

$wp_customize->add_panel(
	'lz_fitness_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'Luzuk Premium')
	)
);
//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'Luzuk Premium' ),
	'panel' => 'lz_fitness_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'Luzuk Premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'Luzuk Premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

addColorPalatOption($wp_customize, 'header_SiteLtitleColor', 'title_tagline', 'Title Color', '#000'); 

addColorPalatOption($wp_customize, 'lz_fitness_header_taglineColor', 'title_tagline', 'Tagline Color', '#000');

//HEADER LOGO MARGIN SETTINGS
$wp_customize->add_section(
	'lz_fitness_headerlogo_settings',
	array(
		'title' => __( 'Header Logo Margin Settings', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

lzCustomLable($wp_customize, 'lz_fitness_headerlogo_margin', 'lz_fitness_headerlogo_settings', ' Site Header Logo Margin:');


$wp_customize->add_setting(
	'pages_logoTmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '15px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoTmargin',
	array(
		'settings'      => 'pages_logoTmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Top Margin', 'lz-fitness-premium' )
	)
);


$wp_customize->add_setting(
	'pages_logoBmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '5px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoBmargin',
	array(
		'settings'      => 'pages_logoBmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Bottom Margin', 'lz-fitness-premium' )
	)
);


$wp_customize->add_setting(
	'pages_logoLmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoLmargin',
	array(
		'settings'      => 'pages_logoLmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Left Margin', 'lz-fitness-premium' )
	)
);


$wp_customize->add_setting(
	'pages_logoRmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoRmargin',
	array(
		'settings'      => 'pages_logoRmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Right Margin', 'lz-fitness-premium' )
	)
);

//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image Setting', 'Luzuk Premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'Luzuk Premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'Luzuk Premium'),
	'panel' => 'lz_fitness_general_panel',
) );
//theme primary color
addColorPalatOption($wp_customize, 'lz_fitness_template_color', 'colors', 'Theme Primary Color', '#283949');

// // Set heading/title colour
// addColorPalatOption($wp_customize, 'lz_fitness_title_color', 'colors', 'Heading Text Color', '#fe5722');

// //theme Secondary color
// addColorPalatOption($wp_customize, 'theme_secondary_color', 'colors', 'Theme Secondary Color', '#f15a24');

//Inner page title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_titlecolor', 'colors', 'Inner page title color', '#fff');
//Inner page background color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_bgcolor', 'colors', 'Inner page backgroundcolor', '#283949');

//HEADER SETTINGS
$wp_customize->add_section(
	'lz_fitness_header_settings',
	array(
		'title' => __( 'Header Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

	//ENABLE/DISABLE STICKY HEADER
$wp_customize->add_setting(
	'lz_fitness_sticky_header_enable',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default' => 'off'
	)
);

$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'lz_fitness_sticky_header_enable',
		array(
			'settings'		=> 'lz_fitness_sticky_header_enable',
			'section'		=> 'lz_fitness_header_settings',
			'label'			=> __( 'Sticky Header', 'Luzuk Premium' ),
			'on_off_label' 	=> array(
				'on' => __( 'Enable', 'Luzuk Premium' ),
				'off' => __( 'Disable', 'Luzuk Premium' )
			)	
		)
	)
);
//top header
$wp_customize->add_setting(
	'lz_fitness_headermain_phonelabel',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Call Us Free:', 'Luzuk Premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_phonelabel',
	array(
		'settings'      => 'lz_fitness_headermain_phonelabel',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Phone Label', 'Luzuk Premium' )
	)
);

$wp_customize->add_setting(
	'lz_fitness_headermain_phone',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '(012) 345 6789' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_phone',
	array(
		'settings'      => 'lz_fitness_headermain_phone',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Phone Number', 'Luzuk Premium' )
	)
);

 //header phone color
//header phone icon color
   addColorPalatOption($wp_customize, 'lz_fitness_header_phoneiconColor', 'lz_fitness_header_settings', 'header phone number icon color', '#fbda4d');
  
   addColorPalatOption($wp_customize, 'lz_fitness_header_phonetitleColor', 'lz_fitness_header_settings', 'header phone Label Text color', '#27394d'); 
   
 addColorPalatOption($wp_customize, 'lz_fitness_header_phoneColor', 'lz_fitness_header_settings', 'header phone number color', '#27394d'); 
$sectionHeader = 'lz_fitness_header_settings';
// Adding the Label
lzCustomLable($wp_customize, 'lz_fitness_reservation_lblImgTxt', $sectionHeader, 'Social media icons');

// FACEBOOK 
$wp_customize->add_setting('lz_fitness_header_fb',	array('default'=> 'https://facebook.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_fb',
	array(
		'settings'      => 'lz_fitness_header_fb',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Facebook Url', 'lz-fitness-premium' )
	)
);

// TWITTER
$wp_customize->add_setting('lz_fitness_header_tw', array('default'=> 'https://twitter.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_tw',
	array(
		'settings'      => 'lz_fitness_header_tw',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Twitter Url', 'lz-fitness-premium' )
	)
);

// LINKED IN
$wp_customize->add_setting('lz_fitness_header_in',array('default'=> 'https://linkedin.com','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_in',
	array(
		'settings'      => 'lz_fitness_header_in',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Linkedin Url', 'lz-fitness-premium' )
	)
);

// Instagram
$wp_customize->add_setting('lz_fitness_header_insta', array('default' => 'https://www.instagram.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_insta',
	array(
		'settings'      => 'lz_fitness_header_insta',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Instagram', 'gurukul' )
	)
); 

//PINTREST
$wp_customize->add_setting('lz_fitness_header_pintrest',array('default'=> 'https://in.pinterest.com/','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_pintrest',
	array(
		'settings'      => 'lz_fitness_header_pintrest',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Pintrest Url', 'lz-fitness-premium' )
	)
);

//YOUTUBE
// $wp_customize->add_setting('lz_fitness_header_yt',array('default'=> 'https://www.youtube.com/','sanitize_callback' => 'esc_url_raw'));
// $wp_customize->add_control('lz_fitness_header_yt',
// 	array(
// 		'settings'      => 'lz_fitness_header_yt',
// 		'section'       => 'lz_fitness_header_settings',
// 		'type'          => 'url',
// 		'label'         => __( 'Youtube Url', 'lz-fitness-premium' )
// 	)
// );



// header Social color
addColorPalatOption($wp_customize, 'lz_fitness_header_socialColor', 'lz_fitness_header_settings', 'Header social Icon color', '#283a48');
addColorPalatOption($wp_customize, 'lz_fitness_header_socialBorderColor', 'lz_fitness_header_settings', 'Header social Icon Border color', '#283a48');
// header Social hover color
addColorPalatOption($wp_customize, 'lz_fitness_header_socialhoverColor', 'lz_fitness_header_settings', 'Header social hover color', '#fbda4d');
addColorPalatOption($wp_customize, 'lz_fitness_header_socialBorderhoverColor', 'lz_fitness_header_settings', 'Header social Icon Border Hover color', '#fbda4d');
addColorPalatOption($wp_customize, 'lz_fitness_header_backgroundColor', 'lz_fitness_header_settings', 'Upper header background color', '#f8f8f8');


//Menu colors
  // -----------------------
//Set header menu colour
addColorPalatOption($wp_customize, 'lz_fitness_headermenu_color', 'lz_fitness_header_settings', 'Header Menu Color', '#fff');

//Set header current menu colour
addColorPalatOption($wp_customize, 'lz_fitness_headercurrentmenu_color', 'lz_fitness_header_settings', 'Header Current Menu Color', '#e2c547');

//Set header menu hover colour
addColorPalatOption($wp_customize, 'lz_fitness_headermenuhover_color', 'lz_fitness_header_settings', 'Header Menu Hover Color', '#e2c547');
//Set header current menu bg colour
addColorPalatOption($wp_customize, 'lz_fitness_headercurrentmenubg_color', 'lz_fitness_header_settings', 'Header Current Menu Background Color', '#283949');

//Set header menu hover bg colour
addColorPalatOption($wp_customize, 'lz_fitness_headermenuhoverbg_color', 'lz_fitness_header_settings', 'Header Menu Hover Background Color', '#45494a');


//Set header sub menu colour
addColorPalatOption($wp_customize, 'lz_fitness_headersubmenu_color', 'lz_fitness_header_settings', 'Header Sub Menu Color', '#fff');
//Set header dropdown Background colour
addColorPalatOption($wp_customize, 'lz_fitness_headerdropdownbg_color', 'lz_fitness_header_settings', 'Header dropdown Background Color', '#283949');

//Set header dropdown border colour
addColorPalatOption($wp_customize, 'lz_fitness_headerdropdownborder_color', 'lz_fitness_header_settings', 'Header dropdown Border Color', '#ecce4d');


//Set header sub menu hover colour
addColorPalatOption($wp_customize, 'lz_fitness_headersubmenuhover_color', 'lz_fitness_header_settings', 'Header Sub Menu Hover Color', '#000');

//Set header sub menu arrow hover colour
addColorPalatOption($wp_customize, 'lz_fitness_headersubmenuarrowhover_color', 'lz_fitness_header_settings', 'Header Sub Menu Arrow Hover Color', '#000');


//Set header current sub menu colour
addColorPalatOption($wp_customize, 'lz_fitness_headercurrentsubmenu_color', 'lz_fitness_header_settings', 'Header Current Sub Menu Color', '#fff');

//Set header current sub menu bg colour
addColorPalatOption($wp_customize, 'lz_fitness_headercurrentsubmenubg_color', 'lz_fitness_header_settings', 'Header Current Sub Menu Background Color', '#45494a');







  //lower header background color
 addColorPalatOption($wp_customize, 'lz_fitness_header_backgroundlowerColor', 'lz_fitness_header_settings', 'Logo Box background color', '#fff');

 addColorPalatOption($wp_customize, 'lz_fitness_header_bottomheaderborderColor', 'lz_fitness_header_settings', 'Header Border color', '#fff');
 addColorPalatOption($wp_customize, 'lz_fitness_header_navigationbgsbackgroundlowerColor', 'lz_fitness_header_settings', 'Navigation Box background color', '#283949');
 
lzCustomLable($wp_customize, 'lz_fitness_premium_headerbtn_lblbutton1display', 'lz_fitness_header_settings', 'Header Button Display & Text Setting:');
// to show & hide another button
$wp_customize->add_setting( 'headerrightbtn_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'headerrightbtn_button_display', array( 'label' => 'Button Display', 'section' => 'lz_fitness_header_settings', 'settings' => 'headerrightbtn_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button

$wp_customize->add_setting(
	'lz_fitness_headermain_headerrightExt',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'GET A QUOTE' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_headerrightExt',
	array(
		'settings'      => 'lz_fitness_headermain_headerrightExt',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Button Text', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting('lz_fitness_header_headerrightExtlink',	array('default'=> 'add Button link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_headerrightExtlink',
	array(
		'settings'      => 'lz_fitness_header_headerrightExtlink',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Button Url', 'gurukul' )
	)
);

addColorPalatOption($wp_customize, 'lz_fitness_headerrightboxbtntest_color', 'lz_fitness_header_settings', 'Button Text Color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_headerrightboxbtntesthover_color', 'lz_fitness_header_settings', 'Button Text Hover Color', '#fbda4d');

addColorPalatOption($wp_customize, 'lz_fitness_headerrightboxbgss_color', 'lz_fitness_header_settings', 'Button Background Color', '#34495c'); 
addColorPalatOption($wp_customize, 'lz_fitness_headerrightboxbgsshover_color', 'lz_fitness_header_settings', 'Button Background Hover Color', '#34495c');

lzCustomLable($wp_customize, 'header_colorsfortabandmobview', 'lz_fitness_header_settings', 'Responsive Header Settings');

addColorPalatOption($wp_customize, 'header_respnavtoggbarbgssColor', 'lz_fitness_header_settings', 'Toggle Bar Color', '#fff');

addColorPalatOption($wp_customize, 'header_respnavbsbgssColor', 'lz_fitness_header_settings', ' Navigation Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'header_navigationrespnavbrssColor', 'lz_fitness_header_settings', 'Menus Title Color', '#000');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenuttlbgColor', 'lz_fitness_header_settings', 'Menus Title BG Color', '#d5d5d5');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenuColor', 'lz_fitness_header_settings', 'Menus Color', '#fff');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenubgColor', 'lz_fitness_header_settings', 'Menus BG Color', '#283949');
  
//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'lz_fitness_footer_copyright_settings',
	array(
		'title' => __( 'Footer Copyright Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

$wp_customize->add_setting(
	'lz_fitness_footer_copyrighttext',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Copyright © 2018 Nirman Construction Website. All Rights Reserved', 'Luzuk Premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_footer_copyrighttext',
	array(
		'settings'      => 'lz_fitness_footer_copyrighttext',
		'section'       => 'lz_fitness_footer_copyright_settings',
		'type'          => 'text',
		'label'         => __( 'Footer Copyright Text', 'Luzuk Premium' )
	)
);

backgroundManager($wp_customize, 'footer', 'lz_fitness_footer_copyright_settings', $color='#283949', get_template_directory_uri().'/images/default-gray.png', 'img');



//theme Footer title Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_title_color', 'lz_fitness_footer_copyright_settings', 'Footer Title Color', '#fff');

//theme Footer icon Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_icon_color', 'lz_fitness_footer_copyright_settings', 'Footer Icon Color', '#fbda4d');

//theme Footer icon hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_iconhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Icon Hover Color', '#fff');

//theme Footer text Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_text_color', 'lz_fitness_footer_copyright_settings', 'Footer Text Color', '#fff');

//theme Footer menu Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_menuicon_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Icon Color', '#fff');
addColorPalatOption($wp_customize, 'lz_fitness_footer_menuiconhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Icon Hover Color', '#fbda4d');

addColorPalatOption($wp_customize, 'lz_fitness_footer_menu_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Color', '#fff');

addColorPalatOption($wp_customize, 'lz_fitness_footer_menuhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Hover Color', '#fbda4d');

//theme Footer menu border Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_menusborder_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Border Color', '#fff');

//theme Footer menu border hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_menusborderhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Border Hover Color', '#fbda4d');

//theme Footer menu hover Color


//theme Footer menu date Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_menudate_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Date Color', '#fff');


//theme Footer social Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_social_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Color', '#fff');

//theme Footer social Hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_socialhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Hover Color', '#fbda4d');

//theme Footer social border Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_socialborder_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Border Color', '#fff');

//theme Footer social border hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_socialborderhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Border Hover Color', '#fbda4d');

//theme Footer table text Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_tabletext_color', 'lz_fitness_footer_copyright_settings', 'Footer Table Text Color', '#fff');


//theme Footer table border Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_tableborder_color', 'lz_fitness_footer_copyright_settings', 'Footer Table Border Color', '#fff');
addColorPalatOption($wp_customize, 'lz_fitness_footer_formlabeltext_color', 'lz_fitness_footer_copyright_settings', 'Form Label Text Color', '#ffffff');

addColorPalatOption($wp_customize, 'lz_fitness_footer_form_color', 'lz_fitness_footer_copyright_settings', 'Form Text Color', '#283949');
addColorPalatOption($wp_customize, 'lz_fitness_footer_formbg_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Background Color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_footer_formbtn_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Button Text Color', '#283949');
addColorPalatOption($wp_customize, 'lz_fitness_footer_formbtnbg_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Button Background Color', '#fbda4d');

//theme Footer Text Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_copyrighttext_color', 'lz_fitness_footer_copyright_settings', 'Copyright Footer Text Color', '#fff');


//theme Copyright Footer bg Color
//addColorPalatOption($wp_customize, 'lz_fitness_footer_copyrightbg_color', 'lz_fitness_footer_copyright_settings', 'Copyright Footer Background Color', '#283949');

addColorPalatOption($wp_customize, 'lz_fitness_footer_copyrightbrss_color', 'lz_fitness_footer_copyright_settings', 'Copyright Footer Border Color', '#53616e');




//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'lz_fitness_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'lz_fitness_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Breadcrumb', 'hide' => 'Hide Breadcrumb', ), ) ); 

// end to show & hide button
//Inner page breadcrumbbox title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbtitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox title color', '#000');
//Inner page breadcrumbbox current title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbcurrenttitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox current title color', '#fbda4d');

//Inner page breadcrumbbox background color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbbgcolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox background color', '#fff');


//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
	'lz_fitness_shopsidebar_settings',
	array(
		'title' => __( 'Shop Page Sidebar Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);


// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'lz_fitness_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Sidebar', 'hide' => 'Hide Sidebar', ), ) ); 
// end to show & hide button