<?php

// START PRICING SECTION 
    $wp_customize->add_section('lz_fitness_premium_pricing_section',array('title' => __( 'Pricing Section', 'Luzuk Premium' ),'panel' => 'lz_fitness_premium_home_panel'));
    // ENABLE/DISABLE PRISING SECTION
    $wp_customize->add_setting('lz_fitness_premium_pricing_section_disable',array('sanitize_callback' => 'lz_fitness_sanitize_text',));
    $wp_customize->add_control(
        new lz_fitness_Switch_Control(
            $wp_customize,
            'lz_fitness_premium_pricing_section_disable',
            array(
                'settings' => 'lz_fitness_premium_pricing_section_disable',
                'section' => 'lz_fitness_premium_pricing_section',
                'label' => __( 'Disable Section', 'Luzuk Premium' ),
                'on_off_label'  => array('on' => __( 'Yes', 'Luzuk Premium' ), 'off' => __( 'No', 'Luzuk Premium' )),
            )
        )
    );

    backgroundManager($wp_customize, 'pricing', 'lz_fitness_premium_pricing_section', $color='#ffffff', get_template_directory_uri().'/images/package-bg.jpg', 'color');

    $wp_customize->add_setting('lz_fitness_pricing_title_heading',array('sanitize_callback' => 'lz_fitness_sanitize_text'));
    $wp_customize->add_control(
        new lz_fitness_Customize_Heading(
            $wp_customize,
            'lz_fitness_pricing_title_heading',
            array(
                'settings'      => 'lz_fitness_pricing_title_heading',
                'section'       => 'lz_fitness_premium_pricing_section',
                'label'         => __( 'Pricing Title & Text', 'Luzuk Premium' ),
            )
        )
    );    
    $wp_customize->add_setting('lz_fitness_package_title',array('sanitize_callback' => 'lz_fitness_sanitize_text','default' => __( 'Package Offers', 'Luzuk Premium' )));
    $wp_customize->add_control(
        'lz_fitness_package_title',
        array(
            'settings'      => 'lz_fitness_package_title',
            'section'       => 'lz_fitness_premium_pricing_section',
            'type'          => 'text',
            'label'         => __( 'Title', 'Luzuk Premium' )
        )
    );
     $wp_customize->add_setting('lz_fitness_package_titlebgtext',array('sanitize_callback' => 'lz_fitness_sanitize_text','default' => __( 'PACKAGES', 'Luzuk Premium' )));
    $wp_customize->add_control(
        'lz_fitness_package_titlebgtext',
        array(
            'settings'      => 'lz_fitness_package_titlebgtext',
            'section'       => 'lz_fitness_premium_pricing_section',
            'type'          => 'text',
            'label'         => __( 'Title background text', 'Luzuk Premium' )
        )
    );
    $wp_customize->add_setting('lz_fitness_package_sub_title',array('sanitize_callback'=>'lz_fitness_sanitize_text','default'=> __('Our Packages', 'Luzuk Premium')));
    $wp_customize->add_control(
        'lz_fitness_package_sub_title',
        array(
            'settings' =>'lz_fitness_package_sub_title',
            'section' => 'lz_fitness_premium_pricing_section',
            'type'=> 'text',
            'label'=> __('Sub title', 'Luzuk Premium')
        )
    );

// Heading color
addColorPalatOption($wp_customize, 'lz_fitness_plan_HeadingColor', 'lz_fitness_premium_pricing_section', 'Heading color', '#fff');
// Heading border color
addColorPalatOption($wp_customize, 'lz_fitness_plan_headingborderColor', 'lz_fitness_premium_pricing_section', 'Heading border color', '#fff');

// Heading background text color
addColorPalatOption($wp_customize, 'lz_fitness_plan_HeadingbgtextColor', 'lz_fitness_premium_pricing_section', 'Heading background text color', '#868985');

// Sub heading color
addColorPalatOption($wp_customize, 'lz_fitness_plan_SubheadingColor', 'lz_fitness_premium_pricing_section', 'Sub heading color', '#fff');

    $wp_customize->add_setting('lz_fitness_pricing_npp_heading',array('sanitize_callback' => 'lz_fitness_sanitize_text'));
    $wp_customize->add_control(
        new lz_fitness_Customize_Heading(
            $wp_customize,
            'lz_fitness_pricing_npp_heading',
            array(
                'settings'      => 'lz_fitness_pricing_npp_heading',
                'section'       => 'lz_fitness_premium_pricing_section',
                'label'         => __( 'Number Of Pricing Plans', 'Luzuk Premium' ),
            )
        )
    );    
    $wp_customize->add_setting('lz_fitness_pricing_npp_count',array('sanitize_callback' => 'lz_fitness_sanitize_text','default' => 2));
    $wp_customize->add_control(
        'lz_fitness_pricing_npp_count',
        array(
            'settings'      => 'lz_fitness_pricing_npp_count',
            'section'       => 'lz_fitness_premium_pricing_section',
            'type'          => 'select',
            'label'         => __( 'Number of plan to show', 'Luzuk Premium' ),
            'choices'=>array(1,2,3,4)
        )
    );

    for($i=1;$i<=4;$i++){
        $wp_customize->add_setting('lz_fitness_pricing_plan_heading_'.$i,array('sanitize_callback' => 'lz_fitness_sanitize_text'));
        $wp_customize->add_control(
            new lz_fitness_Customize_Heading(
                $wp_customize,
                'lz_fitness_pricing_plan_heading_'.$i,
                array(
                    'settings' => 'lz_fitness_pricing_plan_heading_'.$i,
                    'section' => 'lz_fitness_premium_pricing_section',
                    'label' => __( 'Plan'.$i, 'Luzuk Premium' ),
                )
            )
        ); 
        $wp_customize->add_setting('lz_fitness_pricing_plan_name_'.$i,array('sanitize_callback' => 'lz_fitness_sanitize_text','default' => __( 'Family Package', 'Luzuk Premium' )));
        $wp_customize->add_control(
            'lz_fitness_pricing_plan_name_'.$i,
            array(
                'settings' => 'lz_fitness_pricing_plan_name_'.$i,
                'section' => 'lz_fitness_premium_pricing_section',
                'type' => 'text',
                'label' => __( 'Plan Name', 'Luzuk Premium' )
            )
        );

         $wp_customize->add_setting('lz_fitness_pricing_plan_content_'.$i,array('sanitize_callback' => 'lz_fitness_sanitize_text','default' => __( 'Lorem ipsum dolor sit amet, consctetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation.', 'Luzuk Premium' )));
        $wp_customize->add_control(
            'lz_fitness_pricing_plan_content_'.$i,
            array(
                'settings' => 'lz_fitness_pricing_plan_content_'.$i,
                'section' => 'lz_fitness_premium_pricing_section',
                'type' => 'textarea',
                'label' => __( 'Plan Content', 'Luzuk Premium' )
            )
        );

          $wp_customize->add_setting('lz_fitness_pricing_plan_start_'.$i,array('sanitize_callback' => 'lz_fitness_sanitize_text','default' => __( 'STARTS FROM', 'Luzuk Premium' )));
        $wp_customize->add_control(
            'lz_fitness_pricing_plan_start_'.$i,
            array(
                'settings' => 'lz_fitness_pricing_plan_start_'.$i,
                'section' => 'lz_fitness_premium_pricing_section',
                'type' => 'text',
                'label' => __( 'Plan Start Label', 'Luzuk Premium' )
            )
        );

        $wp_customize->add_setting('lz_fitness_pricing_plan_unit_'.$i,array('sanitize_callback' => 'lz_fitness_sanitize_text','default' => __( '$', 'Luzuk Premium' )));
        $wp_customize->add_control(
            'lz_fitness_pricing_plan_unit_'.$i,
            array(
                'settings' => 'lz_fitness_pricing_plan_unit_'.$i,
                'section' => 'lz_fitness_premium_pricing_section',
                'type' => 'text',
                'label' => __( 'Plan Price Unit', 'Luzuk Premium' )
            )
        );
       
         $wp_customize->add_setting('lz_fitness_pricing_plan_price_'.$i,array('sanitize_callback' => 'lz_fitness_sanitize_text','default' => __( '250', 'Luzuk Premium' )));
        $wp_customize->add_control(
            'lz_fitness_pricing_plan_price_'.$i,
            array(
                'settings' => 'lz_fitness_pricing_plan_price_'.$i,
                'section' => 'lz_fitness_premium_pricing_section',
                'type' => 'text',
                'label' => __( 'Plan price', 'Luzuk Premium' )
            )
        );

        lzAddElement($wp_customize, 'pricing_plan_url_'.$i, 'lz_fitness_premium_pricing_section', $type = 'text', $label="Add Link for plan".$i."&nbsp;if plan selected", $callback ='esc_url', $default='Add link here');

    /*code for button text*/
    $wp_customize->add_setting(
        'lz_fitness_pricing_page_button_title_'.$i,
        array(
            'sanitize_callback'=>'lz_fitness_sanitize_text',
            'default'=> __('BOOK NOW', 'lz-fitness-premium')
        )
    );
    $wp_customize->add_control(
        'lz_fitness_pricing_page_button_title_'.$i,
        array(
            'settings' =>'lz_fitness_pricing_page_button_title_'.$i,
            'section' => 'lz_fitness_premium_pricing_section',
            'type'=> 'text',
            'label'=> __('Button Text', 'lz-fitness-premium')
        )
    );

    }
    // EDN PRICING SECTION 
    $wp_customize->add_setting('lz_fitness_pricing_shortcode', array('sanitize_callback'=>'lz_fitness_sanitize_text'));
    $wp_customize->add_control(
        new lz_fitness_Info_Text( 
            $wp_customize,
            'lz_fitness_pricing_shortcode',
            array(
                'settings'      => 'lz_fitness_pricing_shortcode',
                'section'       => 'lz_fitness_premium_pricing_section',
                'label'         => __( 'Note:', 'Luzuk Premium' ), 
                'description'   => __( 'Just place the shortcode <strong>"[PLAN_PRICING]"</strong> in your page to show the Pricing in a page ', 'Luzuk Premium' ),
            )
        )
    );

// title color
addColorPalatOption($wp_customize, 'lz_fitness_plan_titleColor', 'lz_fitness_premium_pricing_section', 'Title color', '#212121');
// content color
addColorPalatOption($wp_customize, 'lz_fitness_plan_contentColor', 'lz_fitness_premium_pricing_section', 'Content color', '#3f3f3f');
// content border color
addColorPalatOption($wp_customize, 'lz_fitness_plan_contentborderColor', 'lz_fitness_premium_pricing_section', 'Content border color', '#dadada');
// plan start color
addColorPalatOption($wp_customize, 'lz_fitness_plan_planstartColor', 'lz_fitness_premium_pricing_section', 'Plan Start color', '#212121');
// amount color
addColorPalatOption($wp_customize, 'lz_fitness_plan_amountColor', 'lz_fitness_premium_pricing_section', 'Amount color', '#212121');
// Button text color
addColorPalatOption($wp_customize, 'lz_fitness_plan_btntextColor', 'lz_fitness_premium_pricing_section', 'Button text color', '#fff');
// Button bg color
addColorPalatOption($wp_customize, 'lz_fitness_plan_btnbgColor', 'lz_fitness_premium_pricing_section', 'Button background color', '#fc226a');
// Button border color
addColorPalatOption($wp_customize, 'lz_fitness_plan_btnborderColor', 'lz_fitness_premium_pricing_section', 'Button border color', '#fc226a');

//pricing box color
addColorPalatOption($wp_customize, 'lz_fitness_plan_pricingboxColor', 'lz_fitness_premium_pricing_section', 'Pricing box color', '#fff');
// pricing box outline color
addColorPalatOption($wp_customize, 'lz_fitness_plan_pricingboxoutlineColor', 'lz_fitness_premium_pricing_section', 'Pricing box outline color', '#fff');


// title hover color
addColorPalatOption($wp_customize, 'lz_fitness_plan_titlehoverColor', 'lz_fitness_premium_pricing_section', 'Title hover color', '#fff');
// content hover color
addColorPalatOption($wp_customize, 'lz_fitness_plan_contenthoverColor', 'lz_fitness_premium_pricing_section', 'Content hover color', '#fff');
// content border hover color
addColorPalatOption($wp_customize, 'lz_fitness_plan_contentborderhoverColor', 'lz_fitness_premium_pricing_section', 'Content border hover color', '#fff');
// plan start hover color
addColorPalatOption($wp_customize, 'lz_fitness_plan_planstarthoverColor', 'lz_fitness_premium_pricing_section', 'Plan Start hover color', '#fff');
// amount hover color
addColorPalatOption($wp_customize, 'lz_fitness_plan_amounthoverColor', 'lz_fitness_premium_pricing_section', 'Amount hover color', '#fff');
// Button text hover color
addColorPalatOption($wp_customize, 'lz_fitness_plan_btntexthoverColor', 'lz_fitness_premium_pricing_section', 'Button text hover color', '#fff');
// Button bg hover color
addColorPalatOption($wp_customize, 'lz_fitness_plan_btnbghoverColor', 'lz_fitness_premium_pricing_section', 'Button background hover color', '#7c529c');
// Button border hover color
addColorPalatOption($wp_customize, 'lz_fitness_plan_btnborderhoverColor', 'lz_fitness_premium_pricing_section', 'Button border hover color', '#fff');

//pricing box hover color
addColorPalatOption($wp_customize, 'lz_fitness_plan_pricingboxhoverColor', 'lz_fitness_premium_pricing_section', 'Pricing box hover color', '#7c529c');
// pricing box outline hover color
addColorPalatOption($wp_customize, 'lz_fitness_plan_pricingboxoutlinehoverColor', 'lz_fitness_premium_pricing_section', 'Pricing box outline hover color', '#7c529c');


// Box btn text hover color
addColorPalatOption($wp_customize, 'lz_fitness_plan_boxbtntexthoverColor', 'lz_fitness_premium_pricing_section', 'Box button text  hover color', '#fb216a');
// Box btn bg hover color
addColorPalatOption($wp_customize, 'lz_fitness_plan_boxbtnbghoverColor', 'lz_fitness_premium_pricing_section', 'Box button background  hover color', '#fff');
// Box btn border hover color
addColorPalatOption($wp_customize, 'lz_fitness_plan_boxbtnborderhoverColor', 'lz_fitness_premium_pricing_section', 'Box button border hover color', '#fb216a');
