<?php

$lzFitnessSliderSingleChoice = getFitnessPostsType('lz_fitness_slider');

// CREATING A SECTION IN CUSTOMIZER
$wp_customize->add_section(
	'lz_fitness_premium_slider_section',
	array(
		'title' => __( 'Slider Section', 'luzuk' ),
        'panel' => 'lz_fitness_premium_home_panel',
		'priority' =>18
	)
);

// show content in slider
$wp_customize->add_setting(
	'lz_fitness_premium_slider_show_content',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
	)
);
$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'lz_fitness_premium_slider_show_content',
		array(
			'settings'      => 'lz_fitness_premium_slider_show_content',
			'section'       => 'lz_fitness_premium_slider_section',
			'label'         => __( 'Hide Title and description on slider', 'luzuk' ),
			'on_off_label'  => array(
				'on' => __( 'No', 'luzuk' ),
				'off' => __( 'Yes', 'luzuk' )
			),
		)
	)
);

$wp_customize->add_setting('lz_fitness_premium_slider_section_lbl', array('sanitize_callback'=>'lz_fitness_sanitize_text'));
$wp_customize->add_control(
	new lz_fitness_Info_Text( 
		$wp_customize,
		'lz_fitness_premium_slider_section_lbl',
		array(
			'settings'		=> 'lz_fitness_premium_slider_section_lbl',
			'section'		=> 'lz_fitness_premium_slider_section',
			'label'			=> __( 'Note:', 'luzuk' ),	
			'description'	=> __( 'The Page featured image works as a slider banner and the title & content work as a slider caption. And you can add this from the Slider menu. <br/> Recommended Image Size: 1900X600', 'luzuk' ),
		)
	)
);


// Slider Title color
addColorPalatOption($wp_customize, 'lz_fitness_slider_TitleColor', 'lz_fitness_premium_slider_section', 'Slider Title Color', '#000');

// Slider Title bg color
addColorPalatOption($wp_customize, 'lz_fitness_slider_TitlebgColor', 'lz_fitness_premium_slider_section', 'Slider Title Background Color', '#fbda4d');

// Slider Sub Title color
addColorPalatOption($wp_customize, 'lz_fitness_slider_SubtitleColor', 'lz_fitness_premium_slider_section', 'Slider Sub Title Color', '#fff');

// Slider Sub Title bg color
addColorPalatOption($wp_customize, 'lz_fitness_slider_SubtitlebgColor', 'lz_fitness_premium_slider_section', 'Slider Sub Title Background Color', '#181f25');

addColorPalatOption($wp_customize, 'lz_fitness_slider_buttontextColor', 'lz_fitness_premium_slider_section', 'Slider Button Text Color', '#2b2b2b');
addColorPalatOption($wp_customize, 'lz_fitness_slider_buttonbgColor', 'lz_fitness_premium_slider_section', 'Slider Button Background Color', '#fbda4d');
addColorPalatOption($wp_customize, 'lz_fitness_slider_buttonbg2Color', 'lz_fitness_premium_slider_section', 'Slider Button back Background Color', '#000');

addColorPalatOption($wp_customize, 'lz_fitness_slider_buttontexthoverColor', 'lz_fitness_premium_slider_section', 'Slider Button Text Hover Color', '#fbda4d');
//addColorPalatOption($wp_customize, 'lz_fitness_slider_buttonbghoverColor', 'lz_fitness_premium_slider_section', 'Slider Button Background Hover Color', '#000000');
addColorPalatOption($wp_customize, 'lz_fitness_slider_buttonborderhoverColor', 'lz_fitness_premium_slider_section', 'Slider Button Border Hover Color', '#fbda4d');
addColorPalatOption($wp_customize, 'lz_fitness_slider_arrowsColor', 'lz_fitness_premium_slider_section', 'Slider Button arrow Color', '#2b2b2b');
addColorPalatOption($wp_customize, 'lz_fitness_slider_arrowshoverColor', 'lz_fitness_premium_slider_section', 'Slider Button arrow Hover Color', '#fbda4d');

addColorPalatOption($wp_customize, 'lz_fitness_slider_prevbuttonColor', 'lz_fitness_premium_slider_section', 'Slider Prev Button Background Color', '#af9d56');
addColorPalatOption($wp_customize, 'lz_fitness_slider_NextbuttonColor', 'lz_fitness_premium_slider_section', 'Slider Next Button Background Color', '#918659');

addColorPalatOption($wp_customize, 'lz_fitness_slider_prevbuttonhoverColor', 'lz_fitness_premium_slider_section', 'Slider Prev Button Hover Background Color', '#fcda4e');
addColorPalatOption($wp_customize, 'lz_fitness_slider_NextbuttonhoverColor', 'lz_fitness_premium_slider_section', 'Slider Next Button Hover Background Color', '#fcda4e');


