<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luzuk Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link href="https://fonts.googleapis.com/css?family=Roboto:700" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Roboto+Condensed:300,300i,400,400i,700,700i" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i,800,800i" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Lobster&amp;subset=cyrillic,cyrillic-ext,latin-ext,vietnamese" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Dancing+Script" rel="stylesheet">
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>

	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>
	<script type="text/javascript">
		$(document).ready(function(){
			$("#formButton").click(function(){
				$("#form1").toggle();
			});
		});
	</script>

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<div class="main-container">
		<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'gurukul' ); ?></a>
		<header class="site-header header-transparent header mo-left header-seo">
			<div class="medal-header">

				<div class="container">

					<div class="row"> 
						<div class="col-md-3 col-sm-6 col-xs-12 logomainbox">
							<div class="inside-full-height">
								<?php 
								if( get_theme_mod('pages_logoTmargin',true) ) {
									$pages_logoTmargin = 'margin-top:'.esc_attr(get_theme_mod('pages_logoTmargin')).';';
								}
								if( get_theme_mod('pages_logoBmargin',true) ) {
									$pages_logoBmargin = 'margin-bottom:'.esc_attr(get_theme_mod('pages_logoBmargin')).';';
								}
								if( get_theme_mod('pages_logoLmargin',true) ) {
									$pages_logoLmargin = 'margin-left:'.esc_attr(get_theme_mod('pages_logoLmargin')).';';
								}
								if( get_theme_mod('pages_logoRmargin',true) ) {
									$pages_logoRmargin = 'margin-right:'.esc_attr(get_theme_mod('pages_logoRmargin')).';';
								}
								?>
								<div class="logobox" style="<?php echo esc_attr($pages_logoTmargin); ?>" "<?php echo esc_attr($pages_logoBmargin); ?>" "<?php echo esc_attr($pages_logoLmargin); ?>" "<?php echo esc_attr($pages_logoRmargin); ?>">
									<?php 
									if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
										the_custom_logo();
								else : 
									if ( is_front_page() ) : ?>
										<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
										<?php else : ?>
											<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
										<?php endif; ?>
										<!-- <p class="ht-site-description"><a href="<?php //echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php //bloginfo( 'description' ); ?></a></p> -->
									<?php endif; ?>
									<!-- .site-branding -->
								</div>
								<div class="clearfix"></div>
							</div>
						</div>
						<!-- main header -->
						<div class="col-md-7 col-sm-12 col-xs-12 head-menu main-bar-wraper padding0">
							<!-- <div class="col-md-offset-2 inside-full-height"> -->

								<div class="main-bar clearfix ">
									<div class="top-bar-head">
										<div class="site-navigation ">
											<div class="hamburger-menus">
												<span></span>
												<span></span>
												<span></span>
												<span></span>
												<span></span>
												<span></span>
												<span></span>
												<span></span>
												<span></span>
											</div>
											<nav class="navigation">
												<div class="overlaybg"></div><!--  /.overlaybg -->
												<!-- Main Menu -->
												<div class="menu-wrapper">
													<div class="menu-content">
														<?php
														if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
															wp_nav_menu ( array(
																'menu_class' => 'mainmenu ht-clearfix',
																'container'=> 'ul',
																'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
																'theme_location' => 'primary',  
															)); 
														} else {
															wp_nav_menu ( array(
																'menu_class' => 'mainmenu ht-clearfix',
																'container'=> 'ul',
																'theme_location' => 'primary',  
															)); 
														}
														?>
													</div> <!-- /.hours-content-->


													<div class="clearfix"></div>

												</div><!-- /.menu-wrapper --> 
											</nav>
											<div class="clearfix"></div>
										</div><!--  /.site-navigation -->

									</div>
								</div>
								<!-- </div> -->
							</div>
							<div class="col-md-2 col-sm-6 col-xs-12 headerbtnright">
								<div class="total-count pull-left">				
									<?php if(function_exists ('wc_get_cart_url')){?>				
										<a href="<?php echo wc_get_cart_url();?>" class=""><i class="fa fa-shopping-cart"></i></a>
										<div class="count"><!-- <?php //global $woocommerce; ?> --><?php echo WC()->cart->get_cart_contents_count(); ?> </div>

										<!--<a href="#<?php //echo get_permalink(120); ?>"><img src="<?php //echo get_template_directory_uri(); ?>/images/wishlists.png"  alt=""></a>-->
									<?php }?>
								</div>
								<div class="header-btn">
									<?php if( get_theme_mod('cdsmyaccount_button_display','show' ) == 'show') :
										?>
										<div class="header-myaccount-btn">
											<?php
											$headermyaccounttitle = get_theme_mod('lz_fitness_headermain_headermyaccounttitle', 'My Account'); 
											$headermyaccount = get_theme_mod('lz_fitness_header_headermyaccount', 'Add My Account link here');
											?>
											<?php if(!empty($headermyaccount)){ ?>
												<div class='head-button'><a href="<?php echo $headermyaccount ?>" title="headermyaccount"><?php echo ($headermyaccounttitle);  ?></a></div>
											<?php }?> 
										</div>
									<?php endif ?>
									<div class="clearfix"></div>
								</div>
							</div>
						</div>
						<!-- main header END -->
						<div class="clearfix"></div>
					</div>
				</div>
			</header><!-- #masthead -->
		</div>
