<?php

     /**
     * Use for the show the testimonials at home page and in testimonial page with shortcode
     * @param int $pageId default is null the id of a post
     * @param boolean $isCustomizer default is false if set to true it mean the output is set for the home page
     * @param int $i default null
     * @param boolean $showStaticVals default is false
     * @return void
     * @author Luzuk Premium <support@luzuk.com>
     * */
   function testimonialShortCode($pageId = null, $isCustomizer = false, $i = 0, $showStaticVals = false, $totalItems=0) {
    global $query;
    $args = array('post_type' => 'lz_fitness_testimoni');
    if (!empty($pageId)) {
        $args['page_id'] = absint($pageId);
    } else {
        $args['paged'] = max(1, get_query_var('paged'));
    }
    $args['posts_per_page'] = (!empty($args['posts_per_page'])) ? $args['posts_per_page'] : -1;
    $i = !empty($i) && is_numeric($i) ? $i : 0;
    $text = '';
    $query = new WP_Query($args);
    // print_r($query);
    if ($query->have_posts()):
        $cssCls = ($isCustomizer == false) ? 'col-md-6 col-sm-12' : 'col-sm-10 col-sm-offset-1';

        ob_start();
        while ($query->have_posts()) : $query->the_post();
            $post = get_post();
            $lz_fitness_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'total-team-thumb');
           // echo"(($i == 0) || ($i%2)==0)".__LINE__;
            if(($i == 0) || ($i%2)==0){
                ?>
                <div class="item <?php if ($i == 0) { ?>active<?php } ?>">
                    <div class="row">
                        <?php
                    }
                    ?>
                    <div class="<?php echo $cssCls; ?> padding0 testineer">
                        <?php if ($isCustomizer == false) { ?>
                            <div class="row">

                             <div class="col-sm-10 testimonial-contentbox">
                                <div class="quote-shape"></div>
                             <?php } ?>
                            <div class="team-thumb padding0">
                                <img src="<?php echo (!empty($lz_fitness_image[0])) ? $lz_fitness_image[0] : get_template_directory_uri() . '/images/team-thumb.png' ?>" class="img-responsive" alt="<?php the_title(); ?>" />

                            </div>
                            <div class="col-md-12 col-sm-12 padding0 test-box">
                                <h3 class="secondry-text"><?php the_title(); ?></h3>
                                 <div class="text-designation">
                                    <?php
                                    $name2 = get_post_meta($post->ID, 'testimonial_Sub_Title', false);
                                    echo (!empty($name2[0])) ? $name2[0] : '';
                                    ?>
                                </div>
                                <p><?php
                                      if (has_excerpt()) {
                                        echo get_the_excerpt();
                                    } else {
                                        echo get_the_content();
                                    }
                                ?>
                                </p>
                            </div>  
                    <?php if ($isCustomizer == false) { ?>
                     </div>

                    </div>
                <?php } ?>
                <div class="clearfix"></div>
            </div>
                <?php
            //echo"\n($i+1)%2 == 0 || $totalItems == ($i+1)";
                if(($i+1)%2 == 0 || $totalItems == ($i+1)){ ?>
            </div>
        </div>
        <?php
    }
    ?>

    <?php
endwhile;
$text = ob_get_contents();
ob_clean();
ob_end_flush();
endif;
wp_reset_postdata();
    // echo $text;
return $text;
}


/*End Testimonials*/

add_shortcode('TESTIMONIALS', 'testimonialShortCode');


  /**
 * Get list of all categories from woocommerce theme
 * @param int $isObject return type in array of object default is true
 * @param int $itemPerPagenumber of items per page default -1
 * @param int $isParents to show the only parents default '0'
 * @param int $orderby name of field ordeing with default 'name'
 * @param int $order assending of deseinging default 'ASC'
 * @param int $hideEmpty show the empty categories or not default 'false'
 * @return Array/Object 
 * @author Luzuk 
 * @since version 1.0
 **/
function getWooCategories($isObject = true, $id=0, $isproduct_categories = 0, $itemPerPagenumber = -1, $orderby='name', $order='ASC', $hideEmpty = false){
    $categories = array();
    // echo 'asdlkfjoasdoh';
    $args = array(
        'taxonomy' => 'product_cat',
        'orderby' => $orderby, // 'slug',
        'hide_empty' => $hideEmpty,
        'number'=> 0
    );

    if($isproduct_categories == 0 ){
        $args['product_category'] = $isproduct_categories;
    }

    if(!empty($id) && $id >0 ){
        $args['term_taxonomy_id'] = $id;
    }
    $product_categories = get_terms($args);
    // print_r($parent_terms);
    foreach ($product_categories as $product_category) {
        if($isObject === true){
            $categories[] = $product_category;
        }elseif(!empty($product_category->term_id)){
            $categories[$product_category->term_id] = $product_category->name;
            // echo '&*&*&';
        }
        
    }
    // print_r($categories);
    return $categories;
}      