<?php

$wp_customize->add_panel(
	'lz_fitness_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'lz-fitness-premium')
	)
);
//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'lz-fitness-premium' ),
	'panel' => 'lz_fitness_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'lz-fitness-premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'lz-fitness-premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//HEADER LOGO MARGIN SETTINGS
$wp_customize->add_section(
	'lz_fitness_headerlogo_settings',
	array(
		'title' => __( 'Header Logo Margin Settings', 'luzuk-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

lzCustomLable($wp_customize, 'lz_fitness_headerlogo_margin', 'lz_fitness_headerlogo_settings', ' Site Header Logo Margin:');

$wp_customize->add_setting(
	'pages_logoTmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoTmargin',
	array(
		'settings'      => 'pages_logoTmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Top Margin', 'luzuk-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoBmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoBmargin',
	array(
		'settings'      => 'pages_logoBmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Bottom Margin', 'luzuk-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoLmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoLmargin',
	array(
		'settings'      => 'pages_logoLmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Left Margin', 'luzuk-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoRmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoRmargin',
	array(
		'settings'      => 'pages_logoRmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Right Margin', 'luzuk-premium' )
	)
);




//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image', 'lz-fitness-premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'lz-fitness-premium' ),
	'panel' => 'lz_fitness_general_panel',
) );



//HEADER SETTINGS
$wp_customize->add_section(
	'lz_fitness_header_settings',
	array(
		'title' => __( 'Header Settings', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

	//ENABLE/DISABLE STICKY HEADER
$wp_customize->add_setting(
	'lz_fitness_sticky_header_enable',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default' => 'off'
	)
);

$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'lz_fitness_sticky_header_enable',
		array(
			'settings'		=> 'lz_fitness_sticky_header_enable',
			'section'		=> 'lz_fitness_header_settings',
			'label'			=> __( 'Sticky Header', 'lz-fitness-premium' ),
			'on_off_label' 	=> array(
				'on' => __( 'Enable', 'lz-fitness-premium' ),
				'off' => __( 'Disable', 'lz-fitness-premium' )
			)	
		)
	)
);

$sectionHeader = 'lz_fitness_header_settings'; 

lzCustomLable($wp_customize, 'lz_fitness_header_clrlblImgTxt', 'lz_fitness_header_settings', 'Set Header Menu Colors:');

//Set header menu colour
addColorPalatOption($wp_customize, 'lz_fitness_headermenu_color', 'lz_fitness_header_settings', 'Header Menu Color', '#fff');

//Set header current menu colour
addColorPalatOption($wp_customize, 'lz_fitness_headercurrentmenu_color', 'lz_fitness_header_settings', 'Header Current Menu Color', '#fff');

//Set header current menu border colour
addColorPalatOption($wp_customize, 'lz_fitness_headercurrentmenuborder_color', 'lz_fitness_header_settings', 'Header Current Menu border Color', '#fff');

//Set header menu hover colour
addColorPalatOption($wp_customize, 'lz_fitness_headermenuhover_color', 'lz_fitness_header_settings', 'Header Menu Hover Color', '#fff');

//Set header menu hover border colour
addColorPalatOption($wp_customize, 'lz_fitness_headermenuhoverborder_color', 'lz_fitness_header_settings', 'Header Menu Hover border Color', '#fff');

//Set header sub menu colour
addColorPalatOption($wp_customize, 'lz_fitness_headersubmenu_color', 'lz_fitness_header_settings', 'Header Sub Menu Color', '#ff6796');

//Set header dropdown Background colour
addColorPalatOption($wp_customize, 'lz_fitness_headerdropdownbg_color', 'lz_fitness_header_settings', 'Header dropdown Background Color', '#fff');

//Set header dropdown border colour
addColorPalatOption($wp_customize, 'lz_fitness_headerdropdownborder_color', 'lz_fitness_header_settings', 'Header dropdown Border Color', '#272727');


//Set header sub menu hover colour
addColorPalatOption($wp_customize, 'lz_fitness_headersubmenuhover_color', 'lz_fitness_header_settings', 'Header Sub Menu Hover Color', '#000');

//Set header sub menu arrow hover colour
addColorPalatOption($wp_customize, 'lz_fitness_headersubmenuarrowhover_color', 'lz_fitness_header_settings', 'Header Sub Menu Arrow Hover Color', '#000');

//Set header sub menu hover border colour
addColorPalatOption($wp_customize, 'lz_fitness_headersubmenuhoverborder_color', 'lz_fitness_header_settings', 'Header Sub Menu Hover border Color', '#000');


//Set header current sub menu colour
addColorPalatOption($wp_customize, 'lz_fitness_headercurrentsubmenu_color', 'lz_fitness_header_settings', 'Header Current Sub Menu Color', '#01beff');

//Set header current sub menu border colour
//addColorPalatOption($wp_customize, 'lz_fitness_headercurrentsubmenuborder_color', 'lz_fitness_header_settings', 'Header Current Sub Menu border Color', '#fff');

//Set header current menu of sub menu colour
//addColorPalatOption($wp_customize, 'lz_fitness_headercurrentmenuofsubmenu_color', 'lz_fitness_header_settings', 'Header Current Menu of sub menu Color', '#ff6796');

//Set header current menu of sub menu border colour
//addColorPalatOption($wp_customize, 'lz_fitness_headercurrentmenuofsubmenuborder_color', 'lz_fitness_header_settings', 'Header Current Menu of sub menu border Color', '#fff');


lzCustomLable($wp_customize, 'lz_fitness_header_clrlblcartTxt', 'lz_fitness_header_settings', 'Set Cart Colors:');

//cart icon colour
addColorPalatOption($wp_customize, 'lz_fitness_headercarticon_color', 'lz_fitness_header_settings', 'Cart Icon Color', '#fff');

//count icon colour
addColorPalatOption($wp_customize, 'lz_fitness_headercartcounticon_color', 'lz_fitness_header_settings', 'Count Icon Color', '#fff');

//count icon bg colour
addColorPalatOption($wp_customize, 'lz_fitness_headercartcounticonbg_color', 'lz_fitness_header_settings', 'Count Icon Background Color', '#01beff');


addColorPalatOption($wp_customize, 'lz_fitness_ToggleIcocolor', 'lz_fitness_header_settings', 'Toggle Bar Color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_NavBoxBgcolor', 'lz_fitness_header_settings', 'Navigation Box Background Color For Tab & Mobile View', '#ff6796');
addColorPalatOption($wp_customize, 'lz_fitness_NavBoxBgBrscolor', 'lz_fitness_header_settings', 'Navigation Box Border Color For Tab & Mobile View', '#ffffff');

 
lzCustomLable($wp_customize, 'lz_fitness_premium_header_lblbutton1display', 'lz_fitness_header_settings', 'Header My Account Button Display & Text Setting:');

// to show & hide another button
$wp_customize->add_setting( 'cdsmyaccount_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'cdsmyaccount_button_display', array( 'label' => 'Button Display', 'section' => 'lz_fitness_header_settings', 'settings' => 'cdsmyaccount_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 

// end to show & hide button
// appointment 
$wp_customize->add_setting(
	'lz_fitness_headermain_headermyaccounttitle',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'My Account' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_headermyaccounttitle',
	array(
		'settings'      => 'lz_fitness_headermain_headermyaccounttitle',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Header Button Text', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting('lz_fitness_header_headermyaccount',	array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_headermyaccount',
	array(
		'settings'      => 'lz_fitness_header_headermyaccount',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Add "Header Button" link here', 'lz-fitness-premium' )
	)
);

lzCustomLable($wp_customize, 'lz_fitness_header_clrlbtnTxt', 'lz_fitness_header_settings', 'Set Header Button Colors:');

//Set header button colour
addColorPalatOption($wp_customize, 'lz_fitness_headerbtn_color', 'lz_fitness_header_settings', 'Header Button Color', '#ff6796');

//Set header button bg colour
addColorPalatOption($wp_customize, 'lz_fitness_headerbtnbg_color', 'lz_fitness_header_settings', 'Header Button Background Color', '#fff');

//Set header button hover colour
addColorPalatOption($wp_customize, 'lz_fitness_headerbtnhover_color', 'lz_fitness_header_settings', 'Header Button Hover Color', '#fff');

//Set header button bg hover colour
addColorPalatOption($wp_customize, 'lz_fitness_headerbtnbghover_color', 'lz_fitness_header_settings', 'Header Button Background Hover Color', '#01beff');

//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'lz-fitness-premium'),
	'panel' => 'lz_fitness_general_panel',
) );
//theme primary color
addColorPalatOption($wp_customize, 'lz_fitness_template_color', 'colors', 'Theme Primary Color', '#01beff');

//theme Secondary color
addColorPalatOption($wp_customize, 'theme_secondary_color', 'colors', 'Theme Secondary Color', '#ff6796');


//theme toggle bar color
addColorPalatOption($wp_customize, 'lz_fitness_headertogglebar_color', 'colors', 'Toggle Bar Color', '#01beff');

//Set inner header colour
addColorPalatOption($wp_customize, 'lz_fitness_header_color', 'colors', 'Inner Header Color', '#ff6796');

lzCustomLable($wp_customize, 'lz_fitness_header_lblcurvedisplay', 'colors', 'Inner Page Header Wave Curve Display Setting:');
// to show & hide another button
$wp_customize->add_setting( 'cds_mainheader_curvedisplay' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'cds_mainheader_curvedisplay', array( 'label' => 'Header Wave Curve Display', 'section' => 'colors', 'settings' => 'cds_mainheader_curvedisplay', 'type' => 'radio', 'choices' => array( 'show' => 'Show Wave Curve', 'hide' => 'Hide Wave Curve', ), ) ); 
// end to show & hide button

//Set inner header curve colour
addColorPalatOption($wp_customize, 'lz_fitness_innerheadercurve_color', 'colors', 'Inner Page Header Wave Curve Color', '#ff6796');

//Inner page title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_titlecolor', 'colors', 'Inner page title color', '#fff');
//Inner page background color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_bgcolor', 'colors', 'Inner page title backgroundcolor', '#01beff');

//theme Inner page Footer curve Color
//addColorPalatOption($wp_customize, 'lz_fitness_footer_innerpagecurve_color', 'colors', 'Inner Page Footer Wave Curve Color', '#ff6796');




lzCustomLable($wp_customize, 'innerpage_defaultcolors', 'colors', 'Inner Page Default Colors Setting:');


//Inner page content box heading 1 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh1color', 'colors', 'Heading 1 color', '#333333');

//Inner page content box heading 2 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh2color', 'colors', 'Heading 2 color', '#333333');

//Inner page content box heading 3 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh3color', 'colors', 'Heading 3 color', '#333333');

//Inner page content box heading 4 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh4color', 'colors', 'Heading 4 color', '#333333');

//Inner page content box heading 5 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh5color', 'colors', 'Heading 5 color', '#333333');

//Inner page content box heading 6 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh6color', 'colors', 'Heading 6 color', '#333333');

//Inner page content box text color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtextcolor', 'colors', 'Inner page content box text color', '#303030');

//Inner page content box list color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlistcolor', 'colors', 'Inner page content box list color', '#303030');

//Inner page content box list icon color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlisticoncolor', 'colors', 'Inner page content box list icon color', '#ff6796');

//Inner page content box list number color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlistnumbercolor', 'colors', 'Inner page content box list number color', '#fff');

//Inner page content box list number bg color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlistnumberbgcolor', 'colors', 'Inner page content box list number background color', '#ff6796');

//Inner page content box links color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlinkcolor', 'colors', 'Inner page content box links color', '#ff6796');


//Inner page border color
addColorPalatOption($wp_customize, 'template_innerpage_bordercolor', 'colors', 'Inner page border color', '#EEE');


//Inner page table days Color
addColorPalatOption($wp_customize, 'template_innerpage_tabledays_color', 'colors', 'Inner Page Sidebar Table Days Color', '#fff');

//Inner page table days bg Color
addColorPalatOption($wp_customize, 'template_innerpage_tabledaysbg_color', 'colors', 'Inner Page Sidebar Table Days Background Color', '#ff6796');

//Inner page table text Color
addColorPalatOption($wp_customize, 'template_innerpage_tabletext_color', 'colors', 'Inner Page Sidebar Table Text Color', '#6b7385');

//Inner page table box bg Color
addColorPalatOption($wp_customize, 'template_innerpage_tableboxbg_color', 'colors', 'Inner Page Sidebar Table Box Background Color', '#fff');

//Inner page table btn Color
addColorPalatOption($wp_customize, 'template_innerpage_tablebtn_color', 'colors', 'Inner Page Sidebar Table, Form Button Text and category product dropdown hover Color', '#fff');

//Inner page table btn bg Color
addColorPalatOption($wp_customize, 'template_innerpage_tablebtnbg_color', 'colors', 'Inner Page Sidebar Table Button Background Color', '#ff6796');

//Inner Page Social color
addColorPalatOption($wp_customize, 'template_innerpage_socials_color', 'colors', 'Inner Page Social color', '#fff');

//Inner page box bg Color
addColorPalatOption($wp_customize, 'template_innerpage_boxbg_color', 'colors', 'Inner Page Box Background Color', '#fff');
//Inner page blog box bg Color
addColorPalatOption($wp_customize, 'template_innerpage_blogboxbg_color', 'colors', 'Inner Page Info Box Background Color', '#eee');



//INNER PAGE HEADING FONT SIZE SETTINGS
$wp_customize->add_section(
	'innerheadingfontsize_settings',
	array(
		'title' => __( 'Inner Page Heading Font Size Settings', 'luzuk-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

lzCustomLable($wp_customize, 'lz_fitness_headerlogo_margin', 'innerheadingfontsize_settings', ' Inner Page Heading Font Size:');


$wp_customize->add_setting(
	'pages_h1font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '28px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h1font',
	array(
		'settings'      => 'pages_h1font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 1 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h2font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '26px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h2font',
	array(
		'settings'      => 'pages_h2font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 2 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h3font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '24px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h3font',
	array(
		'settings'      => 'pages_h3font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 3 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h4font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '22px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h4font',
	array(
		'settings'      => 'pages_h4font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 4 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h5font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '20px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h5font',
	array(
		'settings'      => 'pages_h5font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 5 Font Size', 'luzuk-premium' )
	)
);


$wp_customize->add_setting(
	'pages_h6font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '18px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h6font',
	array(
		'settings'      => 'pages_h6font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 6 Font Size', 'luzuk-premium' )
	)
);



//Inner Page Box Padding Setting
$wp_customize->add_section(
	'innerboxpaddiing_settings',
	array(
		'title' => __( 'Inner Page Box Padding Setting', 'luzuk-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

lzCustomLable($wp_customize, 'innerpagebox_padding', 'innerboxpaddiing_settings', ' Inner Page Box Padding Setting:');

$wp_customize->add_setting(
    'innerpagesbox_toppadding',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'innerpagesbox_toppadding',
    array(
        'settings'      => 'innerpagesbox_toppadding',
        'section'       => 'innerboxpaddiing_settings',
        'type'          => 'text',
        'label'         => __( 'Section Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'innerpagesbox_bottompadding',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'innerpagesbox_bottompadding',
    array(
        'settings'      => 'innerpagesbox_bottompadding',
        'section'       => 'innerboxpaddiing_settings',
        'type'          => 'text',
        'label'         => __( 'Section Bottom Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'innerpagesbox_leftpadding',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'innerpagesbox_leftpadding',
    array(
        'settings'      => 'innerpagesbox_leftpadding',
        'section'       => 'innerboxpaddiing_settings',
        'type'          => 'text',
        'label'         => __( 'Section Left Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'innerpagesbox_rightpadding',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'innerpagesbox_rightpadding',
    array(
        'settings'      => 'innerpagesbox_rightpadding',
        'section'       => 'innerboxpaddiing_settings',
        'type'          => 'text',
        'label'         => __( 'Section Right Padding', 'luzuk-premium' )
    )
);



//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'lz_fitness_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'lz_fitness_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Breadcrumb', 'hide' => 'Hide Breadcrumb', ), ) ); 

// end to show & hide button

$wp_customize->add_setting(
        'lz_fitness_breadcrumbhometxt',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text',
            'default'           => __( 'Home', 'luzuk' )
        )
    );
    $wp_customize->add_control(
        'lz_fitness_breadcrumbhometxt',
        array(
            'settings'      => 'lz_fitness_breadcrumbhometxt',
            'section'       => 'lz_fitness_breadcrumb_settings',
            'type'          => 'text',
            'label'         => __( 'Add Breadcrumb Text Here:', 'luzuk' )
        )
    );


//Inner page breadcrumbbox title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbtitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox title color', '#000');
//Inner page breadcrumbbox current title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbcurrenttitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox current title color', '#01beff');

//Inner page breadcrumbbox background color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbbgcolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox background color', '#fff');

//Inner page breadcrumbbox border color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbordercolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox border color', '#01beff');



//POSTPAGEDATE SETTINGS
$wp_customize->add_section(
	'lz_fitness_postpagedate_settings',
	array(
		'title' => __( 'Post Page Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

//for POSTPAGEDATE to show & hide button

$wp_customize->add_setting( 'postdate_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'postdate_button_display', array( 'label' => 'Post Date Display', 'section' => 'lz_fitness_postpagedate_settings', 'settings' => 'postdate_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Post Date', 'hide' => 'Hide Post Date', ), ) ); 

// end to show & hide button

//for POSTPAGEDATE to show & hide button

$wp_customize->add_setting( 'socialpost_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'socialpost_button_display', array( 'label' => 'Post Social Media Display', 'section' => 'lz_fitness_postpagedate_settings', 'settings' => 'socialpost_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Post Social Media', 'hide' => 'Hide Post Social Media', ), ) ); 

// end to show & hide button



$wp_customize->add_section(
	'innershortcode_page_settings',
	array(
		'title' => __( 'Color Setting For Shortcode Pages', 'luzuk-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);


lzCustomLable($wp_customize, 'teaminnerpagepageclrdisplay', 'innershortcode_page_settings', 'Set Team Shortcode Page [TEAMLIST]Colors:');

// img hover overlay color
addColorPalatOption($wp_customize, 'lz_fitness_teaminner_imghoveroverlayColor', 'innershortcode_page_settings', 'Image hover overlay color', '#ff6796');

// social color
addColorPalatOption($wp_customize, 'lz_fitness_teaminner_SocialColor', 'innershortcode_page_settings', 'Social color', '#000');

// social border color
addColorPalatOption($wp_customize, 'lz_fitness_teaminner_SocialborderColor', 'innershortcode_page_settings', 'Social border color', '#000');

// social hover color
addColorPalatOption($wp_customize, 'lz_fitness_teaminner_SocialhoverColor', 'innershortcode_page_settings', 'Social hover color', '#fff');

// social border hover color
addColorPalatOption($wp_customize, 'lz_fitness_teaminner_SocialborderhoverColor', 'innershortcode_page_settings', 'Social border hover color', '#fff');

//Triangle image border color
addColorPalatOption($wp_customize, 'lz_fitness_teaminner_boxborderColor', 'innershortcode_page_settings', 'Triangle image border  color', '#f4f3f3');

// Content box color
addColorPalatOption($wp_customize, 'lz_fitness_teaminner_boxColor', 'innershortcode_page_settings', 'Content box color', '#f4f3f3');

// title color
addColorPalatOption($wp_customize, 'lz_fitness_teaminner_TitleColor', 'innershortcode_page_settings', 'Title color', '#444444');

// title hover color
addColorPalatOption($wp_customize, 'lz_fitness_teaminner_TitlehoverColor', 'innershortcode_page_settings', 'Title hover color', '#ff6796');

// desg color
addColorPalatOption($wp_customize, 'lz_fitness_teaminner_DesColor', 'innershortcode_page_settings', 'Designation color', '#01beff');

// text color
addColorPalatOption($wp_customize, 'lz_fitness_teaminner_TextColor', 'innershortcode_page_settings', 'Text color', '#2e2e2e');

lzCustomLable($wp_customize, 'testimonialsinnerpagepageclrdisplay', 'innershortcode_page_settings', 'Set Testimonials Shortcode Page [TESTIMONIALS] Colors:');


// title color
addColorPalatOption($wp_customize, 'lz_fitness_testimonialsinner_TitleColor', 'innershortcode_page_settings', 'Title color', '#fff');

// desg color
addColorPalatOption($wp_customize, 'lz_fitness_testimonialsinner_desgColor', 'innershortcode_page_settings', 'Designation color', '#fff');

// text color
addColorPalatOption($wp_customize, 'lz_fitness_testimonialsinner_TextColor', 'innershortcode_page_settings', 'Testimonial color', '#fff');

// desg hover color
addColorPalatOption($wp_customize, 'lz_fitness_testimonialsinner_desghoverColor', 'innershortcode_page_settings', 'Designation hover color', '#000');


// desg icon color
addColorPalatOption($wp_customize, 'lz_fitness_testimonialsinner_desgiconColor', 'innershortcode_page_settings', 'Designation hover icon color', '#fff');

// Box color
addColorPalatOption($wp_customize, 'lz_fitness_testimonialsinner_boxColor', 'innershortcode_page_settings', 'Box color', '#ff6796');

// Box border color
addColorPalatOption($wp_customize, 'lz_fitness_testimonialsinner_boxborderColor', 'innershortcode_page_settings', 'Box border color', '#eae6e6');

// Box icon color
addColorPalatOption($wp_customize, 'lz_fitness_testimonialsinner_boxiconColor', 'innershortcode_page_settings', 'Box icon color', '#fff');

// Box icon bg color
addColorPalatOption($wp_customize, 'lz_fitness_testimonialsinner_boxiconbgColor', 'innershortcode_page_settings', 'Box icon background color', '#01beff');

lzCustomLable($wp_customize, 'galleryinnerpagepageclrdisplay', 'innershortcode_page_settings', 'Set Gallery Shortcode [GALLERY] Page Colors:');

// img border color
addColorPalatOption($wp_customize, 'lz_fitness_galleryinner_imgborderColor', 'innershortcode_page_settings', 'Image border color', '#ff6796');

lzCustomLable($wp_customize, 'faqsinnerpagepageclrdisplay', 'innershortcode_page_settings', 'Set FAQS Shortcode Page [FAQS]Colors:');

//ques dark border color
addColorPalatOption($wp_customize, 'lz_fitness_faqsinner_QdarkborderColor', 'innershortcode_page_settings', 'Question dark border color', '#01beff');

//ques bg color
addColorPalatOption($wp_customize, 'lz_fitness_faqsinner_QbgColor', 'innershortcode_page_settings', 'Question background color', '#44494a');
//ques text color
addColorPalatOption($wp_customize, 'lz_fitness_faqsinner_QtextColor', 'innershortcode_page_settings', 'Question text color', '#fff');

//down arrow text color
addColorPalatOption($wp_customize, 'lz_fitness_faqsinner_QdownarrowColor', 'innershortcode_page_settings', 'Question down arrow color', '#fff');

//ans text color
addColorPalatOption($wp_customize, 'lz_fitness_faqsinner_AtextColor', 'innershortcode_page_settings', 'Answer text color', '#fff');

//ans bg color
addColorPalatOption($wp_customize, 'lz_fitness_faqsinner_AbgColor', 'innershortcode_page_settings', 'Answer background color', '#ff6796');

//ans border color
addColorPalatOption($wp_customize, 'lz_fitness_faqsinner_AborderColor', 'innershortcode_page_settings', 'Answer border color', '#01beff');


lzCustomLable($wp_customize, 'servicespagepageclrdisplay', 'innershortcode_page_settings', 'Set Services Shortcode Page [SERVICES]Colors:');


//ans border color
addColorPalatOption($wp_customize, 'lz_featuredinnerimgborder_Color', 'innershortcode_page_settings', 'Services Image Spinner Border color', '#01beff');

//ans border color
addColorPalatOption($wp_customize, 'lz_featuredinnerimgdarkborder_Color', 'innershortcode_page_settings', 'Services Image Spinner Highlights Border Right color', '#ff6796');



//ans border color
addColorPalatOption($wp_customize, 'lz_featuredinnertitle_Color', 'innershortcode_page_settings', 'Services Title color', '#01beff');

//ans border color
addColorPalatOption($wp_customize, 'lz_featuredinnertitlehover_Color', 'innershortcode_page_settings', 'Services Title Hover color', '#ff6796');

//ans border color
addColorPalatOption($wp_customize, 'lz_featuredinnertext_Color', 'innershortcode_page_settings', 'Services Box Text color', '#383838');

//ans border color
addColorPalatOption($wp_customize, 'lz_featuredinnerboxbor_Color', 'innershortcode_page_settings', 'Services Box Border color', '#e8e8e8');


//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'lz_fitness_footer_copyright_settings',
	array(
		'title' => __( 'Footer Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

backgroundManager($wp_customize, 'footer', 'lz_fitness_footer_copyright_settings', $color='#231e1d', get_template_directory_uri().'/images/default-gray.png', 'img');


lzCustomLable($wp_customize, 'lz_fitness_footer_copyright_settingscurvedisplay', 'lz_fitness_footer_copyright_settings', 'Footer Wave Curve Display Setting:');
// to show & hide another button
$wp_customize->add_setting( 'cds_footer_curvedisplay' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'cds_footer_curvedisplay', array( 'label' => 'Footer Wave Curve Display', 'section' => 'lz_fitness_footer_copyright_settings', 'settings' => 'cds_footer_curvedisplay', 'type' => 'radio', 'choices' => array( 'show' => 'Show Wave Curve', 'hide' => 'Hide Wave Curve', ), ) ); 
// end to show & hide button

//theme home Footer curve Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_homecurve_color', 'lz_fitness_footer_copyright_settings', 'Home Page Footer Wave Curve Color', '#ff6796');

//theme Footer social Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_social_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Color', '#fff');

//theme Footer social Hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_socialhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Hover Color', '#fff');

//theme Footer Social Background hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_socialbghover_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Background hover Color', '#00beff');


//theme Footer Social border Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_socialborder_color', 'lz_fitness_footer_copyright_settings', 'Footer  Social Border Color', '#4c3a37');

//theme Footer Social border hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_socialborderhover_color', 'lz_fitness_footer_copyright_settings', 'Footer  Social Border Hover Color', '#00beff');

//theme Footer menu Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_menu_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Color', '#fff');

//theme Footer menu hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_menuhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Hover Color', '#00beff');

//theme Footer menu date Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_menudate_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Date Color', '#fff');

//theme Footer title Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_title_color', 'lz_fitness_footer_copyright_settings', 'Footer Title Color', '#fff');

//theme Footer icon Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_icon_color', 'lz_fitness_footer_copyright_settings', 'Footer Icon Color', '#fff');

//theme Footer icon hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_iconhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Icon Hover Color', '#00beff');

//theme Footer text Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_text_color', 'lz_fitness_footer_copyright_settings', 'Footer Text Color', '#fff');

//theme Footer form Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_form_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Color', '#fff');

//theme Footer form border Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_formborder_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Border Color', '#fff');

//theme Footer form button Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_formbtn_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Button Color', '#fff');

//theme Footer Form Button Background Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_formbtnbg_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Button Background Color', '#00beff');

$wp_customize->add_setting(
	'lz_fitness_footer_copyrighttext',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Copyright © 2019 Panadero Bakery. All Rights Reserved', 'Luzuk Premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_footer_copyrighttext',
	array(
		'settings'      => 'lz_fitness_footer_copyrighttext',
		'section'       => 'lz_fitness_footer_copyright_settings',
		'type'          => 'text',
		'label'         => __( 'Footer Copyright Text', 'Luzuk Premium' )
	)
);


//theme Copyright Footer Border Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_copyrightborder_color', 'lz_fitness_footer_copyright_settings', 'Copyright Footer Border Color', '#dadada');

//theme Copyright Footer Border indicator Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_copyrightborderindicator_color', 'lz_fitness_footer_copyright_settings', 'Copyright Footer Border Indicator Color', '#ff6796');

//theme Footer Text Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_copyrighttext_color', 'lz_fitness_footer_copyright_settings', 'Copyright Footer Text Color', '#fff');

//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
	'lz_fitness_shopsidebar_settings',
	array(
		'title' => __( 'Shop Page Sidebar Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);


// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'lz_fitness_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Sidebar', 'hide' => 'Hide Sidebar', ), ) ); 