<?php
/**
 * Customiser section for featured
 **/
// Start Feature section 
$wp_customize->add_section(
    'lz_fitness_premium_featured_product_section',
    array(
        'title' => __( 'Our Featured Products', 'lz-fitness-premium' ),
        'panel' => 'lz_fitness_premium_home_panel'
    )
);
// ENABLE/DISABLE FEATURED PRODUCT SECTION
$wp_customize->add_setting(
    'lz_fitness_premium_featured_product_section_disable',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
    )
);
$wp_customize->add_control(
    new lz_fitness_Switch_Control(
        $wp_customize,
        'lz_fitness_premium_featured_product_section_disable',
        array(
            'settings'      => 'lz_fitness_premium_featured_product_section_disable',
            'section'       => 'lz_fitness_premium_featured_product_section',
            'label'         => __( 'Disable Section', 'lz-fitness-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'lz-fitness-premium' ),
                'off' => __( 'No', 'lz-fitness-premium' )
            ),
        )
    )
);

backgroundManager($wp_customize, 'featuredproduct', 'lz_fitness_premium_featured_product_section', $color='#ffffff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'lz_fitness_featuredprod_lblteamcurvedisplay', 'lz_fitness_premium_featured_product_section', 'Wave Curve Display Setting:');
// to show & hide another button
$wp_customize->add_setting( 'cds_featureprod_curvedisplay' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'cds_featureprod_curvedisplay', array( 'label' => 'Wave Curve Display', 'section' => 'lz_fitness_premium_featured_product_section', 'settings' => 'cds_featureprod_curvedisplay', 'type' => 'radio', 'choices' => array( 'show' => 'Show Wave Curve', 'hide' => 'Hide Wave Curve', ), ) ); 
// end to show & hide button

 // Curve color
    addColorPalatOption($wp_customize, 'lz_fitness_featiredprod_curveColor', 'lz_fitness_premium_featured_product_section', 'Wave Curve color', '#fff');

$wp_customize->add_setting(
    'lz_fitness_featured_product_title_sub_title_heading',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text'
    )
);
$wp_customize->add_control(
    new lz_fitness_Customize_Heading(
        $wp_customize,
        'lz_fitness_featured_product_title_sub_title_heading',
        array(
            'settings'      => 'lz_fitness_featured_product_title_sub_title_heading',
            'section'       => 'lz_fitness_premium_featured_product_section',
            'label'         => __( 'Section Title', 'lz-fitness-premium' ),
        )
    )
);    
$wp_customize->add_setting(
    'lz_fitness_featured_product_title',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( 'Our Featured Products', 'lz-fitness-premium' )
    )
);
$wp_customize->add_control(
    'lz_fitness_featured_product_title',
    array(
        'settings'      => 'lz_fitness_featured_product_title',
        'section'       => 'lz_fitness_premium_featured_product_section',
        'type'          => 'text',
        'label'         => __( 'Title', 'lz-fitness-premium' )
    )
);


// Heading color
addColorPalatOption($wp_customize, 'lz_fitness_featured_product_HeadingColor', 'lz_fitness_premium_featured_product_section', 'Heading color ', '#444444');

// Heading border color
addColorPalatOption($wp_customize, 'lz_fitness_featured_product_HeadingborderColor', 'lz_fitness_premium_featured_product_section', 'Section Heading border color', '#01beff');
// Heading border icon color
addColorPalatOption($wp_customize, 'lz_fitness_featured_product_HeadingbordericonColor', 'lz_fitness_premium_featured_product_section', 'Section Heading border icon color', '#ff6796');

// Product box color
addColorPalatOption($wp_customize, 'lz_fitness_featured_product_boxColor', 'lz_fitness_premium_featured_product_section', 'Product box color ', '#fff');

// Product Name color
addColorPalatOption($wp_customize, 'lz_fitness_featured_product_NameColor', 'lz_fitness_premium_featured_product_section', 'Product name color ', '#444444');

// Product reguler Price color
addColorPalatOption($wp_customize, 'lz_fitness_featured_product_delpriceColor', 'lz_fitness_premium_featured_product_section', 'Product reguler price color ', '#444444');

// Product Sele Price color
addColorPalatOption($wp_customize, 'lz_fitness_featured_product_inspriceColor', 'lz_fitness_premium_featured_product_section', 'Product sale price color ', '#444444');

// Product Sele Price bg color
addColorPalatOption($wp_customize, 'lz_fitness_featured_product_inspricebgColor', 'lz_fitness_premium_featured_product_section', 'Product sale price background color ', '#96e4ff');


// Button Text color
addColorPalatOption($wp_customize, 'lz_fitness_featured_product_btntextColor', 'lz_fitness_premium_featured_product_section', ' Button text color ', '#fff');

// Button bg color
addColorPalatOption($wp_customize, 'lz_fitness_featured_product_btnbgColor', 'lz_fitness_premium_featured_product_section', ' Button background color ', '#01beff');

// Button Text color
addColorPalatOption($wp_customize, 'lz_fitness_featured_product_btntexthoverColor', 'lz_fitness_premium_featured_product_section', ' Button text hover color ', '#fff');

// Button bg hover color
addColorPalatOption($wp_customize, 'lz_fitness_featured_product_btnbghoverColor', 'lz_fitness_premium_featured_product_section', ' Button background hover color ', '#ff6796');

