<?php
/**
 * @package Luzuk Premium
 */
if(get_theme_mod('product_categories_catlogue_disable') != 'on' ){
	// wp_enqueue_script('product-category-slider', get_template_directory_uri().'/js/product-category-slider.js', array(), '1.1', true);
	//wp_enqueue_script('product-category-slider', get_template_directory_uri().'/js/slider.js', array(), '1.1', true);
	?>
	<section id="product-category-section" class="ht-section product-category-section">
<!-- for Border display-->
			<div class="container">
				<?php
				$product_category_title = get_theme_mod('product_category_title', 'Product Category rsdegsr');
				?>
				<?php if( $product_category_title){ ?>
				<div class="ht-section-title-tagline">			
					<?php if($product_category_title){ ?>
					<h2 class="ht-section-title product-category-heading"><?php echo($product_category_title); ?></h2>
					<?php } ?>
					<div class="dlab-separator-outer m-b0">
						<div class="dlab-separator text-primary style-icon"><i class="fa fa-birthday-cake"></i></div>
					</div>
					<div class="clearfix"></div>
				</div>
				<?php } ?>
 
				<div class="row">
					<div class="col-md-12">
						<div class="product-grid">
							<?php
							$taxonomyName = "product_cat";
							// This gets top layer terms only.  This is done by setting parent to 0.  
							$parent_terms = get_terms($taxonomyName, array('parent' => 0,  'orderby' => 'slug', 'hide_empty' => false));
							if(!empty($parent_terms) && function_exists('get_term_meta')){
								?>
									<div class="owl-carousel owl-theme">
										<?php
										foreach ($parent_terms as $pterm) {
											if(function_exists('get_term_meta')){
											//show parent categories
												$thumbnail_id = get_term_meta($pterm->term_id, 'thumbnail_id', true);
											// get the image URL for parent category
												$image = wp_get_attachment_url($thumbnail_id);
											}else{
												$image = esc_html(get_template_directory_uri()).'/images/default.png';
											}
											echo '<div class="item cat-product hvr-float-shadow">											
											<figure class="pro-cat-img">											
											<a href="' . get_term_link($pterm->name, $taxonomyName) . '"><img src="'.$image.'" alt="" width="270" height="377" /></a>
											</figure>											
											<div class="clearfix"></div>
											<div class="pro-cat-content">
											<span class="rolln"><h5><a href="' . get_term_link($pterm->name, $taxonomyName) . '">' . $pterm->name . '</a></h5></span>
											  <p class="catdesc">' . $pterm->description . '</p>
											   <svg class="procat-separator-svg procat-separator-svg__waves_svg_separator" xmlns="http://www.w3.org/2000/svg" version="1.0" width="1200" fill="#f1f2f4" height="30" viewBox="0 0 1200 30" preserveAspectRatio="none"><path d="M0,0S1.209,1.508,200.671,7.031C375.088,15.751,454.658,30,600,30V0H0ZM1200,0s-90.21,1.511-200.671,7.034C824.911,15.751,745.342,30,600,30V0h600Z"></path></svg>
											  </div>
											  </div>
											  ';
												//Get the Child terms
											$terms = get_terms($taxonomyName, array('parent' => $pterm->term_id, 'orderby' => 'slug', 'hide_empty' => false));
											foreach ($terms as $term) {
												$thumbnail_id = get_term_meta($pterm->term_id, 'thumbnail_id', true);
												// get the image URL for child category
												$image = wp_get_attachment_url($thumbnail_id);
												// print the IMG HTML for child category
												echo '<div class="item cat-product hvr-float-shadow">
												<figure class="pro-cat-img">		
												<a href="' . get_term_link($pterm->name, $taxonomyName) . '"><img src="'.$image.'" alt="" width="270" height="377" /></a>
												</figure>	
												<div class="clearfix"></div>
												<div class="pro-cat-content">
												<span class="rolln"><h5><a href="' . get_term_link($pterm->name, $taxonomyName) . '">' . $pterm->name . '</a></h5></span>
											  	 <p class="catdesc">' . $pterm->description . '</p>
											  	 <svg class="procat-separator-svg procat-separator-svg__waves_svg_separator" xmlns="http://www.w3.org/2000/svg" version="1.0" width="1200" fill="#f1f2f4" height="30" viewBox="0 0 1200 30" preserveAspectRatio="none"><path d="M0,0S1.209,1.508,200.671,7.031C375.088,15.751,454.658,30,600,30V0H0ZM1200,0s-90.21,1.511-200.671,7.034C824.911,15.751,745.342,30,600,30V0h600Z"></path></svg>
											  	 </div>
											  	 </div>
											  ';
											}
										}?>
										<div class="clearfix"></div>
									</div>
								
								<?php
							}else{ ?>
								<div class="alert alert-warning">
									Kindly Install or Activate the WooCommerce plugin.
								</div>
							<?php }
							wp_reset_query();
							?>
							<div class="clearfix"></div>
						</div>
					</div>
				</div>
			</div>
	<div class="clearfix"></div>
</section>
 <script>
            $(document).ready(function() {
              $('.owl-carousel').owlCarousel({
                loop: true,
                margin: 30,
                responsiveClass: true,
                responsive: {
                  0: {
                    items: 1,
                    nav: true
                  },
                  600: {
                    items:2,
                    nav: false
                  },
                  1000: {
                    items:4,
                    nav: true,
                    loop: false,
                    margin: 25
                  }
                }
              })
            })
          </script>
<?php }

