<?php    
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luzuk Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link href="https://fonts.googleapis.com/css?family=Open+Sans:100,100i,200,200i,300,300i,400,400i,600,600i,700,700i,800,800i&display=swap" rel="stylesheet">

	<link href="https://fonts.googleapis.com/css?family=Poppins:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i&display=swap" rel="stylesheet">
	
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery.min.js" crossorigin="anonymous"></script>
	
	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>
	<script>
		function buttonUp(){
			var valux = $('.sb-search-input').val(); 
			valux = $.trim(valux).length;
			if(valux !== 0){
				$('.sb-search-submit').css('z-index','99');
			} else{
				$('.sb-search-input').val(''); 
				$('.sb-search-submit').css('z-index','-999');
			}
		}

		$(document).ready(function(){
			var submitIcon = $('.sb-icon-search');
			var submitInput = $('.sb-search-input');
			var searchBox = $('.sb-search');
			var isOpen = false;

			$(document).mouseup(function(){
				if(isOpen == true){
					submitInput.val('');
					$('.sb-search-submit').css('z-index','-999');
					submitIcon.click();
				}
			});

			submitIcon.mouseup(function(){
				return false;
			});

			searchBox.mouseup(function(){
				return false;
			});

			submitIcon.click(function(){
				if(isOpen == false){
					searchBox.addClass('sb-search-open');
					isOpen = true;
				} else {
					searchBox.removeClass('sb-search-open');
					isOpen = false;
				}
			});

		});
	</script><!--end script for search bar-->
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<div class="main-container clearfix">
		<!-- <a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'InsideTours' ); ?></a> -->
		<div id="loading-area"><div class="la-anim-10"></div></div>
		<!-- header -->
		<!-- #masthead -->
		<header class="site-header header-transparent header mo-left header-seo">

			<?php 
		if( get_theme_mod('header_topbarTpadding',true) ) {
			$header_topbarTpadding = 'padding-top:'.esc_attr(get_theme_mod('header_topbarTpadding')).';';
		}
		if( get_theme_mod('header_topbarBpadding',true) ) {
			$header_topbarBpadding = 'padding-bottom:'.esc_attr(get_theme_mod('header_topbarBpadding')).';';
		}
		if( get_theme_mod('header_middlebarTpadding',true) ) {
			$header_middlebarTpadding = 'padding-top:'.esc_attr(get_theme_mod('header_middlebarTpadding')).';';
		}
		if( get_theme_mod('header_middlebarBpadding',true) ) {
			$header_middlebarBpadding = 'padding-bottom:'.esc_attr(get_theme_mod('header_middlebarBpadding')).';';
		}
		if( get_theme_mod('header_bottombarTpadding',true) ) {
			$header_bottombarTpadding = 'padding-top:'.esc_attr(get_theme_mod('header_bottombarTpadding')).';';
		}
		if( get_theme_mod('header_bottombarBpadding',true) ) {
			$header_bottombarBpadding = 'padding-bottom:'.esc_attr(get_theme_mod('header_bottombarBpadding')).';';
		}
	?>			
			<!-- main header -->
			<div class="top-bar-head">
				<div class="container clearfix">
				<div class="col-md-6 col-sm-12 col-xs-12 pd-0">
					<?php
						$luzuk_header_disc = get_theme_mod('luzuk_header_disc', 'Discount off 25% only for Summer Collection !');
						?>
					
					<i class="fa fa-snowflake-o" aria-hidden="true"></i>
					<?php echo ($luzuk_header_disc);  ?>

				</div>
				<div class="col-md-6 col-sm-12 col-xs-12 pd-0">
					<div class="sticky-header main-bar-wraper navbar-expand-lg">
						<div class="main-bar clearfix ">
						
							<div class="resp_header_btn">
								<button class="navbar-toggler collapsed navicon justify-content-end" type="button" data-toggle="collapse" data-target="#navbarTopNavDropdown" aria-controls="navbarTopNavDropdown" aria-expanded="false" aria-label="Toggle navigation">
									<span></span>
									<span></span>
									<span></span>
								</button>
								<div class="clearfix"></div>
							</div>
							<!-- main nav -->
							<div class="header-nav navbar-collapse collapse justify-content-end" id="navbarTopNavDropdown">
								<ul class="nav navbar-nav">	
									<?php 
									wp_nav_menu( array( 
										'theme_location' => 'topmenu', 
										'container_class' => 'ht-menu clearfix' ,
										'menu_class' => 'ht-clearfix',
										'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
									) ); 
									?>
								</ul>
							</div>
					
						</div>
						<div class="clearfix"></div>
					</div>
				</div>
			</div>
			<div class="clearfix"></div>
		</div>
			<div class="midle-bar-head">
				<div class="container">
					<div class="header-left col-md-3 col-sm-12 col-xs-12 logo">
				
					<!-- website logo -->
					<div class="logo-header mostion">
						<?php 
						if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
							the_custom_logo();
					else : 
						if ( is_front_page() ) : ?>
							<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
							<?php else : ?>
								<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
							<?php endif; ?>
						<?php endif; ?>
					</div> 
					<p class="ht-site-description"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'description' ); ?></a></p>  
					<!-- nav toggle button -->
					<div class="resp_header_logo">
						<?php 
						if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
							the_custom_logo();
					else : 
						if ( is_front_page() ) : ?>
							<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
							<?php else : ?>
								<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
							<?php endif; ?>
							<!-- <p class="ht-site-description"><a href="<?php //echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php //bloginfo( 'description' ); ?></a></p> -->
						<?php endif; ?>
					</div>
				</div>
				<div class="col-md-5 col-sm-12 col-xs-12 pd-0">
					<div class="row row-eq-height head-banner pd-0">
						<div class="col-md-12 col-sm-12 col-xs-12 pd-0 header-off">
							<div class="inside-full-height">
								<?php
			                    $static=true;
			                    for($i=1;$i<2;$i++){
			                        $link = get_theme_mod('header_link'.$i);
			                        $img = get_theme_mod('header_image'.$i);
			                        if (!empty($img) || !empty($link)){
			                            $static=false;
			                        }
			                    }

			                    if(function_exists('get_woocommerce_term_meta')){
			                        for($i=1;$i<2;$i++){

			                            if($static==false){
			                                $link = get_theme_mod('header_link'.$i);
			                                $img = get_theme_mod('header_image'.$i);
			                                $url = get_theme_mod('header_url_'.$i, '#');
			                                $category = get_term_by( 'id', $link, 'product_cat' );

			                                $img = !empty($img)?$img:get_template_directory_uri().'/images/top-ads.png';

			                                if( !empty($url) || !empty($category) ){
			                                    //echo $term->name;
			                                    ?>
			                                        <a href="<?php echo esc_url(!empty($url)?$url:'#');?>">
			                                            <img src="<?php echo esc_url($img);?>" alt="" class="img-responsive header banner">
			                                        </a>
			                                    <?php
			                                }
			                            }
			                        }
			                    }else{ ?>
			                    <div class="alert alert-warning">
			                        Kindly Install or Activate the WooCommerce plugin.
			                    </div>
			                    <?php }

			                    if($static==true){
			                        ?>
			                            <a href="#">
			                                <img class="img-responsive header banner" src="<?php echo get_template_directory_uri(); ?>/images/top-ads.png" alt="">
			                            </a>
			                        <?php
			                    }?>
							</div>
						</div>
						<div class="clearfix"></div>
					</div>
					<div class="clearfix"></div>

				</div>
				<div class="col-md-3 col-sm-10 col-xs-9">
					<?php
							$luzuk_search_placeholder = get_theme_mod('luzuk_search_placeholder', 'Enter your keywords.....');
							?>
					<div id="sb-search" class="sb-search">
					   <form role="search" method="get" class="woocommerce-product-search" action="<?php echo esc_url( home_url( '/'  ) ); ?>">
						<label class="screen-reader-text" for="s"><?php _e( 'Search for:', 'woocommerce' ); ?></label>
						<input type="search" class="search-field" placeholder="<?php echo ($luzuk_search_placeholder);  ?>" value="<?php echo get_search_query(); ?>" name="s" title="<?php echo esc_attr_x( 'Search for:', 'label', 'woocommerce' ); ?>" />
						<input type="submit" value="<?php echo esc_attr_x( 'Search', 'submit button', 'woocommerce' ); ?>" />
						<input type="hidden" name="post_type" value="product" />
						</form>
					</div>	
				</div>
				<div class="col-md-1 col-sm-12 col-xs-12">
					<div class="total-count pull-right col-md-3 col-sm-3 col-xs-8 padding0">				
					<?php if(function_exists ('wc_get_cart_url')){?>				
						<a href="<?php echo wc_get_cart_url();?>" class=""><img src="<?php echo get_template_directory_uri(); ?>/images/carticon.png"  alt=""></a>
						<div class="count">
							<?php global $woocommerce; print_r(count(WC()->cart->get_cart())); ?>
							<?php //global $woocommerce; ?><?php //echo WC()->cart->get_cart_contents_count(); ?></div>
						<?php }?>
					</div>
				</div>
				<div class="clearfix"></div>
			</div>
			<div class="clearfix"></div>
		</div>
		<div class="bottom-bar-head">
			<div class="container clearfix">
				
					<div class="col-md-9 col-sm-12 col-xs-12 sticky-header main-bar-wraper navbar-expand-lg">
					<div class="main-bar clearfix ">
						<div class="resp_header_btn">
							<button class="navbar-toggler collapsed navicon justify-content-end" type="button" data-toggle="collapse" data-target="#navbarNavDropdown" aria-controls="navbarNavDropdown" aria-expanded="false" aria-label="Toggle navigation">
								<span></span>
								<span></span>
								<span></span>
							</button>
							<div class="clearfix"></div>
						</div>
						<!-- main nav -->
						<div class="header-nav navbar-collapse collapse justify-content-end" id="navbarNavDropdown">
							<ul class="nav navbar-nav">	
								<?php 
								wp_nav_menu( array( 
									'theme_location' => 'primary', 
									'container_class' => 'ht-menu clearfix' ,
									'menu_class' => 'ht-clearfix',
									'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
								) ); 
								?>
							</ul>
						</div>
					</div>
					<div class="clearfix"></div>
				</div>
				<div class="col-md-3 col-sm-4 col-xs-8">
					<?php if(class_exists('woocommerce')){ ?>
						<div class="header-category-box">
							<?php
							$luzuk_header_browsebydept = get_theme_mod('luzuk_header_browsebydept', ' Category');
							?>
							<button class="product-btn">
								<?php echo ($luzuk_header_browsebydept);  ?><i class="fa fa-bars" aria-hidden="true"></i></button>

							<div class="product-cat" style="display: none">
						<?php
						$args = array(
						          'taxonomy' => 'product_cat',
						          'hide_empty' => false,
						          'parent'   => 0
						      );
						  $product_cat = get_terms( $args );

						  foreach ($product_cat as $parent_product_cat)
						  {

						  echo '
						      <ul>
						        <li><a href="'.get_term_link($parent_product_cat->term_id).'">'.$parent_product_cat->name.'</a>
						        <ul>
						          ';
						  $child_args = array(
						              'taxonomy' => 'product_cat',
						              'hide_empty' => false,
						              'parent'   => $parent_product_cat->term_id
						          );
						  $child_product_cats = get_terms( $child_args );
						  foreach ($child_product_cats as $child_product_cat)
						  {
						    echo '<li class="sucat"><a href="'.get_term_link($child_product_cat->term_id).'">'.$child_product_cat->name.'</a>
 							<ul>
						          ';
						  $child_child_args = array(
						              'taxonomy' => 'product_cat',
						              'hide_empty' => false,
						              'parent'   => $child_product_cat->term_id
						          );
						  $child_child_product_cats = get_terms( $child_child_args );
						  foreach ($child_child_product_cats as $child_child_product_cat)
						  {
						    echo '<li class="sucat"><a href="'.get_term_link($child_child_product_cat->term_id).'">'.$child_child_product_cat->name.'</a>
						    			<ul>
						          ';
						  $child_child_child_args = array(
						              'taxonomy' => 'product_cat',
						              'hide_empty' => false,
						              'parent'   => $child_child_product_cat->term_id
						          );
						  $child_child_child_product_cats = get_terms( $child_child_child_args );
						  foreach ($child_child_child_product_cats as $child_child_child_product_cat)
						  {
						    echo '<li class="sucat"><a href="'.get_term_link($child_child_child_product_cat->term_id).'">'.$child_child_child_product_cat->name.'</a></li>';

							}
							echo '</ul>
								</li>';




						    ;

							}
							echo '</ul>
								</li>';

						  }

						  echo ' </ul>	
						  </li>					    
						    </ul>';
						  }
						?>
					</div>
						<?php }else {
							echo '<h6>'.esc_html('Please Install Woocommerce Plugin','lz-fashion-ecommerce').'<h6>'; }?>
					</div>
				
			</div>
		<div class="clearfix"></div>
		</div>
		<div class="clearfix"></div>
	</header>
</div>
