<?php

$wp_customize->add_panel(
	'luzuk_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'Luzuk Premium')
	)
);
//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'Luzuk Premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );

$wp_customize->add_setting(
    'pages_logoTopsetmaxwidth',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '100', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoTopsetmaxwidth',
    array(
        'settings'      => 'pages_logoTopsetmaxwidth',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Set Logo Max Width', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'header_SiteTaglineColor', 'title_tagline', 'Tagline Color', '#0d61cc');



//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image Setting', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );


//HEADER SETTINGS
$wp_customize->add_section(
	'header_settings',
	array(
		'title' => __( 'Header Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);
$sectionHeader = 'header_settings';

lzCustomLable($wp_customize, 'header_bgColorssettings', $sectionHeader, 'Header Background Colors');

addColorPalatOption($wp_customize, 'header_topbgColor', 'header_settings', ' Top Header Background Color', '#0d61cc');
addColorPalatOption($wp_customize, 'header_midleColor', 'header_settings', ' Middle Header Background Color', '#fff');
addColorPalatOption($wp_customize, 'header_bottombgColor', 'header_settings', ' Bottom Header Background Color', '#0d61cc');

lzCustomLable($wp_customize, 'header_toppaddingsetting', 'header_settings', 'Set Top Header Padding:');

$wp_customize->add_setting(
    'header_topbarTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '15px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'header_topbarTpadding',
    array(
        'settings'      => 'header_topbarTpadding',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'header_topbarBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '15px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'header_topbarBpadding',
    array(
        'settings'      => 'header_topbarBpadding',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'header_middlepaddingsetting', 'header_settings', 'Set Middle Header Padding:');

$wp_customize->add_setting(
    'header_middlebarTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '20px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'header_middlebarTpadding',
    array(
        'settings'      => 'header_middlebarTpadding',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'header_middlebarBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '20px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'header_middlebarBpadding',
    array(
        'settings'      => 'header_middlebarBpadding',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'header_bottompaddingsetting', 'header_settings', 'Set Bottom Header Padding:');

$wp_customize->add_setting(
    'header_bottombarTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '10px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'header_bottombarTpadding',
    array(
        'settings'      => 'header_bottombarTpadding',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'header_bottombarBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '10px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'header_bottombarBpadding',
    array(
        'settings'      => 'header_bottombarBpadding',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);


lzCustomLable($wp_customize, 'header_distextssettings', $sectionHeader, 'Header Discount Text Setting');
$wp_customize->add_setting(
        'luzuk_header_disc',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Discount off 25% only for Summer Collection !', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'luzuk_header_disc',
        array(
            'settings'      => 'luzuk_header_disc',
            'section'       => 'header_settings',
            'type'          => 'textarea',
            'label'         => __( 'Discount Text', 'luzuk-premium' )
        )
    );
addColorPalatOption($wp_customize, 'header_distextColor', 'header_settings', ' Discount Text & Icon Color', '#fff');

lzCustomLable($wp_customize, 'header_offertextssettings', $sectionHeader, 'Header Banner Setting');

for( $i = 1; $i <2; $i++ ){

    $wp_customize->add_setting(
        'img_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'img_header'.$i,
            array(
                'settings'      => 'img_header'.$i,
                'section'       => 'header_settings',
                'label'         => __( 'Product Banner '.$i, 'luzuk-premium' )
            )
        )
    );

    lzAddImageElement($wp_customize, 'header_image'.$i, 'header_settings', $label="Recommended Image Size: 500X500px");
    lzAddElement($wp_customize, 'header_url_'.$i, 'header_settings', $type = 'text', $label="Image Link", $callback ='esc_url', $default='Add link here');

}

lzCustomLable($wp_customize, 'header_SearchColorssettings', $sectionHeader, 'Search Settings');

lzCustomLable($wp_customize, 'header_searchlable', 'header_settings', 'Note: Do not add any html tags on search Placeholder.');

$wp_customize->add_setting(
        'luzuk_search_placeholder',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Enter your keywords.....', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'luzuk_search_placeholder',
        array(
            'settings'      => 'luzuk_search_placeholder',
            'section'       => 'header_settings',
            'type'          => 'text',
            'label'         => __( 'Search Placeholder', 'luzuk-premium' )
        )
    );

addColorPalatOption($wp_customize, 'header_searchtextColor', 'header_settings', 'Search Text color', '#bebec2');
addColorPalatOption($wp_customize, 'header_searchborderColor', 'header_settings', 'Search Border color', '#e5e5e5');
addColorPalatOption($wp_customize, 'header_searchbgColor', 'header_settings', 'Search Background color', '#fff');
addColorPalatOption($wp_customize, 'header_searchhoverborderColor', 'header_settings', 'Search Border Hover color', '#ff0c12');

addColorPalatOption($wp_customize, 'header_searchbuttonbgColor', 'header_settings', 'Search Button Background color', '#0d61cc');
addColorPalatOption($wp_customize, 'header_searchbuttonbghoverColor', 'header_settings', 'Search Button Background Hover color', '#ff0c12');


lzCustomLable($wp_customize, 'header_procatColorssettings', $sectionHeader, 'Product Category Setting');
$wp_customize->add_setting(
        'luzuk_header_browsebydept',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Category', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'luzuk_header_browsebydept',
        array(
            'settings'      => 'luzuk_header_browsebydept',
            'section'       => 'header_settings',
            'type'          => 'text',
            'label'         => __( 'Category Label', 'luzuk-premium' )
        )
    );

addColorPalatOption($wp_customize, 'header_procatlabelColor', 'header_settings', 'Product Category Label & Icon color', '#fff');
addColorPalatOption($wp_customize, 'header_procatborderColor', 'header_settings', 'Product Category Label border color', '#2273cf');
addColorPalatOption($wp_customize, 'header_procatboxColor', 'header_settings', 'Product Category Box color', '#fff');
addColorPalatOption($wp_customize, 'header_procatColor', 'header_settings', 'Product Category  & Icon color', '#7c8396');
addColorPalatOption($wp_customize, 'header_procathoverColor', 'header_settings', 'Product Category  & Icon Hover color', '#0d61cc');

lzCustomLable($wp_customize, 'header_cartColorssettings', $sectionHeader, 'Cart Colors');

addColorPalatOption($wp_customize, 'header_cartcountColor', 'header_settings', 'Cart Count color', '#eef3f7');
addColorPalatOption($wp_customize, 'header_cartcountbgColor', 'header_settings', 'Cart Count Background color', '#2973d2');
addColorPalatOption($wp_customize, 'header_cartcountbghoverColor', 'header_settings', 'Cart Count Background Hover color', '#ff0c12');

lzCustomLable($wp_customize, 'header_MenuColorssettings', $sectionHeader, 'Navigation Colors');

addColorPalatOption($wp_customize, 'header_topmenusColor', 'header_settings', 'Menus color', '#fff');
addColorPalatOption($wp_customize, 'header_topmenushoverColor', 'header_settings', 'Menus Hover color', '#8a9dbc');
addColorPalatOption($wp_customize, 'header_topmenusactiveColor', 'header_settings', 'Active Menus color', '#8a9dbc');
addColorPalatOption($wp_customize, 'header_topmenusactivehoverborderColor', 'header_settings', 'Active Menus & Hover Menu Border color', '#8a9dbc');
addColorPalatOption($wp_customize, 'header_topsubmenusColor', 'header_settings', 'Header Sub Menus color', '#8a9dbc');
addColorPalatOption($wp_customize, 'header_topsubmenushvrColor', 'header_settings', 'Sub Menus Hover color', '#fff');
addColorPalatOption($wp_customize, 'header_topsubmenusactiveColor', 'header_settings', 'Sub Menu Active color', '#0d61cc');
addColorPalatOption($wp_customize, 'header_topsubmenushoverborderbgColor', 'header_settings', 'Sub Menu Hover Border & Background color', '#ff0c12');

addColorPalatOption($wp_customize, 'header_submenusbgsscColor', 'header_settings', 'Sub Menus Box Background color', '#fff');

//lzCustomLable($wp_customize, 'luzuk_header_colorsforstickyheader', $sectionHeader, 'Colors For Sticky Header');

//addColorPalatOption($wp_customize, 'header_HeaderstickybgColor', 'header_settings', 'Sticky Header Background Color', '#0d61cc');

lzCustomLable($wp_customize, 'header_colorsfortabandmobview', $sectionHeader, 'Responsive Header Settings');

addColorPalatOption($wp_customize, 'header_respnavtoggbarbgssColor', 'header_settings', 'Toggle Bar color', '#fff');

addColorPalatOption($wp_customize, 'header_respnavbsbgssColor', 'header_settings', ' Navigation Box Background Color', '#0d61cc');
addColorPalatOption($wp_customize, 'header_navigationrespnavbrssColor', 'header_settings', 'Navigation Box Border Color', '#fff');

//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'Luzuk Premium'),
	'panel' => 'luzuk_general_panel',
) );
//theme primary color
addColorPalatOption($wp_customize, 'luzuk_template_color', 'colors', 'Theme Primary Color', '#0d61cc');
//theme Secondary color
addColorPalatOption($wp_customize, 'theme_secondary_color', 'colors', 'Theme Secondary Color', '#ff0c12');

lzCustomLable($wp_customize, 'luzuk_allinnerpagesec_colordisplaysettdisplay', 'colors', 'Color Setting For Innerpage Colors:');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_titlecolor', 'colors', 'Inner page title color', '#fff');
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_bgcolor1', 'colors', 'Inner page title background color one', '#0d61cc'); 
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_bgcolor2', 'colors', 'Inner page title background color two', '#ff0c12'); 

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionbox_color', 'colors', 'Inner Page Box Background color', '#ffffff');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading1_color', 'colors', 'Heading 1 color', '#2e2e2e');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading2_color', 'colors', 'Heading 2 color', '#2e2e2e');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading3_color', 'colors', 'Heading 3 color', '#2e2e2e');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading4_color', 'colors', 'Heading 4 color', '#2e2e2e');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading5_color', 'colors', 'Heading 5 color', '#2e2e2e');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading6_color', 'colors', 'Heading 6 color', '#2e2e2e');

addColorPalatOption($wp_customize, 'template_innerpage_contentboxsidebartitlecolor', 'colors', 'Inner Page Sidebar Heading Color', '#000');
addColorPalatOption($wp_customize, 'template_innerpage_contentboxsidebartitlebordercolor', 'colors', 'Inner Page Sidebar Heading Border & Product Button Background Color', '#000');


addColorPalatOption($wp_customize, 'luzuk_template_innerpageproductprice_color', 'colors', 'Inner Page Product Selling Price color', '#868b9e');
addColorPalatOption($wp_customize, 'luzuk_template_innerpageproductpricedel_color', 'colors', 'Inner Page Product Price color', '#7c8491');
addColorPalatOption($wp_customize, 'luzuk_template_innerpageproductimghovericon_color', 'colors', 'Inner Page Product Image Hover Icon color', '#868b9e');
addColorPalatOption($wp_customize, 'luzuk_template_innerpageproductimghovericonbg_color', 'colors', 'Inner Page Product Image Hover Icon Background color', '#fff');


addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtext_color', 'colors', 'Inner Page Text Color', '#666');

addColorPalatOption($wp_customize, 'template_innerpage_productpageboldtextcolor', 'colors', 'Inner Product Page Bold Text Color', '#000');

addColorPalatOption($wp_customize, 'template_innerpage_cartpageproducttitlecolor', 'colors', 'Inner  Cart Page Product Title Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_template_Ptoductinnerpagelinktextcolor_color', 'colors', 'Product Page Link Tab Text Color', '#282828');

addColorPalatOption($wp_customize, 'luzuk_template_Ptoductinnerpagelinktextactivecolor_color', 'colors', 'Product Page Link Active Tab Text Color', '#666');

addColorPalatOption($wp_customize, 'luzuk_template_innerpageallothrtheadtextcolcolor_color', 'colors', 'Other Text Color', '#fff');
addColorPalatOption($wp_customize, 'luzuk_template_innerpageallothrtheadtextbgsscolcolor_color', 'colors', 'Other Fields Background Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtextlinks_color', 'colors', 'Inner Page Links color', '#4f4c4c');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtextlinkshvrs_color', 'colors', 'Inner Page Links Hover color', '#0d61cc');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtextlinksicon_color', 'colors', 'Inner Page Icons, list number color', '#0d61cc');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtextlinksiconbgssclr_color', 'colors', 'Inner Page list number Background color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionsidebarborderrs_color', 'colors', 'Inner Page Sidebar & text field Border color', '#eaeaea');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagesidebardaytxt_color', 'colors', 'Inner Page Sidebar Calender Widgets Day Text color', '#ffffff');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagesidebardaybgsstxt_color', 'colors', 'Inner Page Sidebar Calender Widgets Day Text Background color', '#777777');

lzCustomLable($wp_customize, 'luzuk_allinnerpagesec_pagination', 'colors', 'Color Setting For Pagination:');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagepagination_color', 'colors', 'Inner Page Pagination Color', '#000');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagepaginationbg_color', 'colors', 'Inner Page Pagination Background Color', '#fff');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagepaginationborder_color', 'colors', 'Inner Page Pagination Border Color', '#eaeaea');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagepaginationactive_color', 'colors', 'Inner Page Pagination Hover & Active Color', '#fff');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagepaginationbgactive_color', 'colors', 'Inner Page Pagination Background Hover & Active Color', '#0d61cc');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagepaginationborderactive_color', 'colors', 'Inner Page Pagination Border Hover & Active Color', '#0d61cc');


//addColorPalatOption($wp_customize, 'luzuk_template_staticfrontinnerpage_bgcolor', 'colors', 'Static Front Page Top Header background color', '#2e2e2e');
lzCustomLable($wp_customize, 'luzuk_allinnerpagesec_colordisplaysettnavbackttoarrdisplay', 'colors', 'Color Setting For Navigation Back to top arrow:');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_backttoparrcbgcolor', 'colors', 'Site Navigation Arrow color', '#0d61cc');
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_backttoparrcbghvrcolor', 'colors', 'Site Navigation Arrow Hover color', '#516bec');
//addColorPalatOption($wp_customize, 'luzuk_template_innerpage_backttoparrbackcolbgcolor', 'colors', 'Site Navigation Arrow background color', '#fd3e1c');
//addColorPalatOption($wp_customize, 'luzuk_template_innerpage_backttoparrbackcolbghvrscolor', 'colors', 'Site Navigation Arrow background hover color', '#ffffff');





//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'luzuk_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'luzuk_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Breadcrumb', 'hide' => 'Hide Breadcrumb', ), ) ); 

$wp_customize->add_setting(
        'luzuk_breadcrumbhometxt',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Home', 'luzuk' )
        )
    );
    $wp_customize->add_control(
        'luzuk_breadcrumbhometxt',
        array(
            'settings'      => 'luzuk_breadcrumbhometxt',
            'section'       => 'luzuk_breadcrumb_settings',
            'type'          => 'text',
            'label'         => __( 'Add Breadcrumb Text Here:', 'luzuk' )
        )
    );

//Inner page breadcrumbbox title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbtitlecolor', 'luzuk_breadcrumb_settings', 'Inner page breadcrumbbox title color', '#fff');
//Inner page breadcrumbbox current title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlecolor', 'luzuk_breadcrumb_settings', 'Inner page breadcrumbbox current title color', '#fff');
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlehovercolor', 'luzuk_breadcrumb_settings', 'Inner page breadcrumbbox current title hover color', '#121212');
// end to show & hide button

//POSTPAGEDATE SETTINGS
$wp_customize->add_section(
	'luzuk_blogpage_settings',
	array(
		'title' => __( 'Blog Page Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'allblog_heading2label', 'luzuk_blogpage_settings', 'Post Heading Font Size Setting:');

$wp_customize->add_setting(
    'blogpages_innerpageheading2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '24px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blogpages_innerpageheading2',
    array(
        'settings'      => 'blogpages_innerpageheading2',
        'section'       => 'luzuk_blogpage_settings',
        'type'          => 'text',
        'label'         => __( 'Post Heading Font Size', 'luzuk-premium' )
    )
);




lzCustomLable($wp_customize, 'allblog_lblbuttonabtdisplay', 'luzuk_blogpage_settings', 'Post Date Display Setting:');

//for POSTPAGEDATE to show & hide button

$wp_customize->add_setting( 'postdate_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'postdate_button_display', array( 'label' => 'Post Date Display', 'section' => 'luzuk_blogpage_settings', 'settings' => 'postdate_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Post Date', 'hide' => 'Hide Post Date', ), ) ); 

// end to show & hide button


lzCustomLable($wp_customize, 'singleblog_lblbuttonabtdisplay', 'luzuk_blogpage_settings', 'Post social Icons Display Setting:');


//for POSTPAGEsocialsshare to show & hide button

$wp_customize->add_setting( 'postsocialsshare_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'postsocialsshare_button_display', array( 'label' => 'Post social Icons Display', 'section' => 'luzuk_blogpage_settings', 'settings' => 'postsocialsshare_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Social Icons', 'hide' => 'Hide Social Icons', ), ) ); 

// end to show & hide button

//Blog page social color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogsocialcolor', 'luzuk_blogpage_settings', 'Blog page social color', '#fff');
//Blog page social color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogsocialbgcolor', 'luzuk_blogpage_settings', 'Blog page social background color', '#0d61cc');
//Blog page social hover color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogsocialhovercolor', 'luzuk_blogpage_settings', 'Blog page social hover color', '#0d61cc');
//Blog page social color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogsocialbghovercolor', 'luzuk_blogpage_settings', 'Blog page social background hover color', '#fff');


lzCustomLable($wp_customize, 'blog_lblbuttonabtdisplay', 'luzuk_blogpage_settings', 'Post Button Display & Text Setting:');

// to show & hide another button
$wp_customize->add_setting( 'blogpage_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'blogpage_button_display', array( 'label' => 'Blog Button Display', 'section' => 'luzuk_blogpage_settings', 'settings' => 'blogpage_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button


$wp_customize->add_setting(
    'blogbutninner_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Continue Reading', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blogbutninner_text',
    array(
        'settings'      => 'blogbutninner_text',
        'section'       => 'luzuk_blogpage_settings',
        'type'          => 'text',
        'label'         => __( 'Blog Button Text', 'luzuk-premium' )
    )
);

//Blog page button color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogbuttoncolor', 'luzuk_blogpage_settings', 'Blog page button Text & Date color', '#fff');

//Blog page button color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogboxbgcolor', 'luzuk_blogpage_settings', 'Blog page Box Background color', '#eee');


//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'footer_area',
	array(
		'title' => __( 'Footer Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

backgroundManager($wp_customize, 'footer', 'footer_area', $color='#0c0c0c');

lzCustomLable($wp_customize, 'footer_areatPadding', 'footer_area', 'Set Top Footer Padding:');

$wp_customize->add_setting(
    'sec_footersetopfooterseTmargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1.5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_footersetopfooterseTmargin',
    array(
        'settings'      => 'sec_footersetopfooterseTmargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'sec_footersetopfooterseBmargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1.2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_footersetopfooterseBmargin',
    array(
        'settings'      => 'sec_footersetopfooterseBmargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);


$wp_customize->add_setting(
    'footer_FUniqueN',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '25,329,532' )
    )
);
$wp_customize->add_control(
    'footer_FUniqueN',
    array(
        'settings'      => 'footer_FUniqueN',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Unique Number', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'footer_FUniqueNL',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Our Unique visitor' )
    )
);
$wp_customize->add_control(
    'footer_FUniqueNL',
    array(
        'settings'      => 'footer_FUniqueNL',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Unique Label', 'luzuk-premium' )
    )
);


$wp_customize->add_setting(
    'footer_FTotalN',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '25,329,53253825' )
    )
);
$wp_customize->add_control(
    'footer_FTotalN',
    array(
        'settings'      => 'footer_FTotalN',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Total Number', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'footer_FTotalNL',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Our Total visitor' )
    )
);
$wp_customize->add_control(
    'footer_FTotalNL',
    array(
        'settings'      => 'footer_FTotalNL',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Total Label', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'footer_areamPadding', 'footer_area', 'Set Middle Footer Padding:');

$wp_customize->add_setting(
    'sec_footerseTmargin', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_footerseTmargin',
    array(
        'settings'      => 'sec_footerseTmargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'sec_footersebottommargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_footersebottommargin',
    array(
        'settings'      => 'sec_footersebottommargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'footerarea_bottomareabg_color', 'footer_area', 'Bottom Area Background Color', '#101010');

lzCustomLable($wp_customize, 'footer_areabottomfPadding', 'footer_area', 'Set Bottom Footer Padding:');

$wp_customize->add_setting(
    'sec_bottomareaTmargin', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '30px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_bottomareaTmargin',
    array(
        'settings'      => 'sec_bottomareaTmargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'sec_bottomareabottommargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '30px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_bottomareabottommargin',
    array(
        'settings'      => 'sec_bottomareabottommargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);
lzCustomLable($wp_customize, 'footer_copytext', 'footer_area', 'Footer Copyright Text:');

$wp_customize->add_setting(
    'footer_area_copyrighttext',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Copyright by <span>© Perfect Ecommerce</span>. All Rights Reserved', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'footer_area_copyrighttext',
    array(
        'settings'      => 'footer_area_copyrighttext',
        'section'       => 'footer_area',
        'type'          => 'textarea',
        'label'         => __( 'Footer Copyright Text', 'Luzuk Premium' )
    )
);


//theme Footer title Color
addColorPalatOption($wp_customize, 'footerarea_title_color', 'footer_area', 'Footer Title & Number Color', '#fff');
addColorPalatOption($wp_customize, 'footerarea_titleborder_color', 'footer_area', 'Footer Title Border Color', '#242424');
addColorPalatOption($wp_customize, 'footerarea_text_color', 'footer_area', 'Footer Text Color', '#7d8b98');
addColorPalatOption($wp_customize, 'footerarea_hglightsctext_color', 'footer_area', 'Footer Hightlight Text Color', '#0d61cc');
addColorPalatOption($wp_customize, 'footerarea_icon_color', 'footer_area', 'Footer Icon Color', '#f0f0f0');
addColorPalatOption($wp_customize, 'footerarea_sicon_color', 'footer_area', 'Footer Social Icon Color', '#81868c');
addColorPalatOption($wp_customize, 'footerarea_siconhover_color', 'footer_area', 'Footer Social Icon Hover Color', '#145ab8');

addColorPalatOption($wp_customize, 'footerarea_menu_color', 'footer_area', 'Footer Menu Color', '#7d8b98');
addColorPalatOption($wp_customize, 'footerarea_menuhover_color', 'footer_area', 'Footer Menu Hover Color', '#145ab8');
addColorPalatOption($wp_customize, 'footerarea_activemenu_color', 'footer_area', 'Active Menu Color', '#145ab8');

addColorPalatOption($wp_customize, 'footerarea_datext_color', 'footer_area', 'Date Text Color', '#145ab8');
addColorPalatOption($wp_customize, 'footerarea_tableborder_color', 'footer_area', 'Border Color', '#1e1e1e');

addColorPalatOption($wp_customize, 'footerarea_formtextlabel_color', 'footer_area', 'Label Color', '#fff');
addColorPalatOption($wp_customize, 'footerarea_formtext_color', 'footer_area', 'Form Text & Placeholder Text Color', '#b2b2b2');

addColorPalatOption($wp_customize, 'footerarea_formbuttontext_color', 'footer_area', 'Button Text Color', '#fff');

$wp_customize->add_setting(
    'footerareabutton_bg_color', array(
        'default'           => '#0d61cc',
        'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'footerareabutton_bg_color',array(
            'settings'      => 'footerareabutton_bg_color',
            'section'       => 'footer_area',
            'label'         => __( 'Button Background Color', 'Luzuk Premium' ),
        )
    )
);
$wp_customize->add_setting(
    'footerareabutton_bg_Hovercolor', array(
        'default'           => '#ff0c12',
        'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'footerareabutton_bg_Hovercolor',array(
            'settings'      => 'footerareabutton_bg_Hovercolor',
            'section'       => 'footer_area',
            'label'         => __( 'Button Background Hover Color', 'Luzuk Premium' ),
        )
    )
);

addColorPalatOption($wp_customize, 'footerarea_otherfbgs_color', 'footer_area', 'Other Fields Background Color', '#eeeeee');

addColorPalatOption($wp_customize, 'footerarea_bottomareatext_color', 'footer_area', 'Bottom Area Text Color', '#fff');
addColorPalatOption($wp_customize, 'footerarea_bottomareatexthighlight_color', 'footer_area', 'Bottom Area Text Highlight Color', '#145ab8');

//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
	'luzuk_shopsidebar_settings',
	array(
		'title' => __( 'Shop Page Sidebar Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);


// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'luzuk_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Sidebar', 'hide' => 'Hide Sidebar', ), ) ); 
// end to show & hide button

$wp_customize->add_section(
	'luzuk_innerpageshortcode_page_settings',
	array(
		'title' => __( 'Color Setting For Shortcode Pages', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);
lzCustomLable($wp_customize, 'luzuk_teaminnerpagepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Team Shortcode Page Colors:');

lzCustomLable($wp_customize, 'luzuk_teampagelable', 'luzuk_innerpageshortcode_page_settings', 'Note: Set team member images of equal height.');

addColorPalatOption($wp_customize, 'pages_innerTeamNameCColor', 'luzuk_innerpageshortcode_page_settings', 'Select team member color', '#fff');

addColorPalatOption($wp_customize, 'pages_innerTeamDesignationCColor', 'luzuk_innerpageshortcode_page_settings', 'Select team designation color', '#fff');

addColorPalatOption($wp_customize, 'pages_innerTeamsocialsColor', 'luzuk_innerpageshortcode_page_settings', 'Select team Socials color', '#ff0c12');
addColorPalatOption($wp_customize, 'pages_innerTeamsocialshvrsColor', 'luzuk_innerpageshortcode_page_settings', 'Select team Socials Hover color', '#fff');

addColorPalatOption($wp_customize, 'pages_innerTeamsocialsbgColor', 'luzuk_innerpageshortcode_page_settings', 'Select team Socials Background color', '#fff');
addColorPalatOption($wp_customize, 'pages_innerTeamsocialsbghvrsColor', 'luzuk_innerpageshortcode_page_settings', 'Select team Socials Background Hover color', '#ff0c12');

addColorPalatOption($wp_customize, 'pages_innerTeamcontentboxbgColor', 'luzuk_innerpageshortcode_page_settings', 'Select team Content Box Background color', '#0d61cc');
addColorPalatOption($wp_customize, 'pages_innerTeamsocialboxbgColor', 'luzuk_innerpageshortcode_page_settings', 'Select team Social Box Background color', '#ff0c12');

lzCustomLable($wp_customize, 'luzuk_testimonialinnerpagepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Testimonial Shortcode Page Colors:');
 
addColorPalatOption($wp_customize, 'luzuk_innertestimonials_textcolor', 'luzuk_innerpageshortcode_page_settings', 'Select Testimonial Content Color', '#000');
addColorPalatOption($wp_customize, 'luzuk_innertestimonials_imgbordercolor', 'luzuk_innerpageshortcode_page_settings', 'Select Client Image Border Color', '#fff');
addColorPalatOption($wp_customize, 'luzuk_innertestimonials_Namecolor', 'luzuk_innerpageshortcode_page_settings', 'Select Client Name Color', '#fff');
addColorPalatOption($wp_customize, 'luzuk_innertestimonials_Namehovercolor', 'luzuk_innerpageshortcode_page_settings', 'Select Client Name Hover Color', '#000');
 addColorPalatOption($wp_customize, 'luzuk_innertestimonials_boxcolor', 'luzuk_innerpageshortcode_page_settings', 'Select Box Color', '#0d61cc');
  addColorPalatOption($wp_customize, 'luzuk_innertestimonials_boxbordercolor', 'luzuk_innerpageshortcode_page_settings', 'Select Box Border Color', '#000');
  
lzCustomLable($wp_customize, 'luzuk_faqinnerpagepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Faq Shortcode Page Colors:');
 addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetitleIconColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Question Icon Color', '#ffffff');
 addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetitleIconbgColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Question Icon Background Color', '#0d61cc');
 addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetitleIconborderColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Question Icon Border Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetitleColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Question Text Color', '#fff');
addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetitleboxbgColor', 'luzuk_innerpageshortcode_page_settings', 'Select Question Box Background Color', '#0d61cc');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetextcColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Answer Text Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpageatextborderColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Answer Border Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpageatextbgcColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Answer Background Color', '#4a090b');

$wp_customize->add_section(
	'luzuk_innerpagefont_settings',
	array(
		'title' => __( 'Inner Page Settings', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'luzuk_innerpage_titlepaddset', 'luzuk_innerpagefont_settings', ' Set Header Title Box Padding:');


$wp_customize->add_setting(
    'inner_headertitleboxTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'inner_headertitleboxTpadding',
    array(
        'settings'      => 'inner_headertitleboxTpadding',
        'section'       => 'luzuk_innerpagefont_settings',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'inner_headertitleboxBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4.5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'inner_headertitleboxBpadding',
    array(
        'settings'      => 'inner_headertitleboxBpadding',
        'section'       => 'luzuk_innerpagefont_settings',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);



lzCustomLable($wp_customize, 'luzuk_innerpageh1_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 1:');


$wp_customize->add_setting(
	'pages_innerpageheading',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '35px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading',
	array(
		'settings'      => 'pages_innerpageheading',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 1 Font Size', 'luzuk-premium' )
	)
);


lzCustomLable($wp_customize, 'luzuk_innerpageh2_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 2:');


$wp_customize->add_setting(
	'pages_innerpageheading2',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '24px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading2',
	array(
		'settings'      => 'pages_innerpageheading2',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 2 Font Size', 'luzuk-premium' )
	)
);
 

lzCustomLable($wp_customize, 'luzuk_innerpageh3_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 3:');


$wp_customize->add_setting(
	'pages_innerpageheading3',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '20px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading3',
	array(
		'settings'      => 'pages_innerpageheading3',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 3 Font Size', 'luzuk-premium' )
	)
);

lzCustomLable($wp_customize, 'luzuk_innerpageh4_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 4:');


$wp_customize->add_setting(
	'pages_innerpageheading4',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '18px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading4',
	array(
		'settings'      => 'pages_innerpageheading4',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 4 Font Size', 'luzuk-premium' )
	)
);

lzCustomLable($wp_customize, 'luzuk_innerpageh5_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 5:');


$wp_customize->add_setting(
	'pages_innerpageheading5',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '17px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading5',
	array(
		'settings'      => 'pages_innerpageheading5',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 5 Font Size', 'luzuk-premium' )
	)
);

lzCustomLable($wp_customize, 'luzuk_innerpageh6_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 6:');


$wp_customize->add_setting(
	'pages_innerpageheading6',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '16px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading6',
	array(
		'settings'      => 'pages_innerpageheading6',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 6 Font Size', 'luzuk-premium' )
	)
);