<?php 
    $wp_customize->add_section(
        'popularcat_area',
        array(
            'title' => __( 'Popular Categories', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );

lzCustomLable($wp_customize, 'header_popularcatsettings', 'popularcat_area', 'Popular Category Setting');
$wp_customize->add_setting(
        'luzuk_popular_cattitle',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Popular Categories', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'luzuk_popular_cattitle',
        array(
            'settings'      => 'luzuk_popular_cattitle',
            'section'       => 'popularcat_area',
            'type'          => 'text',
            'label'         => __( 'Popular Category Label', 'luzuk-premium' )
        )
    );

$cats = array();
$args =array(
    'taxonomy'=>'product_cat',
    'hide_empty' => false,
);

$results= get_terms($args);
$i = 0;
foreach($results as $cat){
    
    $cats[$cat->slug] =  $cat-> name ;
    if($i==0){
        $default = 'Uncategorized';
        $i++;
    }
}
for ( $count = 1; $count <= 10; $count++ ) {

    $wp_customize->add_setting('slider_product_category'. $count, array(
        'default'        => $default,
        'sanitize_callback' => 'luzuk_sanitize_text'
    ));

    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'slider_product_category'. $count, array(
        'label' => 'Select Product Categories',
        'section' => 'popularcat_area',
        'settings' => 'slider_product_category'. $count,
        'type'    => 'select',
        'choices' => $cats
    )));
}

addColorPalatOption($wp_customize, 'slider_procatborderColor', 'popularcat_area', ' Popular Category Box border color', '#e6e6e6');

addColorPalatOption($wp_customize, 'slider_procatlabelColor', 'popularcat_area', ' Popular Category Label color', '#fff');
addColorPalatOption($wp_customize, 'slider_procatlabelbgColor', 'popularcat_area', 'Popular Category Label background color', '#0d60cc');

addColorPalatOption($wp_customize, 'slider_procatboxColor', 'popularcat_area', 'Popular Category Box color', '#fff');
addColorPalatOption($wp_customize, 'slider_procatColor', 'popularcat_area', 'Popular Category  & Icon color', '#7c8396');
addColorPalatOption($wp_customize, 'slider_procathoverColor', 'popularcat_area', 'Popular Category & Icon Hover color', '#0d61cc');
