<?php 
    $wp_customize->add_section(
        'productblock1_area',
        array(
            'title' => __( 'Product Block One', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'problock1_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    ); 
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'problock1_area_disable',
            array(
                'settings'      => 'problock1_area_disable',
                'section'       => 'productblock1_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'productblock1', 'productblock1_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'aboutarea_padding', 'productblock1_area', 'Set Section Padding:');

$wp_customize->add_setting(
    'problock1_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'problock1_areaTpadding',
    array(
        'settings'      => 'problock1_areaTpadding',
        'section'       => 'productblock1_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'problock1_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'problock1_areaBpadding',
    array(
        'settings'      => 'problock1_areaBpadding',
        'section'       => 'productblock1_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'probanner1_padding', 'productblock1_area', 'Banner One Setting:');

backgroundManager($wp_customize, 'pro_b_img', 'productblock1_area', $color='#fff', get_template_directory_uri().'/images/banner-headp.jpg', 'colors');

    $wp_customize->add_setting(
        'pro_b_title',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Adjustable Noise Cancelling', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'pro_b_title',
        array(
            'settings'      => 'pro_b_title',
            'section'       => 'productblock1_area',
            'type'          => 'text',
            'label'         => __( 'Banner Title', 'luzuk-premium' )
        )
    );
addColorPalatOption($wp_customize, 'productblock1_area_banner1title', 'productblock1_area', 'Banner One Title color', '#000');

     $wp_customize->add_setting(
        'pro_b_text',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'WIRELESS HEADPHONES', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'pro_b_text',
        array(
            'settings'      => 'pro_b_text',
            'section'       => 'productblock1_area',
            'type'          => 'text',
            'label'         => __( 'Banner Sub Title', 'luzuk-premium' )
        )
    );
addColorPalatOption($wp_customize, 'productblock1_area_banner1text', 'productblock1_area', 'Banner One Sub Title color', '#0d61cc');
addColorPalatOption($wp_customize, 'productblock1_area_banner1texthover', 'productblock1_area', 'Banner One Sub Title Hover color', '#ff0c12');

 for( $i = 1; $i <2; $i++ ){

    $wp_customize->add_setting(
        'pro_b_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'pro_b_header'.$i,
            array(
                'settings'      => 'pro_b_header'.$i,
                'section'       => 'productblock1_area',
                'label'         => __( 'Image '.$i, 'luzuk-premium' )
            )
        )
    );

    lzAddImageElement($wp_customize, 'pro_b_image'.$i, 'productblock1_area', $label="Recommended Image Size: 500X500px");
    lzAddElement($wp_customize, 'pro_b_url_'.$i, 'productblock1_area', $type = 'text', $label="Image Link", $callback ='esc_url', $default='Add link here');

}

lzCustomLable($wp_customize, 'probanner2_padding', 'productblock1_area', 'Banner Two Setting:');

backgroundManager($wp_customize, 'probox1', 'productblock1_area', $color='#eaeaea', get_template_directory_uri().'/images/default-gray.png', 'img');

for( $i = 1; $i <2; $i++ ){

    $wp_customize->add_setting(
        'probox1_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'probox1_header'.$i,
            array(
                'settings'      => 'probox1_header'.$i,
                'section'       => 'productblock1_area',
                'label'         => __( 'Product Image '.$i, 'luzuk-premium' )
            )
        )
    );

    lzAddImageElement($wp_customize, 'probox1_image'.$i, 'productblock1_area', $label="Recommended Image Size: 500X500px");
    lzAddElement($wp_customize, 'probox1_url_'.$i, 'productblock1_area', $type = 'text', $label="Image Link", $callback ='esc_url', $default='Add link here');

}

    $wp_customize->add_setting(
        'pro_box1_title',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'CC CAMERA', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'pro_box1_title',
        array(
            'settings'      => 'pro_box1_title',
            'section'       => 'productblock1_area',
            'type'          => 'text',
            'label'         => __( 'Banner Title', 'luzuk-premium' )
        )
    );

     $wp_customize->add_setting(
        'probox_text',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'JVS-H510-Plus 1.3MP Wi-Fi Cloudsee.', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'probox_text',
        array(
            'settings'      => 'probox_text',
            'section'       => 'productblock1_area',
            'type'          => 'textarea',
            'label'         => __( 'Banner Sub Title', 'luzuk-premium' )
        )
    );

    $wp_customize->add_setting(
        'probox_price',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'From: <span>$99.00</span>', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'probox_price',
        array(
            'settings'      => 'probox_price',
            'section'       => 'productblock1_area',
            'type'          => 'text',
            'label'         => __( 'Banner Price & Text', 'luzuk-premium' )
        )
    );

lzCustomLable($wp_customize, 'probanner3_padding', 'productblock1_area', 'Banner Three Setting:');

backgroundManager($wp_customize, 'probox2', 'productblock1_area', $color='#eaeaea', get_template_directory_uri().'/images/default-gray.png', 'img');

 for( $i = 1; $i <2; $i++ ){

    $wp_customize->add_setting(
        'probox2_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'probox2_header'.$i,
            array(
                'settings'      => 'probox2_header'.$i,
                'section'       => 'productblock1_area',
                'label'         => __( 'Product Image '.$i, 'luzuk-premium' )
            )
        )
    );

    lzAddImageElement($wp_customize, 'probox2_image'.$i, 'productblock1_area', $label="Recommended Image Size: 500X500px");
    lzAddElement($wp_customize, 'probox2_url_'.$i, 'productblock1_area', $type = 'text', $label="Image Link", $callback ='esc_url', $default='Add link here');

}


    $wp_customize->add_setting(
        'pro_box2_title',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'CLOCK-RADIO', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'pro_box2_title',
        array(
            'settings'      => 'pro_box2_title',
            'section'       => 'productblock1_area',
            'type'          => 'text',
            'label'         => __( 'Banner Title', 'luzuk-premium' )
        )
    );

     $wp_customize->add_setting(
        'probox2_text',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'FM/AM Alarm Clock ICF-C1 configuration, set alarm, time.', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'probox2_text',
        array(
            'settings'      => 'probox2_text',
            'section'       => 'productblock1_area',
            'type'          => 'textarea',
            'label'         => __( 'Banner Sub Title', 'luzuk-premium' )
        )
    );

    
lzCustomLable($wp_customize, 'probanner_seccolor', 'productblock1_area', 'Banner Two Three Colors Setting:');
    
    addColorPalatOption($wp_customize, 'productblock1_area_banner2title', 'productblock1_area', 'Banner Title color', '#060606');
    addColorPalatOption($wp_customize, 'productblock1_area_banner2titlehover', 'productblock1_area', 'Banner Title Hover color', '#0d61cc');

    addColorPalatOption($wp_customize, 'productblock1_area_banner2textptext', 'productblock1_area', 'Banner Text color', '#848b93');
    addColorPalatOption($wp_customize, 'productblock1_area_banner2textpriceb', 'productblock1_area', 'Banner Price color', '#0d61cc');
    addColorPalatOption($wp_customize, 'productblock1_area_banner2textpricehover', 'productblock1_area', 'Banner Price Hover color', '#ff0c12');


lzCustomLable($wp_customize, 'prosupport_padding', 'productblock1_area', 'Support Setting:');

$wp_customize->add_setting('pro_b_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'pro_b_npp_heading',
        array(
            'settings'      => 'pro_b_npp_heading',
            'section'       => 'productblock1_area',
            'label'         => __( 'Number Of Support', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('pro_b_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 2));
$wp_customize->add_control(
    'pro_b_npp_count',
    array(
        'settings'      => 'pro_b_npp_count',
        'section'       => 'productblock1_area',
        'type'          => 'select',
        'label'         => __( 'Number of support to show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6)
    )
);

//ABOUT PAGES
for( $i = 1; $i <=6; $i++ ){
    $wp_customize->add_setting(
        'pro_b_page'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'pro_b_page'.$i,
            array(
                'settings'      => 'pro_b_page'.$i,
                'section'       => 'productblock1_area',
                'label'         => __( 'Support Page ', 'luzuk-premium' ).$i
            )
        )
    );

     $wp_customize->add_setting(
        'pro_b_page_icon'.$i,
        array(
            'default'           => 'fa fa-car',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'pro_b_page_icon'.$i,
            array(
                'settings'      => 'pro_b_page_icon'.$i,
                'section'       => 'productblock1_area',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'luzuk-premium' ),
            )
        )
    );

lzAddElement($wp_customize, 'pro_b_page_title'.$i, 'productblock1_area', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='Free Shipping.');

lzAddElement($wp_customize, 'pro_b_page_description'.$i, 'productblock1_area', $type = 'textarea', $label="Description", $callback ='luzuk_sanitize_text', $default='Mauris quis fringilla dui.');
    
}
addColorPalatOption($wp_customize, 'productblock1_area_pageicon', 'productblock1_area', 'Icon color', '#7a8996');
addColorPalatOption($wp_customize, 'productblock1_area_pageiconhover', 'productblock1_area', 'Icon hover color', '#ff0c12');
addColorPalatOption($wp_customize, 'productblock1_area_pagetitle', 'productblock1_area', 'Title color', '#000');
addColorPalatOption($wp_customize, 'productblock1_area_pagetitlehover', 'productblock1_area', 'Title hover color', '#0d61cc');

addColorPalatOption($wp_customize, 'productblock1_area_pagetext', 'productblock1_area', 'Text color', '#7f878a');

addColorPalatOption($wp_customize, 'productblock1_area_pageborder', 'productblock1_area', 'Border color', '#ebebeb');


lzCustomLable($wp_customize, 'profeatureproduct_sec', 'productblock1_area', 'Featured Product Setting:');


 $wp_customize->add_setting(
    'featureproduct_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'featureproduct_title_heading',
        array(
            'settings'      => 'featureproduct_title_heading',
            'section'       => 'productblock1_area',
            'label'         => __( 'Featured Product Title', 'Luzuk Premium' ),
        )
    )
);    
$wp_customize->add_setting(
    'featuredpro_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'FEATURED PRODUCTS', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'featuredpro_title',
    array(
        'settings'      => 'featuredpro_title',
        'section'       => 'productblock1_area',
        'type'          => 'text',
        'label'         => __( 'Title', 'Luzuk Premium' )
    )
);

lzCustomLable($wp_customize, 'problock2featu_padding', 'productblock1_area', 'Set Featured Product Slider Height:');

$wp_customize->add_setting(
    'problock1_featuredprosliderHeight',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '360px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'problock1_featuredprosliderHeight',
    array(
        'settings'      => 'problock1_featuredprosliderHeight',
        'section'       => 'productblock1_area',
        'type'          => 'text',
        'label'         => __( ' Slider Height', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'productblock1_area_featuredprotitle', 'productblock1_area', 'Featured Product Title color', '#000');
addColorPalatOption($wp_customize, 'productblock1_area_featuredprotitleborder', 'productblock1_area', 'Featured Product Title Border color', '#eaeaea');
addColorPalatOption($wp_customize, 'productblock1_area_featuredprosliderarrow', 'productblock1_area', 'Featured Product Slider Arrow color', '#9fa2a5');
addColorPalatOption($wp_customize, 'productblock1_area_featuredprosliderarrowhover', 'productblock1_area', 'Featured Product Slider Arrow Hover color', '#0d61cc');
addColorPalatOption($wp_customize, 'productblock1_area_featuredprosliderborder', 'productblock1_area', 'Featured Product Slider Border color', '#eaeaea');
addColorPalatOption($wp_customize, 'productblock1_area_featuredproimhhoverborder', 'productblock1_area', 'Featured Product Image Hover Border color', '#eaeaea');
addColorPalatOption($wp_customize, 'productblock1_area_featuredproimhhovericon', 'productblock1_area', 'Featured Product Image Hover Icon color', '#cfd0d5');
addColorPalatOption($wp_customize, 'productblock1_area_featuredproimhhovericonbg', 'productblock1_area', 'Featured Product Image Hover Icon Background color', '#fff');
addColorPalatOption($wp_customize, 'productblock1_area_featuredproimhhovericonhover', 'productblock1_area', 'Featured Product Image Hover Icon Hover color', '#0d61cc');

addColorPalatOption($wp_customize, 'productblock1_area_featuredprocat', 'productblock1_area', 'Featured Product Category color', '#0d61cc');
addColorPalatOption($wp_customize, 'productblock1_area_featuredprocathover', 'productblock1_area', 'Featured Product Category Hover color', '#ff0c12');
addColorPalatOption($wp_customize, 'productblock1_area_featuredproname', 'productblock1_area', 'Featured Product Name color', '#000');
addColorPalatOption($wp_customize, 'productblock1_area_featuredpronamehover', 'productblock1_area', 'Featured Product Name Hover color', '#0d61cc');

addColorPalatOption($wp_customize, 'productblock1_area_featuredproprice', 'productblock1_area', 'Featured Product Price color', '#7c8491');
addColorPalatOption($wp_customize, 'productblock1_area_featuredpropricecboprder', 'productblock1_area', 'Featured Product Price Cut Border color', '#ccd0d3');
addColorPalatOption($wp_customize, 'productblock1_area_featuredprosellingprice', 'productblock1_area', 'Featured Product Selling Price color', '#868b9e');
