<?php 
    $wp_customize->add_section(
        'productblock2_area',
        array(
            'title' => __( 'Product Block Two', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'problock2_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'problock2_area_disable',
            array(
                'settings'      => 'problock2_area_disable',
                'section'       => 'productblock2_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'productblock2', 'productblock2_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'problock2area_padding', 'productblock2_area', 'Set Section Padding:');

$wp_customize->add_setting(
    'problock2_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'problock2_areaTpadding',
    array(
        'settings'      => 'problock2_areaTpadding',
        'section'       => 'productblock2_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'problock2_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'problock2_areaBpadding',
    array(
        'settings'      => 'problock2_areaBpadding',
        'section'       => 'productblock2_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'procat_setting', 'productblock2_area', 'Top Category Product Setting:');


$choices = getWooCategories($isObject = false, $id=0, $isParents = 0);

// print_r($choices);

lzCheckBoxElement($wp_customize, 'topcatproduct_categories', 'productblock2_area', $choices, $default=0, $label=__('Please select the Categories to show Product', 'luzuk-premium'));
$wp_customize->add_setting(
    'catproduct_protopcat_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'catproduct_protopcat_title',
        array(
            'settings'      => 'catproduct_protopcat_title',
            'section'       => 'productblock2_area',
            'label'         => __( 'Section Label', 'luzuk-premium' ),
        )
    )
);   
$wp_customize->add_setting(
    'protopcat_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'TOP CATEGORY PRODUCT', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'protopcat_title',
    array(
        'settings'      => 'protopcat_title',
        'section'       => 'productblock2_area',
        'type'          => 'text',
        'label'         => __( 'Label', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'productblock2_area_protopcattitle', 'productblock2_area', 'Featured Product Title color', '#000');
addColorPalatOption($wp_customize, 'productblock2_area_protopcattitleborder', 'productblock2_area', 'Featured Product Title Border color', '#eaeaea');

addColorPalatOption($wp_customize, 'productblock2_area_protopcatboxborder', 'productblock2_area', 'Category Product Box Border color', '#eaeaea');

addColorPalatOption($wp_customize, 'productblock2_area_protopcatimhhovericon', 'productblock2_area', 'Category Product Image Hover Icon color', '#0d61cc');
addColorPalatOption($wp_customize, 'productblock2_area_protopcatimhhovericonbg', 'productblock2_area', 'Category Product Image Hover Icon Background color', '#fff');
addColorPalatOption($wp_customize, 'productblock2_area_protopcatimhhovericonhover', 'productblock2_area', 'Category Product Image Hover Icon Hover color', '#fff');
addColorPalatOption($wp_customize, 'productblock2_area_protopcatimhhovericonhoverbg', 'productblock2_area', 'Category Product Image Hover Icon Hover Background color', '#ff0c12');
addColorPalatOption($wp_customize, 'productblock2_area_protopcatcat', 'productblock2_area', 'Category Product Category color', '#0d61cc');
addColorPalatOption($wp_customize, 'productblock2_area_protopcatcathover', 'productblock2_area', 'Category Product Category Hover color', '#ff0c12');

addColorPalatOption($wp_customize, 'productblock2_area_protopcatname', 'productblock2_area', 'Category Product Name color', '#000');
addColorPalatOption($wp_customize, 'productblock2_area_protopcatnamehover', 'productblock2_area', 'Category Product Name Hover color', '#0d61cc');
addColorPalatOption($wp_customize, 'productblock2_area_protopcatprice', 'productblock2_area', 'Category Product Price color', '#7c8491');
addColorPalatOption($wp_customize, 'productblock2_area_protopcatpricecboprder', 'productblock2_area', 'Category Product Price Cut Border color', '#ccd0d3');
addColorPalatOption($wp_customize, 'productblock2_area_protopcatsellingprice', 'productblock2_area', 'Category Product Selling Price color', '#868b9e');

lzCustomLable($wp_customize, 'procatblock2a_setting', 'productblock2_area', 'Banner One Setting:');

backgroundManager($wp_customize, 'proboxblock21', 'productblock2_area', $color='#eaeaea', get_template_directory_uri().'/images/default-gray.png', 'img');

 for( $i = 1; $i <2; $i++ ){

    $wp_customize->add_setting(
        'proboxblock21_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'proboxblock21_header'.$i,
            array(
                'settings'      => 'proboxblock21_header'.$i,
                'section'       => 'productblock2_area',
                'label'         => __( 'Product Image '.$i, 'luzuk-premium' )
            )
        )
    );

    lzAddImageElement($wp_customize, 'proboxblock21_image'.$i, 'productblock2_area', $label="Recommended Image Size: 500X500px");
    lzAddElement($wp_customize, 'proboxblock21_url_'.$i, 'productblock2_area', $type = 'text', $label="Image Link", $callback ='esc_url', $default='Add link here');

}

      $wp_customize->add_setting(
        'problock2_box1_sell',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Sell', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'problock2_box1_sell',
        array(
            'settings'      => 'problock2_box1_sell',
            'section'       => 'productblock2_area',
            'type'          => 'text',
            'label'         => __( 'Sell', 'luzuk-premium' )
        )
    );

    $wp_customize->add_setting(
        'problock2_box1_title',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'New Fashion 2020', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'problock2_box1_title',
        array(
            'settings'      => 'problock2_box1_title',
            'section'       => 'productblock2_area',
            'type'          => 'text',
            'label'         => __( 'Banner Title', 'luzuk-premium' )
        )
    );

    $wp_customize->add_setting(
        'problock2_box1_offert',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Get Extra<span>30% OFF</span>', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'problock2_box1_offert',
        array(
            'settings'      => 'problock2_box1_offert',
            'section'       => 'productblock2_area',
            'type'          => 'text',
            'label'         => __( 'Offer', 'luzuk-premium' )
        )
    );


     $wp_customize->add_setting(
        'problock2_box1_price',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'From: <span>$99.00</span>', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'problock2_box1_price',
        array(
            'settings'      => 'problock2_box1_price',
            'section'       => 'productblock2_area',
            'type'          => 'text',
            'label'         => __( 'Price', 'luzuk-premium' )
        )
    );

lzCustomLable($wp_customize, 'probanner3_padding', 'productblock2_area', 'Banner Two Setting:');

backgroundManager($wp_customize, 'proboxblock22', 'productblock2_area', $color='#eaeaea', get_template_directory_uri().'/images/default-gray.png', 'img');


 for( $i = 1; $i <2; $i++ ){

    $wp_customize->add_setting(
        'proboxblock22_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'proboxblock22_header'.$i,
            array(
                'settings'      => 'proboxblock22_header'.$i,
                'section'       => 'productblock2_area',
                'label'         => __( 'Product Image '.$i, 'luzuk-premium' )
            )
        )
    );

    lzAddImageElement($wp_customize, 'proboxblock22_image'.$i, 'productblock2_area', $label="Recommended Image Size: 500X500px");
    lzAddElement($wp_customize, 'proboxblock22_url_'.$i, 'productblock2_area', $type = 'text', $label="Image Link", $callback ='esc_url', $default='Add link here');

}

      $wp_customize->add_setting(
        'problock2_box2_sell',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Available Now', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'problock2_box2_sell',
        array(
            'settings'      => 'problock2_box2_sell',
            'section'       => 'productblock2_area',
            'type'          => 'text',
            'label'         => __( 'Sell', 'luzuk-premium' )
        )
    );

    $wp_customize->add_setting(
        'problock2_box2_title',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'iPhone Pro 9+ Black Headphone', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'problock2_box2_title',
        array(
            'settings'      => 'problock2_box2_title',
            'section'       => 'productblock2_area',
            'type'          => 'text',
            'label'         => __( 'Banner Title', 'luzuk-premium' )
        )
    );

     $wp_customize->add_setting(
        'problock2_box2_price',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Intro Price: <span>$190.00</span>', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'problock2_box2_price',
        array(
            'settings'      => 'problock2_box2_price',
            'section'       => 'productblock2_area',
            'type'          => 'text',
            'label'         => __( 'Price', 'luzuk-premium' )
        )
    );
    
lzCustomLable($wp_customize, 'probanner_seccolor', 'productblock2_area', 'Banner One Two Colors Setting:');
    addColorPalatOption($wp_customize, 'productblock2_area_banner1sale', 'productblock2_area', 'Banner One Sale color', '#fff');
    addColorPalatOption($wp_customize, 'productblock2_area_banner1salebg', 'productblock2_area', 'Banner One Background Sale color', '#49cb59');
        addColorPalatOption($wp_customize, 'productblock2_area_banner1sale2', 'productblock2_area', 'Banner Two Sale color', '#0f65d7');
    addColorPalatOption($wp_customize, 'productblock2_area_banner2title', 'productblock2_area', 'Banner Title color', '#060606');
    addColorPalatOption($wp_customize, 'productblock2_area_banner2textptext', 'productblock2_area', 'Banner Text color', '#848b93');
      addColorPalatOption($wp_customize, 'productblock2_area_banner2textOtxt', 'productblock2_area', 'Banner Offer color', '#ff1b01');
    addColorPalatOption($wp_customize, 'productblock2_area_banner2textprice', 'productblock2_area', 'Banner One Price color', '#000');
    addColorPalatOption($wp_customize, 'productblock2_area_banner2textprice2', 'productblock2_area', 'Banner Two Price color', '#0d5dcc');

lzCustomLable($wp_customize, 'profeatureproduct_sec', 'productblock2_area', 'Recent Product Setting:');


 $wp_customize->add_setting(
    'recentpro_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'recentpro_title_heading',
        array(
            'settings'      => 'recentpro_title_heading',
            'section'       => 'productblock2_area',
            'label'         => __( 'Recent Product Title', 'Luzuk Premium' ),
        )
    )
);    
$wp_customize->add_setting(
    'recentpro_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'RECENT PRODUCTS', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'recentpro_title',
    array(
        'settings'      => 'recentpro_title',
        'section'       => 'productblock2_area',
        'type'          => 'text',
        'label'         => __( 'Title', 'Luzuk Premium' )
    )
);


lzCustomLable($wp_customize, 'problock2recearea_padding', 'productblock2_area', 'Set Recent Product Slider Height:');

$wp_customize->add_setting(
    'problock2_recentprosliderHeight',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '360px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'problock2_recentprosliderHeight',
    array(
        'settings'      => 'problock2_recentprosliderHeight',
        'section'       => 'productblock2_area',
        'type'          => 'text',
        'label'         => __( ' Slider Height', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'productblock2_area_Recentprotitle', 'productblock2_area', 'Recent Product Title color', '#000');
addColorPalatOption($wp_customize, 'productblock2_area_Recentprotitleborder', 'productblock2_area', 'Recent Product Title Border color', '#eaeaea');
addColorPalatOption($wp_customize, 'productblock2_area_Recentprosliderarrow', 'productblock2_area', 'Recent Product Slider Arrow color', '#9fa2a5');
addColorPalatOption($wp_customize, 'productblock2_area_Recentprosliderarrowhover', 'productblock2_area', 'Recent Product Slider Arrow Hover color', '#0d61cc');
addColorPalatOption($wp_customize, 'productblock2_area_Recentprosliderborder', 'productblock2_area', 'Recent Product Slider Border color', '#eaeaea');
addColorPalatOption($wp_customize, 'productblock2_area_Recentproimhhoverborder', 'productblock2_area', 'Recent Product Image Hover Border color', '#eaeaea');
addColorPalatOption($wp_customize, 'productblock2_area_Recentproimhhovericon', 'productblock2_area', 'Recent Product Image Hover Icon color', '#cfd0d5');
addColorPalatOption($wp_customize, 'productblock2_area_Recentproimhhovericonbg', 'productblock2_area', 'Recent Product Image Hover Icon Background color', '#fff');
addColorPalatOption($wp_customize, 'productblock2_area_Recentproimhhovericonhover', 'productblock2_area', 'Recent Product Image Hover Icon color', '#0d61cc');

addColorPalatOption($wp_customize, 'productblock2_area_Recentprocat', 'productblock2_area', 'Recent Product Category color', '#0d61cc');
addColorPalatOption($wp_customize, 'productblock2_area_Recentprocathover', 'productblock2_area', 'Recent Product Category Hover color', '#ff0c12');
addColorPalatOption($wp_customize, 'productblock2_area_Recentproname', 'productblock2_area', 'Recent Product Name color', '#000');
addColorPalatOption($wp_customize, 'productblock2_area_Recentpronamehover', 'productblock2_area', 'Recent Product Name Hover color', '#0d61cc');

addColorPalatOption($wp_customize, 'productblock2_area_Recentproprice', 'productblock2_area', 'Recent Product Price color', '#7c8491');
addColorPalatOption($wp_customize, 'productblock2_area_Recentpropricecboprder', 'productblock2_area', 'Recent Product Price Cut Border color', '#ccd0d3');
addColorPalatOption($wp_customize, 'productblock2_area_Recentprosellingprice', 'productblock2_area', 'Recent Product Selling Price color', '#868b9e');


lzCustomLable($wp_customize, 'propopularproduct_sec', 'productblock2_area', 'Popular Product Setting:');


 $wp_customize->add_setting(
    'popularpro_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'popularpro_title_heading',
        array(
            'settings'      => 'popularpro_title_heading',
            'section'       => 'productblock2_area',
            'label'         => __( 'Popular Product Title', 'Luzuk Premium' ),
        )
    )
);    
$wp_customize->add_setting(
    'popularpro_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'popular PRODUCTS', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'popularpro_title',
    array(
        'settings'      => 'popularpro_title',
        'section'       => 'productblock2_area',
        'type'          => 'text',
        'label'         => __( 'Title', 'Luzuk Premium' )
    )
);


lzCustomLable($wp_customize, 'problock2recearea_padding', 'productblock2_area', 'Set popular Product Slider Height:');

$wp_customize->add_setting(
    'problock2_popularprosliderHeight',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '360px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'problock2_popularprosliderHeight',
    array(
        'settings'      => 'problock2_popularprosliderHeight',
        'section'       => 'productblock2_area',
        'type'          => 'text',
        'label'         => __( ' Slider Height', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'productblock2_area_Popularprotitle', 'productblock2_area', 'Popular Product Title color', '#000');
addColorPalatOption($wp_customize, 'productblock2_area_Popularprotitleborder', 'productblock2_area', 'Popular Product Title Border color', '#eaeaea');
addColorPalatOption($wp_customize, 'productblock2_area_Popularprosliderarrow', 'productblock2_area', 'Popular Product Slider Arrow color', '#9fa2a5');
addColorPalatOption($wp_customize, 'productblock2_area_Popularprosliderarrowhover', 'productblock2_area', 'Popular Product Slider Arrow Hover color', '#0d61cc');
addColorPalatOption($wp_customize, 'productblock2_area_Popularprosliderborder', 'productblock2_area', 'Popular Product Slider Border color', '#eaeaea');
addColorPalatOption($wp_customize, 'productblock2_area_Popularproimhhoverborder', 'productblock2_area', 'Popular Product Image Hover Border color', '#eaeaea');
addColorPalatOption($wp_customize, 'productblock2_area_Popularproimhhovericon', 'productblock2_area', 'Popular Product Image Hover Icon color', '#cfd0d5');
addColorPalatOption($wp_customize, 'productblock2_area_Popularproimhhovericonbg', 'productblock2_area', 'Popular Product Image Hover Icon Background color', '#fff');
addColorPalatOption($wp_customize, 'productblock2_area_Popularproimhhovericonhover', 'productblock2_area', 'Popular Product Image Hover Icon color', '#0d61cc');

addColorPalatOption($wp_customize, 'productblock2_area_Popularprocat', 'productblock2_area', 'Popular Product Category color', '#0d61cc');
addColorPalatOption($wp_customize, 'productblock2_area_Popularprocathover', 'productblock2_area', 'Popular Product Category Hover color', '#ff0c12');
addColorPalatOption($wp_customize, 'productblock2_area_Popularproname', 'productblock2_area', 'Popular Product Name color', '#000');
addColorPalatOption($wp_customize, 'productblock2_area_Popularpronamehover', 'productblock2_area', 'Popular Product Name Hover color', '#0d61cc');

addColorPalatOption($wp_customize, 'productblock2_area_Popularproprice', 'productblock2_area', 'Popular Product Price color', '#7c8491');
addColorPalatOption($wp_customize, 'productblock2_area_Popularpropricecboprder', 'productblock2_area', 'Popular Product Price Cut Border color', '#ccd0d3');
addColorPalatOption($wp_customize, 'productblock2_area_Popularprosellingprice', 'productblock2_area', 'Popular Product Selling Price color', '#868b9e');