<?php
/**
 * The template for displaying archive pages.
 *
 * Used for displaying archive-type pages. These views can be further customized by
 * creating a separate template for each one.
 *
 * - author.php (Author archive)
 * - category.php (Category archive)
 * - date.php (Date archive)
 * - tag.php (Tag archive)
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 */
?>
<?php get_header(); ?>
<header class="page-main-header">
	<div class="container">
		<div class="ht-main-title"><?php single_cat_title(''); ?></div>
		<div class="clearfix"></div>
	</div>
</header><!-- .entry-header -->

<main id="innerpage-box">
	<div class="container">
		<div id="blog-box" class="col-md-9 innerpage-whitebox">
			<?php 
			$current_page = max(1, get_query_var('paged'));
			$lz_fitness_blog_post_count = get_theme_mod('lz_fitness_blog_post_count', 3 );
			$lz_fitness_blog_cat_exclude = get_theme_mod('lz_fitness_blog_categories');
			$lz_fitness_blog_cat_exclude = explode(',', $lz_fitness_blog_cat_exclude);
			$excerpt = get_theme_mod('lz_fitness_blog_categories_settings');
			$args = array(
				'paged'=> $current_page,
				'category__not_in' => $lz_fitness_blog_cat_exclude
			);
			$query = new WP_Query($args);
			if($query -> have_posts()):
				while($query -> have_posts()) : $query -> the_post();
					$lz_fitness_image = wp_get_attachment_image_src(get_post_thumbnail_id() , 'total-blog-thumb');
					$img = (has_post_thumbnail())?esc_url($lz_fitness_image[0]):get_template_directory_uri().'/images/default.png';
					?>
					<div class="inner-blog-post">
						<a href="<?php the_permalink(); ?>">
						<div class="ht-blog-thumbnail">
							<img class="inner-blog-img" src="<?php echo $img; ?>" alt="<?php the_title(); ?>">
						</div>
						</a>
						<div class="inner-blog-excerpt">
							<h2><?php the_title(); ?></h2>
							<div class="ht-blog-date"><i class="fa fa-calendar-o" aria-hidden="true"></i><?php echo get_the_date(); ?></div>
							<?php 
							if($excerpt === 1 ){
								echo get_the_content();
							}else{
								echo (get_the_excerpt())?get_the_excerpt():lz_fitness_excerpt( get_the_content() , 200 );
							} ?>
						</div>

						<div class="socialMedia">
								
                                <a href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink();?>" target="_parent"><i class="fa fa-facebook" aria-hidden="true"></i></a>
                                <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink();?>&title=<?php the_title();?>&source=<?php the_title();?>" target="_parent"><i class="fa fa-linkedin" aria-hidden="true"></i></a>
                                <a href="https://plus.google.com/share?url=<?php the_permalink();?>" target="_parent"><i class="fa fa-google-plus" aria-hidden="true"></i></a>
                                <a href="https://twitter.com/share?url=<?php the_permalink();?>&amp;text=<?php the_title();?>" target="_blank"><i class="fa fa-twitter" aria-hidden="true"></i></a>
                                <a href="http://www.digg.com/submit?url=<?php the_permalink();?>" target="_blank"><i class="fa fa-digg" aria-hidden="true"></i></a>
                                <div class="clearfix"></div>
                    </div>

						<div class="blog-read-more">
								<a href="<?php the_permalink(); ?>"><?php _e('Continue Reading', 'total'); ?></a>
							</div>
						<div class="clearfix"></div>
					</div>
					<?php
				endwhile;
			endif;
			wp_reset_postdata();
			?>
		</div> 
		<div class="col-md-3">
			<div <div id="secondary" class="widget-area">
				<?php dynamic_sidebar('lz-fitness-blog-sidebar'); ?>
			</div>
		</div>
		<div class="clearfix"></div>
		
		<div class="row">
			<div class="col-md-12">
				<div class="pagingation">
				    <?php lzGetPagination($query);?>
				</div>
			</div>
		</div>
	</div>
</main>
<?php get_footer(); ?>
<!--<div id="page" class="home-page">
	<div id="content" class="article">
		<h1 class="postsby">
			<span><?php //the_archive_title(); ?></span>
		</h1>	
		<?php ///if ( have_posts() ) :
			//$lz_fitness_lite_full_posts = get_theme_mod('lz_fitness_lite_full_posts');
			//while ( have_posts() ) : the_post();
				//lz_fitness_lite_archive_post();
			//endwhile;
			//lz_fitness_lite_post_navigation();
		//endif; ?>
	</div>
	<?php //get_sidebar(); ?>
</div>
<?php //get_footer(); ?>