<?php 
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luzuk Premium
 */

?>

<footer id="ht-colophon" class="ht-site-footer">
	<?php if(is_active_sidebar('lz-fitness-footer1') || is_active_sidebar('lz-fitness-footer2') || is_active_sidebar('lz-fitness-footer3') || is_active_sidebar('lz-fitness-footer4')){ ?>

		<?php if( get_theme_mod('footerupperrowremove_button_display','show' ) == 'show') :
			?>			
			<div class="upper-footer-row">
				<div class="container">
					<div class="col-md-4 col-sm-4 col-xs-12 text-center">
						<?php if( get_theme_mod('footerlogoremove_button_display','show' ) == 'show') :
							?>	
							<div class="footer-logo"> 
								 <?php 
							$lz_fitness_footerlogo_image = get_theme_mod('lz_fitness_footerlogo_image');
							if(!empty($lz_fitness_footerlogo_image)){
								echo '<img alt="'. esc_html(get_the_title()) .'" src="'.esc_url($lz_fitness_footerlogo_image).'" class="img-responsive" />';
							}else{
								echo '<img alt="About Us" src="'.get_template_directory_uri().'/images/logo.png" class="img-responsive aboutbox-img" />';
							}
							?>
							</div> 
							<div class="clearfix"></div>
						<?php endif ?> 
					</div>
					<div class="col-md-8 col-sm-8 col-xs-12 footer-social-up-right">
						<?php
						$facebook = get_theme_mod('lz_fitness_footer_fb', '//facebook.com/');
						$twitter = get_theme_mod('lz_fitness_footer_tw', '//twitter.com/');
						$instagram = get_theme_mod('lz_fitness_footer_insta', 'https://www.instagram.com/');
						?>
						<ul class="list-inline m-a0">
							<?php if(!empty($twitter)){ ?>
								<li><a href="<?php echo $twitter ?>" class="site-button twitter circle " target="_blank"><i class="fa fa-twitter"></i></a></li>
							<?php }?>
							<?php if(!empty($facebook)){ ?>
								<li><a href="<?php echo $facebook ?>" class="site-button facebook circle " target="_blank"><i class="fa fa-facebook"></i></a></li>
							<?php }?>
							<?php if(!empty($instagram)){ ?>
								<li><a href="<?php echo $instagram ?>" class="site-button instagram circle " target="_blank"><i class="fa fa-instagram"></i></a></li>
							<?php }?>

						</ul>
					</div>
					<div class="clearfix"></div>
				</div>
			</div>		
		<?php endif ?> 
		<div id="ht-top-footer">
			<div class="container"> 
		<?php 
		if( get_theme_mod('sec_footerseTmargin',true) ) {
			$sec_footerseTmargin = 'margin-top:'.esc_attr(get_theme_mod('sec_footerseTmargin')).';';
		}
		if( get_theme_mod('sec_footerseBmargin',true) ) {
			$sec_footerseBmargin = 'margin-bottom:'.esc_attr(get_theme_mod('sec_footerseBmargin')).';';
		}
		if( get_theme_mod('sec_footerseLmargin',true) ) {
			$sec_footerseLmargin = 'margin-left:'.esc_attr(get_theme_mod('sec_footerseLmargin')).';';
		}
		if( get_theme_mod('sec_footerseRmargin',true) ) {
			$sec_footerseRmargin = 'margin-right:'.esc_attr(get_theme_mod('sec_footerseRmargin')).';';
		}
		?>			
				<div class="ht-top-footer ht-clearfix" style="<?php echo esc_attr($sec_footerseTmargin); ?>" "<?php echo esc_attr($sec_footerseBmargin); ?>" "<?php echo esc_attr($sec_footerseLmargin); ?>" "<?php echo esc_attr($sec_footerseRmargin); ?>">

					<div class="ht-footer ht-footer1 wow fadeInUp">
						<?php if(is_active_sidebar('lz-fitness-footer1')): 
							dynamic_sidebar('lz-fitness-footer1');
						endif;
						?>	
					</div>

					<div class="ht-footer ht-footer2 wow fadeInUp">
						<?php if(is_active_sidebar('lz-fitness-footer2')): 
							dynamic_sidebar('lz-fitness-footer2');
						endif;
						?>	
					</div>

					<div class="ht-footer ht-footer3 wow fadeInUp">
						<?php if(is_active_sidebar('lz-fitness-footer3')): 
							dynamic_sidebar('lz-fitness-footer3');
						endif;
						?>	
					</div>

					<div class="ht-footer ht-footer4 wow fadeInUp">
						<?php if(is_active_sidebar('lz-fitness-footer4')): 
							dynamic_sidebar('lz-fitness-footer4');
						endif;
						?>	
					</div>
					<div class="clearfix"></div>
				</div>
			</div>
		</div>
	<?php } ?>
	<div id="ht-bottom-footer">
		<?php 
		// Prevent direct access
		if ( ! defined( 'ABSPATH' ) ) {
			exit; // Exit if accessed directly
		}

		$footercopyright = '';
		if (function_exists('custom_theme_copyright')) {
			$footercopyright = custom_theme_copyright();
		}
 
	?>
		<div class="ht-container container">
			<?php if($footercopyright){ ?>
				<div class="ht-site-info">
					<!-- 	<?php //lz_fitness_lite_copyrights_credit();?> -->
					<span><?php echo $footercopyright;?></span>
				</div><!-- #site-info -->
			<?php } ?>
		</div>
	</div>
</footer><!-- #colophon -->
<script type="text/javascript">
	if(jQuery(window).width() >= 1170){
		new WOW().init();
	}
</script>
<script>
	$(window).scroll(function() {
		var height = $(window).scrollTop();
		if (height > 100) {
			$('#back2Top').fadeIn();
		} else {
			$('#back2Top').fadeOut();
		}
	});
	$(document).ready(function() {
		$("#back2Top").click(function(event) {
			event.preventDefault();
			$("html, body").animate({ scrollTop: 0 }, "slow");
			return false;
		});

	});
</script>

<?php wp_footer(); ?>
<a id="back2Top" title="Back to top" href="#"> &#10148; </a>
</body>
</html>
