<?php    
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luzuk Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link href="https://fonts.googleapis.com/css?family=Work+Sans:400,600" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Biryani:400,600,700&display=swap" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Lato:400,700,900&display=swap" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Arvo:400,700&display=swap" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Passion+One:400,700,900&display=swap" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Passion+One:400,700,900|Schoolbell&display=swap" rel="stylesheet">
	
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>
	
	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<div class="main-container">
		<!-- <a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'InsideTours' ); ?></a> -->
		<div id="loading-area"><div class="la-anim-10"></div></div>
		<!-- header -->
		<header class="site-header header-transparent header mo-left header-seo">
			<?php 
			if( get_theme_mod('pages_logoTpadding',true) ) {
				$pages_logoTpadding = 'padding-top:'.esc_attr(get_theme_mod('pages_logoTpadding')).';';
			}
			if( get_theme_mod('pages_logoBpadding',true) ) {
				$pages_logoBpadding = 'padding-bottom:'.esc_attr(get_theme_mod('pages_logoBpadding')).';';
			}
			if( get_theme_mod('pages_logoLpadding',true) ) {
				$pages_logoLpadding = 'padding-left:'.esc_attr(get_theme_mod('pages_logoLpadding')).';';
			}
			if( get_theme_mod('pages_logoRpadding',true) ) {
				$pages_logoRpadding = 'padding-right:'.esc_attr(get_theme_mod('pages_logoRpadding')).';';
			}
			?>			

			<div class="top-bar" style="<?php echo esc_attr($pages_logoTpadding); ?>" "<?php echo esc_attr($pages_logoBpadding); ?>" "<?php echo esc_attr($pages_logoLpadding); ?>" "<?php echo esc_attr($pages_logoRpadding); ?>">

				<div class="container">
					<div class="row justify-content-between">
						<div class="dlab-topbar-left">
							<?php

							$email = get_theme_mod('lz_fitness_headermain_email', 'needhelp@Petcare.com');	
							$emailaddresslabel = get_theme_mod('lz_fitness_headermain_emaillabel', 'Email address');	
							$phone = get_theme_mod('lz_fitness_headermain_phone', '666 888 0000');	
							$phonelabel = get_theme_mod('lz_fitness_headermain_phonelabel', 'Phone line');	
							?>				

							<div class="col-md-8 col-md-offset-4 padding0 col-sm-12">
								<div class="col-md-4 col-sm-6 header-icon">
									<?php if($email || $emailaddresslabel){ ?>
										<div class="col-md-3 col-sm-2 col-xs-2 tada midix infinite icon-x">
											<i class="fa fa-envelope"></i>
										</div>	
										<div class="col-md-9 col-sm-10 col-xs-10 text-bx padding0">
											<a href="mailto:<?php echo $email;?>"><?php echo $email;?></a><br>
											<p><?php echo $emailaddresslabel ;?></p>
										</div>		
									<?php } ?>	
								</div>
								<div class="col-md-4 col-sm-6 header-icon">
									<?php if($phone || $phonelabel){ ?>
										<div class="col-md-3 col-sm-2 col-xs-2 tada midix infinite icon-x">
											<i class="fa fa-phone"></i>
										</div>	
										<div class="col-md-9 col-sm-10 col-xs-10 text-bx padding0">
											<a href="tel:<?php echo $phone;?>"><?php echo $phone ;?></a><br>
											<p><?php echo $phonelabel ;?></p>
										</div>		
									<?php } ?>	
								</div>	
									<?php
							$facebook = get_theme_mod('lz_fitness_header_fb', '//facebook.com/');
							$twitter = get_theme_mod('lz_fitness_header_tw', '//twitter.com/');
							$instagram = get_theme_mod('lz_fitness_header_insta', 'https://www.instagram.com/');
							?>
							<ul class="col-md-4 list-inline m-a0">
								<?php if(!empty($twitter)){ ?>
									<li><a href="<?php echo $twitter ?>" class="site-button twitter circle " target="_blank"><i class="fa fa-twitter"></i></a></li>
								<?php }?>
								<?php if(!empty($facebook)){ ?>
									<li><a href="<?php echo $facebook ?>" class="site-button facebook circle " target="_blank"><i class="fa fa-facebook"></i></a></li>
								<?php }?>
								<?php if(!empty($instagram)){ ?>
									<li><a href="<?php echo $instagram ?>" class="site-button instagram circle " target="_blank"><i class="fa fa-instagram"></i></a></li>
								<?php }?>

							</ul>

							</div>
						</div>
						
					</div>
				</div>
			</div>
			<?php 
			if( get_theme_mod('pages_logoboxtoppostionset',true) ) {
				$pages_logoboxtoppostionset = 'top:'.esc_attr(get_theme_mod('pages_logoboxtoppostionset')).';';
			}
			
			?>
			<?php 
			if( get_theme_mod('pages_logoTmargin',true) ) {
				$pages_logoTmargin = 'padding-top:'.esc_attr(get_theme_mod('pages_logoTmargin')).';';
			}
			if( get_theme_mod('pages_logoBmargin',true) ) {
				$pages_logoBmargin = 'padding-bottom:'.esc_attr(get_theme_mod('pages_logoBmargin')).';';
			}
			if( get_theme_mod('pages_logoLmargin',true) ) {
				$pages_logoLmargin = 'padding-left:'.esc_attr(get_theme_mod('pages_logoLmargin')).';';
			}
			if( get_theme_mod('pages_logoRmargin',true) ) {
				$pages_logoRmargin = 'padding-right:'.esc_attr(get_theme_mod('pages_logoRmargin')).';';
			}
			?>
			<div class="col-md-4 col-sm-6 col-xs-8 logo" style="<?php echo esc_attr($pages_logoboxtoppostionset); ?> <?php echo esc_attr($pages_logoTmargin); ?>" "<?php echo esc_attr($pages_logoBmargin); ?>" "<?php echo esc_attr($pages_logoLmargin); ?>" "<?php echo esc_attr($pages_logoRmargin); ?>"> 
				
				
				<div class="logobox">
					<?php 
					if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
						the_custom_logo();
				else : 
					if ( is_front_page() ) : ?>
						<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
						<?php else : ?>
							<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
						<?php endif; ?>
						<!-- <p class="ht-site-description"><a href="<?php //echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php //bloginfo( 'description' ); ?></a></p> -->
					<?php endif; ?>
					<!-- .site-branding -->
				</div>
			</div>
			<!-- main header -->
			<div class="col-md-8 col-md-offset-3 col-sm-6 col-xs-4 sticky-header main-bar-wraper navbar-expand-lg">
				<div class="main-bar clearfix ">
					<div class="col-md-offset-2 top-bar-head">

						<!-- nav toggle button -->
						<button class="navbar-toggler collapsed navicon justify-content-end" type="button" data-toggle="collapse" data-target="#navbarNavDropdown" aria-controls="navbarNavDropdown" aria-expanded="false" aria-label="Toggle navigation">
							<span></span>
							<span></span>
							<span></span>
						</button>
						<!-- main nav -->

						<?php 
						if( get_theme_mod('pages_BottomHeaderTpadding',true) ) {
							$pages_BottomHeaderTpadding = 'padding-top:'.esc_attr(get_theme_mod('pages_BottomHeaderTpadding')).';';
						}
						if( get_theme_mod('pages_BottomHeaderBpadding',true) ) {
							$pages_BottomHeaderBpadding = 'padding-bottom:'.esc_attr(get_theme_mod('pages_BottomHeaderBpadding')).';';
						}
						if( get_theme_mod('pages_BottomHeaderLpadding',true) ) {
							$pages_BottomHeaderLpadding = 'padding-left:'.esc_attr(get_theme_mod('pages_BottomHeaderLpadding')).';';
						}
						if( get_theme_mod('pages_BottomHeaderRpadding',true) ) {
							$pages_BottomHeaderRpadding = 'padding-right:'.esc_attr(get_theme_mod('pages_BottomHeaderRpadding')).';';
						}
						?>


						<div class="header-nav navbar-collapse collapse justify-content-end" id="navbarNavDropdown" style="<?php echo esc_attr($pages_BottomHeaderTpadding); ?>" "<?php echo esc_attr($pages_BottomHeaderRpadding); ?>" "<?php echo esc_attr($pages_BottomHeaderLpadding); ?>" "<?php echo esc_attr($pages_BottomHeaderRpadding); ?>">

							<ul class="nav navbar-nav wow slideInLeft ">	
								<?php 
								wp_nav_menu( array( 
									'theme_location' => 'primary', 
									'container_class' => 'ht-menu clearfix' ,
									'menu_class' => 'ht-clearfix wow',
									'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
								) ); 
								?>
							</ul>

							<!-- for responsive only -->
							<?php

							$email = get_theme_mod('lz_fitness_headermain_email', 'needhelp@Petcare.com');	
							$emailaddresslabel = get_theme_mod('lz_fitness_headermain_emaillabel', 'Emailaddress');	
							$phone = get_theme_mod('lz_fitness_headermain_phone', '666 888 0000');	
							$phonelabel = get_theme_mod('lz_fitness_headermain_phonelabel', 'Phone line');	
							?>				

							<div class="col-md-12 responsive-header-box">
								<div class="col-md-12 header-icon">
									<?php if($email || $emailaddresslabel){ ?>
										<div class="col-md-2 col-sm-3 col-xs-3 tada midix infinite icon-x">
											<i class="fa fa-envelope"></i>
										</div>	
										<div class="col-md-10 col-sm-9 col-xs-9 text-bx padding0">
											<a href="mailto:<?php echo $email;?>"><?php echo $email;?></a><br>
											<p><?php echo $emailaddresslabel ;?></p>
										</div>	
										<div class="clearfix"></div>	 
									<?php } ?>	
								</div> 
								<div class="col-md-12 header-icon">
									<?php if($phone || $phonelabel){ ?>
										<div class="col-md-2 col-sm-3 col-xs-3 tada midix infinite icon-x">
											<i class="fa fa-phone"></i>
										</div>	
										<div class="col-md-10 col-sm-9 col-xs-9 text-bx padding0">
											<?php echo $phone ;?><br>
											<p><?php echo $phonelabel ;?></p>
										</div>	
										<div class="clearfix"></div>		
									<?php } ?>	
								</div>		
							</div>

							<!-- for responsive only -->
							<?php
							$facebook = get_theme_mod('lz_fitness_header_fb', '//facebook.com/');
							$twitter = get_theme_mod('lz_fitness_header_tw', '//twitter.com/');
							$instagram = get_theme_mod('lz_fitness_header_insta', 'https://www.instagram.com/');
							?>
							<ul class="col-md-4 list-inline m-a0">
								<?php if(!empty($twitter)){ ?>
									<li><a href="<?php echo $twitter ?>" class="site-button twitter circle " target="_blank"><i class="fa fa-twitter"></i></a></li>
								<?php }?>
								<?php if(!empty($facebook)){ ?>
									<li><a href="<?php echo $facebook ?>" class="site-button facebook circle " target="_blank"><i class="fa fa-facebook"></i></a></li>
								<?php }?>
								<?php if(!empty($instagram)){ ?>
									<li><a href="<?php echo $instagram ?>" class="site-button instagram circle " target="_blank"><i class="fa fa-instagram"></i></a></li>
								<?php }?>

							</ul>



						</div>

					</div>
				</div>
			</div>
			<!-- main header END -->
			<div class="clearfix"></div>

		</header><!-- #masthead -->

	</div>
