<?php

$wp_customize->add_panel(
	'lz_fitness_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'Luzuk Premium')
	)
);
//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'Luzuk Premium' ),
	'panel' => 'lz_fitness_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'Luzuk Premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'Luzuk Premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image Setting', 'Luzuk Premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'Luzuk Premium' ),
	'panel' => 'lz_fitness_general_panel',
) );



//HEADER LOGO MARGIN SETTINGS



//HEADER SETTINGS
$wp_customize->add_section(
	'lz_fitness_header_settings',
	array(
		'title' => __( 'Header Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);
	//ENABLE/DISABLE STICKY HEADER
// $wp_customize->add_setting(
// 	'lz_fitness_sticky_header_enable',
// 	array(
// 		'sanitize_callback' => 'lz_fitness_sanitize_text',
// 		'default' => 'off'
// 	)
// );
// $wp_customize->add_control(
// 	new lz_fitness_Switch_Control(
// 		$wp_customize,
// 		'lz_fitness_sticky_header_enable',
// 		array(
// 			'settings'		=> 'lz_fitness_sticky_header_enable',
// 			'section'		=> 'lz_fitness_header_settings',
// 			'label'			=> __( 'Sticky Header', 'Luzuk Premium' ),
// 			'on_off_label' 	=> array(
// 				'on' => __( 'Enable', 'Luzuk Premium' ),
// 				'off' => __( 'Disable', 'Luzuk Premium' )
// 			)	
// 		)
// 	)
// );

$sectionHeader = 'lz_fitness_header_settings';

lzCustomLable($wp_customize, 'lz_fitness_header_toppadsettings', $sectionHeader, 'Set Top Header Padding');

$wp_customize->add_setting(
	'pages_logoTpadding',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '15px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoTpadding',
	array(
		'settings'      => 'pages_logoTpadding',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Top Header Top Padding', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoBpadding',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '15px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoBpadding',
	array(
		'settings'      => 'pages_logoBpadding',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Top Header Bottom Padding', 'lz-fitness-premium' )
	)
);

$wp_customize->add_setting(
	'pages_logoLpadding',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '00px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoLpadding',
	array(
		'settings'      => 'pages_logoLpadding',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Top Header Left Padding', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoRpadding',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '00px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoRpadding',
	array(
		'settings'      => 'pages_logoRpadding',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Top Header Right Padding', 'lz-fitness-premium' )
	)
);

lzCustomLable($wp_customize, 'lz_fitness_header_settings', $sectionHeader, 'Add Email & Phone Text');


$wp_customize->add_setting(
	'lz_fitness_headermain_email',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'needhelp@Petcare.com', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_email',
	array(
		'settings'      => 'lz_fitness_headermain_email',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Add Email Address Here:', 'lz-fitness-premium' )
	)
);

$wp_customize->add_setting(
	'lz_fitness_headermain_emaillabel',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Emailaddress', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_emaillabel',
	array(
		'settings'      => 'lz_fitness_headermain_emaillabel',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Add Email Label Here:', 'lz-fitness-premium' )
	)
);


$wp_customize->add_setting(
	'lz_fitness_headermain_phone',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '666 888 0000', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_phone',
	array(
		'settings'      => 'lz_fitness_headermain_phone',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Add Phone Number Here:', 'lz-fitness-premium' )
	)
);


$wp_customize->add_setting(
	'lz_fitness_headermain_phonelabel',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'Phone line', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_phonelabel',
	array(
		'settings'      => 'lz_fitness_headermain_phonelabel',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Add Phone Label Here:', 'lz-fitness-premium' )
	)
);
addColorPalatOption($wp_customize, 'lz_fitness_header_emailndphoneIconsColor', 'lz_fitness_header_settings', ' Email & Phone Icon color', '#fbb34d');

addColorPalatOption($wp_customize, 'lz_fitness_header_emailndphoneTxtColor', 'lz_fitness_header_settings', ' Email Id & Phone Text color', '#ffffff');

addColorPalatOption($wp_customize, 'lz_fitness_header_emailndTxtHvrColor', 'lz_fitness_header_settings', ' Email Text Hover color', '#ff7c4e');

addColorPalatOption($wp_customize, 'lz_fitness_header_emailndphonelabelColor', 'lz_fitness_header_settings', ' Email Id & Phone Label color', '#e0d8d5');

addColorPalatOption($wp_customize, 'lz_fitness_header_topheaderbgsscColor', 'lz_fitness_header_settings', 'Top Header Background color', '#3b3634');


lzCustomLable($wp_customize, 'lz_fitness_headerlogo_margin', 'lz_fitness_header_settings', ' Site Header Logo Padding Setting:');

$wp_customize->add_setting(
	'pages_logoTmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '40px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoTmargin',
	array(
		'settings'      => 'pages_logoTmargin',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Top Padding', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoBmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '40px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoBmargin',
	array(
		'settings'      => 'pages_logoBmargin',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Bottom Padding', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoLmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '85px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoLmargin',
	array(
		'settings'      => 'pages_logoLmargin',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Left Padding', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoRmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '85px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoRmargin',
	array(
		'settings'      => 'pages_logoRmargin',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Right Padding', 'lz-fitness-premium' )
	)
);



lzCustomLable($wp_customize, 'lz_fitness_header_logoboxpositionsettings', $sectionHeader, 'Set Logo Box Position from top');
 
$wp_customize->add_setting(
	'pages_logoboxtoppostionset',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '30px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoboxtoppostionset',
	array(
		'settings'      => 'pages_logoboxtoppostionset',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Top', 'lz-fitness-premium' )
	)
);

addColorPalatOption($wp_customize, 'lz_fitness_header_logoboxbgssColor', 'lz_fitness_header_settings', 'Header Logo box background color', '#ffffff');




addColorPalatOption($wp_customize, 'lz_fitness_header_topmenusColor', 'lz_fitness_header_settings', 'Header Menus color', '#3b3634');
addColorPalatOption($wp_customize, 'lz_fitness_header_topmenushoverColor', 'lz_fitness_header_settings', 'Header Menus Hover color', '#ff7c4e');

addColorPalatOption($wp_customize, 'lz_fitness_header_activeheademenusColor', 'lz_fitness_header_settings', 'Active Menu color', '#ff7c4e');


addColorPalatOption($wp_customize, 'lz_fitness_header_topsubmenusbackgroundColor', 'lz_fitness_header_settings', 'Header Dropdown Background color', '#f2f1f0');

addColorPalatOption($wp_customize, 'lz_fitness_header_topmenusiconColor', 'lz_fitness_header_settings', 'Header Sub Menu Icon color', '#ccc');
addColorPalatOption($wp_customize, 'lz_fitness_header_topmenusiconhoverColor', 'lz_fitness_header_settings', 'Header Sub Menu Icon Hover color', '#ffffff');

addColorPalatOption($wp_customize, 'lz_fitness_header_topsubmenusColor', 'lz_fitness_header_settings', 'Header Sub Menus color', '#3b3634');
addColorPalatOption($wp_customize, 'lz_fitness_header_topsubmenushvrColor', 'lz_fitness_header_settings', 'Header Sub Menu Hover color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_header_topsubmenusbgsshvrColor', 'lz_fitness_header_settings', 'Header Sub Menu Hover background color', '#ff7c4e');
addColorPalatOption($wp_customize, 'lz_fitness_header_activesubmenuColor', 'lz_fitness_header_settings', 'Header Active Sub Menu color', '#121212');


lzCustomLable($wp_customize, 'lz_fitness_header_bottpadsettings', $sectionHeader, 'Set Bottom Header Padding');

$wp_customize->add_setting(
	'pages_BottomHeaderTpadding',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '22px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_BottomHeaderTpadding',
	array(
		'settings'      => 'pages_BottomHeaderTpadding',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Bottom Header Top Padding', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'pages_BottomHeaderBpadding',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '22px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_BottomHeaderBpadding',
	array(
		'settings'      => 'pages_BottomHeaderBpadding',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Bottom Header Bottom Padding', 'lz-fitness-premium' )
	)
);

$wp_customize->add_setting(
	'pages_BottomHeaderLpadding',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '00px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_BottomHeaderLpadding',
	array(
		'settings'      => 'pages_BottomHeaderLpadding',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Bottom Header Left Padding', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'pages_BottomHeaderRpadding',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '00px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_BottomHeaderRpadding',
	array(
		'settings'      => 'pages_BottomHeaderRpadding',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Bottom Header Right Padding', 'lz-fitness-premium' )
	)
);
addColorPalatOption($wp_customize, 'lz_fitness_header_bottomheaderbgssColor', 'lz_fitness_header_settings', 'Bottom Header Background color', '#f2f1f0');


// Adding the Label
lzCustomLable($wp_customize, 'lz_fitness_header_lblsocialtxt', $sectionHeader, 'Add Social Media Links');
// TWITTER
$wp_customize->add_setting('lz_fitness_header_tw', array('default'=> 'https://twitter.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_tw',
	array(
		'settings'      => 'lz_fitness_header_tw',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Add Twitter Url Here', 'lz-fitness-premium' )
	)
);

// FACEBOOK 
$wp_customize->add_setting('lz_fitness_header_fb',	array('default'=> 'https://facebook.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_fb',
	array(
		'settings'      => 'lz_fitness_header_fb',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Add Facebook Url Here', 'lz-fitness-premium' )
	)
);

// Instagram
$wp_customize->add_setting('lz_fitness_header_insta', array('default' => 'https://www.instagram.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_header_insta',
	array(
		'settings'      => 'lz_fitness_header_insta',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'url',
		'label'         => __( 'Add Instagram Url Here', 'tattooexpert' )
	)
); 

addColorPalatOption($wp_customize, 'lz_fitness_header_socialscColor', 'lz_fitness_header_settings', 'Twitter Icon color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_header_TwittersocialscColor', 'lz_fitness_header_settings', 'Twitter Icon Background color', '#ff7c4e');
addColorPalatOption($wp_customize, 'lz_fitness_header_TwitterhoversocialscColor', 'lz_fitness_header_settings', 'Twitter Icon Hover Background color', '#ff7c4e');

addColorPalatOption($wp_customize, 'lz_fitness_header_facebooksocialscColor', 'lz_fitness_header_settings', 'Facebook Icon color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_header_FacebooksocialscColor', 'lz_fitness_header_settings', 'Facebook Icon Background color', '#fbb34d');
addColorPalatOption($wp_customize, 'lz_fitness_header_FacebooksocialshvrcColor', 'lz_fitness_header_settings', 'Facebook Icon Hover Background color', '#fbb34d');

addColorPalatOption($wp_customize, 'lz_fitness_header_instagramsocialscColor', 'lz_fitness_header_settings', 'Instagram Icon color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_header_InstasocialscColor', 'lz_fitness_header_settings', 'Instagram Icon Background color', '#4d93fb');
addColorPalatOption($wp_customize, 'lz_fitness_header_InstasocialshvrcColor', 'lz_fitness_header_settings', 'Instagram Icon Hover Background color', '#4d93fb');

lzCustomLable($wp_customize, 'lz_fitness_header_colorsfortabandmobview', $sectionHeader, 'Colors For Tablet & Mobile View');

addColorPalatOption($wp_customize, 'lz_fitness_header_respnavbsbgssColor', 'lz_fitness_header_settings', 'Set Navigation Box Background Color for Tablet and Mobile View', '#ff7c4e');

addColorPalatOption($wp_customize, 'lz_fitness_header_activemenubgsscColor', 'lz_fitness_header_settings', 'Active Menu Background color for Tablet and Mobile View', '#ffffff');

addColorPalatOption($wp_customize, 'lz_fitness_header_respnavtoggbarbgssColor', 'lz_fitness_header_settings', 'Toggole Bar color for Tablet and Mobile View', '#ff7c4e');
//addColorPalatOption($wp_customize, 'lz_fitness_header_respnavtoggbaractivebgssColor', 'lz_fitness_header_settings', 'Active Toggole Bar color for Tablet and Mobile View', '#ff7c4e');

addColorPalatOption($wp_customize, 'lz_fitness_header_respsocialbxbgssc', 'lz_fitness_header_settings', 'Social Box Background color for Tablet and Mobile View', '#ffffff');


//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'Luzuk Premium'),
	'panel' => 'lz_fitness_general_panel',
) );
//theme primary color
addColorPalatOption($wp_customize, 'lz_fitness_template_color', 'colors', 'Theme Primary Color', '#ff7c4e');
//theme Secondary color
addColorPalatOption($wp_customize, 'theme_secondary_color', 'colors', 'Theme Secondary Color', '#121212');

lzCustomLable($wp_customize, 'lz_fitness_allinnerpagesec_colordisplaysettdisplay', 'colors', 'Color Setting For Innerpage Colors:');

addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_titlecolor', 'colors', 'Inner page title color', '#fff');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_bgcolor', 'colors', 'Inner page title background color', '#ff7c4e');

addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionbox_color', 'colors', 'Inner Page Box Background color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionboxheading1_color', 'colors', 'Heading 1 color', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionboxheading2_color', 'colors', 'Heading 2 color', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionboxheading3_color', 'colors', 'Heading 3 color', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionboxheading4_color', 'colors', 'Heading 4 color', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionboxheading5_color', 'colors', 'Heading 5 color', '#2e2e2e');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionboxheading6_color', 'colors', 'Heading 6 color', '#2e2e2e');

addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionboxtext_color', 'colors', 'Inner Page Text color', '#777777');

addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionboxtextlinks_color', 'colors', 'Inner Page Links color', '#4f4c4c');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionboxtextlinkshvrs_color', 'colors', 'Inner Page Links Hover color', '#ff7c4e');

addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionboxtextlinksicon_color', 'colors', 'Inner Page Icons, list number color', '#ff7c4e');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionboxtextlinksiconbgssclr_color', 'colors', 'Inner Page list number Background color', '#121212');

addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionsidebarwidbrs_color', 'colors', 'Inner Page Sidebar Widgets Border color', '#ff7c4e');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionsidebarborderrs_color', 'colors', 'Inner Page Sidebar & text field Border color', '#e9e7e7');

addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagemainsectionsidebarborderrs_color', 'colors', 'Inner Page Sidebar & Search field Border color', '#e9e7e7');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagesidebardaytxt_color', 'colors', 'Inner Page Sidebar Calender Widgets Day Text color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpagesidebardaybgsstxt_color', 'colors', 'Inner Page Sidebar Calender Widgets Day Text Background color', '#777777');

//addColorPalatOption($wp_customize, 'lz_fitness_template_staticfrontinnerpage_bgcolor', 'colors', 'Static Front Page Top Header background color', '#2e2e2e');
lzCustomLable($wp_customize, 'lz_fitness_allinnerpagesec_colordisplaysettnavbackttoarrdisplay', 'colors', 'Color Setting For Navigation Back to top arrow:');

addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_backttoparrcbgcolor', 'colors', 'Site Navigation Arrow color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_backttoparrcbghvrcolor', 'colors', 'Site Navigation Arrow Hover color', '#121212');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_backttoparrbackcolbgcolor', 'colors', 'Site Navigation Arrow background color', '#ff7924');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_backttoparrbackcolbghvrscolor', 'colors', 'Site Navigation Arrow background hover color', '#ffffff');

//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'lz_fitness_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'lz_fitness_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Breadcrumb', 'hide' => 'Hide Breadcrumb', ), ) ); 

$wp_customize->add_setting(
        'lz_fitness_breadcrumbhometxt',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text',
            'default'           => __( 'Home', 'luzuk' )
        )
    );
    $wp_customize->add_control(
        'lz_fitness_breadcrumbhometxt',
        array(
            'settings'      => 'lz_fitness_breadcrumbhometxt',
            'section'       => 'lz_fitness_breadcrumb_settings',
            'type'          => 'text',
            'label'         => __( 'Add Breadcrumb Text Here:', 'luzuk' )
        )
    );

//Inner page breadcrumbbox title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbtitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox title color', '#000');
//Inner page breadcrumbbox current title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbcurrenttitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox current title color', '#fbb34d');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbcurrenttitlehovercolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox current title hover color', '#121212');

//Inner page breadcrumbbox background color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbbgcolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox background color', '#fff');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbbgbordercolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox border color', '#ccc');

// end to show & hide button

//POSTPAGEDATE SETTINGS
$wp_customize->add_section(
	'lz_fitness_postpagedate_settings',
	array(
		'title' => __( 'Postpage Date Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

//for POSTPAGEDATE to show & hide button

$wp_customize->add_setting( 'postdate_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'postdate_button_display', array( 'label' => 'Post Date Display', 'section' => 'lz_fitness_postpagedate_settings', 'settings' => 'postdate_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Post Date', 'hide' => 'Hide Post Date', ), ) ); 

// end to show & hide button


//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'lz_fitness_footer_copyright_settings',
	array(
		'title' => __( 'Footer Copyright Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

$wp_customize->add_setting(
	'lz_fitness_footer_copyrighttext',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '© 2019 Copyrights, by the-pet-clinic.com', 'Luzuk Premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_footer_copyrighttext',
	array(
		'settings'      => 'lz_fitness_footer_copyrighttext',
		'section'       => 'lz_fitness_footer_copyright_settings',
		'type'          => 'text',
		'label'         => __( 'Footer Copyright Text', 'Luzuk Premium' )
	)
);

backgroundManager($wp_customize, 'footer', 'lz_fitness_footer_copyright_settings', $color='#f2f1f0');
addColorPalatOption($wp_customize, 'lz_fitness_footercompletebordess_color', 'lz_fitness_footer_copyright_settings', 'Footer Border Color', '#ffffff');

lzCustomLable($wp_customize, 'lz_fitness_footer_logoimgbx', 'lz_fitness_footer_copyright_settings', 'Set Left Image For upper footer');

$wp_customize->add_setting(
        'lz_fitness_footerlogo_image_heading',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Customize_Heading(
            $wp_customize,
            'lz_fitness_footerlogo_image_heading',
            array(
                'settings'      => 'lz_fitness_footerlogo_image_heading',
                'section'       => 'lz_fitness_footer_copyright_settings',
                'label'         => __( 'Left Image', 'lz-fitness-premium' ),
            )
        )
    );
    $wp_customize->add_setting(
        'lz_fitness_footerlogo_image',
        array(
            'sanitize_callback' => 'esc_url_raw'
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'lz_fitness_footerlogo_image',
            array(
                'section' => 'lz_fitness_footer_copyright_settings',
                'settings' => 'lz_fitness_footerlogo_image',
                'description' => __('Recommended Image Size: 649X687px', 'lz-fitness-premium')
            )
        )
    );

lzCustomLable($wp_customize, 'footerupperrowremove_button_displaysets', 'lz_fitness_footer_copyright_settings', 'Remove Logo & Social Box:');

// to show & hide another button
$wp_customize->add_setting( 'footerupperrowremove_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'footerupperrowremove_button_display', array( 'label' => 'Upper Footer Dispaly Settings:', 'section' => 'lz_fitness_footer_copyright_settings', 'settings' => 'footerupperrowremove_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Upper Footer', 'hide' => 'Hide Upper Footer', ), ) ); 
// end to show & hide button




lzCustomLable($wp_customize, 'footerlogoremove_button_displaysets', 'lz_fitness_footer_copyright_settings', 'Footer Image Display Setting:');

// to show & hide another button
$wp_customize->add_setting( 'footerlogoremove_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'footerlogoremove_button_display', array( 'label' => 'Footer Image Display', 'section' => 'lz_fitness_footer_copyright_settings', 'settings' => 'footerlogoremove_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Image', 'hide' => 'Hide Image', ), ) ); 
// end to show & hide button


lzCustomLable($wp_customize, 'lz_fitness_footer_lblsocialtxt', 'lz_fitness_footer_copyright_settings', 'Add Social Media Links');
// TWITTER
$wp_customize->add_setting('lz_fitness_footer_tw', array('default'=> 'https://twitter.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_footer_tw',
	array(
		'settings'      => 'lz_fitness_footer_tw',
		'section'       => 'lz_fitness_footer_copyright_settings',
		'type'          => 'url',
		'label'         => __( 'Add Twitter Url Here', 'lz-fitness-premium' )
	)
);

// FACEBOOK 
$wp_customize->add_setting('lz_fitness_footer_fb',	array('default'=> 'https://facebook.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_footer_fb',
	array(
		'settings'      => 'lz_fitness_footer_fb',
		'section'       => 'lz_fitness_footer_copyright_settings',
		'type'          => 'url',
		'label'         => __( 'Add Facebook Url Here', 'lz-fitness-premium' )
	)
);

// Instagram
$wp_customize->add_setting('lz_fitness_footer_insta', array('default' => 'https://www.instagram.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lz_fitness_footer_insta',
	array(
		'settings'      => 'lz_fitness_footer_insta',
		'section'       => 'lz_fitness_footer_copyright_settings',
		'type'          => 'url',
		'label'         => __( 'Add Instagram Url Here', 'tattooexpert' )
	)
); 

addColorPalatOption($wp_customize, 'lz_fitness_upperfootersocials_color', 'lz_fitness_footer_copyright_settings', 'Footer Socials Color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_twitterfootersocialbgc_color', 'lz_fitness_footer_copyright_settings', 'Twitter icon background Color', '#ff7c4e');
addColorPalatOption($wp_customize, 'lz_fitness_footerfbsocibg_color', 'lz_fitness_footer_copyright_settings', 'Facebook icon background Color', '#fbb34d');
addColorPalatOption($wp_customize, 'lz_fitness_footerinstasocibg_color', 'lz_fitness_footer_copyright_settings', 'Instagram icon background Color', '#4d93fb');



lzCustomLable($wp_customize, 'lz_fitness_sec_footersectionpadding', 'lz_fitness_footer_copyright_settings', 'Set Footer Margin:');

$wp_customize->add_setting(
    'sec_footerseTmargin', 
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '0em', 'lz-fitness-premium' )
    )
);
$wp_customize->add_control(
    'sec_footerseTmargin',
    array(
        'settings'      => 'sec_footerseTmargin',
        'section'       => 'lz_fitness_footer_copyright_settings',
        'type'          => 'text',
        'label'         => __( 'Footer Top Margin', 'lz-fitness-premium' )
    )
);
$wp_customize->add_setting(
    'sec_footersebottommargin',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '0em', 'lz-fitness-premium' )
    )
);
$wp_customize->add_control(
    'sec_footersebottommargin',
    array(
        'settings'      => 'sec_footersebottommargin',
        'section'       => 'lz_fitness_footer_copyright_settings',
        'type'          => 'text',
        'label'         => __( 'Footer Bottom Margin', 'lz-fitness-premium' )
    )
);

$wp_customize->add_setting(
    'sec_footerseLmargin',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '0em', 'lz-fitness-premium' )
    )
);
$wp_customize->add_control(
    'sec_footerseLmargin',
    array(
        'settings'      => 'sec_footerseLmargin',
        'section'       => 'lz_fitness_footer_copyright_settings',
        'type'          => 'text',
        'label'         => __( 'Footer Left Margin', 'lz-fitness-premium' )
    )
);
$wp_customize->add_setting(
    'sec_footerseRmargin',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '0em', 'lz-fitness-premium' )
    )
);
$wp_customize->add_control(
    'sec_footerseRmargin',
    array(
        'settings'      => 'sec_footerseRmargin',
        'section'       => 'lz_fitness_footer_copyright_settings',
        'type'          => 'text',
        'label'         => __( 'Footer Right Margin', 'lz-fitness-premium' )
    )
);

//theme Footer title Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_title_color', 'lz_fitness_footer_copyright_settings', 'Footer Title Color', '#3b3634');

//theme Footer icon Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_icon_color', 'lz_fitness_footer_copyright_settings', 'Footer Icon Color', '#615d5c');
//theme Footer icon hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_iconhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Icon Hover Color', 'ff7c4e');

//theme Footer text Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_text_color', 'lz_fitness_footer_copyright_settings', 'Footer Text Color', '#696665');
addColorPalatOption($wp_customize, 'lz_fitness_footer_hglightsctext_color', 'lz_fitness_footer_copyright_settings', 'Footer Hightlight Text Color', '#ff7c4e');

//theme Footer menu Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_menuicon_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Icon & Count Text Color', '#615d5c');
addColorPalatOption($wp_customize, 'lz_fitness_footer_menuiconhvr_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Icon & Count Text Hover Color', '#ff7c4e');

addColorPalatOption($wp_customize, 'lz_fitness_footer_menu_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Color', '#696665');

//theme Footer menu hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_menuhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Menu Hover Color', '#3b3634');

//theme Footer social Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_social_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Color', '#ffffff');
//theme Footer social Hover Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_socialhover_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Hover Color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_footer_socialbgss_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Background Color', '#ff7c4e');
addColorPalatOption($wp_customize, 'lz_fitness_footer_socialbgsshvr_color', 'lz_fitness_footer_copyright_settings', 'Footer Social Background Hover Color', '#fbb34d');

//theme Footer table text Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_tabletext_color', 'lz_fitness_footer_copyright_settings', 'Footer Table Text Color', '#696665');
//theme Footer table border Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_tableborder_color', 'lz_fitness_footer_copyright_settings', 'Footer Table Border Color', '#696665');
   
addColorPalatOption($wp_customize, 'lz_fitness_footer_formlabeltxt_color', 'lz_fitness_footer_copyright_settings', 'Footer Form & Calender label Text Color', '#696665');
 
//theme Footer form Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_form_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Text & Placeholder Text Color', '#696665');

//theme Footer form border Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_formborder_color', 'lz_fitness_footer_copyright_settings', 'Footer Form text field & Calender background Color', '#fff');

//theme Footer form button Color 
addColorPalatOption($wp_customize, 'lz_fitness_footer_formbtn_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Button Color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_footer_formbtnhvrss_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Button Hover Color', '#ffffff');

//theme Footer Form Button Background Color
addColorPalatOption($wp_customize, 'lz_fitness_footer_formbtnbg_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Button Background Color', '#ff7c4e');
addColorPalatOption($wp_customize, 'lz_fitness_footer_formbtnbghvrss_color', 'lz_fitness_footer_copyright_settings', 'Footer Form Button Background Hover Color', '#fbb34d');

addColorPalatOption($wp_customize, 'lz_fitness_footer_menudate_color', 'lz_fitness_footer_copyright_settings', 'Posts & Calender active Date Text Color', '#ff7c4e');
addColorPalatOption($wp_customize, 'lz_fitness_footer_calendertxtc_color', 'lz_fitness_footer_copyright_settings', 'Calender Day Text Color', '#ffffff');
addColorPalatOption($wp_customize, 'lz_fitness_footer_calendertxtcbgssc_color', 'lz_fitness_footer_copyright_settings', 'Calender date Text background Color', '#121212');


addColorPalatOption($wp_customize, 'lz_fitness_footer_copyrighttext_color', 'lz_fitness_footer_copyright_settings', 'Copyright Footer Text Color', '#fff');
addColorPalatOption($wp_customize, 'lz_fitness_footer_copyrighttextbackbgss_color', 'lz_fitness_footer_copyright_settings', 'Copyright Footer Background Color', '#3b3634');

//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
	'lz_fitness_shopsidebar_settings',
	array(
		'title' => __( 'Shop Page Sidebar Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);


// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'lz_fitness_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Sidebar', 'hide' => 'Hide Sidebar', ), ) ); 
// end to show & hide button

//addColorPalatOption($wp_customize, 'lz_fitness_shoppageheaderbg_color', 'lz_fitness_shopsidebar_settings', 'Shop Pages Top Header Background Color', '#2e2e2e');


$wp_customize->add_section(
	'lz_fitness_innerpageshortcode_page_settings',
	array(
		'title' => __( 'Color Setting For Shortcode Pages', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

lzCustomLable($wp_customize, 'lz_fitness_servicepageclrdisplay', 'lz_fitness_innerpageshortcode_page_settings', 'Set Services Shortcode Page Colors:'); 

addColorPalatOption($wp_customize, 'lz_fitness_serviceinnerbgClr', 'lz_fitness_innerpageshortcode_page_settings', 'Select Services Box Background Color', '#ff7c4e');

addColorPalatOption($wp_customize, 'lz_fitness_serviceinnerpagetitleColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Services Title Color', '#fff');

//addColorPalatOption($wp_customize, 'lz_fitness_serviceinnerpagetitleColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Services Title Color', '#ff7c4e');

addColorPalatOption($wp_customize, 'lz_fitness_serviceinnerpagedescriptionColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Services Text Color', '#787777');

lzCustomLable($wp_customize, 'Serviceinnerpageservices_button_displaysets', 'lz_fitness_innerpageshortcode_page_settings', 'Services Button Display & Button Text Setting:');

// to show & hide another button
$wp_customize->add_setting( 'innerpageservices_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'innerpageservices_button_display', array( 'label' => 'Button Display', 'section' => 'lz_fitness_innerpageshortcode_page_settings', 'settings' => 'innerpageservices_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button


$wp_customize->add_setting(
    'lz_fitness_innerpageservicesbutton_txt',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( 'Read More', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'lz_fitness_innerpageservicesbutton_txt',
    array(
        'settings'      => 'lz_fitness_innerpageservicesbutton_txt',
        'section'       => 'lz_fitness_innerpageshortcode_page_settings',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);



addColorPalatOption($wp_customize, 'lz_fitness_serviceinnerpagebuttontxtColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Button Text & Icon Color', '#fff');

addColorPalatOption($wp_customize, 'lz_fitness_serviceinnerpagebuttontxthvrssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Button Text & Icon Hover Color', '#000');




lzCustomLable($wp_customize, 'lz_fitness_teaminnerpagepageclrdisplay', 'lz_fitness_innerpageshortcode_page_settings', 'Set Team Shortcode Page Colors:');

lzCustomLable($wp_customize, 'lz_fitness_teaminnerpageimgdisplayset', 'lz_fitness_innerpageshortcode_page_settings', 'Note: Set team member images of equal height of size atleast 385px to show team images in proper way');

addColorPalatOption($wp_customize, 'lz_fitness_teaminnermemberimageborderColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Team Member Image Hover Background color', '#ff7c4e');

addColorPalatOption($wp_customize, 'lz_fitness_teaminnermembersociconsColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Team Member Image Hover Social Icon color', '#ffffff');

addColorPalatOption($wp_customize, 'lz_fitness_teaminnermembersociconsbrdClr', 'lz_fitness_innerpageshortcode_page_settings', 'Select Team Member Image Hover Social Icon Border Color', '#ffffff');

addColorPalatOption($wp_customize, 'lz_fitness_teaminnermembernbxClr', 'lz_fitness_innerpageshortcode_page_settings', 'Select Team Text Background Color', '#fff');


addColorPalatOption($wp_customize, 'lz_fitness_teaminnermembernametextColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Team Member Name Text Color', '#ff7c4e');

addColorPalatOption($wp_customize, 'lz_fitness_teaminnermembernametexthvrcColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Team Member Name Text Hover Color', '#444');

addColorPalatOption($wp_customize, 'lz_fitness_teaminnermemberdescColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Team Member Designation Text Color', '#696363');


lzCustomLable($wp_customize, 'lz_fitness_testimonialinnerpagepageclrdisplay', 'lz_fitness_innerpageshortcode_page_settings', 'Set Testimonial Shortcode Page Colors:');

addColorPalatOption($wp_customize, 'lz_fitness_testpbgdssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Image Box Background Color', '#fff');
addColorPalatOption($wp_customize, 'lz_fitness_testpbgdssicnColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Image Box Icon Color', '#ff7c4e');
addColorPalatOption($wp_customize, 'lz_fitness_testinnerptextbxtColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Text color', '#454545');
addColorPalatOption($wp_customize, 'lz_fitness_testclientnamebgdssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Client name text color', '#ff7c4e');
addColorPalatOption($wp_customize, 'lz_fitness_testclientdesignationtxtbgdssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Client designation text color', '#454545');

//addColorPalatOption($wp_customize, 'lz_fitness_testinnerptextbxtbgssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Text box background color', '#ff7c4e');
addColorPalatOption($wp_customize, 'lz_fitness_testinnerptextbxtbgssiconColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Text box Icon color', '#eb683b');
 

lzCustomLable($wp_customize, 'lz_fitness_galleryinnerpagepageclrdisplay', 'lz_fitness_innerpageshortcode_page_settings', 'Set Gallery Shortcode Page Colors:');

addColorPalatOption($wp_customize, 'lz_fitness_innergalleryimgboxbgsscbrssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Gallery Image Hover Border Color', '#ff7c4e');

addColorPalatOption($wp_customize, 'lz_fitness_innergalleryimgboxicnColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Gallery Image Hover Icon Color', '#fff');



lzCustomLable($wp_customize, 'lz_fitness_faqinnerpagepageclrdisplay', 'lz_fitness_innerpageshortcode_page_settings', 'Set Faq Shortcode Page Colors:');


addColorPalatOption($wp_customize, 'lz_fitness_faqinnIconbgClr', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Question Box Icon Background Color', '#ff7c4e');

addColorPalatOption($wp_customize, 'lz_fitness_faqinnerpagetitleIconColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Question Box Icon Color', '#000');

addColorPalatOption($wp_customize, 'lz_fitness_faqinnerpagetitleIconhvColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Question Box Icon Hover Color', '#fff');

addColorPalatOption($wp_customize, 'lz_fitness_faqinnerpagetitleColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Question Text Color', '#000');

addColorPalatOption($wp_customize, 'lz_fitness_faqinnertitlebxbrssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Question Box Border Color', '#000');
addColorPalatOption($wp_customize, 'lz_fitness_faqinnerpagetitleboxborderColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Question Box Background Color', '#fff');
addColorPalatOption($wp_customize, 'lz_fitness_faqinnerpagetextcColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Answer Text color', '#000');
addColorPalatOption($wp_customize, 'lz_fitness_faqinnerpagetextboxbgsscbrssColor', 'lz_fitness_innerpageshortcode_page_settings', 'Select Faq Answer Text Box Background color', '#fff');


$wp_customize->add_section(
	'lz_fitness_innerpagefont_settings',
	array(
		'title' => __( 'Inner Page Fonts Settings', 'lz-fitness-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

lzCustomLable($wp_customize, 'lz_fitness_innerpageh1_fontsizeset', 'lz_fitness_innerpagefont_settings', ' Heading 1:');


$wp_customize->add_setting(
	'pages_innerpageheading',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '35px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading',
	array(
		'settings'      => 'pages_innerpageheading',
		'section'       => 'lz_fitness_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 1 Font Size', 'lz-fitness-premium' )
	)
);


lzCustomLable($wp_customize, 'lz_fitness_innerpageh2_fontsizeset', 'lz_fitness_innerpagefont_settings', ' Heading 2:');


$wp_customize->add_setting(
	'pages_innerpageheading2',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '24px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading2',
	array(
		'settings'      => 'pages_innerpageheading2',
		'section'       => 'lz_fitness_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 2 Font Size', 'lz-fitness-premium' )
	)
);


lzCustomLable($wp_customize, 'lz_fitness_innerpageh3_fontsizeset', 'lz_fitness_innerpagefont_settings', ' Heading 3:');


$wp_customize->add_setting(
	'pages_innerpageheading3',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '18px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading3',
	array(
		'settings'      => 'pages_innerpageheading3',
		'section'       => 'lz_fitness_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 3 Font Size', 'lz-fitness-premium' )
	)
);

lzCustomLable($wp_customize, 'lz_fitness_innerpageh4_fontsizeset', 'lz_fitness_innerpagefont_settings', ' Heading 4:');


$wp_customize->add_setting(
	'pages_innerpageheading4',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '15px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading4',
	array(
		'settings'      => 'pages_innerpageheading4',
		'section'       => 'lz_fitness_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 4 Font Size', 'lz-fitness-premium' )
	)
);

lzCustomLable($wp_customize, 'lz_fitness_innerpageh5_fontsizeset', 'lz_fitness_innerpagefont_settings', ' Heading 5:');


$wp_customize->add_setting(
	'pages_innerpageheading5',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '13px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading5',
	array(
		'settings'      => 'pages_innerpageheading5',
		'section'       => 'lz_fitness_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 5 Font Size', 'lz-fitness-premium' )
	)
);

lzCustomLable($wp_customize, 'lz_fitness_innerpageh6_fontsizeset', 'lz_fitness_innerpagefont_settings', ' Heading 6:');


$wp_customize->add_setting(
	'pages_innerpageheading6',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '10px', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading6',
	array(
		'settings'      => 'pages_innerpageheading6',
		'section'       => 'lz_fitness_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 6 Font Size', 'lz-fitness-premium' )
	)
);