<?php  

$lzFitnessSliderSingleChoice = getFitnessPostsType('slider');

// CREATING A SECTION IN CUSTOMIZER
$wp_customize->add_section(
	'lz_fitness_premium_slider_section',
	array(
		'title' => __( 'Slider Section', 'InsideTours' ),
        'panel' => 'lz_fitness_premium_home_panel',
		'priority' =>18
	)
);

// show content in slider
$wp_customize->add_setting(
	'lz_fitness_premium_slider_show_content',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
	)
);
$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'lz_fitness_premium_slider_show_content',
		array(
			'settings'      => 'lz_fitness_premium_slider_show_content',
			'section'       => 'lz_fitness_premium_slider_section',
			'label'         => __( 'Hide Title and description on slider', 'InsideTours' ),
			'on_off_label'  => array(
				'on' => __( 'No', 'InsideTours' ),
				'off' => __( 'Yes', 'InsideTours' )
			),
		)
	)
);

$wp_customize->add_setting('lz_fitness_premium_slider_section_lbl', array('sanitize_callback'=>'lz_fitness_sanitize_text'));
$wp_customize->add_control(
	new lz_fitness_Info_Text( 
		$wp_customize,
		'lz_fitness_premium_slider_section_lbl',
		array(
			'settings'		=> 'lz_fitness_premium_slider_section_lbl',
			'section'		=> 'lz_fitness_premium_slider_section',
			'label'			=> __( 'Note:', 'InsideTours' ),	
			'description'	=> __( 'The Page featured image works as a slider banner and the title & content work as a slider caption. And you can add this from the Slider menu. <br/> Recommended Image Size: 1900X600', 'InsideTours' ),
		)
	)
);



lzCustomLable($wp_customize, 'lz_fitness_slideropacilty', 'lz_fitness_premium_slider_section', 'Set slider overlay opacity & slider overlay Background color:');


$wp_customize->add_setting(
	'pages_slideopacity',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0.2', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'pages_slideopacity',
	array(
		'settings'      => 'pages_slideopacity',
		'section'       => 'lz_fitness_premium_slider_section',
		'type'          => 'text',
		'label'         => __( 'Add Opacity Here:', 'lz-fitness-premium' )
	)
);
addColorPalatOption($wp_customize, 'slider_overlaybgsColor', 'lz_fitness_premium_slider_section', 'Slider Overlay Background Color', '#000');

lzCustomLable($wp_customize, 'lz_fitness_sliderotherclrs', 'lz_fitness_premium_slider_section', 'Set Slider Title, Subtitle & Button Colors:');

addColorPalatOption($wp_customize, 'slider_SubtitleColor', 'lz_fitness_premium_slider_section', 'Slider Sub Title Color', '#fff');
addColorPalatOption($wp_customize, 'slider_SubtitleborderColor', 'lz_fitness_premium_slider_section', 'Slider Sub Title Border Color', '#fff');

// Slider Title color
addColorPalatOption($wp_customize, 'slider_TitleColor', 'lz_fitness_premium_slider_section', 'Slider Title Color', '#fff');
// Slider Sub Title color

// Slider Button Text color
addColorPalatOption($wp_customize, 'slider_buttontextColor', 'lz_fitness_premium_slider_section', 'Slider Button Text Color', '#fff');
addColorPalatOption($wp_customize, 'slider_buttontexthoverColor', 'lz_fitness_premium_slider_section', 'Slider Button Text Hover Color', '#ff7c4e');
// Slider Button Background color
addColorPalatOption($wp_customize, 'slider_buttonbgColor', 'lz_fitness_premium_slider_section', 'Slider Button Background Color', '#ff7c4e');
addColorPalatOption($wp_customize, 'slider_buttonbghoverColor', 'lz_fitness_premium_slider_section', 'Slider Button Background Hover Color', '#fff');

addColorPalatOption($wp_customize, 'slider_prevandnxtbuttonbghoverColor', 'lz_fitness_premium_slider_section', 'Slider Prev & Next Button Background Color', '#ffffff');
addColorPalatOption($wp_customize, 'slider_prevandnxtbuttonbgsshoverColor', 'lz_fitness_premium_slider_section', 'Slider Prev & Next Button Hover Background Color', '#a39c91');

lzCustomLable($wp_customize, 'lz_fitness_premium_bouncarrdispdisplay', 'lz_fitness_premium_slider_section', 'Bouncing Arrow Display & Color Setting:');
// to show & hide another button
$wp_customize->add_setting( 'bouncingicon_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'bouncingicon_button_display', array( 'label' => 'Bouncing Arrow Display', 'section' => 'lz_fitness_premium_slider_section', 'settings' => 'bouncingicon_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Bouncing Arrow', 'hide' => 'Hide Bouncing Arrow', ), ) ); 
// end to show & hide button

addColorPalatOption($wp_customize, 'slider_bouncingarrowColor', 'lz_fitness_premium_slider_section', 'Slider Bouncing Arrow Color', '#ffffff');
