<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Luzuk Premium
 */
$lz_fitness_lite_single_breadcrumb_section = get_theme_mod('lz_fitness_lite_single_breadcrumb_section', '1');
$lz_fitness_lite_single_tags_section = get_theme_mod('lz_fitness_lite_single_tags_section', '1');
$lz_fitness_lite_authorbox_section = get_theme_mod('lz_fitness_lite_authorbox_section', '1');
$lz_fitness_lite_relatedposts_section = get_theme_mod('lz_fitness_lite_relatedposts_section', '1');

get_header(); ?> 
   <header class="page-main-header">
    <div class="container">
        <?php the_title( '<h1 class="ht-main-title">', '</h1>' ); ?>
       <div class="clearfix"></div>
    </div>
</header><!-- .entry-header -->
<main id="innerpage-box">
    <div class="container">
        <div id="content-box" class="innerpage-whitebox">
           
            <?php if( get_theme_mod('breadcrumb_button_display','show' ) == 'show') :
                ?>
                <div class="breadcrumbbox">
                    <div class='button'><?php lz_fitness_lite_the_breadcrumb(); ?></div>
                        <!--  <?php //lz_fitness_lite_the_breadcrumb(); ?> -->
                </div>

            <?php endif ?>   
        <article class="article">       
            <?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
                <div id="post-<?php the_ID(); ?>" <?php post_class('post'); ?>>
                    <div class="single_post">
                        <header>
                            <?php if( get_theme_mod('postdate_button_display','show' ) == 'show') :
                                 ?>
                            <div class="post-date-publishable"><i class="fa fa-calendar-o" aria-hidden="true"></i><?php the_time( get_option( 'date_format' ) ); ?></div>
                              <?php endif ?> 
                            <!-- Start Title -->
                        </header>
                   
                        <!-- Start Content -->
                        <div id="content" class="post-single-content box mark-links">
                            <?php the_content(); ?>

                            <div class="socialMedia socialMedia-single-bottom text-right">
                               
                                <div class="row">
                                    <div class="col-sm-12 socialbxsinglepost">
                                        <a href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink();?>" target="_blank"><i class="fa fa-facebook" aria-hidden="true"></i></a>
                                        <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink();?>&title=<?php the_title();?>&source=<?php the_title();?>" target="_blank"><i class="fa fa-linkedin" aria-hidden="true"></i></a>
                                        
                                        <a href="https://twitter.com/share?url=<?php the_permalink();?>&amp;text=<?php the_title();?>" target="_blank"><i class="fa fa-twitter" aria-hidden="true"></i></a>
                                        <a href="http://www.digg.com/submit?url=<?php the_permalink();?>" target="_blank"><i class="fa fa-digg" aria-hidden="true"></i></a>
                                    </div>
                                </div>
                            </div>

                            
                            <?php if($lz_fitness_lite_single_tags_section == '1') { ?>
                                <!-- Start Tags -->
                                <div class="tags"><?php the_tags('<span class="tagtext">'.__('Tags','Luzuk Premium').':</span>',', ') ?></div>
                                <!-- End Tags -->
                            <?php } ?>
                        </div><!-- End Content -->
                        

                        <?php if($lz_fitness_lite_authorbox_section == '1') { ?>
                            <!-- Start Author Box 
                            <div class="postauthor">
                                <h4><?php _e('About The Author', 'Luzuk Premium'); ?></h4>
                                <?php //if(function_exists('get_avatar')) { echo get_avatar( get_the_author_meta('email'), '85' );  } ?>
                                <h5><?php //the_author(); ?></h5>
                                <p><?php //the_author_meta('description') ?></p>
                            </div>
                            <!-- End Author Box -->
                        <?php }?>  
                        <?php comments_template( '', true ); ?>
                    </div>
                </div>
            <?php endwhile; ?>
        </article>
        <!-- End Article -->
        <!-- Start Sidebar -->
        <?php // get_sidebar(); ?>
        <!-- End Sidebar -->
    </div>
</div>
</main>
<?php get_footer(); ?>
