<?php

$wp_customize->add_panel(
	'lz_fitness_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'luzuk-premium')
	)
);
//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'luzuk-premium' ),
	'panel' => 'lz_fitness_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'luzuk-premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'luzuk-premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//HEADER LOGO MARGIN SETTINGS
$wp_customize->add_section(
	'lz_fitness_headerlogo_settings',
	array(
		'title' => __( 'Header Logo Margin Settings', 'luzuk-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

lzCustomLable($wp_customize, 'lz_fitness_headerlogo_margin', 'lz_fitness_headerlogo_settings', ' Site Header Logo Margin:');

$wp_customize->add_setting(
	'pages_logoTmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoTmargin',
	array(
		'settings'      => 'pages_logoTmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Top Margin', 'luzuk-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoBmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoBmargin',
	array(
		'settings'      => 'pages_logoBmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Bottom Margin', 'luzuk-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoLmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoLmargin',
	array(
		'settings'      => 'pages_logoLmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Left Margin', 'luzuk-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoRmargin',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '0px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoRmargin',
	array(
		'settings'      => 'pages_logoRmargin',
		'section'       => 'lz_fitness_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Right Margin', 'luzuk-premium' )
	)
);



//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image', 'luzuk-premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'luzuk-premium' ),
	'panel' => 'lz_fitness_general_panel',
) );

//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'luzuk-premium'),
	'panel' => 'lz_fitness_general_panel',
) );
//theme primary color
addColorPalatOption($wp_customize, 'lz_fitness_template_color', 'colors', 'Theme Primary Color', '#a556d4');
// Set heading/title colour
addColorPalatOption($wp_customize, 'lz_fitness_title_color', 'colors', 'Heading Text Color', '#000');
//theme Secondary color
addColorPalatOption($wp_customize, 'theme_secondary_color', 'colors', 'Theme Secondary Color', '#fd7198');





//Inner page title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_titlecolor', 'colors', 'Inner page title color', '#fff');
//Inner page background color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_bgcolor', 'colors', 'Inner page title background color', '#a556d4');

//Inner page content box heading 1 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh1color', 'colors', 'Heading 1 color', '#333333');

//Inner page content box heading 2 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh2color', 'colors', 'Heading 2 color', '#333333');

//Inner page content box heading 3 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh3color', 'colors', 'Heading 3 color', '#333333');

//Inner page content box heading 4 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh4color', 'colors', 'Heading 4 color', '#333333');

//Inner page content box heading 5 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh5color', 'colors', 'Heading 5 color', '#333333');

//Inner page content box heading 6 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh6color', 'colors', 'Heading 6 color', '#333333');

//Inner page content box text color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtextcolor', 'colors', 'Inner page content box text color', '#303030');

//Inner page content box list color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlistcolor', 'colors', 'Inner page content box list color', '#303030');

//Inner page content box list icon color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlisticoncolor', 'colors', 'Inner page content box list icon color', '#a556d4');

//Inner page content box list number color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlistnumbercolor', 'colors', 'Inner page content box list number color', '#fff');

//Inner page content box list number bg color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlistnumberbgcolor', 'colors', 'Inner page content box list number background color', '#a556d4');

//Inner page content box links color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlinkcolor', 'colors', 'Inner page content box links color', '#a556d4');


//Inner page border color
addColorPalatOption($wp_customize, 'template_innerpage_bordercolor', 'colors', 'Inner page border color', '#EEE');


//Inner page table days Color
addColorPalatOption($wp_customize, 'template_innerpage_tabledays_color', 'colors', 'Inner Page Sidebar Table Days Color', '#fff');

//Inner page table days bg Color
addColorPalatOption($wp_customize, 'template_innerpage_tabledaysbg_color', 'colors', 'Inner Page Sidebar Table Days Background Color', '#fd7198');

//Inner page table text Color
addColorPalatOption($wp_customize, 'template_innerpage_tabletext_color', 'colors', 'Inner Page Sidebar Table Text Color', '#6b7385');

//Inner page table box bg Color
addColorPalatOption($wp_customize, 'template_innerpage_tableboxbg_color', 'colors', 'Inner Page Sidebar Table Box Background Color', '#fff');

//Inner page table btn Color
addColorPalatOption($wp_customize, 'template_innerpage_tablebtn_color', 'colors', 'Inner Page Sidebar Table, Form Button Text and category product dropdown hover Color', '#fff');

//Inner page table btn bg Color
addColorPalatOption($wp_customize, 'template_innerpage_tablebtnbg_color', 'colors', 'Inner Page Sidebar Table Button Background Color', '#fd7198');

//Inner Page Social color
addColorPalatOption($wp_customize, 'template_innerpage_socials_color', 'colors', 'Inner Page Social color', '#fff');

//Inner Page widget title color
addColorPalatOption($wp_customize, 'template_innerpage_sidebarwidgettitle_color', 'colors', 'Inner Page Sidebar Widget Title Color', '#fff');

//Inner page box bg Color
addColorPalatOption($wp_customize, 'template_innerpage_boxbg_color', 'colors', 'Inner Page Box Background Color', '#fff');
//Inner page blog box bg Color
addColorPalatOption($wp_customize, 'template_innerpage_blogboxbg_color', 'colors', 'Inner Page Info Box Background Color', '#eee');



//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'lz_fitness_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'lz_fitness_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Breadcrumb', 'hide' => 'Hide Breadcrumb', ), ) ); 

$wp_customize->add_setting(
        'lz_fitness_breadcrumbhometxt',
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text',
            'default'           => __( 'Home', 'luzuk' )
        )
    );
    $wp_customize->add_control(
        'lz_fitness_breadcrumbhometxt',
        array(
            'settings'      => 'lz_fitness_breadcrumbhometxt',
            'section'       => 'lz_fitness_breadcrumb_settings',
            'type'          => 'text',
            'label'         => __( 'Add Breadcrumb Text Here:', 'luzuk' )
        )
    );

//Inner page breadcrumbbox title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbtitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox title color', '#000');
//Inner page breadcrumbbox current title color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbcurrenttitlecolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox current title color', '#a556d4');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbcurrenttitlehovercolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox current title hover color', '#fd7198');

//Inner page breadcrumbbox background color
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbbgcolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox background color', '#fff');
addColorPalatOption($wp_customize, 'lz_fitness_template_innerpage_breadcrumbbgbordercolor', 'lz_fitness_breadcrumb_settings', 'Inner page breadcrumbbox border color', '#ccc');

// end to show & hide button

//INNER PAGE HEADING FONT SIZE SETTINGS
$wp_customize->add_section(
	'innerheadingfontsize_settings',
	array(
		'title' => __( 'Inner Page Heading Font Size Settings', 'luzuk-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

lzCustomLable($wp_customize, 'lz_fitness_headerlogo_margin', 'innerheadingfontsize_settings', ' Inner Page Heading Font Size:');


$wp_customize->add_setting(
	'pages_h1font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '28px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h1font',
	array(
		'settings'      => 'pages_h1font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 1 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h2font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '26px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h2font',
	array(
		'settings'      => 'pages_h2font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 2 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h3font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '24px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h3font',
	array(
		'settings'      => 'pages_h3font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 3 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h4font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '22px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h4font',
	array(
		'settings'      => 'pages_h4font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 4 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h5font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '20px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h5font',
	array(
		'settings'      => 'pages_h5font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 5 Font Size', 'luzuk-premium' )
	)
);


$wp_customize->add_setting(
	'pages_h6font',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '18px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h6font',
	array(
		'settings'      => 'pages_h6font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 6 Font Size', 'luzuk-premium' )
	)
);


//Inner Page Box Padding Setting
$wp_customize->add_section(
	'innerboxpaddiing_settings',
	array(
		'title' => __( 'Inner Page Box Padding Setting', 'luzuk-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

lzCustomLable($wp_customize, 'innerpagebox_padding', 'innerboxpaddiing_settings', ' Inner Page Box Padding Setting:');

$wp_customize->add_setting(
    'innerpagesbox_toppadding',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'innerpagesbox_toppadding',
    array(
        'settings'      => 'innerpagesbox_toppadding',
        'section'       => 'innerboxpaddiing_settings',
        'type'          => 'text',
        'label'         => __( 'Section Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'innerpagesbox_bottompadding',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'innerpagesbox_bottompadding',
    array(
        'settings'      => 'innerpagesbox_bottompadding',
        'section'       => 'innerboxpaddiing_settings',
        'type'          => 'text',
        'label'         => __( 'Section Bottom Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'innerpagesbox_leftpadding',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'innerpagesbox_leftpadding',
    array(
        'settings'      => 'innerpagesbox_leftpadding',
        'section'       => 'innerboxpaddiing_settings',
        'type'          => 'text',
        'label'         => __( 'Section Left Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'innerpagesbox_rightpadding',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'innerpagesbox_rightpadding',
    array(
        'settings'      => 'innerpagesbox_rightpadding',
        'section'       => 'innerboxpaddiing_settings',
        'type'          => 'text',
        'label'         => __( 'Section Right Padding', 'luzuk-premium' )
    )
);




//HEADER SETTINGS
$wp_customize->add_section(
	'lz_fitness_header_settings',
	array(
		'title' => __( 'Header Settings', 'luzuk-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

	//ENABLE/DISABLE STICKY HEADER
$wp_customize->add_setting(
	'lz_fitness_sticky_header_enable',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default' => 'off'
	)
);

$wp_customize->add_control(
	new lz_fitness_Switch_Control(
		$wp_customize,
		'lz_fitness_sticky_header_enable',
		array(
			'settings'		=> 'lz_fitness_sticky_header_enable',
			'section'		=> 'lz_fitness_header_settings',
			'label'			=> __( 'Sticky Header', 'luzuk-premium' ),
			'on_off_label' 	=> array(
				'on' => __( 'Enable', 'luzuk-premium' ),
				'off' => __( 'Disable', 'luzuk-premium' )
			)	
		)
	)
);


addColorPalatOption($wp_customize, 'headersitetitlecol', 'lz_fitness_header_settings', 'Site title Color', '#000000');

addColorPalatOption($wp_customize, 'headersitdescriptioncol', 'lz_fitness_header_settings', 'Site Description Text Color', '#000000');

//top header
$wp_customize->add_setting(
	'lz_fitness_headermain_email',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( 'info@companyname.com', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_email',
	array(
		'settings'      => 'lz_fitness_headermain_email',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Email', 'lz-fitness-premium' )
	)
);
$wp_customize->add_setting(
	'lz_fitness_headermain_location',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '9870 St Vinset Place,Glasgow, DC 45 Fr 45', 'lz-fitness-premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_headermain_location',
	array(
		'settings'      => 'lz_fitness_headermain_location',
		'section'       => 'lz_fitness_header_settings',
		'type'          => 'text',
		'label'         => __( 'Location', 'lz-fitness-premium' )
	)
);


addColorPalatOption($wp_customize, 'headlocationcol', 'lz_fitness_header_settings', 'Location Or Email Text  Color', '#ffffff');

addColorPalatOption($wp_customize, 'headlocationiconscol', 'lz_fitness_header_settings', 'Location Or Email Text Icon Color', '#ffffff');


$sectionHeader = 'lz_fitness_header_settings';
// Adding the Label
lzCustomLable($wp_customize, 'lz_fitness_reservation_lblImgTxt', $sectionHeader, 'Social media icons');
//ADD TEXT BOX FOR FORM SHORTCODE
lzAddElement($wp_customize, 'lz_fitness_header_fb', $sectionHeader, 'text', $label = "Facebook", 'lz_fitness_sanitize_text', 'http://Facbook.com');
lzAddElement($wp_customize, 'lz_fitness_header_tw', $sectionHeader, 'text', $label = "Twitter", 'lz_fitness_sanitize_text', 'http://twitter.com');
lzAddElement($wp_customize, 'lz_fitness_header_in', $sectionHeader, 'text', $label = "LinedIn", 'lz_fitness_sanitize_text', 'http://Linkedin.com');

lzAddElement($wp_customize, 'lz_fitness_header_it', $sectionHeader, 'text', $label = "Instagram", 'lz_fitness_sanitize_text', 'http://Instragram.com');


addColorPalatOption($wp_customize, 'headersocialicon', 'lz_fitness_header_settings', 'Social Icons Color', '#e4cdf2');

addColorPalatOption($wp_customize, 'headersocialiconhover', 'lz_fitness_header_settings', 'Social Icons Hover Color', '#000000');




//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
	'lz_fitness_shopsidebar_settings',
	array(
		'title' => __( 'Shop Page Sidebar Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);


// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'lz_fitness_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Sidebar', 'hide' => 'Hide Sidebar', ), ) ); 
// end to show & hide button


$wp_customize->add_section(
	'innershortcode_page_settings',
	array(
		'title' => __( 'Color Setting For Shortcode Pages', 'luzuk-premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);



//POSTPAGEDATE SETTINGS
$wp_customize->add_section(
	'lz_fitness_postpagedate_settings',
	array(
		'title' => __( 'Post Page Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

//for POSTPAGEDATE to show & hide button

$wp_customize->add_setting( 'postdate_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'postdate_button_display', array( 'label' => 'Post Date Display', 'section' => 'lz_fitness_postpagedate_settings', 'settings' => 'postdate_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Post Date', 'hide' => 'Hide Post Date', ), ) ); 

// end to show & hide button

//for POSTPAGEDATE to show & hide button

$wp_customize->add_setting( 'socialpost_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'socialpost_button_display', array( 'label' => 'Post Social Media Display', 'section' => 'lz_fitness_postpagedate_settings', 'settings' => 'socialpost_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Post Social Media', 'hide' => 'Hide Post Social Media', ), ) ); 

// end to show & hide button


//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'lz_fitness_footer_copyright_settings',
	array(
		'title' => __( 'Footer Settings', 'Luzuk Premium' ),
		'panel' => 'lz_fitness_general_panel',
	)
);

$wp_customize->add_setting(
	'lz_fitness_footer_copyrighttext',
	array(
		'sanitize_callback' => 'lz_fitness_sanitize_text',
		'default'           => __( '© Copyright 2019 play-school-kindergarten. All Rights Reserved', 'Luzuk Premium' )
	)
);
$wp_customize->add_control(
	'lz_fitness_footer_copyrighttext',
	array(
		'settings'      => 'lz_fitness_footer_copyrighttext',
		'section'       => 'lz_fitness_footer_copyright_settings',
		'type'          => 'textarea',
		'label'         => __( 'Footer Copyright Text', 'Luzuk Premium' )
	)
);
