<?php
/**
 * Createing an about us pannel for customizer
 */

// START ABOUT SECTION 
$wp_customize->add_section(
    'lz_fitness_premium_aboutus_section',
    array(
        'title' => __( 'About Us Section', 'lz-fitness-premium' ),  
        'panel' => 'lz_fitness_premium_home_panel'
    )
);
    // ENABLE/DISABLE FEATURED SECTION
$wp_customize->add_setting(
    'lz_fitness_premium_aboutus_section_disable',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
    )
);
$wp_customize->add_control(
    new lz_fitness_Switch_Control(
        $wp_customize,
        'lz_fitness_premium_aboutus_section_disable',
        array(
            'settings'      => 'lz_fitness_premium_aboutus_section_disable',
            'section'       => 'lz_fitness_premium_aboutus_section',
            'label'         => __( 'Disable Section', 'lz-fitness-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'lz-fitness-premium' ),
                'off' => __( 'No', 'lz-fitness-premium' )
            ),
        )
    )
);

    // Manage the background SECTION
// $wp_customize->add_setting(
//     'lz_fitness_aboutus_title_heading1',
//     array(
//         'sanitize_callback' => 'lz_fitness_sanitize_text'
//     )
// );
// $wp_customize->add_control(
//     new lz_fitness_Customize_Heading(
//         $wp_customize,
//         'lz_fitness_aboutus_title_heading1',
//         array(
//             'settings'      => 'lz_fitness_aboutus_title_heading1',
//             'section'       => 'lz_fitness_premium_aboutus_section',
//             'label'         => __( 'Manage background', 'lz-fitness-premium' ),
//         )
//     )
// );
// $wp_customize->add_setting(
//     'lz_fitness_premium_aboutus_section_background',
//     array(
//         'sanitize_callback' => 'lz_fitness_sanitize_text',
//     )
// );
// $wp_customize->add_control(
//     new lz_fitness_Switch_Control(
//         $wp_customize,
//         'lz_fitness_premium_aboutus_section_background',
//         array(
//             'settings'      => 'lz_fitness_premium_aboutus_section_background',
//             'section'       => 'lz_fitness_premium_aboutus_section',
//             'label'         => __( 'Manage background by', 'lz-fitness-premium' ),
//             'on_off_label'  => array(
//                 'on' => __( 'Image', 'lz-fitness-premium' ),
//                 'off' => __( 'Color', 'lz-fitness-premium' )
//             ),
//         )
//     )
// );
$wp_customize->add_setting(
    'lz_fitness_about_bg_color',
    array(
        'default'           => '#fff',
        'sanitize_callback' => 'sanitize_hex_color',
        'priority' => 1
    )
);
$wp_customize->add_control(
    new WP_Customize_Color_Control(
        $wp_customize,
        'lz_fitness_about_bg_color',
        array(
            'settings'      => 'lz_fitness_about_bg_color',
            'section'       => 'lz_fitness_premium_aboutus_section',
            'label'         => __( 'Background Color ', 'lz-fitness-premium' ),
        )
    )
);
$wp_customize->add_setting(
    'lz_fitness_about_bg_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'lz_fitness_about_bg_image',
        array(
            'section' => 'lz_fitness_premium_aboutus_section',
            'settings' => 'lz_fitness_about_bg_image',
            'label' => __( 'Background Image ', 'lz-fitness-premium' ),
            'description' => __('Recommended Image Size: 1900X600px', 'lz-fitness-premium')
        )
    )
);

$wp_customize->add_setting(
    'lz_fitness_aboutus_title_heading',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text'
    )
);
$wp_customize->add_control(
    new lz_fitness_Customize_Heading(
        $wp_customize,
        'lz_fitness_aboutus_title_heading',
        array(
            'settings'      => 'lz_fitness_aboutus_title_heading',
            'section'       => 'lz_fitness_premium_aboutus_section',
            'label'         => __( 'ABOUT Title & Text', 'lz-fitness-premium' ),
        )
    )
);    
$wp_customize->add_setting(
    'lz_fitness_aboutus_title',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( 'ABOUT US', 'lz-fitness-premium' )
    )
);
$wp_customize->add_control(
    'lz_fitness_aboutus_title',
    array(
        'settings'      => 'lz_fitness_aboutus_title',
        'section'       => 'lz_fitness_premium_aboutus_section',
        'type'          => 'text',
        'label'         => __( 'Title for section', 'lz-fitness-premium' )
    )
);
lzAddElement($wp_customize, 'lz_fitness_aboutus_subTitle', 'lz_fitness_premium_aboutus_section', 'textarea', $label="Sub Title", 'lz_fitness_sanitize_text', 'World Best Education In Our Kindergarten');

lzAddElement($wp_customize, 'lz_fitness_aboutus_subtext', 'lz_fitness_premium_aboutus_section', 'textarea', $label="Sub Text", 'lz_fitness_sanitize_text', 'Loreum Ipsum is simply dummy text of the printing and typesetting industry. Loreum Ipsum has been the industry standard dummy text ever since the 1500s,when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has servieved not only five centuries but also the leap into electronic typesetting.');


$wp_customize->add_setting(
    'lz_fitness_aboutus_text',
    array(
        'sanitize_callback'=>'lz_fitness_sanitize_text',
        'default'=> __('
            <ul>
            <li>It was popularised in the 1960s with the release of Letraset sheets containing Loreum Ipsum passages, and more recently with desktop publishing software like Aldus Pagemaker including version of Loreum Ipsum.</li>
            <li>Loreum Ipsum is simply dummy text of the printing and typesetting industry. Loreum Ipsum has been the industry standard dummy text ever since the 1500s.</li>
            </ul>
            ', 'lz-fitness-premium')
    )
);
$wp_customize->add_control(
    'lz_fitness_aboutus_text',
    array(
        'settings' =>'lz_fitness_aboutus_text',
        'section' => 'lz_fitness_premium_aboutus_section',
        'type'=> 'textarea',
        'label'=> __('Sub Content for the section', 'lz-fitness-premium')
    )
);
// $wp_customize->add_setting(
//     'lz_fitness_aboutus_page',
//     array(
//         'sanitize_callback'=> 'absint',
//         'default' => __('About Page Readmore Link', 'lz-fitness-premium')
//     )
// );
// $wp_customize->add_control(
//     'lz_fitness_aboutus_page',
//     array(
//         'settings'=> 'lz_fitness_aboutus_page',
//         'section' => 'lz_fitness_premium_aboutus_section',
//         'type'=>'select',
//         'label'=>__('Link to About us page', 'lz-fitness-premium'),
//         'choices'=>$lz_fitness_page_choice
//     )
// );

    // Heading color
addColorPalatOption($wp_customize, 'lz_fitness_aboutus_page_HeadingColor', 'lz_fitness_premium_aboutus_section', 'Heading color', '#a556d4');
    // Text color
addColorPalatOption($wp_customize, 'lz_fitness_aboutus_page_TextColor', 'lz_fitness_premium_aboutus_section', 'Text color', '#333333');
 // span Text color
//addColorPalatOption($wp_customize, 'lz_fitness_aboutus_page_sTextColor', 'lz_fitness_premium_aboutus_section', 'Span Text color', '#a556d4');

backgroundManager($wp_customize, 'about', 'lz_fitness_premium_aboutus_section', $color='#ffffff', get_template_directory_uri().'/images/blogbanner.png', 'color');


$wp_customize->add_setting(
    'lz_fitness_about_image_heading',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text'
    )
);
$wp_customize->add_control(
    new lz_fitness_Customize_Heading(
        $wp_customize,
        'lz_fitness_about_image_heading',
        array(
            'settings'      => 'lz_fitness_about_image_heading',
            'section'       => 'lz_fitness_premium_aboutus_section',
            'label'         => __( 'Right Image', 'lz-fitness-premium' ),
        )
    )
);
$wp_customize->add_setting(
    'lz_fitness_about_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'lz_fitness_about_image',
        array(
            'section' => 'lz_fitness_premium_aboutus_section',
            'settings' => 'lz_fitness_about_image',
            'description' => __('Recommended Image Size: 500X600px', 'lz-fitness-premium')
        )
    )
);
    // END ABOUT SECTION 