<?php
/**
 * Customiser section for featured
 **/
// Start Feature section 
$wp_customize->add_section(
    'lz_fitness_featured_section',
    array(
        'title' => __( 'Services Section', 'luzuk-premium' ),
        'panel' => 'lz_fitness_premium_home_panel'
    )
);
// ENABLE/DISABLE FEATURED SECTION
$wp_customize->add_setting(
    'lz_fitness_featured_section_disable',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
    )
);
$wp_customize->add_control(
    new lz_fitness_Switch_Control(
        $wp_customize,
        'lz_fitness_featured_section_disable',
        array(
            'settings'      => 'lz_fitness_featured_section_disable',
            'section'       => 'lz_fitness_featured_section',
            'label'         => __( 'Disable Section', 'luzuk-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk-premium' ),
                'off' => __( 'No', 'luzuk-premium' )
            ),
        )
    )
);

backgroundManager($wp_customize, 'featured', 'lz_fitness_featured_section', $color='#f6f6f6');

$wp_customize->add_setting(
    'lz_fitness_featured_title_sub_title_heading',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text'
    )
);
$wp_customize->add_control(
    new lz_fitness_Customize_Heading(
        $wp_customize,
        'lz_fitness_featured_title_sub_title_heading',
        array(
            'settings'      => 'lz_fitness_featured_title_sub_title_heading',
            'section'       => 'lz_fitness_featured_section',
            'label'         => __( 'Section Title & Sub Title', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting(
    'lz_fitness_featured_title',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( 'OUR Services', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'lz_fitness_featured_title',
    array(
        'settings'      => 'lz_fitness_featured_title',
        'section'       => 'lz_fitness_featured_section',
        'type'          => 'text',
        'label'         => __( 'Title', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'lz_fitness_featured_sub_title',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( 'CHOOSE YOUR DESIRED COURSE', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'lz_fitness_featured_sub_title',
    array(
        'settings'      => 'lz_fitness_featured_sub_title',
        'section'       => 'lz_fitness_featured_section',
        'type'          => 'textarea',
        'label'         => __( 'Sub Title', 'luzuk-premium' ),
    )
);

    // Heading color
    addColorPalatOption($wp_customize, 'lz_fitness_featured_HeadingColor', 'lz_fitness_featured_section', 'Heading color '. $headingColor, '#2a2a2a');
    // Text color
    addColorPalatOption($wp_customize, 'lz_fitness_featured_TextColor', 'lz_fitness_featured_section', 'Text color', '#4f4f4f');

$wp_customize->add_setting('lz_fitness_featured_npp_heading',array('sanitize_callback' => 'lz_fitness_sanitize_text'));
$wp_customize->add_control(
    new lz_fitness_Customize_Heading(
        $wp_customize,
        'lz_fitness_featured_npp_heading',
        array(
            'settings'      => 'lz_fitness_featured_npp_heading',
            'section'       => 'lz_fitness_featured_section',
            'label'         => __( 'Number Of featured Plans', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('lz_fitness_featured_npp_count',array('sanitize_callback' => 'lz_fitness_sanitize_text','default' => 3));
$wp_customize->add_control(
    'lz_fitness_featured_npp_count',
    array(
        'settings'      => 'lz_fitness_featured_npp_count',
        'section'       => 'lz_fitness_featured_section',
        'type'          => 'select',
        'label'         => __( 'Number of plan to show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6)
    )
);

//FEATURED PAGES
for( $i = 1; $i <= 6; $i++ ){
    $wp_customize->add_setting(
        'lz_fitness_featured_header'.$i,
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Customize_Heading(
            $wp_customize,
            'lz_fitness_featured_header'.$i,
            array(
                'settings'      => 'lz_fitness_featured_header'.$i,
                'section'       => 'lz_fitness_featured_section',
                'label'         => __( 'Featured Page ', 'luzuk-premium' ).$i
            )
        )
    );


    $wp_customize->add_setting(
        'lz_fitness_featured_page'.$i,
        array(
            'sanitize_callback' => 'absint'
        )
    );
    $wp_customize->add_control(
        'lz_fitness_featured_page'.$i,
        array(
            'settings'      => 'lz_fitness_featured_page'.$i,
            'section'       => 'lz_fitness_featured_section',
            'type'          => 'dropdown-pages',
            'label'         => __( 'Select a Page', 'luzuk-premium' )
        )
    );
    
	$wp_customize->add_setting(
        'lz_fitness_featured_page_icon'.$i,
        array(
            'default'           => 'fa fa-bell',
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new lz_fitness_Fontawesome_Icon_Chooser(
            $wp_customize,
            'lz_fitness_featured_page_icon'.$i,
            array(
                'settings'      => 'lz_fitness_featured_page_icon'.$i,
                'section'       => 'lz_fitness_featured_section',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'luzuk-premium' ),
            )
        )
    );
	
	//my edit code
	$wp_customize->add_control( 
	'lz_fitness_featured_page', 
	array(
	'settings'=> 'lz_fitness_featured_page', 
	'section' => 'lz_fitness_featured_section', 
	'type'=>'select', 
	'label'=>__('Link to featured page', 'lz-featured-premium'), 
	//'choices'=>$lz_featured_page_choice 
		) 
	);
	
	$wp_customize->add_setting(
	'lz_fitness_featured_image_heading', 
	array(
	'sanitize_callback' => 'lz_fitness_sanitize_text' 
		) 
	); 
	
	$wp_customize->add_control(
	new lz_fitness_Customize_Heading(
	$wp_customize, 
	'lz_fitness_featured_image_heading', 
	array(
	'settings' => 'lz_fitness_featured_image_heading', 
	'section' => 'lz_fitness_featured_section', 
	'label' => __( 'Right Image', 'lz-featured-premium' ), 
			) 
		) 
	); 
	
	$wp_customize->add_setting(
	'lz_fitness_featured_image', 
	array( 
	'sanitize_callback' => 'esc_url_raw' 
		) 
	);
	
	$wp_customize->add_control(
	new WP_Customize_Image_Control(
	$wp_customize, 
	'lz_fitness_featured_image', 
	array(
	'section' => 'lz_fitness_featured_section',
	'settings' => 'lz_fitness_featured_image',
	'description' => __('Recommended Image Size: 500X600px', 'lz-featured-premium') 
			)
		) 
	);

  
    // Title color
    addColorPalatOption($wp_customize, 'lz_fitness_featured_TitleColor', 'lz_fitness_featured_section', 'Title color', '#2a2a2a');
    // Icon color
    addColorPalatOption($wp_customize, 'lz_fitness_featured_IconColor', 'lz_fitness_featured_section', 'Icon color', '#ffffff');
    
}
// End Feature section 