<?php

$wp_customize->add_panel(
	'luzuk_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'Luzuk Premium')
	)
);
//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'Luzuk Premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );
addColorPalatOption($wp_customize, 'header_SiteColor', 'title_tagline', 'Site Title Color', '#ef2853');
addColorPalatOption($wp_customize, 'header_SiteTaglineColor', 'title_tagline', 'Tagline Color', '#000');

lzCustomLable($wp_customize, 'pageslogosetmaxwidthl', 'title_tagline', 'Add Logo Max Width:');

$wp_customize->add_setting(
    'pages_logoTopsetmaxwidth',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '100', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoTopsetmaxwidth',
    array(
        'settings'      => 'pages_logoTopsetmaxwidth',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Set Logo Max Width', 'luzuk-premium' )
    )
);


lzCustomLable($wp_customize, 'pageslogopaddingl', 'title_tagline', 'Add Logo Padding:');

$wp_customize->add_setting(
    'pages_logoTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '18px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoTpadding',
    array(
        'settings'      => 'pages_logoTpadding',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Set Logo Top Padding', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'pages_logoBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoBpadding',
    array(
        'settings'      => 'pages_logoBpadding',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Set Logo Bottom Padding', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'pages_logoLpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoLpadding',
    array(
        'settings'      => 'pages_logoLpadding',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Set Logo Left Padding', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'pages_logoRpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoRpadding',
    array(
        'settings'      => 'pages_logoRpadding',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Set Logo Right Padding', 'luzuk-premium' )
    )
);



//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image Setting', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );


//HEADER SETTINGS
$wp_customize->add_section(
	'header_settings',
	array(
		'title' => __( 'Header Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'stickyheader_view', 'header_settings', 'Sticky Header Settings');
    //ENABLE/DISABLE STICKY HEADER
$wp_customize->add_setting(
    'luzuk_sticky_header_enable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);

$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'luzuk_sticky_header_enable',
        array(
            'settings'      => 'luzuk_sticky_header_enable',
            'section'       => 'header_settings',
            'label'         => __( 'Sticky Header', 'Luzuk Themethemes Premium' ),
            'on_off_label'  => array(
                'on' => __( 'Enable', 'luzuk-premium' ),
                'off' => __( 'Disable', 'luzuk-premium' )
            )   
        )
    )
);


$sectionHeader = 'header_settings';

lzCustomLable($wp_customize, 'header_bgColorssettings', $sectionHeader, 'Header Setting');

addColorPalatOption($wp_customize, 'header_bgColor', 'header_settings', 'Logo Background Color', '#fff');
addColorPalatOption($wp_customize, 'header_albgColor', 'header_settings', 'Header Background Color', '#f8f8f8');

lzCustomLable($wp_customize, 'header_condetailsTxt', 'header_settings', 'Set Header Contact Details:');

$wp_customize->add_setting(
    'header_emailid',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'info.studio@mail.com' )
    )
);
$wp_customize->add_control(
    'header_emailid',
    array(
        'settings'      => 'header_emailid',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Email Id', 'Luzuk Premium' )
    )
);

$wp_customize->add_setting(
    'header_phhone',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '+(012)1258 5789' )
    )
);
$wp_customize->add_control(
    'header_phhone',
    array(
        'settings'      => 'header_phhone',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Phone No.', 'Luzuk Premium' )
    )
);

addColorPalatOption($wp_customize, 'header_mailphoneColor', 'header_settings', 'Email & Phone No. Color', '#fff'); 
addColorPalatOption($wp_customize, 'header_mailphoneiconColor', 'header_settings', 'Email & Phone No. Icon Color', '#ef2853'); 
addColorPalatOption($wp_customize, 'header_mailphonehoverColor', 'header_settings', 'Email & Phone No. Hover Color', '#ef2853');



lzCustomLable($wp_customize, 'form_button_displaylabel', 'header_settings', 'Header Search Icon Display Setting:');
// to show & hide another button
$wp_customize->add_setting( 'form_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'form_button_display', array( 'label' => 'Header Search Icon Display', 'section' => 'header_settings', 'settings' => 'form_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Shop Cart', 'hide' => 'Hide Shop Cart', ), ) ); 

addColorPalatOption($wp_customize, 'header_searchicnclr', 'header_settings', 'Search Icon Color', '#000');
//addColorPalatOption($wp_customize, 'header_searchfrmbgclr', 'header_settings', 'Search Form Border Color', '#000');
addColorPalatOption($wp_customize, 'header_searchfrmtxtclr', 'header_settings', 'Search Form Text Color', '#000');
addColorPalatOption($wp_customize, 'header_searchfrmtxtbgclr', 'header_settings', 'Search Form Text Background Color', '#fff');
addColorPalatOption($wp_customize, 'header_searchfrmtbgclr', 'header_settings', 'Search Form Background Color', '#000');
addColorPalatOption($wp_customize, 'header_searchfrmtbrdclr', 'header_settings', 'Search Form Border Color', '#ef2853');
addColorPalatOption($wp_customize, 'header_searchfrmbtntxtclr', 'header_settings', 'Search Form Button Icon Color', '#000');
addColorPalatOption($wp_customize, 'header_searchfrmbtnbgclr', 'header_settings', 'Search Form Button Background Color', '#ef2853');
addColorPalatOption($wp_customize, 'header_searchfrmbtnbghvclr', 'header_settings', 'Search Form Button Background Hover Color', '#ccc');

lzCustomLable($wp_customize, 'shop_button_displaylabel', 'header_settings', 'Header Shoping Cart Display Setting:');
// to show & hide another button
$wp_customize->add_setting( 'shop_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'shop_button_display', array( 'label' => 'Header Shoping Cart Display', 'section' => 'header_settings', 'settings' => 'shop_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Shop Cart', 'hide' => 'Hide Shop Cart', ), ) ); 
// end to show & hide button

$wp_customize->add_setting('header_cartlink',  array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_cartlink',
    array(
        'settings'      => 'header_cartlink',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'Add "Header Cart" link here', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'header_cartclr', 'header_settings', 'Add To Cart Icon Color', '#000');

addColorPalatOption($wp_customize, 'header_carthvclr', 'header_settings', 'Add To Cart Icon Hover Color', '#ef2853');


lzCustomLable($wp_customize, 'header_MenuColorssettings', $sectionHeader, 'Navigation Colors');


addColorPalatOption($wp_customize, 'header_topmenusColor', 'header_settings', 'Menus Color', '#4c4c4c');

addColorPalatOption($wp_customize, 'header_topmenushoverColor', 'header_settings', 'Menus Hover Color', '#ef2853');

addColorPalatOption($wp_customize, 'header_topmenusactiveColor', 'header_settings', 'Active Menus Color', '#ef2853');

//addColorPalatOption($wp_customize, 'header_actmenusbgClr', 'header_settings', 'Menus Hover Background & Active Menus Background Color', '#62cdb9');

addColorPalatOption($wp_customize, 'header_topmenusarrowColor', 'header_settings', 'Menus Dropdown Arrow Color', '#858585');

addColorPalatOption($wp_customize, 'header_topsubmenusColor', 'header_settings', 'Header Sub Menus Color', '#ffffff');

addColorPalatOption($wp_customize, 'header_topsubmenushvColor', 'header_settings', 'Header Sub Menus Hover Color', '#fff');

addColorPalatOption($wp_customize, 'header_topsubmenushvrbgColor', 'header_settings', 'Sub Menus Hover Background Color', '#ef2853');

addColorPalatOption($wp_customize, 'header_submenusbgsscColor', 'header_settings', 'Dropdown Background Color', '#000');


lzCustomLable($wp_customize, 'header_colorsfortabandmobview', $sectionHeader, 'Responsive Header Settings');

addColorPalatOption($wp_customize, 'header_topsubmenuiconColor', 'header_settings', 'Header Menus Dropdown Icon Color', '#ef2853');
addColorPalatOption($wp_customize, 'topheaderemilclr', 'header_settings', 'Header Email & Phone Icon Text Color', '#000');

addColorPalatOption($wp_customize, 'header_respnavtoggbarbgssColor', 'header_settings', 'Toggle Bar Color', '#ef2853');

addColorPalatOption($wp_customize, 'header_respnavbsbgssColor', 'header_settings', ' Navigation Box Background Color', '#fff');
addColorPalatOption($wp_customize, 'header_navigationrespnavbrssColor', 'header_settings', 'Navigation Box Border Color', '#ef2853');

//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'Luzuk Premium'),
	'panel' => 'luzuk_general_panel',
) );
//theme primary color
addColorPalatOption($wp_customize, 'luzuk_template_color', 'colors', 'Theme Primary Color', '#ef2853');
//theme Secondary color
addColorPalatOption($wp_customize, 'theme_secondary_color', 'colors', 'Theme Secondary Color', '#3f3f3f');

lzCustomLable($wp_customize, 'luzuk_allinnerpagesec_colordisplaysettdisplay', 'colors', 'Color Setting For Innerpage Colors:');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_titlecolor', 'colors', 'Inner Page Title Color', '#fff');
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_bgcolor1', 'colors', 'Inner Page Title Background Color One', '#ccc'); 
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_bgcolor2', 'colors', 'Inner Page Title Background Color Two', '#0a0607'); 

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionbox_color', 'colors', 'Inner Page Box Background Color', '#ffffff');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading1_color', 'colors', 'Heading 1 Color', '#121a36');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading2_color', 'colors', 'Heading 2 Color', '#121a36');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading3_color', 'colors', 'Heading 3 Color', '#121a36');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading4_color', 'colors', 'Heading 4 Color', '#121a36');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading5_color', 'colors', 'Heading 5 Color', '#121a36');
addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxheading6_color', 'colors', 'Heading 6 Color', '#121a36');

addColorPalatOption($wp_customize, 'innerpagemainsectioninnerpagemainsectionboxheadingborderc1', 'colors', 'Heading Border Color', '#ef2853');

addColorPalatOption($wp_customize, 'template_innerpage_contentboxsidebartitlecolor', 'colors', 'Inner Page Sidebar Heading', '#676767');

addColorPalatOption($wp_customize, 'template_innerpage_contentboxsidebartitlebordercolor', 'colors', 'Inner Page Sidebar Heading Border & Product Button Background Color', '#ef2853');


addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtext_color', 'colors', 'Inner Page Text Color', '#666');

addColorPalatOption($wp_customize, 'template_innerpage_productpageboldtextcolor', 'colors', 'Inner Product Page Bold Text Color', '#000');

addColorPalatOption($wp_customize, 'template_innerpage_cartpageproducttitlecolor', 'colors', 'Inner  Cart Page Product Title Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_template_innerpageproductprice_color', 'colors', 'Inner Page Product Selling Price Color', '#ef2853');

addColorPalatOption($wp_customize, 'luzuk_template_innerpageproductpricedel_color', 'colors', 'Inner Page Product Price Color', '#7c8491');

addColorPalatOption($wp_customize, 'luzuk_template_innerpageallothrtheadtextcolcolor_color', 'colors', 'Other Text Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_template_innerpageallothrtheadtextbgsscolcolor_color', 'colors', 'Other Fields Background Color', '#fff');



addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtextlinks_color', 'colors', 'Inner Page Links Color', '#4f4c4c');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtextlinkshvrs_color', 'colors', 'Inner Page Links Hover Color', '#131313');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtextlinksicon_color', 'colors', 'Inner Page Icons, list number Color', '#ef2853');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionboxtextlinksiconbgssclr_color', 'colors', 'Inner Page list number Background Color', '#b5b1b3');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagemainsectionsidebarborderrs_color', 'colors', 'Inner Page Sidebar & text field Border Color', '#e9e7e7');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagesidebardaytxt_color', 'colors', 'Inner Page Sidebar Calender Widgets Day Text Color', '#ffffff');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagesidebardaybgsstxt_color', 'colors', 'Inner Page Sidebar Calender Widgets Day Text Background Color', '#ef2853');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagesblockquote_color', 'colors', 'Inner Page blockquote Background Color', '#f2f2f2');


lzCustomLable($wp_customize, 'luzuk_allinnerpagesec_pagination', 'colors', 'Color Setting For Pagination:');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagepagination_color', 'colors', 'Inner Page Pagination Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagepaginationbg_color', 'colors', 'Inner Page Pagination Background Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagepaginationborder_color', 'colors', 'Inner Page Pagination Border Color', '#eaeaea');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagepaginationactive_color', 'colors', 'Inner Page Pagination Hover & Active Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagepaginationbgactive_color', 'colors', 'Inner Page Pagination Background Hover & Active Color', '#ef2853');

addColorPalatOption($wp_customize, 'luzuk_template_innerpagepaginationborderactive_color', 'colors', 'Inner Page Pagination Border Hover & Active Color', '#ef2853');

lzCustomLable($wp_customize, 'luzuk_allinnerpagesec_colordisplaysettnavbackttoarrdisplay', 'colors', 'Color Setting For Navigation Back to top arrow:');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_backttoparrcbgcolor', 'colors', 'Site Navigation Arrow Color', '#ef2853');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_backttoparrcbghvrcolor', 'colors', 'Site Navigation Arrow Hover Color', '#000');


//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'luzuk_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'luzuk_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Hide Breadcrumb', 'hide' => 'Show Breadcrumb', ), ) ); 

$wp_customize->add_setting(
        'luzuk_breadcrumbhometxt',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Home', 'luzuk' )
        )
    );
    $wp_customize->add_control(
        'luzuk_breadcrumbhometxt',
        array(
            'settings'      => 'luzuk_breadcrumbhometxt',
            'section'       => 'luzuk_breadcrumb_settings',
            'type'          => 'text',
            'label'         => __( 'Add Breadcrumb Text Here:', 'luzuk' )
        )
    );

//Inner page breadcrumbbox title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbtitlecolor', 'luzuk_breadcrumb_settings', 'Inner Page Breadcrumb Box Title Color', '#fff');
//Inner page breadcrumbbox current title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlecolor', 'luzuk_breadcrumb_settings', 'Inner Page Breadcrumb Box Current Title Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlehovercolor', 'luzuk_breadcrumb_settings', 'Inner Page Breadcrumb Box Current Title Hover Color', '#121212');
// end to show & hide button

//POSTPAGEDATE SETTINGS
$wp_customize->add_section(
	'luzuk_blogpage_settings',
	array(
		'title' => __( 'Blog Page Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'allblog_heading2label', 'luzuk_blogpage_settings', 'Post Heading Font Size Setting:');

$wp_customize->add_setting(
    'blogpages_innerpageheading2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '23px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blogpages_innerpageheading2',
    array(
        'settings'      => 'blogpages_innerpageheading2',
        'section'       => 'luzuk_blogpage_settings',
        'type'          => 'text',
        'label'         => __( 'Post Heading Font Size', 'luzuk-premium' )
    )
);




lzCustomLable($wp_customize, 'allblog_lblbuttonabtdisplay', 'luzuk_blogpage_settings', 'Post Date & Admin Display Setting:');

//for POSTPAGEDATE to show & hide button

$wp_customize->add_setting( 'postdate_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'postdate_button_display', array( 'label' => 'Post Date Display', 'section' => 'luzuk_blogpage_settings', 'settings' => 'postdate_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Post Date & Admin', 'hide' => 'Hide Post Date & Admin', ), ) ); 

// end to show & hide button


lzCustomLable($wp_customize, 'singleblog_lblbuttonabtdisplay', 'luzuk_blogpage_settings', 'Post Social Icons Display Setting:');


//for POSTPAGEsocialsshare to show & hide button

$wp_customize->add_setting( 'postsocialsshare_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'postsocialsshare_button_display', array( 'label' => 'Post social Icons Display', 'section' => 'luzuk_blogpage_settings', 'settings' => 'postsocialsshare_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Social Icons', 'hide' => 'Hide Social Icons', ), ) ); 

// end to show & hide button

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogimgoverlaycolor1', 'luzuk_blogpage_settings', 'Blog Page Image Hover Overlay Color One', '#131313');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogimgoverlaycolor2', 'luzuk_blogpage_settings', 'Blog Page Image Hover Overlay Color Two', '#ef2853');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogbuttoniconcolor', 'luzuk_blogpage_settings', 'Blog Page Image Hover Icon Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogbuttoniconbgcolor', 'luzuk_blogpage_settings', 'Blog Page Image Hover Icon Background Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogbuttoniconhovercolor', 'luzuk_blogpage_settings', 'Blog Page Image Hover Icon Hover Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogbuttoniconbghovercolor', 'luzuk_blogpage_settings', 'Blog Page Image Hover Icon Background Hover Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogdateathorclr', 'luzuk_blogpage_settings', 'Blog Page Author & Date Color', '#ef2853');

//Blog page title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogtitlecolor', 'luzuk_blogpage_settings', 'Blog Page Title Color', '#3d3d3d');
//Blog page title hover color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogtitlehovercolor', 'luzuk_blogpage_settings', 'Blog Page Title Hover Color', '#ef2853');

//Blog page social color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogsocialcolor', 'luzuk_blogpage_settings', 'Blog Page Social Color', '#fff');
//Blog page social color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogsocialbgcolor', 'luzuk_blogpage_settings', 'Blog Page Social Background Color', '#ef2853');
//Blog page social hover color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogsocialhovercolor', 'luzuk_blogpage_settings', 'Blog Page Social Hover Color', '#fff');
//Blog page social color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_blogsocialbghovercolor', 'luzuk_blogpage_settings', 'Blog Page Social Background Hover Color', '#000');


//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'footer_area',
	array(
		'title' => __( 'Footer Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

backgroundManager($wp_customize, 'footer', 'footer_area', $color='#191919', get_template_directory_uri().'/images/default-gray.png', 'color');


lzCustomLable($wp_customize, 'footer_areaPadding', 'footer_area', 'Set Footer Padding');

$wp_customize->add_setting(
    'sec_footerseTmargin', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_footerseTmargin',
    array(
        'settings'      => 'sec_footerseTmargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'sec_footersebottommargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_footersebottommargin',
    array(
        'settings'      => 'sec_footersebottommargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'footer_copytext', 'footer_area', 'Footer Copyright Text:');

$wp_customize->add_setting(
    'footer_area_copyrighttext',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Copyright @ All right reserved studio design', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'footer_area_copyrighttext',
    array(
        'settings'      => 'footer_area_copyrighttext',
        'section'       => 'footer_area',
        'type'          => 'textarea',
        'label'         => __( 'Footer Copyright Text', 'Luzuk Premium' )
    )
);


addColorPalatOption($wp_customize, 'footerarea_copyright_color', 'footer_area', 'Footer Copyright Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_title_color', 'footer_area', 'Footer Title Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_text_color', 'footer_area', 'Footer Text & Icon Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_hglightsctext_color', 'footer_area', 'Footer Hightlight Text Color', '#ef2853');

addColorPalatOption($wp_customize, 'footerarea_sicon_color', 'footer_area', 'Footer Social Icon Color', '#898d90');

addColorPalatOption($wp_customize, 'footerarea_siconhover_color', 'footer_area', 'Footer Social Icon Hover Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_siconbrd', 'footer_area', 'Footer Social Icon Border Color', '#898d90');

addColorPalatOption($wp_customize, 'footerarea_siconbrdhv', 'footer_area', 'Footer Social Icon Border Hover Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_menu_color', 'footer_area', 'Footer Menu Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_menuhover_color', 'footer_area', 'Footer Menu Hover Color', '#ef2853');

addColorPalatOption($wp_customize, 'footerarea_activemenu_color', 'footer_area', 'Active Menu Color', '#ef2853');

addColorPalatOption($wp_customize, 'footerarea_datext_color', 'footer_area', 'Date Text Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_tableborder_color', 'footer_area', 'Border Color', '#555555');

addColorPalatOption($wp_customize, 'footerarea_formtextlabel_color', 'footer_area', 'Label Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_formtext_color', 'footer_area', 'Form Text & Placeholder Text Color', '#fff');

addColorPalatOption($wp_customize, 'footerareabutton_bg_color', 'footer_area', 'Button Background Color', '#ef2853');

addColorPalatOption($wp_customize, 'footerareabutton_bghover_color', 'footer_area', 'Button Background Hover Color', '#000');

//addColorPalatOption($wp_customize, 'footerarea_contactdata_color', 'footer_area', 'Footer Contact Data Color', '#777777');

addColorPalatOption($wp_customize, 'footerarea_otherfbgs_color', 'footer_area', 'Other Fields Background Color', '#2a2a2a');

//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
	'luzuk_shopsidebar_settings',
	array(
		'title' => __( 'Shop Page Sidebar Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);


// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'luzuk_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Sidebar', 'hide' => 'Hide Sidebar', ), ) ); 
// end to show & hide button

$wp_customize->add_setting(
    'productpages_productheading2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '20px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'productpages_productheading2',
    array(
        'settings'      => 'productpages_productheading2',
        'section'       => 'luzuk_shopsidebar_settings',
        'type'          => 'text',
        'label'         => __( 'Product Heading Font Size', 'luzuk-premium' )
    )
);


$wp_customize->add_section(
	'luzuk_innerpageshortcode_page_settings',
	array(
		'title' => __( 'Color Setting For Shortcode Pages', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'luzuk_servicepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Services Shortcode Page Colors:'); 


lzCustomLable($wp_customize, 'luzuk_servicepagelable', 'luzuk_innerpageshortcode_page_settings', 'Note: Set Services page images of equal height.');


addColorPalatOption($wp_customize, 'servicearea_Innerimghoverbg_color_one', 'luzuk_innerpageshortcode_page_settings', 'Services Image Hover Color', '#ef2853');

addColorPalatOption($wp_customize, 'luzuk_InnerServiceTextColor', 'luzuk_innerpageshortcode_page_settings', 'Services Box Background Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_InnerServicebxbrdoclr', 'luzuk_innerpageshortcode_page_settings', 'Services Box Border Color', '#e7e7e7');

addColorPalatOption($wp_customize, 'luzuk_InnerServiceicnColor', 'luzuk_innerpageshortcode_page_settings', 'Service Icon Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_InnerServiceicnbgColor', 'luzuk_innerpageshortcode_page_settings', 'Service Icon Background Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_InnerServiceicnbghvColor', 'luzuk_innerpageshortcode_page_settings', 'Service Icon Hover Color', '#ef2853');

addColorPalatOption($wp_customize, 'luzuk_InnerServiceTitleColor', 'luzuk_innerpageshortcode_page_settings', 'Service Title Color', '#131313');

addColorPalatOption($wp_customize, 'InnerSerTitlehvColor', 'luzuk_innerpageshortcode_page_settings', 'Service Title Hover Color', '#ef2853');


lzCustomLable($wp_customize, 'luzuk_eventpageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Events Shortcode Page Colors:');

lzCustomLable($wp_customize, 'luzuk_eventpagelable', 'luzuk_innerpageshortcode_page_settings', 'Note: Set Events images of equal height.');

addColorPalatOption($wp_customize, 'pages_InnereventbxbgClr', 'luzuk_innerpageshortcode_page_settings', 'Event Box Background Color', '#fff');

addColorPalatOption($wp_customize, 'pages_InnereventimgobClr', 'luzuk_innerpageshortcode_page_settings', 'Event Image Overlay Color', '#ef2853');

addColorPalatOption($wp_customize, 'pages_InnereventimgoboxClr', 'luzuk_innerpageshortcode_page_settings', 'Event Box Border Color', '#000');

addColorPalatOption($wp_customize, 'pages_InnereventoboxdateplceClr', 'luzuk_innerpageshortcode_page_settings', 'Event Box Date & Place Color', '#ef2853');

addColorPalatOption($wp_customize, 'pages_InnereventoboxtitleClr', 'luzuk_innerpageshortcode_page_settings', 'Event Box Title Color', '#000');

addColorPalatOption($wp_customize, 'pages_InnereventoboxtitlehvClr', 'luzuk_innerpageshortcode_page_settings', 'Event Box Title Hover Color', '#ef2853');

addColorPalatOption($wp_customize, 'pages_InnereventoboxtxtClr', 'luzuk_innerpageshortcode_page_settings', 'Event Box Text Color', '#858585');

$wp_customize->add_setting( 'event_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'event_button_display', array( 'label' => 'Section Button Display', 'section' => 'luzuk_innerpageshortcode_page_settings', 'settings' => 'event_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) );

$wp_customize->add_setting(
        'event_button',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Read More', 'Luzuk' )
        )
    );
    $wp_customize->add_control(
        'event_button',
        array(
            'settings'      => 'event_button',
            'section'       => 'luzuk_innerpageshortcode_page_settings',
            'type'          => 'text',
            'label'         => __( 'Add Button Text Here', 'Luzuk' )
        )
    );

addColorPalatOption($wp_customize, 'pages_Innereventbtntxtclr', 'luzuk_innerpageshortcode_page_settings', 'Event Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'pages_Innereventbtntxthvclr', 'luzuk_innerpageshortcode_page_settings', 'Event Button Text Hover Color', '#ef2853');

addColorPalatOption($wp_customize, 'pages_Innereventbtnbgclr', 'luzuk_innerpageshortcode_page_settings', 'Event Button Text Background Color', '#ef2853');

addColorPalatOption($wp_customize, 'pages_Innereventbtnbghvclr', 'luzuk_innerpageshortcode_page_settings', 'Event Button Text Background Hover Color', '#000');

lzCustomLable($wp_customize, 'luzuk_teaminnerpagepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Team Shortcode Page Colors:');

lzCustomLable($wp_customize, 'luzuk_teampagelable', 'luzuk_innerpageshortcode_page_settings', 'Note: Set team member images of equal height.');

addColorPalatOption($wp_customize, 'pages_InnerTeamNameCColor', 'luzuk_innerpageshortcode_page_settings', 'Team Member Name Color', '#131313');

addColorPalatOption($wp_customize, 'pages_InnerTeamNamehoverCColor', 'luzuk_innerpageshortcode_page_settings', 'Team Member Name Hover Color', '#ef2853');

addColorPalatOption($wp_customize, 'pages_InnerTeamDesignationCColor', 'luzuk_innerpageshortcode_page_settings', 'Team Designation Color', '#ef2853');

addColorPalatOption($wp_customize, 'pages_InnerTeamsocialsbxClr', 'luzuk_innerpageshortcode_page_settings', 'Socials Box Color', '#ef2853');

addColorPalatOption($wp_customize, 'pages_InnerTeamsocialsColor', 'luzuk_innerpageshortcode_page_settings', 'Socials Color', '#fff');

addColorPalatOption($wp_customize, 'pages_TeamsocialshvrsColor', 'luzuk_innerpageshortcode_page_settings', 'Socials Hover Color', '#000');

addColorPalatOption($wp_customize, 'Innerteamarea_Highlightbox_color_one', 'luzuk_innerpageshortcode_page_settings', 'Team Box Background Color', '#fff');

addColorPalatOption($wp_customize, 'Innerteamarea_Highlightboxbrdclr', 'luzuk_innerpageshortcode_page_settings', 'Team Box Border Color', '#ef2853');


lzCustomLable($wp_customize, 'luzuk_testimonialinnerpagepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Testimonial Shortcode Page Colors:');
 

addColorPalatOption($wp_customize, 'luzuk_innertestimonials_imgbrdclr', 'luzuk_innerpageshortcode_page_settings', 'Select Client Name Box Border Color', '#f7f7f782');

addColorPalatOption($wp_customize, 'luzuk_innertestimonials_imgbbxclr', 'luzuk_innerpageshortcode_page_settings', 'Select Client Name Box Background Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_innertestimonials_Namecolor', 'luzuk_innerpageshortcode_page_settings', 'Select Client Name Color', '#ef2853');

addColorPalatOption($wp_customize, 'luzuk_innertestimonials_postioncolor', 'luzuk_innerpageshortcode_page_settings', 'Select Box Designation Color', '#444'); 

addColorPalatOption($wp_customize, 'luzuk_innertestimonials_icnclr', 'luzuk_innerpageshortcode_page_settings', 'Select Testimonial Icon Color', '#ef2853');

addColorPalatOption($wp_customize, 'luzuk_innertestimonials_textcolor', 'luzuk_innerpageshortcode_page_settings', 'Select Testimonial Content Color', '#000');


lzCustomLable($wp_customize, 'luzuk_gallinnoaheclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Gallery Shortcode Page Colors:');

addColorPalatOption($wp_customize, 'luzuk_gallinnimghvClr', 'luzuk_innerpageshortcode_page_settings', 'Select Image Hover Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_gallinnimghvbrdClr', 'luzuk_innerpageshortcode_page_settings', 'Select Image Border Color', '#ef2853');

addColorPalatOption($wp_customize, 'luzuk_gallinntitleClr', 'luzuk_innerpageshortcode_page_settings', 'Select Title Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_gallinnicnClr', 'luzuk_innerpageshortcode_page_settings', 'Select Icon Color', '#fff');



lzCustomLable($wp_customize, 'luzuk_faqinnerpagepageclrdisplay', 'luzuk_innerpageshortcode_page_settings', 'Set Faq Shortcode Page Colors:');

 addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetitleIconColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Question Icon Color', '#ef2853');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetitleColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Question Text Color', '#444');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetitleboxbrdColor', 'luzuk_innerpageshortcode_page_settings', 'Select Question Box Border Color', '#444');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetitleboxbgColor', 'luzuk_innerpageshortcode_page_settings', 'Select Question Box Background Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpagetextcColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Answer Text Color', '#444');

addColorPalatOption($wp_customize, 'luzuk_faqinnerpageansbg1Color', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Answer Box Background Color One', '#fff');
addColorPalatOption($wp_customize, 'luzuk_faqinnerpageansbg2Color', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Answer Box Background Color Two', '#fff');
//addColorPalatOption($wp_customize, 'luzuk_faqinnerpageansborderColor', 'luzuk_innerpageshortcode_page_settings', 'Select Faq Answer Box Border Color', '#fff');

$wp_customize->add_section(
	'luzuk_innerpagefont_settings',
	array(
		'title' => __( 'Inner Page Settings', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'luzuk_innerpage_titlepaddset', 'luzuk_innerpagefont_settings', ' Set Header Title Box Padding:');


$wp_customize->add_setting(
    'inner_headertitleboxTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '11em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'inner_headertitleboxTpadding',
    array(
        'settings'      => 'inner_headertitleboxTpadding',
        'section'       => 'luzuk_innerpagefont_settings',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'inner_headertitleboxBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'inner_headertitleboxBpadding',
    array(
        'settings'      => 'inner_headertitleboxBpadding',
        'section'       => 'luzuk_innerpagefont_settings',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);



lzCustomLable($wp_customize, 'luzuk_innerpageh1_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 1:');


$wp_customize->add_setting(
	'pages_innerpageheading',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '35px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading',
	array(
		'settings'      => 'pages_innerpageheading',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 1 Font Size', 'luzuk-premium' )
	)
);


lzCustomLable($wp_customize, 'luzuk_innerpageh2_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 2:');


$wp_customize->add_setting(
	'pages_innerpageheading2',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '24px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading2',
	array(
		'settings'      => 'pages_innerpageheading2',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 2 Font Size', 'luzuk-premium' )
	)
);
 

lzCustomLable($wp_customize, 'luzuk_innerpageh3_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 3:');


$wp_customize->add_setting(
	'pages_innerpageheading3',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '20px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading3',
	array(
		'settings'      => 'pages_innerpageheading3',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 3 Font Size', 'luzuk-premium' )
	)
);

lzCustomLable($wp_customize, 'luzuk_innerpageh4_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 4:');


$wp_customize->add_setting(
	'pages_innerpageheading4',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '18px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading4',
	array(
		'settings'      => 'pages_innerpageheading4',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 4 Font Size', 'luzuk-premium' )
	)
);

lzCustomLable($wp_customize, 'luzuk_innerpageh5_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 5:');


$wp_customize->add_setting(
	'pages_innerpageheading5',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '17px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading5',
	array(
		'settings'      => 'pages_innerpageheading5',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 5 Font Size', 'luzuk-premium' )
	)
);

lzCustomLable($wp_customize, 'luzuk_innerpageh6_fontsizeset', 'luzuk_innerpagefont_settings', ' Heading 6:');


$wp_customize->add_setting(
	'pages_innerpageheading6',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '16px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_innerpageheading6',
	array(
		'settings'      => 'pages_innerpageheading6',
		'section'       => 'luzuk_innerpagefont_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 6 Font Size', 'luzuk-premium' )
	)
);