<?php
$wp_customize->add_section(
    'aboutus_section',
    array(
        'title' => __( 'About Us Section', 'Luzuk' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);

$wp_customize->add_setting(
    'aboutus_section_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'aboutus_section_disable',
        array(
            'settings'      => 'aboutus_section_disable',
            'section'       => 'aboutus_section',
            'label'         => __( 'Disable/ Enable Section', 'Luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk' ),
                'off' => __( 'No', 'Luzuk' )
            ),
        )
    )
);

lzCustomLable($wp_customize, 'sec_aboutlhsimg', 'aboutus_section', 'Section Left Side Image Setting');

backgroundManager($wp_customize, 'aboutileft', 'aboutus_section', $color='#fff', get_template_directory_uri().'/images/aboutleft.jpg', 'color');


lzCustomLable($wp_customize, 'sec_aboutrhsimg', 'aboutus_section', 'Section Right Side Image Setting');

backgroundManager($wp_customize, 'aboutiright', 'aboutus_section', $color='#fff', get_template_directory_uri().'/images/aboutright.png', 'color');

addColorPalatOption($wp_customize, 'about_olayClr', 'aboutus_section', 'Section Overlay Color', '#000');

$wp_customize->add_setting(
    'about_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_title_heading',
        array(
            'settings'      => 'about_title_heading',
            'section'       => 'aboutus_section',
            'label'         => __( 'About Heading ', 'Luzuk' ),
        )
    )
);   


$wp_customize->add_setting(
    'about_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'A', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'about_title',
    array(
        'settings'      => 'about_title',
        'section'       => 'aboutus_section',
        'type'          => 'text',
        'label'         => __( 'Section Heading ', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'about_title2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'bout Us', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'about_title2',
    array(
        'settings'      => 'about_title2',
        'section'       => 'aboutus_section',
        'type'          => 'text',
        'label'         => __( 'Section Border Heading ', 'Luzuk' )
    )
);
addColorPalatOption($wp_customize, 'about_headingClr', 'aboutus_section', 'Section Heading Color', '#fff'); 
addColorPalatOption($wp_customize, 'about_headingbrdClr', 'aboutus_section', 'Section Heading Border Color', '#ef2853'); 

$wp_customize->add_setting(
    'about_text',
    array(
        'sanitize_callback'=>'luzuk_sanitize_text',
        'default'=> __('Lorem ipsum dolor sit ametconse tetur adipiscing elit do is eiusmod tempor incididunt ut labor dolore magna aliqua. Quis ipsum suspen ultrices gravida. Risus commiverrs maecenas accumsan lacu velon facilisis dance.', 'Luzuk')
    )
);
$wp_customize->add_control(
    'about_text',
    array(
        'settings' =>'about_text',
        'section' => 'aboutus_section',
        'type'=> 'textarea',
        'label'=> __('Content for the section', 'Luzuk')
    )
);

addColorPalatOption($wp_customize, 'aboutReservation_alltxtColor', 'aboutus_section', 'Section Content Color', '#fff'); 

//lzCustomLable($wp_customize, 'about_signimg', 'aboutus_section', 'Section Signature Image');
lzCustomLable($wp_customize, 'signimg_displaylabel', 'aboutus_section', 'Signature Image Display Setting:');
// to show & hide another button
$wp_customize->add_setting( 'signimg_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'signimg_display', array( 'label' => 'Signature Image Display', 'section' => 'aboutus_section', 'settings' => 'signimg_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Signature Image', 'hide' => 'Hide Signature Image', ), ) ); 

$wp_customize->add_setting(
    'abt_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'abt_image',
        array(
            'section' => 'aboutus_section',
            'settings' => 'abt_image',
            'description' => __('Recommended Image Size: 100X100px', 'luzuk-premium')
        )
    )
);


lzCustomLable($wp_customize, 'about_rhsimg', 'aboutus_section', 'Right Side Box Image');

$wp_customize->add_setting(
    'smash_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'smash_image',
        array(
            'section' => 'aboutus_section',
            'settings' => 'smash_image',
            'description' => __('Recommended Image Size: 180X240px', 'luzuk-premium')
        )
    )
);


addColorPalatOption($wp_customize, 'about_smallimgbrsclr', 'aboutus_section', 'Image Border Color', '#ef2853'); 