<?php 
$wp_customize->add_section(
    'service_area',
    array(
        'title'         => __( 'Our Services Section', 'Luzuk' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);
$wp_customize->add_setting(
    'service_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'service_area_disable',
        array(
            'settings'      => 'service_area_disable',
            'section'       => 'service_area',
            'label'         => __( 'Disable Section', 'Luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk' ),
                'off' => __( 'No', 'Luzuk' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'service', 'service_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'luzuk_sec_servicessectionpadding', 'service_area', 'Set Section Padding:');

$wp_customize->add_setting(
    'service_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaTpadding',
    array(
        'settings'      => 'service_areaTpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'service_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaBpadding',
    array(
        'settings'      => 'service_areaBpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);



$wp_customize->add_setting(
    'services_maintitle_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'services_maintitle_subtitle_heading',
        array(
            'settings'      => 'services_maintitle_subtitle_heading',
            'section'       => 'service_area',
            'label'         => __( 'Section Heading & Sub Heading', 'Luzuk' ),
        )
    )
);
$wp_customize->add_setting(
    'services_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Service', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'services_subtitle',
    array(
        'settings'      => 'services_subtitle',
        'section'       => 'service_area', 
        'type'          => 'text',
        'label'         => __( 'Section Sub Heading', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'servicearea_secsubtitle_color', 'service_area', 'Section Sub Heading Color ', '#ef2853');

$wp_customize->add_setting(
    'services_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'W', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'services_maintitle',
    array(
        'settings'      => 'services_maintitle',
        'section'       => 'service_area', 
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'services_maintitle2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'E OFFERS', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'services_maintitle2',
    array(
        'settings'      => 'services_maintitle2',
        'section'       => 'service_area', 
        'type'          => 'text',
        'label'         => __( 'Section Border Heading', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'servicearea_sectitle_color', 'service_area', 'Section Heading Color ', '#3f3f3f');
addColorPalatOption($wp_customize, 'servicearea_sectitlebrdclr', 'service_area', 'Section Border Heading Color ', '#ef2853');

$wp_customize->add_setting('service_area_lbl2', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'service_area_lbl2',
        array(
            'settings'      => 'service_area_lbl2',
            'section'       => 'service_area',
            'label'         => __( 'Note:', 'Luzuk' ),  
            'description'   => __( '{a} Use Shortcode [SERVICES] to show all services in a page.
             {b} Image use same height(210px*210px)', 'Luzuk' ),
        )
    )
);

$wp_customize->add_setting('service_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'service_npp_heading',
        array(
            'settings'      => 'service_npp_heading',
            'section'       => 'service_area',
            'label'         => __( 'Number of Services to show', 'Luzuk' ),
        )
    )
);    
$wp_customize->add_setting('service_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 7));
$wp_customize->add_control(
    'service_npp_count',
    array(
        'settings'      => 'service_npp_count',
        'section'       => 'service_area',
        'type'          => 'select',
        'label'         => __( 'Number of services to show', 'Luzuk' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    )
);

$ServicesSingleChoice[] = 'Select';
for( $i = 1; $i <= 12; $i++ ){
    $wp_customize->add_setting(
        'services_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'services_heading'.$i,
            array(
                'settings'      => 'services_heading'.$i,
                'section'       => 'service_area',
                'label'         => __( 'Service Page', 'Luzuk' ).$i,
            )
        )
    );
    if(is_array($ServicesSingleChoice)){
        $wp_customize->add_setting(
            'services_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'services_page'.$i,
            array(
                'settings'      => 'services_page'.$i,
                'section'       => 'service_area',
                'type'=> 'select',
                'label'         => __( 'Select a Service Page', 'Luzuk' ),
                'choices' => $ServicesSingleChoice,
            )
        );

// $wp_customize->add_setting(
//         'services_page_icon1'.$i,
//         array(
//             'default'           => 'fa fa-language',
//             'sanitize_callback' => 'luzuk_sanitize_text'
//         )
//     );        
//     $wp_customize->add_control(
//         new luzuk_Fontawesome_Icon_Chooser(
//             $wp_customize,
//             'services_page_icon1'.$i,
//             array(
//                 'settings'      => 'services_page_icon1'.$i,
//                 'section'       => 'service_area',
//                 'type'          => 'icon',
//                 'label'         => __( 'FontAwesome Icon', 'Luzuk' ),
//             )
//         )
//     );

    }else{
        $wp_customize->add_setting('service_area_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
        $wp_customize->add_control(
            new luzuk_Info_Text( 
                $wp_customize,
                'service_area_lbl'.$i,
                array(
                    'settings'      => 'service_area_lbl'.$i,
                    'section'       => 'service_area',
                    'label'         => __( 'Note:', 'Luzuk' ),    
                    'description'   => __( '<strong>Changes will not reflect unless you select the Service Page.</strong> <br/>Please add the Services from "Services menu" and then select Services to show information.', 'Luzuk' ),
                )
            )
        );
    }
 
}

lzCustomLable($wp_customize, 'services_bxclr', 'service_area', 'Section Color');

addColorPalatOption($wp_customize, 'services_Simghvclr', 'service_area', 'Section Image Hover Color ', '#f80539');
addColorPalatOption($wp_customize, 'services_Sbxclr', 'service_area', 'Section Box Color ', '#fff');
addColorPalatOption($wp_customize, 'services_Sbxhvclr', 'service_area', 'Section Box Hover Color ', '#191919');
addColorPalatOption($wp_customize, 'services_ServicePageTitleColor', 'service_area', 'Section Title Color ', '#444');
addColorPalatOption($wp_customize, 'services_ServicePageTitlehvColor', 'service_area', 'Section Title Hover Color ', '#fff');

// to show & hide another button
$wp_customize->add_setting( 'services_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'services_button_display', array( 'label' => 'Button Display', 'section' => 'service_area', 'settings' => 'services_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button

addColorPalatOption($wp_customize, 'services_secbtnicnclr', 'service_area', 'Section Button Icon Color ', '#ef2853');
addColorPalatOption($wp_customize, 'services_secbtnicnbghvclr', 'service_area', 'Section Button Icon Background Hover Color ', '#fff');