<?php    
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luzuk Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link rel="stylesheet" href="font-awesome-animation.min.css">

<link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i,800,800i&display=swap" rel="stylesheet">
	
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>
	
	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>

<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/component.css" />

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<div class="main-container">
		<!-- <a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'Luzuk' ); ?></a> -->
		<div id="loading-area"><div class="la-anim-10"></div></div>
		<!-- header -->
		<header class="site-header header-transparent header mo-left header-seo" id="myHeader">

			<?php 
				if( get_theme_mod('headertop_Tpadding',true) ) {
	                $headertop_Tpadding = 'padding-top:'.esc_attr(get_theme_mod('headertop_Tpadding')).';';
	            }
	            if( get_theme_mod('headertop_Bpadding',true) ) {
	                $headertop_Bpadding = 'padding-bottom:'.esc_attr(get_theme_mod('headertop_Bpadding')).';';
	            }
	            if( get_theme_mod('headertop_Lpadding',true) ) {
	                $headertop_Lpadding = 'padding-left:'.esc_attr(get_theme_mod('headertop_Lpadding')).';';
	            }
	            if( get_theme_mod('headertop_Rpadding',true) ) {
	                $headertop_Rpadding = 'padding-right:'.esc_attr(get_theme_mod('headertop_Rpadding')).';';
	            }
				?>

			<div class="top-header"  style="<?php echo esc_attr($headertop_Tpadding); ?>" "<?php echo esc_attr($headertop_Bpadding); ?>" "<?php echo esc_attr($headertop_Lpadding); ?>" "<?php echo esc_attr($headertop_Rpadding); ?>"> 


				<div class="container">
					<div class="col-md-7 col-sm-12 col-xs-12 ">
					<?php
						$email = get_theme_mod('headermain_email', 'info@youremail.com');
						$phone = get_theme_mod('headermain_phone', '+1800 123 456 789');
						
					?>
					<ul class="themetext">
						<?php if($phone){ ?><li class="header-phoneicon"><i class="fa fa-phone" aria-hidden="true"></i><?php echo ($phone);?></li><?php } ?>

						<?php if($email){ ?>
						<li class="header-emailicon mailto"><a href="mailto:<?php echo $email;?>"><i class="fa fa-envelope-o" aria-hidden="true"></i><?php echo ($email);?></a></li>
						<?php } ?>
					</ul>
						
					</div>
					<div class="col-md-3 col-sm-12 col-xs-12 padding0 textcenter">
						<?php
						$headerbtntitle = get_theme_mod('headermain_headerbtntitle', 'GET FREE CONSULTATION'); 
						$headerbtn = get_theme_mod('header_headerbtn', '#');
					?>
					<?php if( get_theme_mod('cds_button_display','show' ) == 'show') :
						?>
						<div class="header-inquiry-btn">
							
							<?php if(!empty($headerbtn)){ ?>
								<div class='head-button'><a href="<?php echo $headerbtn ?>" title="headerbtn" ><?php echo ($headerbtntitle);  ?></a></div>
							<?php }?> 
						</div>
					<?php endif ?>
					</div>

					<div class="col-md-2 col-sm-12 col-xs-12 padding0">
						
						<?php

								$facebook = get_theme_mod('header_fb', '//facebook.com/');
								$twitter = get_theme_mod('header_tw', '//twitter.com/');
								$linkedIn = get_theme_mod('header_in', '//linkedin.com/');
								$youtube = get_theme_mod('header_yt', '//www.youtube.com/');
								$rss = get_theme_mod('header_rss', '//www.ndtv.com/rss/');
							
						?>
							<?php if($facebook || $twitter || $linkedIn || $youtube || $rss){ ?>

							<div class="social-icons">
									<?php if(!empty($facebook)){ ?>
										<a href="<?php echo $facebook ?>" target="_blank" title="Facebook"><span class="fa fa-facebook"></span></a>
									<?php }?>
									<?php if(!empty($twitter)){ ?>
										<a href="<?php echo $twitter ?>" target="_blank" title="Twitter"><span class="fa fa-twitter"></span></a>
									<?php }?>
									<?php if(!empty($linkedIn)){ ?>
										<a href="<?php echo $linkedIn ?>" target="_blank" title="Linked In"><span class="fa fa-linkedin"></span></a>
									<?php }?>
									
								<?php if(!empty($rss)){ ?>
									<a href="<?php echo $rss ?>" target="_blank" title="rss"><span class="fa fa-rss"></span></a>
								<?php }?>

								<?php if(!empty($youtube)){ ?>
									<a href="<?php echo $youtube ?>" target="_blank" title="youtube"><span class="fa fa-youtube"></span></a>
								<?php }?>
									
									
								</div>
						<?php }?>

					</div>
				</div>
					<div class="clearfix"></div>


			</div>


			<?php 
				if( get_theme_mod('header_Tpadding',true) ) {
	                $header_Tpadding = 'padding-top:'.esc_attr(get_theme_mod('header_Tpadding')).';';
	            }
	            if( get_theme_mod('header_Bpadding',true) ) {
	                $header_Bpadding = 'padding-bottom:'.esc_attr(get_theme_mod('header_Bpadding')).';';
	            }
	            if( get_theme_mod('header_Lpadding',true) ) {
	                $header_Lpadding = 'padding-left:'.esc_attr(get_theme_mod('header_Lpadding')).';';
	            }
	            if( get_theme_mod('header_Rpadding',true) ) {
	                $header_Rpadding = 'padding-right:'.esc_attr(get_theme_mod('header_Rpadding')).';';
	            }
				?>

			<div class="main-header"  style="<?php echo esc_attr($header_Tpadding); ?>" "<?php echo esc_attr($header_Bpadding); ?>" "<?php echo esc_attr($header_Lpadding); ?>" "<?php echo esc_attr($header_Rpadding); ?>">
				<div class="container">
		
				<?php 
					if( get_theme_mod('pages_logoTmargin',true) ) {
		                $pages_logoTmargin = 'margin-top:'.esc_attr(get_theme_mod('pages_logoTmargin')).';';
		            }
		            if( get_theme_mod('pages_logoBmargin',true) ) {
		                $pages_logoBmargin = 'margin-bottom:'.esc_attr(get_theme_mod('pages_logoBmargin')).';';
		            }
		            if( get_theme_mod('pages_logoLmargin',true) ) {
		                $pages_logoLmargin = 'margin-left:'.esc_attr(get_theme_mod('pages_logoLmargin')).';';
		            }
		            if( get_theme_mod('pages_logoRmargin',true) ) {
		                $pages_logoRmargin = 'margin-right:'.esc_attr(get_theme_mod('pages_logoRmargin')).';';
		            }
		            if( get_theme_mod('pages_logomaxwidth',true) ) {
		                $pages_logomaxwidth = 'max-width:'.esc_attr(get_theme_mod('pages_logomaxwidth')).';';
		            }

				?>
			<div class="header-left col-md-4 col-sm-6 col-xs-8 logo"> 
			
				<div class="logobox" style="<?php echo esc_attr($pages_logoTmargin); ?>" "<?php echo esc_attr($pages_logoBmargin); ?>" "<?php echo esc_attr($pages_logoLmargin); ?>" "<?php echo esc_attr($pages_logoRmargin); ?>" "<?php echo esc_attr($pages_logomaxwidth); ?>" >
					<?php 
					if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
						the_custom_logo();
				else : 
					if ( is_front_page() ) : ?>
						<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
						<?php else : ?>
							<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
						<?php endif; ?>
					<?php endif; ?>
					<!-- .site-branding -->
					<div class="clearfix"></div>
					<p class="ht-site-description"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'description' ); ?></a></p>
				</div>
			</div>
			<!-- main header -->
			<div class="col-md-8 col-sm-6 col-xs-4 sticky-header main-bar-wraper navbar-expand-lg">
				<div class="main-bar clearfix ">
					<div class="top-bar-head">

						<!-- nav toggle button -->
						<button class="navbar-toggler collapsed navicon justify-content-end" type="button" data-toggle="collapse" data-target="#navbarNavDropdown" aria-controls="navbarNavDropdown" aria-expanded="false" aria-label="Toggle navigation">
							<span></span>
							<span></span>
							<span></span>
						</button>
						<!-- main nav -->


						<div class="header-nav navbar-collapse collapse justify-content-end" id="navbarNavDropdown" >
							<div class="reslogobox">
								<?php 
								if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
									the_custom_logo();
							else : 
								if ( is_front_page() ) : ?>
									<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
									<?php else : ?>
										<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
									<?php endif; ?>
									<!-- <p class="ht-site-description"><a href="<?php //echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php //bloginfo( 'description' ); ?></a></p> -->
								<?php endif; ?>
								<!-- .site-branding -->
								<div class="clearfix"></div>
					<p class="ht-site-description"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'description' ); ?></a></p>
							</div>

							<ul class="nav navbar-nav wow slideInLeft ">	
								<?php 
								wp_nav_menu( array( 
									'theme_location' => 'primary', 
									'container_class' => 'ht-menu clearfix' ,
									'menu_class' => 'ht-clearfix wow',
									'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
								) ); 
								?>
							</ul>

						</div>

					</div>
				</div>
			</div>
		</div>
				<div class="clearfix"></div>
		</div>
			<!-- main header END -->
			<div class="clearfix"></div>

		</header><!-- #masthead -->

	</div>
