<?php
/**
 * Createing a contact us page pannel for customizer
 *
 */

// CREATING A SECTION IN CUSTOMIZER
$wp_customize->add_section(
	'premium_contactus_section',
	array(
		'title' => __( 'Contact Us Page', 'luzuk-premium' ),
        // 'panel' => 'luzuk_premium_home_panel'
		'priority' =>20
	)
);

$wp_customize->add_setting('contactus_address_lbl', array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Customize_Heading($wp_customize, 'contactus_address_lbl',
		array(
			'settings'      => 'contactus_address_lbl',
			'section'       => 'premium_contactus_section',
			'label'         => __( 'Contact Us Address', 'luzuk-premium' ),
		)
	)
);

$section = 'premium_contactus_section';

//ADD TEXTAREA BOX FOR SUB TITLE
$wp_customize->add_setting(
	'contactus_addrress',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'Address', 'luzuk-premium' ) 
	)
);
$wp_customize->add_control(
	'contactus_addrress',
	array(
		'settings'      => 'contactus_addrress',
		'section'       => 'premium_contactus_section',
		'type'          => 'text',
		'label'         => __( 'Address Label', 'luzuk-premium' )
	)
);
lzAddElement($wp_customize, 'contactus_addressdata', $section, 'textarea', $label="Address Line One", 'luzuk_sanitize_text', 'Add Contact Address here..');

lzAddElement($wp_customize, 'contactus_addressdata1', $section, 'textarea', $label="Address Line Two", 'luzuk_sanitize_text', '');

lzAddElement($wp_customize, 'contactus_addressdata2', $section, 'textarea', $label="Address Line Three", 'luzuk_sanitize_text', '');

// contact us email 
$wp_customize->add_setting(
	'contactus_emailid',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'Email', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'contactus_emailid',
	array(
		'settings'      => 'contactus_emailid',
		'section'       => 'premium_contactus_section',
		'type'          => 'text',
		'label'         => __( 'Email Label', 'luzuk-premium' )
	)
);
lzAddElement($wp_customize, 'contactus_emaildata', $section, 'text', $label="Contact Us Email", 'luzuk_sanitize_text', 'contact@example.com');
// contact us Phone 
$wp_customize->add_setting(
	'contactus_phhone',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'Phone', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'contactus_phhone',
	array(
		'settings'      => 'contactus_phhone',
		'section'       => 'premium_contactus_section',
		'type'          => 'text',
		'label'         => __( 'Phone Label.', 'luzuk-premium' )
	)
);
lzAddElement($wp_customize, 'contactus_phonedata', $section, 'text', $label="Contact Us Phone", 'luzuk_sanitize_text', '+1 565 565 656565');

//Contact Details icon color
addColorPalatOption($wp_customize, 'contactus_detailiconColor', 'premium_contactus_section', 'Contact Details Icon Color', '#444');

//Contact Details Title color
addColorPalatOption($wp_customize, 'contactus_detailtitleColor', 'premium_contactus_section', 'Contact Details Title Color', '#444');
//Contact Details Information color
addColorPalatOption($wp_customize, 'contactus_detailinfoColor', 'premium_contactus_section', 'Contact Details Information Color', '#444');
//Contact Details Email color
addColorPalatOption($wp_customize, 'contactus_detailemailColor', 'premium_contactus_section', 'Contact Details Email Color', '#182849');

//Contact Details Email hover color
addColorPalatOption($wp_customize, 'contactus_detailemailhoverColor', 'premium_contactus_section', 'Contact Details Email Hover Color', '#e9bf08');

// SOCIAL MEDIA URLS / LINKS
$wp_customize->add_setting('contactus_sm_lbl', array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Customize_Heading($wp_customize, 'contactus_sm_lbl',
		array(
			'settings'      => 'contactus_sm_lbl',
			'section'       => 'premium_contactus_section',
			'label'         => __( 'Social Media Links', 'luzuk-premium' ),
		)
	)
);
$wp_customize->add_setting(
	'contactus_socialtitle',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'Follow us on', 'luzuk-premium' ) 
	)
);
$wp_customize->add_control(
	'contactus_socialtitle',
	array(
		'settings'      => 'contactus_socialtitle',
		'section'       => 'premium_contactus_section',
		'type'          => 'text',
		'label'         => __( 'Add Social Title', 'luzuk-premium' )
	)
);
// FACEBOOK 
$wp_customize->add_setting('contactus_facebook',	array('default'=> 'https://facebook.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('contactus_facebook',
	array(
		'settings'      => 'contactus_facebook',
		'section'       => 'premium_contactus_section',
		'type'          => 'url',
		'label'         => __( 'Facebook Url', 'luzuk-premium' )
	)
);
// TWITTER
$wp_customize->add_setting('contactus_twitter', array('default'=> 'https://twitter.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('contactus_twitter',
	array(
		'settings'      => 'contactus_twitter',
		'section'       => 'premium_contactus_section',
		'type'          => 'url',
		'label'         => __( 'Twitter Url', 'luzuk-premium' )
	)
);
// Instagram
$wp_customize->add_setting('contactus_instagram', array('default' => 'https://www.instagram.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('contactus_instagram',
	array(
		'settings'      => 'contactus_instagram',
		'section'       => 'premium_contactus_section',
		'type'          => 'url',
		'label'         => __( 'Instagram', 'luzuk-premium' )
	)
);
// LINKED IN
$wp_customize->add_setting('contactus_linkedin',array('default'=> 'https://linkedin.com','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('contactus_linkedin',
	array(
		'settings'      => 'contactus_linkedin',
		'section'       => 'premium_contactus_section',
		'type'          => 'url',
		'label'         => __( 'Linkedin Url', 'luzuk-premium' )
	)
);

//Social Title color
addColorPalatOption($wp_customize, 'contactus_SocialtitleColor', 'premium_contactus_section', 'Social Title Color', '#e9bf08');

//Social Icon color
addColorPalatOption($wp_customize, 'contactus_SocialTitleColor', 'premium_contactus_section', 'Social Icon Color', '#182849');

//Social Icon bg color
addColorPalatOption($wp_customize, 'contactus_SocialbgColor', 'premium_contactus_section', 'Social Icon Background Color', '#e9bf08');

//Social Icon hover color
addColorPalatOption($wp_customize, 'contactus_SocialTitlehoverColor', 'premium_contactus_section', 'Social Icon Hover Color', '#fff');

//Social Icon bg hover color
addColorPalatOption($wp_customize, 'contactus_SocialbghoverColor', 'premium_contactus_section', 'Social Icon Background Hover Color', '#182849');

// contact us form shortcode 
$wp_customize->add_setting('contactus_shortcode_lbl', array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control('contactus_shortcode_lbl', array('settings'=>'contactus_shortcode_lbl', 'section'=>'premium_contactus_section','type'=>'text', 'label'=> __('Form Title', 'luzuk-premium')));

lzAddElement($wp_customize, 'contactus_shortcode_lbl', $section, 'text', $label="Form Title", 'luzuk_sanitize_text', 'Contact Now');

lzAddElement($wp_customize, 'contactus_shortcode', $section, 'text', $label="Form Shortcode", 'luzuk_sanitize_text', '[your shortcode]');

//Form Title color
addColorPalatOption($wp_customize, 'contactus_formtitleColor', 'premium_contactus_section', 'Form Title Color', '#fff');

//Form Background color
addColorPalatOption($wp_customize, 'contactus_formbgColor', 'premium_contactus_section', 'Form Background Color', '#182849');

//Form Label color
addColorPalatOption($wp_customize, 'contactus_formlabelColor', 'premium_contactus_section', 'Form Label Color', '#fff');

//Form text and placeholder color
addColorPalatOption($wp_customize, 'contactus_formtextplaceColor', 'premium_contactus_section', 'Form Text and Placeholder Color', '#fff');

//Form border color
addColorPalatOption($wp_customize, 'contactus_formborderbottomColor', 'premium_contactus_section', 'Form Border Color', '#fff');

//Button color
addColorPalatOption($wp_customize, 'contactus_formbtnColor', 'premium_contactus_section', 'Form Button Color', '#182849');
//Button color
addColorPalatOption($wp_customize, 'contactus_formbtnbgColor', 'premium_contactus_section', 'Form Button Background Color', '#fff');

//Button hover color
addColorPalatOption($wp_customize, 'contactus_formbtnhoverColor', 'premium_contactus_section', 'Form Button Hover Color', '#fff');
//Button bg hover color
addColorPalatOption($wp_customize, 'contactus_formbtnbghoverColor', 'premium_contactus_section', 'Form Button Background Hover Color', '#e9bf08');

//Form text color
addColorPalatOption($wp_customize, 'contactus_formdtextColor', 'premium_contactus_section', 'Form Text Color', '#fff');

// ADDRESS GOOGLE/MSN/OTHER MAP IFRAME OR EMBADE CODE
$wp_customize->add_setting('contactus_iframe_lbl', array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Customize_Heading($wp_customize, 'contactus_iframe_lbl',
		array(
			'settings'      => 'contactus_iframe_lbl',
			'section'       => 'premium_contactus_section',
			'label'         => __( 'Contact Us Address', 'luzuk-premium' ),
		)
	)
);
// field for addeding the map code
$wp_customize->add_setting('contactus_embade', array(/*'sanitize_callback' => 'esc_url_raw',*/ 'default'=>'Add your map embade code'));
$wp_customize->add_control('contactus_embade', array('settings'=>'contactus_embade', 'section'=>'premium_contactus_section','type'=>'textarea', 'label'=> __('Code for map', 'luzuk-premium')));

//map bg color
addColorPalatOption($wp_customize, 'contactus_mapbgColor', 'premium_contactus_section', 'Map Background Color', '#182849');

