<?php

$wp_customize->add_panel(
	'luzuk_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'Luzuk Premium')
	)
);
//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'Luzuk Premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );

lzCustomLable($wp_customize, 'headerlogo_maxwidthtext', 'title_tagline', ' Site Header Logo Max Width:');

$wp_customize->add_setting(
	'pages_logomaxwidth',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '100%', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logomaxwidth',
	array(
		'settings'      => 'pages_logomaxwidth',
		'section'       => 'title_tagline',
		'type'          => 'text',
		'label'         => __( 'Logo Max Width', 'luzuk-premium' )
	)
);


   //Set header menu colour
addColorPalatOption($wp_customize, 'header_taglineColor', 'title_tagline', 'Header Tagline Color', '#182849');



//HEADER LOGO MARGIN SETTINGS
$wp_customize->add_section(
	'luzuk_headerlogo_settings',
	array(
		'title' => __( 'Header Logo Margin Settings', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'luzuk_headerlogo_margin', 'luzuk_headerlogo_settings', ' Site Header Logo Margin:');

$wp_customize->add_setting(
	'pages_logoTmargin',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '0px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoTmargin',
	array(
		'settings'      => 'pages_logoTmargin',
		'section'       => 'luzuk_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Top Margin', 'luzuk-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoBmargin',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '0px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoBmargin',
	array(
		'settings'      => 'pages_logoBmargin',
		'section'       => 'luzuk_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Bottom Margin', 'luzuk-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoLmargin',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '0px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoLmargin',
	array(
		'settings'      => 'pages_logoLmargin',
		'section'       => 'luzuk_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Left Margin', 'luzuk-premium' )
	)
);
$wp_customize->add_setting(
	'pages_logoRmargin',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '0px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_logoRmargin',
	array(
		'settings'      => 'pages_logoRmargin',
		'section'       => 'luzuk_headerlogo_settings',
		'type'          => 'text',
		'label'         => __( 'Logo Right Margin', 'luzuk-premium' )
	)
);


//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image Setting', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );



//HEADER SETTINGS
$wp_customize->add_section(
	'header_settings',
	array(
		'title' => __( 'Header Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);
// 	//ENABLE/DISABLE STICKY HEADER
// $wp_customize->add_setting(
// 	'luzuk_sticky_header_enable',
// 	array(
// 		'sanitize_callback' => 'luzuk_sanitize_text',
// 		'default' => 'off'
// 	)
// );
// $wp_customize->add_control(
// 	new luzuk_Switch_Control(
// 		$wp_customize,
// 		'luzuk_sticky_header_enable',
// 		array(
// 			'settings'		=> 'luzuk_sticky_header_enable',
// 			'section'		=> 'header_settings',
// 			'label'			=> __( 'Sticky Header', 'Luzuk Premium' ),
// 			'on_off_label' 	=> array(
// 				'on' => __( 'Enable', 'Luzuk Premium' ),
// 				'off' => __( 'Disable', 'Luzuk Premium' )
// 			)	
// 		)
// 	)
// );

lzCustomLable($wp_customize, 'mainheader_padding', 'header_settings', ' Main Header Padding Setting:');

$wp_customize->add_setting(
    'header_Tpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'header_Tpadding',
    array(
        'settings'      => 'header_Tpadding',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'header_Bpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'header_Bpadding',
    array(
        'settings'      => 'header_Bpadding',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'header_Lpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'header_Lpadding',
    array(
        'settings'      => 'header_Lpadding',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Left Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'header_Rpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'header_Rpadding',
    array(
        'settings'      => 'header_Rpadding',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Right Padding', 'luzuk-premium' )
    )
);

//main header colors
lzCustomLable($wp_customize, 'headerinner_lblbutton1display', 'header_settings', 'Header Background color Setting:');

//Header Background Color
addColorPalatOption($wp_customize, 'topheader_color', 'header_settings', ' Top Header Background Color', '#182849');
//Header Background Color
addColorPalatOption($wp_customize, 'mainheader_color', 'header_settings', ' Main Header Background Color', '#fff');

lzCustomLable($wp_customize, 'topheader_clrlblImgTxt', 'header_settings', 'Top Header Setting and Colors:');

 //header phone icon color
$wp_customize->add_setting(
	'headermain_phone',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '+1800 123 456 789' )
	)
);
$wp_customize->add_control(
	'headermain_phone',
	array(
		'settings'      => 'headermain_phone',
		'section'       => 'header_settings',
		'type'          => 'text',
		'label'         => __( 'Phone Number', 'Luzuk Premium' )
	)
);

$wp_customize->add_setting(
	'headermain_email',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'info@youremail.com' )
	)
);
$wp_customize->add_control(
	'headermain_email',
	array(
		'settings'      => 'headermain_email',
		'section'       => 'header_settings',
		'type'          => 'text',
		'label'         => __( 'Email Address', 'Luzuk Premium' )
	)
);


   addColorPalatOption($wp_customize, 'header_dataiconColor', 'header_settings', 'Header data icon color', '#e9bf09');

   addColorPalatOption($wp_customize, 'header_dataColor', 'header_settings', 'Header data text color', '#fff'); 

   addColorPalatOption($wp_customize, 'header_emailhoverColor', 'header_settings', 'Header email hover color', '#e9bf09');

lzCustomLable($wp_customize, 'header_lblbutton1display', 'header_settings', 'Header Button Display & Text Setting:');
// to show & hide another button
$wp_customize->add_setting( 'cds_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'cds_button_display', array( 'label' => 'Button Display', 'section' => 'header_settings', 'settings' => 'cds_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button
// appointment 
$wp_customize->add_setting(
	'headermain_headerbtntitle',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'GET FREE CONSULTATION' )
	)
);
$wp_customize->add_control(
	'headermain_headerbtntitle',
	array(
		'settings'      => 'headermain_headerbtntitle',
		'section'       => 'header_settings',
		'type'          => 'text',
		'label'         => __( 'Header Button Text', 'luzuk-premium' )
	)
);
$wp_customize->add_setting('header_headerbtn',	array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_headerbtn',
	array(
		'settings'      => 'header_headerbtn',
		'section'       => 'header_settings',
		'type'          => 'url',
		'label'         => __( 'Add "Header Button" link here', 'luzuk-premium' )
	)
);

lzCustomLable($wp_customize, 'header_clrlbtnTxt', 'header_settings', 'Set Header Button Colors:');

//Set header button colour
addColorPalatOption($wp_customize, 'headerbtn_color', 'header_settings', 'Header Button Color', '#182849');

//Set header button bg colour
addColorPalatOption($wp_customize, 'headerbtnbg_color', 'header_settings', 'Header Button Background Color', '#e9bf09');

//Set header button hover colour
addColorPalatOption($wp_customize, 'headerbtnhover_color', 'header_settings', 'Header Button Hover Color', '#e9bf09');

//Set header button bg hover colour
addColorPalatOption($wp_customize, 'headerbtnbghover_color', 'header_settings', 'Header Button Background Hover Color', '#fff');

// Adding the Label
lzCustomLable($wp_customize, 'social_reservation_lblImgTxt', 'header_settings' , 'Social media icons');
// FACEBOOK 
$wp_customize->add_setting('header_fb', array('default'=> 'https://facebook.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_fb',
    array(
        'settings'      => 'header_fb',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'Facebook Url', 'luzuk-premium' )
    )
);
// TWITTER
$wp_customize->add_setting('header_tw', array('default'=> 'https://twitter.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_tw',
    array(
        'settings'      => 'header_tw',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'Twitter Url', 'luzuk-premium' )
    )
);

// LINKED IN
$wp_customize->add_setting('header_in',array('default'=> 'https://linkedin.com','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_in',
    array(
        'settings'      => 'header_in',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'Linkedin Url', 'luzuk-premium' )
    )
);

// rss 
$wp_customize->add_setting('header_rss',array('default'=> 'https://www.ndtv.com/rss/','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_rss',
    array(
        'settings'      => 'header_rss',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'RSS Url', 'luzuk-premium' )
    )
);

// youtube 
$wp_customize->add_setting('header_yt',array('default'=> 'https://www.youtube.com/','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_yt',
    array(
        'settings'      => 'header_yt',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'Youtube Url', 'luzuk-premium' )
    )
);

//Set header social colour
addColorPalatOption($wp_customize, 'header_socialiconColor', 'header_settings', 'Header Social Color', '#fff');

//Set header social border colour
addColorPalatOption($wp_customize, 'header_socialiconhoverbgColor', 'header_settings', 'Header Social Hover Background Color', '#e9bf09');

lzCustomLable($wp_customize, 'header_clrlblImgTxt', 'header_settings', 'Set Header Menu Colors:');

   //Set header menu colour
addColorPalatOption($wp_customize, 'headermenu_color', 'header_settings', 'Header Menu Color', '#182849');

addColorPalatOption($wp_customize, 'headerhovermenu_color', 'header_settings', 'Header Menu Hover Color', '#e9bf09');

	//Set Current Menu Text colour
addColorPalatOption($wp_customize, 'headercurrentmenu_color', 'header_settings', 'Header Current Menu Color', '#e9bf09');

	//Set Header Current Menu Border And Menu Hover Border Color
addColorPalatOption($wp_customize, 'headercurrentmenuborder_color', 'header_settings', 'Header Current Menu Border And Menu Hover Border Color', '#e9bf09');


	//Set header sub menu colour
addColorPalatOption($wp_customize, 'headersubmenu_color', 'header_settings', 'Header Dropdown Menu Color', '#e9bf09');

addColorPalatOption($wp_customize, 'headersubmenuhover_color', 'header_settings', 'Header Dropdown Menu hover Color', '#fff');

addColorPalatOption($wp_customize, 'headerdropdowncurrentsubmenu_color', 'header_settings', 'Header Dropdown Current Menu Color', '#fff');

	//Header Dropdown Background Color
addColorPalatOption($wp_customize, 'headersubmenubg_color', 'header_settings', 'Header Dropdown Background Color', '#182849');

//responsive header colors

lzCustomLable($wp_customize, 'header_lblresponsivedisplay', 'header_settings', 'Responsive / Slide On Header Setting:');


addColorPalatOption($wp_customize, 'header_responsivetaglineColor', 'header_settings', 'Header tagline color', '#182849');

addColorPalatOption($wp_customize, 'header_responsivelogobgColor', 'header_settings', 'Header logo box background color', '#fff');

addColorPalatOption($wp_customize, 'header_navresponsivebgColor', 'header_settings', 'Header nav bar background color', '#182849');
addColorPalatOption($wp_customize, 'header_navresponsiveborderrightColor', 'header_settings', 'Header nav bar border color', '#fff');
addColorPalatOption($wp_customize, 'header_navresponsiveoffbtnColor', 'header_settings', 'Header nav bar on / off button color', '#000');
addColorPalatOption($wp_customize, 'header_navresponsiveonbtnColor', 'header_settings', 'Header nav bar button hover color', '#fff');
addColorPalatOption($wp_customize, 'header_navresponsiveonbtnbgColor', 'header_settings', 'Header nav bar button hover background color', '#e9bf09');


addColorPalatOption($wp_customize, 'header_responsivemenuColor', 'header_settings', 'Header menu color', '#fff');
addColorPalatOption($wp_customize, 'header_responsivemenuhoverColor', 'header_settings', 'Header menu hover color', '#e9bf09');
addColorPalatOption($wp_customize, 'header_responsivecurrentmenuColor', 'header_settings', 'Header current menu color', '#182849');
addColorPalatOption($wp_customize, 'header_responsivecurrentmenubgColor', 'header_settings', 'Header current menu background color', '#fff');

	//Set Header Current Menu Border And Menu Hover Border Color
addColorPalatOption($wp_customize, 'header_responsivecurrentmenuborder_color', 'header_settings', 'Header Current Menu Border And Menu Hover Border Color', '#e9bf09');

addColorPalatOption($wp_customize, 'header_responsivesubmenuboxbgColor', 'header_settings', 'Header Dropdown box color', '#fff');
addColorPalatOption($wp_customize, 'header_responsivesubmenuColor', 'header_settings', 'Header sub menu color', '#e9bf09');
addColorPalatOption($wp_customize, 'header_responsivesubmenuhoverColor', 'header_settings', 'Header sub menu hover color', '#182849');

addColorPalatOption($wp_customize, 'header_responsivesubmenucurrentmenuColor', 'header_settings', 'Header sub current menu color', '#182849');

addColorPalatOption($wp_customize, 'header_responsivesubmenucurrentmenuhoverColor', 'header_settings', 'Header sub current menu hover color', '#e9bf09');

//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'Luzuk Premium'),
	'panel' => 'luzuk_general_panel',
) );
//theme primary color
addColorPalatOption($wp_customize, 'luzuk_template_color', 'colors', 'Theme Primary Color', '#e9bf09');
//theme Secondary color
addColorPalatOption($wp_customize, 'theme_secondary_color', 'colors', 'Theme Secondary Color', '#182849');

lzCustomLable($wp_customize, 'innerpage_colorsetting', 'colors', ' Inner Page Color Setting:');

//Inner page title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_titlecolor', 'colors', 'Inner page title color', '#fff');
//Inner page background color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_bgcolor', 'colors', 'Inner page title background color', '#182849');

//Inner page content box heading 1 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh1color', 'colors', 'Heading 1 color', '#333333');

//Inner page content box heading 2 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh2color', 'colors', 'Heading 2 color', '#333333');

//Inner page content box heading 3 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh3color', 'colors', 'Heading 3 color', '#333333');

//Inner page content box heading 4 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh4color', 'colors', 'Heading 4 color', '#333333');

//Inner page content box heading 5 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh5color', 'colors', 'Heading 5 color', '#333333');

//Inner page content box heading 6 color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtitleh6color', 'colors', 'Heading 6 color', '#333333');

//Inner page content box text color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxtextcolor', 'colors', 'Inner page content box text color', '#303030');

//Inner page content box list color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlistcolor', 'colors', 'Inner page content box list color', '#303030');

//Inner page content box list icon color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlisticoncolor', 'colors', 'Inner page content box list icon color', '#182849');

//Inner page content box list number color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlistnumbercolor', 'colors', 'Inner page content box list number color', '#fff');

//Inner page content box list number bg color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlistnumberbgcolor', 'colors', 'Inner page content box list number background color', '#182849');

//Inner page content box links color
addColorPalatOption($wp_customize, 'template_innerpage_contentboxlinkcolor', 'colors', 'Inner page content box links color', '#182849');

//Inner page border color
addColorPalatOption($wp_customize, 'template_innerpage_bordercolor', 'colors', 'Inner page border color', '#EEE');


//Inner page table days Color
addColorPalatOption($wp_customize, 'template_innerpage_tabledays_color', 'colors', 'Inner Page Sidebar Table Days Color', '#fff');

//Inner page table days bg Color
addColorPalatOption($wp_customize, 'template_innerpage_tabledaysbg_color', 'colors', 'Inner Page Sidebar Table Days Background Color', '#182849');

//Inner page table text Color
addColorPalatOption($wp_customize, 'template_innerpage_tabletext_color', 'colors', 'Inner Page Sidebar Table Text Color', '#6b7385');

//Inner page table box bg Color
addColorPalatOption($wp_customize, 'template_innerpage_tableboxbg_color', 'colors', 'Inner Page Sidebar Table Box Background Color', '#fff');

//Inner page table btn Color
addColorPalatOption($wp_customize, 'template_innerpage_tablebtn_color', 'colors', 'Inner Page Sidebar Table, Form Button Text Color', '#fff');

//Inner page table btn bg Color
addColorPalatOption($wp_customize, 'template_innerpage_tablebtnbg_color', 'colors', 'Inner Page Sidebar Table Button Background Color', '#182849');

//Inner Page Social color
addColorPalatOption($wp_customize, 'template_innerpage_socials_color', 'colors', 'Inner Page Social color', '#fff');

//Inner page box bg Color
addColorPalatOption($wp_customize, 'template_innerpage_boxbg_color', 'colors', 'Inner Page Box Background Color', '#fff');
//Inner page blog box bg Color
addColorPalatOption($wp_customize, 'template_innerpage_blogboxbg_color', 'colors', 'Inner Page Info Box Background Color', '#eee');


lzCustomLable($wp_customize, 'topbar_colorsetting', 'colors', ' Top Bar Color Setting:');

//top bar Color
addColorPalatOption($wp_customize, 'template_topbar_color', 'colors', 'Top bar Color', '#fff');

//top bar bg Color
addColorPalatOption($wp_customize, 'template_topbarbg_color', 'colors', 'Top bar background Color', '#182849');

//top bar bg hover Color
addColorPalatOption($wp_customize, 'template_topbarbghover_color', 'colors', 'Top bar background hover Color', '#e9bf09');


//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'luzuk_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'luzuk_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Breadcrumb', 'hide' => 'Hide Breadcrumb', ), ) ); 



$wp_customize->add_setting(
        'luzuk_breadcrumbhometxt',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Home', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'luzuk_breadcrumbhometxt',
        array(
            'settings'      => 'luzuk_breadcrumbhometxt',
            'section'       => 'luzuk_breadcrumb_settings',
            'type'          => 'text',
            'label'         => __( 'Add Breadcrumb Text Here:', 'luzuk-premium' )
        )
    );

//Inner page breadcrumbbox title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbtitlecolor', 'luzuk_breadcrumb_settings', 'Breadcrumbbox title color', '#000');
//Inner page breadcrumbbox current title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlecolor', 'luzuk_breadcrumb_settings', 'Breadcrumbbox current title color', '#182849');
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlehovercolor', 'luzuk_breadcrumb_settings', 'Breadcrumbbox current title hover color', '#e9bf09');

//Inner page breadcrumbbox background color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbbgcolor', 'luzuk_breadcrumb_settings', 'Breadcrumbbox background color', '#fff');
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbbgbordercolor', 'luzuk_breadcrumb_settings', 'Breadcrumbbox border color', '#182849');

// end to show & hide button


//INNER PAGE HEADING FONT SIZE SETTINGS
$wp_customize->add_section(
	'innerheadingfontsize_settings',
	array(
		'title' => __( 'Inner Page Heading Font Size Settings', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'luzuk_headerlogo_margin', 'innerheadingfontsize_settings', ' Inner Page Heading Font Size:');


$wp_customize->add_setting(
	'pages_h1font',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '30px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h1font',
	array(
		'settings'      => 'pages_h1font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 1 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h2font',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '28px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h2font',
	array(
		'settings'      => 'pages_h2font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 2 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h3font',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '22px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h3font',
	array(
		'settings'      => 'pages_h3font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 3 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h4font',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '28px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h4font',
	array(
		'settings'      => 'pages_h4font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 4 Font Size', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'pages_h5font',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '20px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h5font',
	array(
		'settings'      => 'pages_h5font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 5 Font Size', 'luzuk-premium' )
	)
);


$wp_customize->add_setting(
	'pages_h6font',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( '18px', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'pages_h6font',
	array(
		'settings'      => 'pages_h6font',
		'section'       => 'innerheadingfontsize_settings',
		'type'          => 'text',
		'label'         => __( 'Heading 6 Font Size', 'luzuk-premium' )
	)
);


//Inner Page Box Padding Setting
$wp_customize->add_section(
	'innerboxpaddiing_settings',
	array(
		'title' => __( 'Inner Page Box Padding Setting', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'innerpagebox_padding', 'innerboxpaddiing_settings', ' Inner Page Box Padding Setting:');

$wp_customize->add_setting(
    'innerpagesbox_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'innerpagesbox_toppadding',
    array(
        'settings'      => 'innerpagesbox_toppadding',
        'section'       => 'innerboxpaddiing_settings',
        'type'          => 'text',
        'label'         => __( 'Section Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'innerpagesbox_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'innerpagesbox_bottompadding',
    array(
        'settings'      => 'innerpagesbox_bottompadding',
        'section'       => 'innerboxpaddiing_settings',
        'type'          => 'text',
        'label'         => __( 'Section Bottom Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'innerpagesbox_leftpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'innerpagesbox_leftpadding',
    array(
        'settings'      => 'innerpagesbox_leftpadding',
        'section'       => 'innerboxpaddiing_settings',
        'type'          => 'text',
        'label'         => __( 'Section Left Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'innerpagesbox_rightpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'innerpagesbox_rightpadding',
    array(
        'settings'      => 'innerpagesbox_rightpadding',
        'section'       => 'innerboxpaddiing_settings',
        'type'          => 'text',
        'label'         => __( 'Section Right Padding', 'luzuk-premium' )
    )
);


//POSTPAGEDATE SETTINGS
$wp_customize->add_section(
	'luzuk_postpagedate_settings',
	array(
		'title' => __( 'Post Page Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

//for POSTPAGEDATE to show & hide button

$wp_customize->add_setting( 'postdate_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'postdate_button_display', array( 'label' => 'Post Date Display', 'section' => 'luzuk_postpagedate_settings', 'settings' => 'postdate_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Post Date', 'hide' => 'Hide Post Date', ), ) ); 

// end to show & hide button

//for POSTPAGEDATE to show & hide button

$wp_customize->add_setting( 'socialpost_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'socialpost_button_display', array( 'label' => 'Post Social Media Display', 'section' => 'luzuk_postpagedate_settings', 'settings' => 'socialpost_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Post Social Media', 'hide' => 'Hide Post Social Media', ), ) ); 

// end to show & hide button


//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'footer_copyright_settings',
	array(
		'title' => __( 'Footer Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);


backgroundManager($wp_customize, 'footer', 'footer_copyright_settings', $color='#182849');

lzCustomLable($wp_customize, 'footer_padding', 'footer_copyright_settings', ' Section Padding Setting:');

$wp_customize->add_setting(
    'footer_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '6em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'footer_toppadding',
    array(
        'settings'      => 'footer_toppadding',
        'section'       => 'footer_copyright_settings',
        'type'          => 'text',
        'label'         => __( 'Section Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'footer_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'footer_bottompadding',
    array(
        'settings'      => 'footer_bottompadding',
        'section'       => 'footer_copyright_settings',
        'type'          => 'text',
        'label'         => __( 'Section Bottom Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'footer_leftpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'footer_leftpadding',
    array(
        'settings'      => 'footer_leftpadding',
        'section'       => 'footer_copyright_settings',
        'type'          => 'text',
        'label'         => __( 'Section Left Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'footer_rightpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'footer_rightpadding',
    array(
        'settings'      => 'footer_rightpadding',
        'section'       => 'footer_copyright_settings',
        'type'          => 'text',
        'label'         => __( 'Section Right Padding', 'luzuk-premium' )
    )
);

//theme Footer top border Color
addColorPalatOption($wp_customize, 'footer_topborder_color', 'footer_copyright_settings', 'Footer Top Border Color', '#e9bf09');

//theme Footer title Color
addColorPalatOption($wp_customize, 'footer_title_color', 'footer_copyright_settings', 'Footer Title Color', '#fff');

//theme Footer icon Color
addColorPalatOption($wp_customize, 'footer_icon_color', 'footer_copyright_settings', 'Footer Icon Color', '#e9bf09');

//theme Footer icon hover Color
addColorPalatOption($wp_customize, 'footer_iconhover_color', 'footer_copyright_settings', 'Footer Icon Hover Color', '#fff');


//theme Footer text Color
addColorPalatOption($wp_customize, 'footer_alltext_color', 'footer_copyright_settings', 'Footer All Text Color', '#fff');

//theme Footer text Color
addColorPalatOption($wp_customize, 'footer_1text_color', 'footer_copyright_settings', 'Footer First Widget Text Color', '#929eb4');

//theme Footer text border Color
addColorPalatOption($wp_customize, 'footer_1widgetborder_color', 'footer_copyright_settings', 'Footer First Widget Border Color', '#646f85');

addColorPalatOption($wp_customize, 'footer_menu_color', 'footer_copyright_settings', 'Footer Menu Color', '#fff');

//theme Footer menu hover Color
addColorPalatOption($wp_customize, 'footer_menuhover_color', 'footer_copyright_settings', 'Footer Menu & Icon Hover Color', '#e9bf09');

//theme Footer menu date Color
addColorPalatOption($wp_customize, 'footer_menudate_color', 'footer_copyright_settings', 'Footer Menu Date Color', '#e9bf09');

//theme Footer social Color
addColorPalatOption($wp_customize, 'footer_social_color', 'footer_copyright_settings', 'Footer Social Color', '#fff');

//theme Footer social Hover Color
addColorPalatOption($wp_customize, 'footer_socialhover_color', 'footer_copyright_settings', 'Footer Social Hover Color', '#e9bf09');

//theme Footer table days Color
addColorPalatOption($wp_customize, 'footer_tabledays_color', 'footer_copyright_settings', 'Footer Table Days Color', '#fff');

//theme Footer table days bg Color
addColorPalatOption($wp_customize, 'footer_tabledaysbg_color', 'footer_copyright_settings', 'Footer Table Days Background Color', '#e9bf09');

//theme Footer table text Color
addColorPalatOption($wp_customize, 'footer_tabletext_color', 'footer_copyright_settings', 'Footer Table Text Color', '#fff');

//theme Footer table btn Color
addColorPalatOption($wp_customize, 'footer_tablebtn_color', 'footer_copyright_settings', 'Footer Table Button Color', '#fff');

//theme Footer table btn bg Color
addColorPalatOption($wp_customize, 'footer_tablebtnbg_color', 'footer_copyright_settings', 'Footer Table Button Background Color', '#e9bf09');

//theme Footer table border Color
addColorPalatOption($wp_customize, 'footer_tableborder_color', 'footer_copyright_settings', 'Footer Table Border Color', '#fff');

addColorPalatOption($wp_customize, 'footer_formlabeltxt_color', 'footer_copyright_settings', 'Footer Form label Text Color', '#fff');

//theme Footer form Color
addColorPalatOption($wp_customize, 'footer_form_color', 'footer_copyright_settings', 'Footer Form Text & Placeholder Text Color', '#fff');

//theme Footer form border Color
addColorPalatOption($wp_customize, 'footer_formborder_color', 'footer_copyright_settings', 'Footer Form Border Color', '#fff');

//theme Footer form background Color
addColorPalatOption($wp_customize, 'footer_formbg_color', 'footer_copyright_settings', 'Footer Form Background Color', '#182849');

//theme Footer form button Color
addColorPalatOption($wp_customize, 'footer_formbtn_color', 'footer_copyright_settings', 'Footer Form Button Color', '#fff');

//theme Footer Form Button Background Color
addColorPalatOption($wp_customize, 'footer_formbtnbg_color', 'footer_copyright_settings', 'Footer Form Button Background Color', '#e9bf09');

$wp_customize->add_setting(
	'footer_copyrighttext',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'Copyright © 2019 Security Guards', 'Luzuk Premium' )
	)
);
$wp_customize->add_control(
	'footer_copyrighttext',
	array(
		'settings'      => 'footer_copyrighttext',
		'section'       => 'footer_copyright_settings',
		'type'          => 'text',
		'label'         => __( 'Footer Copyright Text', 'Luzuk Premium' )
	)
);


$wp_customize->add_setting(
	'footer_copyrighttextprivacy',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'Privacy Policy | Terms & Conditions', 'Luzuk Premium' )
	)
);
$wp_customize->add_control(
	'footer_copyrighttextprivacy',
	array(
		'settings'      => 'footer_copyrighttextprivacy',
		'section'       => 'footer_copyright_settings',
		'type'          => 'text',
		'label'         => __( 'Footer Privacy Text', 'Luzuk Premium' )
	)
);


//theme Footer Copyright text Color
addColorPalatOption($wp_customize, 'footer_copyrighttext_color', 'footer_copyright_settings', 'Copyright Footer Text Color', '#949eb6');


//theme Footer Copyright bgColor
addColorPalatOption($wp_customize, 'footer_copyrightbg_color', 'footer_copyright_settings', 'Copyright Footer Background Color', '#101a33');


//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
	'luzuk_shopsidebar_settings',
	array(
		'title' => __( 'Shop Page Sidebar Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);


// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'luzuk_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Sidebar', 'hide' => 'Hide Sidebar', ), ) ); 
// end to show & hide button


$wp_customize->add_section(
	'innershortcode_page_settings',
	array(
		'title' => __( 'Color Setting For Shortcode Pages', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'servicepageclrdisplay', 'innershortcode_page_settings', 'Set Services Shortcode Page Colors:');

$wp_customize->add_setting('servicesnote_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'servicesnote_lbl',
        array(
            'settings'      => 'servicesnote_lbl',
            'section'       => 'innershortcode_page_settings',
            'label'         => __( 'Note:', 'Luzuk Premium' ),    
            'description'   => __( 'Kindly add same size of Services images.', 'Luzuk Premium' ),
        )
    )
);


addColorPalatOption($wp_customize, 'innerserviceimghoveroverlayColor', 'innershortcode_page_settings', 'Select Service Image hover overlay color', '#e9bf09');

addColorPalatOption($wp_customize, 'innerservicetitleColor', 'innershortcode_page_settings', 'Select Service Title color', '#e9bf09');
addColorPalatOption($wp_customize, 'innerservicetitlehoverColor', 'innershortcode_page_settings', 'Select Service Title Hover color', '#fff');
addColorPalatOption($wp_customize, 'innerservicedescColor', 'innershortcode_page_settings', 'Select Service Description color', '#a5a5a5');
addColorPalatOption($wp_customize, 'innerservicedeschoverColor', 'innershortcode_page_settings', 'Select Service Description Hover color', '#fff');

addColorPalatOption($wp_customize, 'innerservicebtnColor', 'innershortcode_page_settings', 'Select Service Button Text color', '#182849');

addColorPalatOption($wp_customize, 'innerservicebtnhoverColor', 'innershortcode_page_settings', 'Select Service Button Text hover color', '#e9bf09');

addColorPalatOption($wp_customize, 'innerservicebtnborderColor', 'innershortcode_page_settings', 'Select Service Button Border color', '#182849');

addColorPalatOption($wp_customize, 'innerservicebtnhoverborderColor', 'innershortcode_page_settings', 'Select Service Button Hover Border color', '#e9bf09');


addColorPalatOption($wp_customize, 'innerserviceboxhoverbgColor', 'innershortcode_page_settings', 'Select Service Box Hover Background color', '#182849');

addColorPalatOption($wp_customize, 'innerserviceboxborderColor', 'innershortcode_page_settings', 'Select Service Box Border color', '#182849');

addColorPalatOption($wp_customize, 'innerserviceboxhoverborderColor', 'innershortcode_page_settings', 'Select Service Box Border Hover color', '#e9bf09');


lzCustomLable($wp_customize, 'teaminnerpagepageclrdisplay', 'innershortcode_page_settings', 'Set Team Shortcode Page Colors:');


$wp_customize->add_setting('teams_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'teams_lbl',
        array(
            'settings'      => 'teams_lbl',
            'section'       => 'innershortcode_page_settings',
            'label'         => __( 'Note:', 'Luzuk Premium' ),    
            'description'   => __( 'Kindly add same size of Team images. Recommended Team Image Size 370px X 425px', 'Luzuk Premium' ),
        )
    )
);


addColorPalatOption($wp_customize, 'teaminner_imghoverupborderColor', 'innershortcode_page_settings', 'Select Team Image Hover Content Box color', '#e9bf09');


addColorPalatOption($wp_customize, 'teaminnermembernametextColor', 'innershortcode_page_settings', 'Select Member Name color', '#ffffff');
addColorPalatOption($wp_customize, 'teaminnermemberdesignationtextColor', 'innershortcode_page_settings', 'Select Member Designation color', '#182849');

addColorPalatOption($wp_customize, 'teaminnersocialColor', 'innershortcode_page_settings', 'Select Team Social color', '#fff');

addColorPalatOption($wp_customize, 'teaminnersocialbgColor', 'innershortcode_page_settings', 'Select Team Social Background color', '#e9bf09');

addColorPalatOption($wp_customize, 'teaminnersocialhoverColor', 'innershortcode_page_settings', 'Select Team Social Hover color', '#fff');

addColorPalatOption($wp_customize, 'teaminnersocialbghoverColor', 'innershortcode_page_settings', 'Select Team Social Background Hover color', '#182849');



lzCustomLable($wp_customize, 'testimonialinnerpagepageclrdisplay', 'innershortcode_page_settings', 'Set Testimonial Shortcode Page Colors:');


addColorPalatOption($wp_customize, 'testimonialinnerpageclientimgborderColor', 'innershortcode_page_settings', 'Select image border color', '#e9bf09');

addColorPalatOption($wp_customize, 'testimonialinnerpageclientnameColor', 'innershortcode_page_settings', 'Select client name color', '#182849');
addColorPalatOption($wp_customize, 'testimonialinnerpagetextColor', 'innershortcode_page_settings', 'Select Text color', '#000');

addColorPalatOption($wp_customize, 'testimonialinnerpageclientdesgColor', 'innershortcode_page_settings', 'Select designation color', '#fff');

addColorPalatOption($wp_customize, 'testimonialinnerpageclientcompanynameColor', 'innershortcode_page_settings', 'Select company name color', '#fff');

addColorPalatOption($wp_customize, 'testimonialinnerpageclientdesgboxColor', 'innershortcode_page_settings', 'Select designation box background color', '#e9bf09');

addColorPalatOption($wp_customize, 'testimonialinnerpageclientdesgboxborderColor', 'innershortcode_page_settings', 'Select designation box border color', '#182849');



lzCustomLable($wp_customize, 'galleryinnerpagepageclrdisplay', 'innershortcode_page_settings', 'Set Gallery Shortcode Page Colors:');

addColorPalatOption($wp_customize, 'galleryinnericonColor', 'innershortcode_page_settings', 'Select Gallery Image icon color', '#fff');
addColorPalatOption($wp_customize, 'galleryinnericonbgColor', 'innershortcode_page_settings', 'Select Gallery Image icon background color', '#e9bf09');

addColorPalatOption($wp_customize, 'galleryinnericonhoverColor', 'innershortcode_page_settings', 'Select Gallery Image icon hover color', '#182849');


lzCustomLable($wp_customize, 'faqinnerpagepageclrdisplay', 'innershortcode_page_settings', 'Set Faq Shortcode Page Colors:');

addColorPalatOption($wp_customize, 'faqinnerpagetitleColor', 'innershortcode_page_settings', 'Select Faq Question color', '#fff');
addColorPalatOption($wp_customize, 'faqinnerpagetitlebgColor', 'innershortcode_page_settings', 'Select Faq Question Background color', '#182849');

addColorPalatOption($wp_customize, 'faqinnerpagetitleboxborderColor', 'innershortcode_page_settings', 'Select Faq Border color', '#e9bf09');

addColorPalatOption($wp_customize, 'faqinnerpagetitleIconColor', 'innershortcode_page_settings', 'Select Faq Question Icon color', '#ffffff');
addColorPalatOption($wp_customize, 'faqinnerpagetitleIconbgColor', 'innershortcode_page_settings', 'Select Faq Question Icon background color', '#e9bf09');

addColorPalatOption($wp_customize, 'faqinnerpagetextcColor', 'innershortcode_page_settings', 'Select Faq Answer color', '#000');