<?php 
/**
 * Createing Services pannel for customizer
 *
 */
// service SECTION START HERE 
/*============service SECTION PANEL============*/
$wp_customize->add_section(
    'ct_service_section',
    array(
        'title'         => __( 'Services Section', 'Luzuk Premium' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);
// ENABLE/DISABLE SERVICES SECTION
$wp_customize->add_setting(
    'ct_service_section_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'ct_service_section_disable',
        array(
            'settings'      => 'ct_service_section_disable',
            'section'       => 'ct_service_section',
            'label'         => __( 'Disable Section', 'Luzuk Premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk Premium' ),
                'off' => __( 'No', 'Luzuk Premium' )
            )   
        )
    )
);
backgroundManager($wp_customize, 'ctservice', 'ct_service_section', $color='#182849', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'servicesection_padding', 'ct_service_section', ' Section Padding Setting:');

$wp_customize->add_setting(
    'servicesection_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '6em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'servicesection_toppadding',
    array(
        'settings'      => 'servicesection_toppadding',
        'section'       => 'ct_service_section',
        'type'          => 'text',
        'label'         => __( 'Section Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'servicesection_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'servicesection_bottompadding',
    array(
        'settings'      => 'servicesection_bottompadding',
        'section'       => 'ct_service_section',
        'type'          => 'text',
        'label'         => __( 'Section Bottom Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'servicesection_leftpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'servicesection_leftpadding',
    array(
        'settings'      => 'servicesection_leftpadding',
        'section'       => 'ct_service_section',
        'type'          => 'text',
        'label'         => __( 'Section Left Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'servicesection_rightpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'servicesection_rightpadding',
    array(
        'settings'      => 'servicesection_rightpadding',
        'section'       => 'ct_service_section',
        'type'          => 'text',
        'label'         => __( 'Section Right Padding', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'ct_service_title_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'ct_service_title_subtitle_heading',
        array(
            'settings'      => 'ct_service_title_subtitle_heading',
            'section'       => 'ct_service_section',
            'label'         => __( 'Section Title', 'Luzuk Premium' ),
        )
    )
);

$wp_customize->add_setting(
    'ct_service_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Heading Here', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'ct_service_title',
    array(
        'settings'      => 'ct_service_title',
        'section'       => 'ct_service_section', 
        'type'          => 'text',
        'label'         => __( 'Heading', 'Luzuk Premium' )
    )
);


addColorPalatOption($wp_customize, 'lz_services_subHeadingColor', 'ct_service_section', 'Select Section Heading color', '#182849');

addColorPalatOption($wp_customize, 'lz_services_subHeadingbgColor', 'ct_service_section', 'Select Section Heading Background color', '#e9bf08');



$wp_customize->add_setting(
    'service_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'OUR SERVICES', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'service_maintitle',
    array(
        'settings'      => 'service_maintitle',
        'section'       => 'ct_service_section', 
        'type'          => 'text',
        'label'         => __( 'Main Heading', 'Luzuk Premium' )
    )
);


addColorPalatOption($wp_customize, 'lz_services_HeadingColor', 'ct_service_section', 'Select Section Main Heading color', '#fff');


addColorPalatOption($wp_customize, 'lz_services_HeadingborderColor', 'ct_service_section', 'Select Section Main Heading Border color', '#e9bf08');
   

/*for note text*/
$wp_customize->add_setting('lz_CT_service_sectionnoteser_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'lz_CT_service_sectionnoteser_lbl',
        array(
            'settings'      => 'lz_CT_service_sectionnoteser_lbl',
            'section'       => 'ct_service_section',
            'label'         => __( 'Note:', 'Luzuk Premium' ),    
            'description'   => __( 'Just place the shortcode "[SERVICES]" in your page to Show all services in a page', 'Luzuk Premium' ),
        )
    )
);
/*for note text*/


$wp_customize->add_setting('ct_service_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'ct_service_npp_heading',
        array(
            'settings'      => 'ct_service_npp_heading',
            'section'       => 'ct_service_section',
            'label'         => __( 'Set Number Of service to show', 'Luzuk Premium' ),
        )
    )
);    
$wp_customize->add_setting('ct_service_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
    'ct_service_npp_count',
    array(
        'settings'      => 'ct_service_npp_count',
        'section'       => 'ct_service_section',
        'type'          => 'select',
        'label'         => __( 'Number of services to show', 'Luzuk Premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    )
);

// service PAGES
for( $i = 1; $i <= 12; $i++ ){
    $wp_customize->add_setting(
        'ct_service_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'ct_service_heading'.$i,
            array(
                'settings'      => 'ct_service_heading'.$i,
                'section'       => 'ct_service_section',
                'label'         => __( 'Our Services', 'Luzuk Premium' ).$i,
            )
        )
    );
    if(is_array($serviceSingleChoice)){
        $wp_customize->add_setting(
            'ct_service_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'ct_service_page'.$i,
            array(
                'settings'      => 'ct_service_page'.$i,
                'section'       => 'ct_service_section',
                'type'=> 'select',
                'label'         => __( 'Select a service', 'Luzuk Premium' ),
                'choices' => $serviceSingleChoice,
            )
        );

$wp_customize->add_setting(
        'ct_service_icon1'.$i,
        array(
            'default'           => 'fa fa-user',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'ct_service_icon1'.$i,
            array(
                'settings'      => 'ct_service_icon1'.$i,
                'section'       => 'ct_service_section',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'luzuk-premium' ),
            )
        )
    );      

    }else{
        $wp_customize->add_setting('ct_service_section_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
        $wp_customize->add_control(
            new luzuk_Info_Text( 
                $wp_customize,
                'ct_service_section_lbl'.$i,
                array(
                    'settings'      => 'ct_service_section_lbl'.$i,
                    'section'       => 'ct_service_section',
                    'label'         => __( 'Note:', 'Luzuk Premium' ),  
                    'description'   => __( '<strong>Changes will not reflect unless you select the service.</strong> <br/>Please add the service from "services menu" and then select service to show.', 'Luzuk Premium' ),
                )
            )
        );
    }

}

addColorPalatOption($wp_customize, 'lz_services_boxiconColor', 'ct_service_section', 'Select box icon color', '#e9bf08');

addColorPalatOption($wp_customize, 'lz_services_boxiconhoverColor', 'ct_service_section', 'Select box icon hover color', '#fff');

addColorPalatOption($wp_customize, 'lz_services_boxtitleColor', 'ct_service_section', 'Select box title color', '#fff');
addColorPalatOption($wp_customize, 'lz_services_boxdescColor', 'ct_service_section', 'Select box description color', '#fff');
 
 addColorPalatOption($wp_customize, 'lz_services_boxborderColor', 'ct_service_section', 'Select box border color', '#56668a');
 
 addColorPalatOption($wp_customize, 'lz_services_boxhighborderColor', 'ct_service_section', 'Select box highlight border color', '#e9bf08');

 
lzCustomLable($wp_customize, 'homepageservices_button_displaysets', 'ct_service_section', 'Services Button Display, Button Text:');

// to show & hide another button
$wp_customize->add_setting( 'services_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'services_button_display', array( 'label' => 'Button Display', 'section' => 'ct_service_section', 'settings' => 'services_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button


$wp_customize->add_setting(
    'servicesbutn_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Read More', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'servicesbutn_text',
    array(
        'settings'      => 'servicesbutn_text',
        'section'       => 'ct_service_section',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'lz_services_btntextColor', 'ct_service_section', 'Select button text color', '#e9bf08');

addColorPalatOption($wp_customize, 'lz_services_btntexthoverColor', 'ct_service_section', 'Select button text hover color', '#fff');